/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.security.AccessControlException;
import java.util.Arrays;
import org.nlogo.api.Exceptions$;
import org.nlogo.hubnet.client.AnnouncementListener;
import org.nlogo.hubnet.client.DiscoveryListener$;
import org.nlogo.hubnet.protocol.DiscoveryMessage;
import org.nlogo.hubnet.protocol.DiscoveryMessage$;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public class DiscoveryListener
extends Thread {
    private volatile Option<InetAddress> interfaceAddress;
    private AnnouncementListener listener;
    private boolean shouldKeepListening;

    public static String SERVER_DISCOVERY_MULTICAST_GROUP() {
        return DiscoveryListener$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP();
    }

    public static int SERVER_DISCOVERY_MULTICAST_PORT() {
        return DiscoveryListener$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT();
    }

    public DiscoveryListener(Option<InetAddress> interfaceAddress) {
        this.interfaceAddress = interfaceAddress;
        this.listener = null;
        this.shouldKeepListening = true;
    }

    public Option<InetAddress> interfaceAddress() {
        return this.interfaceAddress;
    }

    public void interfaceAddress_$eq(Option<InetAddress> x$1) {
        this.interfaceAddress = x$1;
    }

    public void setAnnouncementListener(AnnouncementListener listener) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            this.listener = listener;
        }
    }

    public void removeAnnouncementListener(AnnouncementListener listener) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            BoxedUnit boxedUnit;
            AnnouncementListener announcementListener = listener;
            AnnouncementListener announcementListener2 = this.listener;
            if (!(announcementListener != null ? !announcementListener.equals(announcementListener2) : announcementListener2 != null)) {
                this.listener = null;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void stopListening() {
        this.shouldKeepListening = false;
    }

    private void notifyListeners(DiscoveryMessage m) {
        if (this.listener != null) {
            AnnouncementListener announcementListener = this.listener;
            synchronized (announcementListener) {
                this.listener.announcementReceived(m);
            }
            return;
        }
    }

    @Override
    public void run() {
        byte[] receiptBuffer = new byte[1024];
        ObjectRef multicastSocket = ObjectRef.create(null);
        while (this.shouldKeepListening) {
            this.interfaceAddress().foreach(address -> {
                Arrays.fill(receiptBuffer, (byte)0);
                DatagramPacket packet = new DatagramPacket(receiptBuffer, receiptBuffer.length - 1);
                InetAddress group = InetAddress.getByName(DiscoveryListener$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP());
                InetSocketAddress socketGroup = new InetSocketAddress(group, DiscoveryListener$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT());
                NetworkInterface netIf = NetworkInterface.getByInetAddress(address);
                try {
                    try {
                        multicastSocket$1.elem = new MulticastSocket(DiscoveryListener$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT());
                        ((MulticastSocket)multicastSocket$1.elem).setSoTimeout(3000);
                        ((MulticastSocket)multicastSocket$1.elem).setNetworkInterface(netIf);
                        ((MulticastSocket)multicastSocket$1.elem).joinGroup(socketGroup, netIf);
                        ((MulticastSocket)multicastSocket$1.elem).receive(packet);
                        this.notifyListeners(DiscoveryMessage$.MODULE$.deserialize(packet.getAddress().getHostName(), packet.getData()));
                    }
                    catch (SocketTimeoutException timeout) {
                    }
                    catch (AccessControlException ex) {
                        System.err.println(ex);
                        System.err.println(ex.getMessage());
                        Exceptions$.MODULE$.ignore(ex);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        System.err.println(ex.getMessage());
                        Exceptions$.MODULE$.ignore(ex);
                    }
                }
                finally {
                    if ((MulticastSocket)multicastSocket$1.elem != null) {
                        ((MulticastSocket)multicastSocket$1.elem).leaveGroup(socketGroup, netIf);
                        ((MulticastSocket)multicastSocket$1.elem).close();
                    }
                }
            });
        }
    }
}

