/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nlogo.core.AgentKind;
import org.nlogo.hubnet.mirroring.Agent;
import org.nlogo.hubnet.mirroring.LinkData;
import org.nlogo.hubnet.mirroring.PatchData;
import org.nlogo.hubnet.mirroring.TurtleData;

public class OverrideList
implements Serializable {
    static final long serialVersionUID = 0L;
    public Agent.AgentType type;
    public int variable;

    public OverrideList(AgentKind agentKind, String varName) {
        this.type = Agent.AgentType.fromAgentKind(agentKind);
        this.variable = OverrideList.getOverrideIndex(this.type, varName);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.type = Agent.AgentType.fromInt(in.readInt());
        this.variable = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.type.toInt());
        out.writeInt(this.variable);
    }

    public static int getOverrideIndex(Agent.AgentType type, String varName) {
        switch (type) {
            case TURTLE: {
                return TurtleData.getOverrideIndex(varName);
            }
            case PATCH: {
                return PatchData.getOverrideIndex(varName);
            }
            case LINK: {
                return LinkData.getOverrideIndex(varName);
            }
        }
        throw new IllegalStateException();
    }
}

