/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.Patch;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.LogoList;
import org.nlogo.hubnet.mirroring.AgentData;
import org.nlogo.hubnet.mirroring.HubNetTurtleStamp;

public class TurtleData
extends AgentData
implements Turtle {
    public static final short DEAD = 0;
    public static final short XCOR = 1;
    public static final short YCOR = 2;
    public static final short SHAPE = 4;
    public static final short COLOR = 8;
    public static final short HEADING = 16;
    public static final short SIZE = 32;
    public static final short HIDDEN = 64;
    public static final short LABEL = 128;
    public static final short LABEL_COLOR = 256;
    public static final short BREED_INDEX = 512;
    public static final short LINE_THICKNESS = 1024;
    public static final short COMPLETE = 2047;
    private long who;
    private short mask;
    private double xcor;
    private double ycor;
    private String shape = "";
    private LogoList color;
    private double heading;
    private double size;
    private boolean hidden;
    private String label = "";
    private LogoList labelColor;
    private int breedIndex;
    private double lineThickness;
    private static final String[] OVERRIDE_VARIABLES = new String[]{"COLOR", "LABEL", "LABEL-COLOR", "LINE-THICKNESS", "HIDDEN?", "HEADING", "SHAPE", "SIZE"};
    private static final String[] OVERRIDE_METHODS = new String[]{"color", "label", "labelColor", "lineThickness", "hidden", "heading", "shape", "size"};

    @Override
    public AgentKind kind() {
        return AgentKindJ.Turtle();
    }

    TurtleData(long who) {
        this.who = who;
        this.mask = 0;
        this.color = LogoList.Empty();
        this.labelColor = LogoList.Empty();
    }

    public TurtleData(HubNetTurtleStamp turtle) {
        this.mask = (short)2047;
        this.xcor = turtle.xcor;
        this.ycor = turtle.ycor;
        this.shape = turtle.shape;
        this.color(turtle.color);
        this.heading = turtle.heading;
        this.size = turtle.size;
        this.hidden = turtle.hidden;
        this.lineThickness = turtle.lineThickness;
    }

    TurtleData(long who, short mask, double xcor, double ycor, String shape, Object color, double heading, double size, boolean hidden, String label, Object labelColor, int breedIndex, double lineThickness) {
        this.who = who;
        this.mask = mask;
        this.xcor = xcor;
        this.ycor = ycor;
        this.shape = shape;
        this.color(color);
        this.heading = heading;
        this.size = size;
        this.hidden = hidden;
        this.label = label;
        this.labelColor(labelColor);
        this.breedIndex = breedIndex;
        this.lineThickness = lineThickness;
    }

    TurtleData(DataInputStream is) throws IOException {
        this.who = is.readLong();
        this.mask = is.readShort();
        if ((this.mask & 1) == 1) {
            this.xcor = is.readDouble();
        }
        if ((this.mask & 2) == 2) {
            this.ycor = is.readDouble();
        }
        if ((this.mask & 4) == 4) {
            this.shape = is.readUTF();
        }
        if ((this.mask & 8) == 8) {
            this.color(is.readInt());
        }
        if ((this.mask & 0x10) == 16) {
            this.heading = is.readDouble();
        }
        if ((this.mask & 0x20) == 32) {
            this.size = is.readDouble();
        }
        if ((this.mask & 0x40) == 64) {
            this.hidden = is.readBoolean();
        }
        if ((this.mask & 0x80) == 128) {
            this.label = is.readUTF();
        }
        if ((this.mask & 0x100) == 256) {
            this.labelColor = Color.getRGBAListByARGB(is.readInt());
        }
        this.breedIndex = is.readInt();
        if ((this.mask & 0x400) == 1024) {
            this.lineThickness = is.readDouble();
        }
    }

    @Override
    public long id() {
        return this.who;
    }

    @Override
    public double xcor() {
        return this.xcor;
    }

    public void xcor(double xcor) {
        this.xcor = xcor;
    }

    @Override
    public double ycor() {
        return this.ycor;
    }

    public void ycor(double ycor) {
        this.ycor = ycor;
    }

    @Override
    public Object color() {
        return this.color;
    }

    public void color(Object color) {
        if (color instanceof Double) {
            this.color((Double)color);
        } else {
            this.color((LogoList)color);
        }
    }

    public void color(Double color) {
        this.color(Color.getARGBbyPremodulatedColorNumber(color));
    }

    public void color(LogoList color) {
        this.color = color;
    }

    public void color(int argb) {
        this.color = Color.getRGBAListByARGB(argb);
    }

    @Override
    public double size() {
        return this.size;
    }

    public void size(Double size) {
        this.size = size;
    }

    @Override
    public String shape() {
        return this.shape;
    }

    public void shape(String shape) {
        this.shape = shape;
    }

    @Override
    public double heading() {
        return this.heading;
    }

    public void heading(Double heading) {
        this.heading = heading;
    }

    @Override
    public boolean hidden() {
        return this.hidden;
    }

    public void hidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void label(Object label) {
        this.label = Dump.logoObject(label);
    }

    public String label() {
        return this.label;
    }

    @Override
    public String labelString() {
        return this.label;
    }

    @Override
    public Object labelColor() {
        return this.labelColor;
    }

    public void labelColor(Object labelColor) {
        if (labelColor instanceof Double) {
            this.labelColor((Double)labelColor);
        } else {
            this.labelColor((LogoList)labelColor);
        }
    }

    public void labelColor(Double labelColor) {
        this.labelColor(Color.getARGBbyPremodulatedColorNumber(labelColor));
    }

    public void labelColor(LogoList labelColor) {
        this.labelColor = labelColor;
    }

    public void labelColor(int argb) {
        this.labelColor = Color.getRGBAListByARGB(argb);
    }

    @Override
    public boolean hasLabel() {
        return this.label != null && this.label.length() > 0;
    }

    @Override
    public double lineThickness() {
        return this.lineThickness;
    }

    public void lineThickness(Double lineThickness) {
        this.lineThickness = lineThickness;
    }

    @Override
    public int getBreedIndex() {
        return this.breedIndex;
    }

    @Override
    public String getMethodName(int index) {
        return OVERRIDE_METHODS[index];
    }

    public static int getOverrideIndex(String varName) {
        return TurtleData.getOverrideIndex(OVERRIDE_VARIABLES, varName);
    }

    @Override
    public double spotlightSize() {
        return this.size * 2.0;
    }

    @Override
    public boolean wrapSpotlight() {
        return true;
    }

    public String stringRep() {
        if (this.mask == 2047) {
            return "Turtle " + this.who + " (" + this.xcor + ", " + this.ycor + ", " + this.shape + ", " + Color.getARGBIntByRGBAList(this.color) + ", " + this.heading + ", " + this.size + ", " + this.hidden + ", " + this.label + ", " + Color.getARGBIntByRGBAList(this.labelColor) + ", " + this.breedIndex + ", " + this.lineThickness + ")";
        }
        if (this.mask == 0) {
            return "Turtle " + this.who + " (dead)";
        }
        return "Turtle " + this.who + " update (mask " + Integer.toBinaryString(this.mask) + ")";
    }

    boolean isComplete() {
        return (this.mask & 0x7FF) == 2047;
    }

    boolean isDead() {
        return this.mask == 0;
    }

    TurtleData updateFrom(TurtleData other) {
        if (other.isDead()) {
            System.err.println("@ " + new Date() + " : ");
            System.err.println("ERROR: attempting incremental update of a dead turtle (" + this.stringRep() + ").");
            return null;
        }
        TurtleData diffs = new TurtleData(this.who);
        if ((other.mask & 1) == 1 && this.xcor != other.xcor) {
            this.xcor = other.xcor;
            diffs.mask = (short)(diffs.mask | 1);
            diffs.xcor = this.xcor;
        }
        if ((other.mask & 2) == 2 && this.ycor != other.ycor) {
            this.ycor = other.ycor;
            diffs.mask = (short)(diffs.mask | 2);
            diffs.ycor = this.ycor;
        }
        if ((other.mask & 4) == 4 && !this.shape.equals(other.shape)) {
            this.shape = other.shape;
            diffs.mask = (short)(diffs.mask | 4);
            diffs.shape = this.shape;
        }
        if ((other.mask & 8) == 8 && !((Object)this.color).equals(other.color)) {
            this.color = other.color;
            diffs.mask = (short)(diffs.mask | 8);
            diffs.color = this.color;
        }
        if ((other.mask & 0x10) == 16 && this.heading != other.heading) {
            this.heading = other.heading;
            diffs.mask = (short)(diffs.mask | 0x10);
            diffs.heading = this.heading;
        }
        if ((other.mask & 0x20) == 32 && this.size != other.size) {
            this.size = other.size;
            diffs.mask = (short)(diffs.mask | 0x20);
            diffs.size = this.size;
        }
        if ((other.mask & 0x40) == 64 && this.hidden != other.hidden) {
            this.hidden = other.hidden;
            diffs.mask = (short)(diffs.mask | 0x40);
            diffs.hidden = this.hidden;
        }
        if ((other.mask & 0x80) == 128 && !this.label.equals(other.label)) {
            this.label = other.label;
            diffs.mask = (short)(diffs.mask | 0x80);
            diffs.label = this.label;
        }
        if ((other.mask & 0x100) == 256 && !((Object)this.labelColor).equals(other.labelColor)) {
            this.labelColor = other.labelColor;
            diffs.mask = (short)(diffs.mask | 0x100);
            diffs.labelColor = this.labelColor;
        }
        if ((other.mask & 0x400) == 1024 && this.lineThickness != other.lineThickness) {
            this.lineThickness = other.lineThickness;
            diffs.mask = (short)(diffs.mask | 0x400);
            diffs.lineThickness = this.lineThickness;
        }
        diffs.breedIndex = this.breedIndex = other.breedIndex;
        if (diffs.mask != 0) {
            return diffs;
        }
        return null;
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeLong(this.who);
        os.writeShort(this.mask);
        if ((this.mask & 1) == 1) {
            os.writeDouble(this.xcor);
        }
        if ((this.mask & 2) == 2) {
            os.writeDouble(this.ycor);
        }
        if ((this.mask & 4) == 4) {
            os.writeUTF(this.shape);
        }
        if ((this.mask & 8) == 8) {
            os.writeInt(Color.getARGBIntByRGBAList(this.color));
        }
        if ((this.mask & 0x10) == 16) {
            os.writeDouble(this.heading);
        }
        if ((this.mask & 0x20) == 32) {
            os.writeDouble(this.size);
        }
        if ((this.mask & 0x40) == 64) {
            os.writeBoolean(this.hidden);
        }
        if ((this.mask & 0x80) == 128) {
            os.writeUTF(this.label);
        }
        if ((this.mask & 0x100) == 256) {
            os.writeInt(Color.getARGBIntByRGBAList(this.labelColor));
        }
        os.writeInt(this.breedIndex);
        if ((this.mask & 0x400) == 1024) {
            os.writeDouble(this.lineThickness);
        }
    }

    @Override
    public AgentSet getBreed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public World world() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Patch getPatchHere() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void jump(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void heading(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String classDisplayName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getVariable(int vn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVariable(int vn, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] variables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int alpha() {
        throw new UnsupportedOperationException();
    }

    public boolean isPartiallyTransparent() {
        throw new UnsupportedOperationException();
    }
}

