/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.World;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.WorldPropertiesInterface;
import org.nlogo.core.AgentKind;
import org.nlogo.hubnet.connection.AbstractConnection;
import org.nlogo.hubnet.connection.ConnectionInterface;
import org.nlogo.hubnet.connection.ConnectionTypes$;
import org.nlogo.hubnet.connection.HubNetException;
import org.nlogo.hubnet.connection.MessageEnvelope;
import org.nlogo.hubnet.connection.Ports$;
import org.nlogo.hubnet.connection.Streamable$;
import org.nlogo.hubnet.mirroring.AgentPerspective;
import org.nlogo.hubnet.mirroring.ClearOverride;
import org.nlogo.hubnet.mirroring.DiffBuffer;
import org.nlogo.hubnet.mirroring.SendOverride;
import org.nlogo.hubnet.mirroring.ServerWorld;
import org.nlogo.hubnet.protocol.AgentPerspectiveMessage;
import org.nlogo.hubnet.protocol.ClearOverrideMessage$;
import org.nlogo.hubnet.protocol.ComputerInterface;
import org.nlogo.hubnet.protocol.ComputerInterface$;
import org.nlogo.hubnet.protocol.DisableView$;
import org.nlogo.hubnet.protocol.HandshakeFromServer;
import org.nlogo.hubnet.protocol.Message;
import org.nlogo.hubnet.protocol.OverrideMessage;
import org.nlogo.hubnet.protocol.PlotControl;
import org.nlogo.hubnet.protocol.PlotUpdate;
import org.nlogo.hubnet.protocol.Text;
import org.nlogo.hubnet.protocol.Text$MessageType$CLEAR$;
import org.nlogo.hubnet.protocol.Text$MessageType$TEXT$;
import org.nlogo.hubnet.protocol.Text$MessageType$USER$;
import org.nlogo.hubnet.protocol.ViewUpdate;
import org.nlogo.hubnet.protocol.WidgetControl;
import org.nlogo.hubnet.server.ClientEventListener;
import org.nlogo.hubnet.server.ConnectionManagerInterface;
import org.nlogo.hubnet.server.DiscoveryAnnouncer;
import org.nlogo.hubnet.server.ServerPlotManager;
import org.nlogo.hubnet.server.ServerSideConnection;
import org.nlogo.plot.Plot;
import org.nlogo.workspace.AbstractWorkspaceScala;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ConnectionManager
implements ConnectionManagerInterface,
Runnable {
    private final ConnectionInterface connection;
    private final ClientEventListener clientEventListener;
    public final AbstractWorkspaceScala org$nlogo$hubnet$server$ConnectionManager$$workspace;
    private final String VALID_SEND_TYPES_MESSAGE;
    private final World world;
    private ServerWorld worldBuffer;
    private Thread nodeThread;
    private DiscoveryAnnouncer announcer;
    private volatile ServerSocket socket;
    private int _port;
    private volatile boolean serverOn;
    private boolean running;
    private final HashMap<String, ServerSideConnection> clients;
    private final ServerPlotManager plotManager;
    private final HashMap<String, Iterable<HubNetInterface.ClientInterface>> clientInterfaceMap;
    private AgentSet lastPatches;

    public ConnectionManager(ConnectionInterface connection, ClientEventListener clientEventListener, AbstractWorkspaceScala workspace) {
        this.connection = connection;
        this.clientEventListener = clientEventListener;
        this.org$nlogo$hubnet$server$ConnectionManager$$workspace = workspace;
        this.VALID_SEND_TYPES_MESSAGE = "You can only send strings, booleans (true or false), numbers, and lists of these types.";
        this.world = workspace.world();
        this.worldBuffer = new ServerWorld(this.worldProps());
        this.nodeThread = null;
        this.announcer = null;
        this.socket = null;
        this._port = -1;
        this.serverOn = false;
        this.running = false;
        this.clients = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.plotManager = new ServerPlotManager(workspace, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.org$nlogo$hubnet$server$ConnectionManager$$workspace, $outer, (Function0<List<Plot>>)ConnectionManager.org$nlogo$hubnet$server$ConnectionManager$$_$$anon$superArg$1$1(workspace$5), (Function0<Plot>)ConnectionManager.org$nlogo$hubnet$server$ConnectionManager$$_$$anon$superArg$2$1(workspace$5));
                $outer.org$nlogo$hubnet$server$ConnectionManager$$workspace.plotManager().listener_$eq(this);
            }
        };
        this.clientInterfaceMap = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.lastPatches = null;
    }

    public ConnectionInterface connection() {
        return this.connection;
    }

    public ClientEventListener clientEventListener() {
        return this.clientEventListener;
    }

    public String VALID_SEND_TYPES_MESSAGE() {
        return this.VALID_SEND_TYPES_MESSAGE;
    }

    private WorldPropertiesInterface worldProps() {
        if (this.org$nlogo$hubnet$server$ConnectionManager$$workspace.getPropertiesInterface() != null) {
            return this.org$nlogo$hubnet$server$ConnectionManager$$workspace.getPropertiesInterface();
        }
        return new WorldPropertiesInterface(){

            public int fontSize() {
                return 10;
            }
        };
    }

    public Thread nodeThread() {
        return this.nodeThread;
    }

    public void nodeThread_$eq(Thread x$1) {
        this.nodeThread = x$1;
    }

    public int port() {
        return this._port;
    }

    private void port_$eq(int p) {
        this._port = p;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public HashMap<String, ServerSideConnection> clients() {
        return this.clients;
    }

    public ServerPlotManager plotManager() {
        return this.plotManager;
    }

    private HubNetInterface.ClientInterface clientInterfaceSpec() {
        return (HubNetInterface.ClientInterface)((IterableOps)this.clientInterfaceMap.apply((Object)ConnectionTypes$.MODULE$.COMP_CONNECTION())).head();
    }

    public boolean nodesHaveView() {
        return this.clientInterfaceMap.nonEmpty() && this.clientInterfaceSpec().containsViewWidget();
    }

    public boolean isRunning() {
        return this.running();
    }

    public boolean startup(String serverName, Tuple2<NetworkInterface, InetAddress> selectedNetwork) {
        boolean bl;
        this.org$nlogo$hubnet$server$ConnectionManager$$workspace.hubNetRunning_$eq(true);
        this.running_$eq(true);
        this.clientInterfaceMap.update((Object)ConnectionTypes$.MODULE$.COMP_CONNECTION(), (Object)new .colon.colon((Object)this.createClientInterfaceSpec(), (List)Nil$.MODULE$));
        try {
            Tuple2 tuple2 = ConnectionManager.createSocket$1(Ports$.MODULE$.DEFAULT_PORT_NUMBER());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int port = BoxesRunTime.unboxToInt((Object)tuple2._1());
            ServerSocket socket = (ServerSocket)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port), (Object)socket);
            int port2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            ServerSocket socket2 = (ServerSocket)tuple22._2();
            this.port_$eq(port2);
            this.socket = socket2;
            this.serverOn = true;
            this.announcer = new DiscoveryAnnouncer(serverName, this.org$nlogo$hubnet$server$ConnectionManager$$workspace.modelNameForDisplay(), port2, (InetAddress)selectedNetwork._2());
            this.announcer.start();
            this.nodeThread_$eq(new Thread(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer);
                    this.setName("org.nlogo.hubnet.server.ConnectionManager");
                }
            });
            this.nodeThread().start();
            bl = true;
        }
        catch (BindException ex) {
            String message = "Could not start the HubNet server. No ports are available.";
            Exceptions$.MODULE$.handle(new Exception(message, ex));
            bl = false;
        }
        return bl;
    }

    public boolean shutdown() {
        if (this.nodeThread() != null && this.nodeThread().isAlive()) {
            this.serverOn = false;
            while (this.socket != null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Exceptions$.MODULE$.ignore(ie);
                }
            }
            HashMap<String, ServerSideConnection> hashMap = this.clients();
            synchronized (hashMap) {
                this.clients().values().foreach(conn -> this.disconnectClient((ServerSideConnection)conn, true, "Shutting Down."));
                this.clients().clear();
            }
        }
        this.org$nlogo$hubnet$server$ConnectionManager$$workspace.hubNetRunning_$eq(false);
        this.running_$eq(false);
        return true;
    }

    public void enqueueMessage(MessageEnvelope.MessageEnvelope message) {
        this.connection().enqueueMessage(message);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                if (!this.serverOn) {
                    this.announcer.shutdown();
                    this.socket.close();
                    this.socket = null;
                    return;
                }
                try {
                    this.waitForConnection();
                }
                catch (InterruptedIOException var1_1) {
                }
                catch (IOException e) {
                    Exceptions$.MODULE$.handle(e);
                }
                catch (RuntimeException e) {
                    Exceptions$.MODULE$.handle(e);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Exceptions$.MODULE$.handle(e);
            return;
        }
        ** GOTO lbl-1000
    }

    private void waitForConnection() throws IOException {
        Socket newSocket = this.socket.accept();
        newSocket.setSoTimeout(0);
        new ServerSideConnection(Streamable$.MODULE$.apply(newSocket), newSocket.getRemoteSocketAddress().toString(), this).start();
    }

    @Override
    public boolean finalizeConnection(ServerSideConnection c, String desiredClientId) {
        boolean bl;
        HashMap<String, ServerSideConnection> hashMap = this.clients();
        synchronized (hashMap) {
            boolean bl2;
            if (this.clients().contains((Object)desiredClientId)) {
                bl2 = false;
            } else {
                this.clients().put((Object)desiredClientId, (Object)c);
                this.clientEventListener().addClient(desiredClientId, c.remoteAddress());
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    public void reloadClientInterface() {
        this.setClientInterface(ConnectionTypes$.MODULE$.COMP_CONNECTION(), (Iterable<HubNetInterface.ClientInterface>)((Iterable)Nil$.MODULE$));
        this.plotManager().initPlotListeners();
    }

    public void setClientInterface(String interfaceType, Iterable<HubNetInterface.ClientInterface> interfaceInfo) {
        String string = interfaceType;
        String string2 = ConnectionTypes$.MODULE$.COMP_CONNECTION();
        this.clientInterfaceMap.update((Object)interfaceType, !(string != null ? !string.equals(string2) : string2 != null) ? (Object)new .colon.colon((Object)this.createClientInterfaceSpec(), (List)Nil$.MODULE$) : interfaceInfo);
    }

    private HubNetInterface.ClientInterface createClientInterfaceSpec() {
        return new ComputerInterface(this.connection().modelWidgets(), this.world.turtleShapeList().shapes(), this.world.linkShapeList().shapes(), ComputerInterface$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public void putClientData(MessageEnvelope.MessageEnvelope messageEnvelope) {
        this.enqueueMessage(messageEnvelope);
    }

    @Override
    public HandshakeFromServer createHandshakeMessage(String clientType) {
        return new HandshakeFromServer(this.org$nlogo$hubnet$server$ConnectionManager$$workspace.modelNameForDisplay(), this.clientInterfaceSpec());
    }

    @Override
    public boolean isSupportedClientType(String clientType) {
        return this.clientInterfaceMap.isDefinedAt((Object)clientType);
    }

    public boolean isValidTag(String tag) {
        return this.clientInterfaceSpec().containsWidgetTag(tag);
    }

    public void broadcast(String tag, Object message) throws HubNetException {
        if (!this.isValidTag(tag)) {
            throw new HubNetException(tag + " is not a valid tag on the client.");
        }
        Object object = message;
        if (object instanceof Serializable && object instanceof Object) {
            Object m = object;
            this.broadcastMessage(new WidgetControl(m, tag));
            return;
        }
        throw new HubNetException(this.VALID_SEND_TYPES_MESSAGE());
    }

    public boolean send(String userId, String tag, Object message) throws HubNetException {
        if (!this.isValidTag(tag)) {
            throw new HubNetException(tag + " is not a valid tag on the client.");
        }
        return this.sendUserMessage(userId, new WidgetControl(message, tag));
    }

    public void broadcast(Object obj) throws HubNetException {
        if (obj instanceof String) {
            this.broadcastMessage(new Text(obj.toString(), Text$MessageType$TEXT$.MODULE$));
            return;
        }
        if (obj instanceof Plot) {
            this.broadcastMessage(new PlotUpdate((Plot)obj));
            return;
        }
        throw new HubNetException(this.VALID_SEND_TYPES_MESSAGE());
    }

    public void broadcastPlotControl(Object a, String plotName) throws HubNetException {
        this.broadcastMessage(new PlotControl(a, plotName));
    }

    public void sendPlotControl(String userId, Object a, String plotName) throws HubNetException {
        this.sendUserMessage(userId, new PlotControl(a, plotName));
    }

    public void broadcastClearTextMessage() {
        this.broadcastMessage(new Text(null, Text$MessageType$CLEAR$.MODULE$));
    }

    private void broadcastMessage(Message msg) {
        HashMap<String, ServerSideConnection> hashMap = this.clients();
        synchronized (hashMap) {
            this.clients().values().foreach(connection -> connection.sendData(msg));
        }
    }

    public boolean sendTextMessage(String node, String text) {
        return this.sendUserMessage(node, new Text(text, Text$MessageType$TEXT$.MODULE$));
    }

    public boolean sendClearTextMessage(String node) {
        return this.sendUserMessage(node, new Text(null, Text$MessageType$CLEAR$.MODULE$));
    }

    public boolean sendUserMessage(String node, String text) {
        return this.sendUserMessage(node, new Text(text, Text$MessageType$USER$.MODULE$));
    }

    private boolean sendUserMessage(String userid, Message message) {
        Option c = this.clients().get((Object)userid);
        c.foreach(_$1 -> _$1.sendData(message));
        return c.isDefined();
    }

    public void broadcastUserMessage(String text) {
        this.broadcastMessage(new Text(text, Text$MessageType$USER$.MODULE$));
    }

    public void removeAllClients() {
        HashMap<String, ServerSideConnection> hashMap = this.clients();
        synchronized (hashMap) {
            this.clients().values().foreach(conn -> this.disconnectClient((ServerSideConnection)conn, true, "Kicked from Control Center."));
            this.clients().clear();
        }
    }

    @Override
    public boolean removeClient(String userid, boolean notifyClient, String reason) {
        Option c;
        Option option;
        HashMap<String, ServerSideConnection> hashMap = this.clients();
        synchronized (hashMap) {
            option = this.clients().remove((Object)userid);
        }
        Option option2 = c = option;
        if (option2 instanceof Some) {
            ServerSideConnection client = (ServerSideConnection)((Some)option2).value();
            this.disconnectClient(client, notifyClient, reason);
            return true;
        }
        return false;
    }

    private void disconnectClient(ServerSideConnection c, boolean notifyClient, String reason) {
        if (c != null) {
            c.disconnect(notifyClient, reason);
            this.clientEventListener().clientDisconnect(c.clientId());
            return;
        }
    }

    public boolean sendOverrideList(String client, AgentKind agentKind, String varName, Map<Long, Object> overrides) {
        return this.sendUserMessage(client, new OverrideMessage(new SendOverride(agentKind, varName, overrides), false));
    }

    public boolean clearOverride(String client, AgentKind agentKind, String varName, Seq<Long> overrides) {
        return this.sendUserMessage(client, new OverrideMessage(new ClearOverride(agentKind, varName, overrides), true));
    }

    public void clearOverrideLists(String client) {
        this.sendUserMessage(client, ClearOverrideMessage$.MODULE$);
    }

    public void sendAgentPerspective(String client, int perspective, AgentKind agentKind, long id, double radius, boolean serverMode) {
        this.sendUserMessage(client, new AgentPerspectiveMessage(new AgentPerspective(agentKind, id, perspective, radius, serverMode).toByteArray()));
    }

    @Override
    public void fullViewUpdate() {
        this.doViewUpdate(true);
    }

    public void incrementalViewUpdate() {
        AgentSet agentSet = this.lastPatches;
        IndexedAgentSet indexedAgentSet = this.world.patches();
        this.doViewUpdate(agentSet == null ? indexedAgentSet != null : !agentSet.equals(indexedAgentSet));
    }

    private void doViewUpdate(boolean resetWorld) {
        DiffBuffer buf;
        if (resetWorld) {
            this.worldBuffer = new ServerWorld(this.worldProps());
            this.lastPatches = this.world.patches();
        }
        if (!(buf = this.worldBuffer.updateWorld(this.world, resetWorld)).isEmpty()) {
            this.broadcastMessage(new ViewUpdate(buf.toByteArray()));
            return;
        }
    }

    public void setViewEnabled(boolean mirror) {
        if (mirror) {
            this.incrementalViewUpdate();
            return;
        }
        this.broadcastMessage(DisableView$.MODULE$);
    }

    public void sendPlot(String clientId, PlotInterface plot) {
        Option c = this.clients().get((Object)clientId);
        if (c.isDefined()) {
            ((AbstractConnection)c.get()).sendData(new PlotUpdate(plot));
            return;
        }
    }

    @Override
    public void sendPlots(String clientId) {
        this.plotManager().sendPlots(clientId);
    }

    public Iterable<Object> clientSendQueueSizes() {
        Iterable iterable;
        HashMap<String, ServerSideConnection> hashMap = this.clients();
        synchronized (hashMap) {
            iterable = (Iterable)this.clients().values().map((Function1 & Serializable)_$2 -> _$2.getSendQueueSize());
        }
        return iterable;
    }

    @Override
    public void logMessage(String message) {
        this.clientEventListener().logMessage(message);
    }

    private static final List $anon$superArg$1$1$$anonfun$1(AbstractWorkspaceScala workspace$2) {
        return workspace$2.plotManager().plots();
    }

    public static final Function0 org$nlogo$hubnet$server$ConnectionManager$$_$$anon$superArg$1$1(AbstractWorkspaceScala workspace$1) {
        return () -> ConnectionManager.$anon$superArg$1$1$$anonfun$1(workspace$1);
    }

    private static final Plot $anon$superArg$2$1$$anonfun$1(AbstractWorkspaceScala workspace$4) {
        return (Plot)workspace$4.plotManager().currentPlot().get();
    }

    public static final Function0 org$nlogo$hubnet$server$ConnectionManager$$_$$anon$superArg$2$1(AbstractWorkspaceScala workspace$3) {
        return () -> ConnectionManager.$anon$superArg$2$1$$anonfun$1(workspace$3);
    }

    private static final Tuple2 createSocket$1(int portToTry) {
        Tuple2 tuple2;
        while (true) {
            if (portToTry > Ports$.MODULE$.MAX_PORT_NUMBER()) {
                throw new BindException("port: " + portToTry);
            }
            try {
                tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)portToTry), (Object)new ServerSocket(portToTry){
                    {
                        this.setSoTimeout(250);
                    }
                });
            }
            catch (BindException bex) {
                ++portToTry;
                continue;
            }
            break;
        }
        return tuple2;
    }
}

