/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.LinkedBlockingQueue;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.Agent;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.HubNetInterface;
import org.nlogo.api.Version$;
import org.nlogo.core.AgentKind;
import org.nlogo.core.Model;
import org.nlogo.core.OptionalSection;
import org.nlogo.core.Shape;
import org.nlogo.core.Widget;
import org.nlogo.fileformat.ConversionResult;
import org.nlogo.hubnet.connection.ConnectionInterface;
import org.nlogo.hubnet.connection.HubNetException;
import org.nlogo.hubnet.connection.MessageEnvelope;
import org.nlogo.hubnet.connection.MessageEnvelope$ExitMessageEnvelope$;
import org.nlogo.hubnet.mirroring.Agent;
import org.nlogo.hubnet.mirroring.HubNetDrawingMessage;
import org.nlogo.hubnet.mirroring.HubNetLine;
import org.nlogo.hubnet.mirroring.HubNetLinkStamp;
import org.nlogo.hubnet.mirroring.HubNetTurtleStamp;
import org.nlogo.hubnet.mirroring.OverrideList;
import org.nlogo.hubnet.protocol.CalculatorInterface$;
import org.nlogo.hubnet.protocol.ComputerInterface$;
import org.nlogo.hubnet.server.ConnectionManager;
import org.nlogo.hubnet.server.HubNetManager$HubNetLoadController$;
import org.nlogo.hubnet.server.HubNetUtils$;
import org.nlogo.hubnet.server.ServerPlotManager;
import org.nlogo.workspace.AbstractWorkspaceScala;
import org.nlogo.workspace.OpenModelFromURI$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public abstract class HubNetManager
implements HubNetInterface,
ConnectionInterface {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HubNetManager.class.getDeclaredField("HubNetLoadController$lzy1"));
    private final AbstractWorkspaceScala workspace;
    private final AbstractModelLoader modelLoader;
    private final Function2<Model, Path, ConversionResult> modelConverter;
    private final String NO_DATA_WAITING;
    private final String NO_DATA_FETCHED;
    private final String NOT_LOGGED_IN;
    private final LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> messagesList;
    private MessageEnvelope.MessageEnvelope messageEnvelope;
    private boolean _framesSkipped;
    private volatile Object HubNetLoadController$lzy1;

    public HubNetManager(AbstractWorkspaceScala workspace, AbstractModelLoader modelLoader, Function2<Model, Path, ConversionResult> modelConverter) {
        this.workspace = workspace;
        this.modelLoader = modelLoader;
        this.modelConverter = modelConverter;
        this.NO_DATA_WAITING = "There is no data waiting.  Always check for data using HUBNET-MESSAGE-WAITING? before fetching data with HUBNET-FETCH-MESSAGE.";
        this.NO_DATA_FETCHED = "The data has not been fetched.  Always fetch the data with HUBNET-FETCH-MESSAGE before you try to access the data with HUBNET-MESSAGE or HUBNET-MESSAGE-SOURCE or HUBNET-MESSAGE-TAG";
        this.NOT_LOGGED_IN = "Not logged in.  Please use the hubnet-reset command.";
        this.messagesList = new LinkedBlockingQueue();
        this.messageEnvelope = null;
        this._framesSkipped = true;
    }

    public abstract ConnectionManager connectionManager();

    public String NO_DATA_WAITING() {
        return this.NO_DATA_WAITING;
    }

    public String NO_DATA_FETCHED() {
        return this.NO_DATA_FETCHED;
    }

    public String NOT_LOGGED_IN() {
        return this.NOT_LOGGED_IN;
    }

    public LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> messagesList() {
        return this.messagesList;
    }

    @Override
    public void enqueueMessage(MessageEnvelope.MessageEnvelope message) {
        this.messagesList().put(message);
    }

    @Override
    public boolean messageWaiting() {
        if (!this.messagesList().isEmpty()) {
            return true;
        }
        try {
            LinkedBlockingQueue<MessageEnvelope.MessageEnvelope> linkedBlockingQueue = this.messagesList();
            synchronized (linkedBlockingQueue) {
                this.messagesList().wait(50L);
            }
        }
        catch (InterruptedException ex) {
            Exceptions$.MODULE$.ignore(ex);
        }
        return !this.messagesList().isEmpty();
    }

    @Override
    public int numberOfMessagesWaiting() {
        return this.messagesList().size();
    }

    @Override
    public boolean enterMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.getMessageEnvelope().isEnterMessage();
    }

    @Override
    public boolean exitMessage() throws HubNetException {
        this.checkRunningStatus();
        return this.getMessageEnvelope().isExitMessage();
    }

    @Override
    public void fetchMessage() throws HubNetException {
        this.checkRunningStatus();
        this.messageEnvelope = null;
        if (!this.messagesList().isEmpty()) {
            this.messageEnvelope = this.messagesList().take();
            return;
        }
        throw new HubNetException(this.NO_DATA_WAITING());
    }

    @Override
    public Object getMessage() throws HubNetException {
        return this.getMessageEnvelope().getMessage();
    }

    @Override
    public String getMessageSource() throws HubNetException {
        return this.getMessageEnvelope().getSource();
    }

    @Override
    public String getMessageTag() throws HubNetException {
        return this.getMessageEnvelope().getTag();
    }

    private MessageEnvelope.MessageEnvelope getMessageEnvelope() throws HubNetException {
        this.checkRunningStatus();
        if (this.messageEnvelope == null) {
            throw new HubNetException(this.NO_DATA_FETCHED());
        }
        return this.messageEnvelope;
    }

    @Override
    public void send(Seq<String> nodes, String tag, Object message) throws HubNetException {
        this.checkRunningStatus();
        nodes.foreach(node -> {
            if (!this.send((String)node, tag, message)) {
                this.simulateFailedExitMessage((String)node);
                return;
            }
        });
    }

    private void simulateFailedExitMessage(String clientId) {
        this.enqueueMessage(MessageEnvelope$ExitMessageEnvelope$.MODULE$.apply(clientId));
    }

    @Override
    public boolean send(String node, String tag, Object message) throws HubNetException {
        return this.connectionManager().send(node, tag, message);
    }

    @Override
    public void sendUserMessage(Seq<String> nodes, String text) {
        nodes.foreach(node -> {
            if (!this.connectionManager().sendUserMessage((String)node, text)) {
                this.simulateFailedExitMessage((String)node);
                return;
            }
        });
    }

    @Override
    public void broadcastUserMessage(String msg) {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcastUserMessage(msg);
            return;
        }
    }

    @Override
    public void sendText(Seq<String> nodes, String text) {
        nodes.foreach(node -> {
            if (!this.connectionManager().sendTextMessage((String)node, text)) {
                this.simulateFailedExitMessage((String)node);
                return;
            }
        });
    }

    @Override
    public void clearText(Seq<String> nodes) {
        nodes.foreach(node -> {
            if (!this.connectionManager().sendClearTextMessage((String)node)) {
                this.simulateFailedExitMessage((String)node);
                return;
            }
        });
    }

    @Override
    public void broadcast(String tag, Object message) throws HubNetException {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcast(tag, message);
            return;
        }
    }

    @Override
    public void broadcast(Object msg) throws HubNetException {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcast(msg);
            return;
        }
    }

    @Override
    public void broadcastClearText() {
        if (this.connectionManager().isRunning()) {
            this.connectionManager().broadcastClearTextMessage();
            return;
        }
    }

    private void checkRunningStatus() throws HubNetException {
        if (!this.connectionManager().isRunning()) {
            throw new HubNetException(this.NOT_LOGGED_IN());
        }
    }

    @Override
    public void setClientInterface(String interfaceType, Iterable<HubNetInterface.ClientInterface> interfaceInfo) throws HubNetException {
        this.connectionManager().setClientInterface(interfaceType, interfaceInfo);
        this.resetPlotManager();
    }

    @Override
    public boolean isOverridable(AgentKind agentKind, String varName) {
        return OverrideList.getOverrideIndex(Agent.AgentType.fromAgentKind(agentKind), varName) != -1;
    }

    @Override
    public void sendOverrideList(String client, AgentKind agentKind, String varName, Map<Long, Object> overrides) {
        this.connectionManager().sendOverrideList(client, agentKind, varName, overrides);
    }

    @Override
    public void clearOverride(String client, AgentKind agentKind, String varName, Seq<Long> overrides) {
        this.connectionManager().clearOverride(client, agentKind, varName, overrides);
    }

    @Override
    public void clearOverrideLists(String client) {
        this.connectionManager().clearOverrideLists(client);
    }

    @Override
    public void sendAgentPerspective(String client, int perspective, AgentKind agentKind, long id, double radius, boolean serverMode) {
        this.connectionManager().sendAgentPerspective(client, perspective, agentKind, id, radius, serverMode);
    }

    public boolean someNodesHaveView() {
        return this.connectionManager().nodesHaveView() && HubNetUtils$.MODULE$.viewMirroring();
    }

    private void broadcastViewMessage(Object obj) {
        if (this.connectionManager().isRunning() && this.someNodesHaveView()) {
            this.broadcast("VIEW", obj);
            return;
        }
    }

    @Override
    public void sendLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.broadcastViewMessage(new HubNetLine(x0, y0, x1, y1, color, size, mode));
    }

    @Override
    public void sendStamp(Agent agent, boolean erase) {
        Agent agent2 = agent;
        if (agent2 instanceof Turtle) {
            Turtle t = (Turtle)agent2;
            this.broadcastViewMessage(new HubNetTurtleStamp(t, erase));
            return;
        }
        if (agent2 instanceof Link) {
            Link l = (Link)agent2;
            this.broadcastViewMessage(new HubNetLinkStamp(l, erase));
            return;
        }
    }

    @Override
    public void sendClear() {
        this.broadcastViewMessage(new HubNetDrawingMessage(HubNetDrawingMessage.Type.CLEAR));
    }

    @Override
    public double getOutQueueSize() throws HubNetException {
        this.checkRunningStatus();
        Iterable<Object> queueSizes = this.connectionManager().clientSendQueueSizes();
        int totalClients = queueSizes.size();
        int totalQueueSize = BoxesRunTime.unboxToInt((Object)queueSizes.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalClients == 0) {
            return 0.0;
        }
        return (double)totalQueueSize / (double)totalClients;
    }

    @Override
    public int getInQueueSize() throws HubNetException {
        this.checkRunningStatus();
        return this.messagesList().size();
    }

    @Override
    public Iterable<String> clients() {
        return this.connectionManager().clients().keys();
    }

    @Override
    public void kick(String userId) {
        this.connectionManager().removeClient(userId, true, "Kicked out.");
    }

    @Override
    public void kickAll() {
        this.connectionManager().removeAllClients();
    }

    @Override
    public void setViewMirroring(boolean onOff) {
        HubNetUtils$.MODULE$.viewMirroring_$eq(onOff);
    }

    @Override
    public void setPlotMirroring(boolean onOff) {
        HubNetUtils$.MODULE$.plotMirroring_$eq(onOff);
    }

    @Override
    public Tuple2<Object, Object> waitForClients(int numClientsToWaitFor, long timeoutMillis) {
        return this.waitForEvents(numClientsToWaitFor, timeoutMillis, (Function0<Object>)((Function0 & Serializable)this::waitForClients$$anonfun$1));
    }

    @Override
    public Tuple2<Object, Object> waitForMessages(int numMessagesToWaitFor, long timeoutMillis) {
        return this.waitForEvents(numMessagesToWaitFor, timeoutMillis, (Function0<Object>)((Function0 & Serializable)this::waitForMessages$$anonfun$1));
    }

    private Tuple2<Object, Object> waitForEvents(int numEventsToWaitFor, long timeoutMillis, Function0<Object> currentNumEvents) {
        block7: {
            long start = System.currentTimeMillis();
            World world = this.workspace.world();
            synchronized (world) {
                Tuple2.mcZI.sp sp2;
                block6: {
                    while (true) {
                        int numNow = currentNumEvents.apply$mcI$sp();
                        if (numNow >= numEventsToWaitFor) {
                            sp2 = new Tuple2.mcZI.sp(true, numNow);
                            break block6;
                        }
                        if (HubNetManager.timedOut$1(start, timeoutMillis)) {
                            sp2 = new Tuple2.mcZI.sp(false, numNow);
                            break block6;
                        }
                        this.workspace.world().wait(25L);
                    }
                    break block7;
                }
                return sp2;
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private ServerPlotManager plotManager() {
        return this.connectionManager().plotManager();
    }

    private void resetPlotManager() {
        this.plotManager().initPlotListeners();
    }

    @Override
    public boolean addNarrowcastPlot(String plotName) {
        return this.plotManager().addNarrowcastPlot(plotName);
    }

    @Override
    public void plot(String clientId, double y) {
        this.plotManager().narrowcastPlot(clientId, y);
    }

    @Override
    public void plot(String clientId, double x, double y) {
        this.plotManager().narrowcastPlot(clientId, x, y);
    }

    @Override
    public void clearPlot(String clientId) {
        this.plotManager().narrowcastClear(clientId);
    }

    @Override
    public void plotPenDown(String clientId, boolean penDown) {
        this.plotManager().narrowcastPenDown(clientId, penDown);
    }

    @Override
    public void setPlotPenMode(String clientId, int plotPenMode) {
        this.plotManager().narrowcastPlotPenMode(clientId, plotPenMode);
    }

    @Override
    public void setHistogramNumBars(String clientId, int num) {
        this.plotManager().narrowcastSetHistogramNumBars(clientId, num);
    }

    @Override
    public void setPlotPenInterval(String clientId, double interval) {
        this.plotManager().narrowcastSetInterval(clientId, interval);
    }

    @Override
    public boolean viewIsVisible() {
        return this.someNodesHaveView();
    }

    @Override
    public void framesSkipped() {
        this._framesSkipped = true;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public void paintImmediately(boolean force) {
        if (force || this._framesSkipped) {
            this.incrementalUpdateFromEventThread();
            return;
        }
    }

    @Override
    public void incrementalUpdateFromEventThread() {
        if (this.someNodesHaveView() && this.connectionManager().isRunning()) {
            this.connectionManager().incrementalViewUpdate();
        }
        this._framesSkipped = false;
    }

    @Override
    public void repaint() {
    }

    @Override
    public boolean mouseInside() {
        return false;
    }

    @Override
    public double mouseXCor() {
        return 0.0;
    }

    @Override
    public double mouseYCor() {
        return 0.0;
    }

    @Override
    public boolean mouseDown() {
        return false;
    }

    @Override
    public void resetMouseCors() {
    }

    @Override
    public void shapeChanged(Shape shape) {
    }

    @Override
    public void applyNewFontSize(int fontSize, int zoom) {
    }

    @Override
    public HubNetInterface.ClientInterface calculatorInterface(String activity, Seq<String> tags) {
        return CalculatorInterface$.MODULE$.apply(activity, tags);
    }

    @Override
    public Option<HubNetInterface.ClientInterface> fileInterface(String path) {
        URI uri = Paths.get(path, new String[0]).toUri();
        return OpenModelFromURI$.MODULE$.apply(uri, this.HubNetLoadController(), this.modelLoader, this.modelConverter, Version$.MODULE$).flatMap((Function1 & Serializable)model -> model.optionalSectionValue("org.nlogo.modelsection.hubnetclient", ClassTag$.MODULE$.apply(OptionalSection.class)).map((Function1 & Serializable)widgets -> ComputerInterface$.MODULE$.apply((Seq<Widget>)widgets, model.turtleShapes(), model.linkShapes(), ComputerInterface$.MODULE$.$lessinit$greater$default$4())));
    }

    public final HubNetManager$HubNetLoadController$ HubNetLoadController() {
        Object object = this.HubNetLoadController$lzy1;
        if (object instanceof HubNetManager$HubNetLoadController$) {
            return (HubNetManager$HubNetLoadController$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HubNetManager$HubNetLoadController$)this.HubNetLoadController$lzyINIT1();
    }

    private Object HubNetLoadController$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.HubNetLoadController$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    HubNetManager$HubNetLoadController$ hubNetManager$HubNetLoadController$ = null;
                    try {
                        hubNetManager$HubNetLoadController$ = new HubNetManager$HubNetLoadController$();
                        serializable = hubNetManager$HubNetLoadController$ == null ? LazyVals.NullValue$.MODULE$ : hubNetManager$HubNetLoadController$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.HubNetLoadController$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return hubNetManager$HubNetLoadController$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final int waitForClients$$anonfun$1() {
        return BoxesRunTime.unboxToInt((Object)this.workspace.getHubNetManager().map((Function1 & Serializable)_$1 -> _$1.clients().size()).get());
    }

    private final int waitForMessages$$anonfun$1() {
        return BoxesRunTime.unboxToInt((Object)this.workspace.getHubNetManager().map((Function1 & Serializable)_$2 -> _$2.getInQueueSize()).get());
    }

    private static final boolean timedOut$1(long start$1, long timeoutMillis$1) {
        return System.currentTimeMillis() - start$1 > timeoutMillis$1;
    }
}

