/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.ObjectOutputStream;
import java.util.Date;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.Version$;
import org.nlogo.hubnet.connection.AbstractConnection;
import org.nlogo.hubnet.connection.MessageEnvelope$ActivityMessageEnvelope$;
import org.nlogo.hubnet.connection.MessageEnvelope$EnterMessageEnvelope$;
import org.nlogo.hubnet.connection.MessageEnvelope$ExitMessageEnvelope$;
import org.nlogo.hubnet.connection.Streamable;
import org.nlogo.hubnet.protocol.ActivityCommand;
import org.nlogo.hubnet.protocol.DisableView$;
import org.nlogo.hubnet.protocol.EnterMessage$;
import org.nlogo.hubnet.protocol.ExitMessage;
import org.nlogo.hubnet.protocol.ExitMessage$;
import org.nlogo.hubnet.protocol.HandshakeFromClient;
import org.nlogo.hubnet.protocol.HandshakeFromClient$;
import org.nlogo.hubnet.protocol.LoginFailure;
import org.nlogo.hubnet.protocol.Message;
import org.nlogo.hubnet.server.ConnectionManagerInterface;
import org.nlogo.hubnet.server.HubNetUtils$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class ServerSideConnection
extends AbstractConnection {
    private final String remoteAddress;
    private final ConnectionManagerInterface server;
    private boolean validClientVersion;
    private volatile boolean disconnecting;
    private String clientId;

    public ServerSideConnection(Streamable connectionStreams, String remoteAddress, ConnectionManagerInterface server) {
        this.remoteAddress = remoteAddress;
        this.server = server;
        super("ServerSideConnection", connectionStreams);
        this.validClientVersion = false;
        this.disconnecting = false;
        this.clientId = null;
    }

    public String remoteAddress() {
        return this.remoteAddress;
    }

    public String clientId() {
        return this.clientId;
    }

    public void clientId_$eq(String x$1) {
        this.clientId = x$1;
    }

    @Override
    public void receiveData(Object a) {
        Object object = a;
        if (object instanceof String) {
            String s = (String)object;
            if (this.clientId() == null) {
                String string = s;
                String string2 = Version$.MODULE$.version();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.validClientVersion = true;
                }
                this.sendData(Version$.MODULE$.version());
                return;
            }
            this.dieHard("Received message out of order: " + a);
            return;
        }
        if (object instanceof Message) {
            Message m = (Message)object;
            this.handleMessage(m);
            return;
        }
        this.dieHard("Unknown message type: " + a.getClass());
    }

    private void handleMessage(Message message) {
        Message message2;
        block25: {
            String clientType;
            String userId;
            block27: {
                block26: {
                    message2 = message;
                    if (!(message2 instanceof HandshakeFromClient)) break block25;
                    HandshakeFromClient handshakeFromClient = HandshakeFromClient$.MODULE$.unapply((HandshakeFromClient)message2);
                    String string = handshakeFromClient._1();
                    String string2 = handshakeFromClient._2();
                    userId = string;
                    clientType = string2;
                    if (userId == null) break block26;
                    String string3 = userId.trim();
                    String string4 = "";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block27;
                }
                this.sendData(new LoginFailure("Server received empty username."));
                return;
            }
            if (!this.validClientVersion) {
                this.sendData(new LoginFailure("The version of the HubNet Client you are using does not match the version of the server.\nPlease use the HubNet Client that comes with " + Version$.MODULE$.version()));
                return;
            }
            if (!this.server.isSupportedClientType(clientType)) {
                this.sendData(new LoginFailure("The HubNet model you are connected to does not support your client type: " + clientType));
                return;
            }
            if (this.clientId() == null) {
                try {
                    ObjectOutputStream objectOutputStream = this.output();
                    synchronized (objectOutputStream) {
                        BoxedUnit boxedUnit;
                        if (this.server.finalizeConnection(this, userId)) {
                            this.clientId_$eq(userId);
                            this.sendData(this.server.createHandshakeMessage(clientType));
                            if (HubNetUtils$.MODULE$.viewMirroring()) {
                                this.server.fullViewUpdate();
                            } else {
                                this.sendData(DisableView$.MODULE$);
                            }
                            if (HubNetUtils$.MODULE$.plotMirroring()) {
                                this.server.sendPlots(userId);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            this.sendData(new LoginFailure("\"" + userId + "\" is already taken by another user.\nPlease choose another name."));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
                catch (RuntimeException ex) {
                    Exceptions$.MODULE$.handle(ex);
                }
                return;
            }
            return;
        }
        if (EnterMessage$.MODULE$.equals(message2)) {
            if (this.clientId() != null) {
                this.server.putClientData(MessageEnvelope$EnterMessageEnvelope$.MODULE$.apply(this.clientId()));
                return;
            }
            this.dieHard("Client login failed, please try logging in again");
            return;
        }
        if (message2 instanceof ActivityCommand) {
            ActivityCommand m = (ActivityCommand)message2;
            if (this.clientId() != null) {
                this.server.putClientData(MessageEnvelope$ActivityMessageEnvelope$.MODULE$.apply(this.clientId(), m.tag(), m.content()));
                return;
            }
            this.dieHard("Client login failed, please try logging in again");
            return;
        }
        if (message2 instanceof ExitMessage) {
            String string;
            ExitMessage exitMessage = ExitMessage$.MODULE$.unapply((ExitMessage)message2);
            String reason = string = exitMessage._1();
            if (this.clientId() != null) {
                this.server.removeClient(this.clientId(), false, reason);
                return;
            }
            this.disconnect("Disconnecting client");
            return;
        }
        this.dieHard("Unknown message type: " + message.getClass());
    }

    private void dieHard(String reason) {
        if (!this.server.removeClient(this.clientId(), true, reason)) {
            this.waitForSendData(ExitMessage$.MODULE$.apply(reason));
            this.stopWriting();
            super.disconnect(reason);
            return;
        }
    }

    @Override
    public void disconnect(String reason) {
        if (!this.disconnecting) {
            this.disconnecting = true;
            if (!this.server.removeClient(this.clientId(), false, reason)) {
                this.stopWriting();
                super.disconnect(reason);
                return;
            }
            return;
        }
    }

    public void disconnect(boolean notifyClient, String reason) {
        this.disconnecting = true;
        if (this.clientId() != null) {
            this.server.putClientData(MessageEnvelope$ExitMessageEnvelope$.MODULE$.apply(this.clientId()));
        }
        if (notifyClient) {
            this.sendData(ExitMessage$.MODULE$.apply(reason));
        }
        this.stopWriting();
        super.disconnect(reason);
    }

    @Override
    public void handleEx(Exception e, boolean sendingEx) {
        if (!this.disconnecting) {
            Object object;
            this.disconnecting = true;
            if (this.clientId() != null) {
                object = BoxesRunTime.boxToBoolean((boolean)this.server.removeClient(this.clientId(), !sendingEx, e.toString()));
            } else {
                this.stopWriting();
                super.disconnect(e.toString());
                object = BoxedUnit.UNIT;
            }
            if (e instanceof ClassNotFoundException) {
                String message = "An incompatible version of the HubNet Client tried logging in.\nPlease ensure that everyone is using the version of the HubNet Client that  came with this release. " + Version$.MODULE$.version();
                Exceptions$.MODULE$.handle(new Exception(message, e));
                return;
            }
            if (!sendingEx) {
                Exceptions$.MODULE$.handle(e);
                return;
            }
            System.err.println("@ " + new Date() + " : ");
            System.err.println("sending exception:\n" + e);
            this.server.logMessage(e.getMessage());
            return;
        }
    }

    public interface MessageHandler {
        public void handleMessage(Message var1);
    }
}

