/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.nlogo.awt.EventQueue$;
import org.nlogo.awt.Positioning$;
import org.nlogo.core.I18N$;
import org.nlogo.hubnet.server.ConnectionManager;
import org.nlogo.hubnet.server.HubNetUtils$;
import org.nlogo.swing.Button;
import org.nlogo.swing.CheckBox;
import org.nlogo.swing.NonemptyTextFieldButtonEnabler;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.SelectableJLabel;
import org.nlogo.swing.TextArea;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.TextFieldBox;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.ClientAppInterface;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class ControlCenter
extends JFrame
implements ThemeSync {
    public final ConnectionManager org$nlogo$hubnet$server$gui$ControlCenter$$server;
    public final String org$nlogo$hubnet$server$gui$ControlCenter$$serverId;
    public final String org$nlogo$hubnet$server$gui$ControlCenter$$activityName;
    public final Option<InetAddress> org$nlogo$hubnet$server$gui$ControlCenter$$address;
    private final ServerOptionsPanel serverPanel;
    private final ClientsPanel clientsPanel;
    private final MessagePanel messagePanel;
    public final Set<ClientAppInterface> org$nlogo$hubnet$server$gui$ControlCenter$$clientWindows;

    public ControlCenter(ConnectionManager server, Frame frame, String serverId, String activityName, Option<InetAddress> address) {
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server = server;
        this.org$nlogo$hubnet$server$gui$ControlCenter$$serverId = serverId;
        this.org$nlogo$hubnet$server$gui$ControlCenter$$activityName = activityName;
        this.org$nlogo$hubnet$server$gui$ControlCenter$$address = address;
        super(I18N$.MODULE$.gui().get("menu.tools.hubNetControlCenter"));
        this.serverPanel = new ServerOptionsPanel(this, HubNetUtils$.MODULE$.viewMirroring(), HubNetUtils$.MODULE$.plotMirroring());
        this.clientsPanel = new ClientsPanel((Iterable<String>)server.clients().keys());
        this.messagePanel = new MessagePanel();
        this.org$nlogo$hubnet$server$gui$ControlCenter$$clientWindows = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientAppInterface[0]));
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.serverPanel, "Center");
        this.getContentPane().add((Component)this.clientsPanel, "East");
        this.getContentPane().add((Component)this.messagePanel, "South");
        this.pack();
        Positioning$.MODULE$.moveNextTo(this, frame);
        this.setVisible(true);
    }

    public void setViewMirroring(boolean mirror) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        if (mirror != HubNetUtils$.MODULE$.viewMirroring()) {
            HubNetUtils$.MODULE$.viewMirroring_$eq(mirror);
            this.org$nlogo$hubnet$server$gui$ControlCenter$$server.setViewEnabled(mirror);
            return;
        }
    }

    public void setPlotMirroring(boolean mirror) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        HubNetUtils$.MODULE$.plotMirroring_$eq(mirror);
        if (mirror) {
            this.org$nlogo$hubnet$server$gui$ControlCenter$$server.plotManager().broadcastPlots();
            this.org$nlogo$hubnet$server$gui$ControlCenter$$server.plotManager().initPlotListeners();
            return;
        }
    }

    public void kickClient(String clientId) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server.removeClient(clientId, true, I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.removedViaControlCenter"));
        this.clientsPanel.removeClientEntry(clientId);
    }

    public void kickAllClients() {
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server.removeAllClients();
    }

    public void reloadClientInterface() {
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server.reloadClientInterface();
    }

    public void broadcastMessage(String text) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server.broadcast(text);
    }

    public void addClient(String clientId, String remoteAddress) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.clientsPanel.addClientEntry(clientId);
        this.messagePanel.logMessage(I18N$.MODULE$.gui().getN("menu.tools.hubnetControlCenter.messagePanel.clientJoined", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{clientId, remoteAddress})) + "\n");
    }

    public void clientDisconnect(String clientId) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.messagePanel.logMessage(I18N$.MODULE$.gui().getN("menu.tools.hubnetControlCenter.messagePanel.clientDisconnected", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{clientId})) + "\n");
        this.clientsPanel.removeClientEntry(clientId);
    }

    public void logMessage(String message) {
        this.messagePanel.logMessage(message);
    }

    public void launchNewClient() {
        this.org$nlogo$hubnet$server$gui$ControlCenter$$server.connection().newClient(false, 0).foreach((Function1 & Serializable)window -> {
            ClientAppInterface client = (ClientAppInterface)window;
            ((Window)((Object)client)).addWindowListener(new WindowAdapter(client, this){
                private final ClientAppInterface client$1;
                private final /* synthetic */ ControlCenter $outer;
                {
                    this.client$1 = client$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void windowClosed(WindowEvent e) {
                    this.$outer.org$nlogo$hubnet$server$gui$ControlCenter$$clientWindows.$minus$eq((Object)this.client$1);
                }
            });
            return (Set)this.org$nlogo$hubnet$server$gui$ControlCenter$$clientWindows.$plus$eq((Object)client);
        });
    }

    @Override
    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.serverPanel.syncTheme();
        this.clientsPanel.syncTheme();
        this.messagePanel.syncTheme();
        this.org$nlogo$hubnet$server$gui$ControlCenter$$clientWindows.foreach(_$1 -> _$1.syncTheme());
    }

    public static final /* synthetic */ void org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$anon$superArg$1$1$$anonfun$1$$anonfun$1(ControlCenter $outer$3, String client) {
        $outer$3.kickClient(client.toString());
    }

    public static final /* synthetic */ void org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$lessinit$greater$$anonfun$1(ControlCenter $outer$4) {
        $outer$4.launchNewClient();
    }

    public static final /* synthetic */ void org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$lessinit$greater$$anonfun$2(ControlCenter $outer$5) {
        $outer$5.kickAllClients();
        $outer$5.reloadClientInterface();
    }

    public static final /* synthetic */ void org$nlogo$hubnet$server$gui$ControlCenter$$anon$7$$_$$lessinit$greater$$anonfun$4(MessagePanel $outer$6, ActionEvent _$2) {
        $outer$6.beginBroadcast();
    }

    public static final Function1 org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$anon$superArg$2$1(ControlCenter $outer$7) {
        return (Function1 & Serializable)v1 -> {
            $outer$7.setViewMirroring(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    public static final Function1 org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$anon$superArg$3$1(ControlCenter $outer$9) {
        return (Function1 & Serializable)v1 -> {
            $outer$9.setPlotMirroring(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ String org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$lessinit$greater$$anonfun$7(InetAddress _$3) {
        return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$3.toString()), 1);
    }

    public static final /* synthetic */ IterableOnce org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$findLocalHostAddress$$anonfun$1(NetworkInterface _$4) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(_$4.getInetAddresses()).asScala().toSeq();
    }

    public static final String org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$findLocalHostAddress$$anonfun$2() {
        throw new UnknownHostException();
    }

    public class ClientsPanel
    extends JPanel
    implements Transparent,
    ListSelectionListener,
    ThemeSync {
        public final DefaultListModel<String> org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData;
        public final JList<String> org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList;
        private final JLabel clientsLabel;
        private final ScrollPane scrollPane;
        public final Button org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton;
        public final Button org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$newClientButton;
        public final Button org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$reloadButton;

        public ClientsPanel(Iterable<String> initialClientEntries) {
            if (ControlCenter.this == null) {
                throw new NullPointerException();
            }
            Transparent.$init$(this);
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData = new DefaultListModel();
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList = new JList<String>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData);
                    this.setSelectionMode(2);
                    this.addListSelectionListener($outer);
                    this.setPrototypeCellValue(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.clientName"));
                    this.setCellRenderer(new ClientCellRenderer());
                }
            };
            this.clientsLabel = new JLabel(){
                {
                    this.setAlignmentY(0.0f);
                }
            };
            this.scrollPane = new Transparent(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
                    Transparent.$init$(this);
                }
            };
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton = new Button(ControlCenter.this, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.kick"), (Function0<BoxedUnit>)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$anon$superArg$1$1($outer$11));
                    this.setEnabled(false);
                }
            };
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$newClientButton = new Button(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.local"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$lessinit$greater$$anonfun$1(ControlCenter.this)));
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$reloadButton = new Button(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.reset"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$lessinit$greater$$anonfun$2(ControlCenter.this)));
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setLayout(new BorderLayout(0, 4));
            this.add((Component)this.clientsLabel, "North");
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)((Object)new Transparent(this){
                private final GridBagConstraints c;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(new GridBagLayout());
                    Transparent.$init$(this);
                    this.c = new GridBagConstraints();
                    this.c().fill = 1;
                    this.add((Component)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton, this.c());
                    this.c().gridwidth = 0;
                    this.add((Component)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$newClientButton, this.c());
                    this.add((Component)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$reloadButton, this.c());
                }

                public GridBagConstraints c() {
                    return this.c;
                }
            }), "South");
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton.setAlignmentY(1.0f);
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$newClientButton.setAlignmentY(1.0f);
            initialClientEntries.foreach(clientId -> this.addClientEntry((String)clientId));
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton.setEnabled(this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList.getMinSelectionIndex() > -1);
                return;
            }
        }

        public void addClientEntry(String clientId) {
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData.addElement(clientId);
        }

        public void removeClientEntry(String clientId) {
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData.removeElement(clientId);
        }

        public void setClientList(List<String> clientNames) {
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData.clear();
            clientNames.foreach(x$0 -> this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$listData.addElement((String)x$0));
        }

        @Override
        public void syncTheme() {
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$kickButton.syncTheme();
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$newClientButton.syncTheme();
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$reloadButton.syncTheme();
            this.clientsLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.scrollPane.setBackground(InterfaceColors$.MODULE$.toolbarControlBackground());
            this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        }

        public final /* synthetic */ ControlCenter org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$$outer() {
            return ControlCenter.this;
        }

        public final Function0 org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$anon$superArg$1$1(ControlCenter $outer$1) {
            return (JFunction0.mcV.sp & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(this.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$clientsList.getSelectedValuesList()).asScala().foreach(arg_0 -> ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$ClientsPanel$$_$$anon$superArg$1$1$$anonfun$1$$anonfun$1($outer$1, arg_0));
        }

        public class ClientCellRenderer
        extends JPanel
        implements ListCellRenderer<String> {
            private final JLabel label = new JLabel();

            public ClientCellRenderer() {
                super(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 17;
                c.fill = 2;
                c.weightx = 1.0;
                c.insets = new Insets(3, 3, 3, 3);
                this.add((Component)this.label, c);
                Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean hasFocus) {
                this.label.setText(value);
                if (isSelected) {
                    this.setBackground(InterfaceColors$.MODULE$.dialogBackgroundSelected());
                    this.label.setForeground(InterfaceColors$.MODULE$.dialogTextSelected());
                } else {
                    this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
                    this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
                }
                return this;
            }
        }
    }

    public class MessagePanel
    extends JPanel
    implements Transparent,
    ThemeSync {
        public final TextField org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField;
        public final TextArea org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea;
        private final ScrollPane scrollPane;
        private final SimpleDateFormat dateFormatter;
        public final Button org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$broadcastButton;
        private final NonemptyTextFieldButtonEnabler buttonEnabler;

        public MessagePanel() {
            if (ControlCenter.this == null) {
                throw new NullPointerException();
            }
            Transparent.$init$(this);
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField = new TextField(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(TextField$.MODULE$.$lessinit$greater$default$1(), TextField$.MODULE$.$lessinit$greater$default$2(), TextField$.MODULE$.$lessinit$greater$default$3());
                    this.addActionListener(arg_0 -> ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$$anon$7$$_$$lessinit$greater$$anonfun$4($outer, arg_0));
                }
            };
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea = new TextArea(){
                {
                    this.setEditable(false);
                }
            };
            this.scrollPane = new ScrollPane(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
                    this.setPreferredSize(new Dimension(10, 70));
                }
            };
            this.dateFormatter = new SimpleDateFormat(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.dateFormat"));
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$broadcastButton = new Button(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.broadcastMessage"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.beginBroadcast());
            this.buttonEnabler = new NonemptyTextFieldButtonEnabler(this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$broadcastButton, (List<TextField>)((List)new .colon.colon((Object)this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField, (List)Nil$.MODULE$)));
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setLayout(new BorderLayout(4, 4));
            this.add((Component)((Object)new Transparent(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(new BorderLayout(8, 8));
                    Transparent.$init$(this);
                    this.add((Component)$outer.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField, "Center");
                    this.add((Component)$outer.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$broadcastButton, "East");
                }
            }), "South");
            this.add((Component)this.scrollPane, "North");
            EventQueue$.MODULE$.invokeLater(() -> this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField.requestFocus());
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        public NonemptyTextFieldButtonEnabler buttonEnabler() {
            return this.buttonEnabler;
        }

        public void beginBroadcast() {
            String message = this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField.getText();
            if (!message.isEmpty()) {
                this.logMessage("<Leader> " + message + "\n");
                String currentTime = this.dateFormatter.format(new Date());
                ControlCenter.this.broadcastMessage(currentTime + "   <Leader> " + message);
                this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField.setText("");
                return;
            }
        }

        public void logMessage(String message) {
            String currentTime = this.dateFormatter.format(new Date());
            String newMessage = currentTime + "   " + message;
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea.setText(this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea.getText() + (newMessage.endsWith("\n") ? newMessage : newMessage) + "\n");
        }

        @Override
        public void syncTheme() {
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$inputField.syncTheme();
            this.org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$messageTextArea.syncTheme();
            this.scrollPane.setBorder(new LineBorder(InterfaceColors$.MODULE$.textAreaBorderNoneditable()));
            this.scrollPane.setBackground(InterfaceColors$.MODULE$.textAreaBackground());
        }

        public final /* synthetic */ ControlCenter org$nlogo$hubnet$server$gui$ControlCenter$MessagePanel$$$outer() {
            return ControlCenter.this;
        }
    }

    public class ServerOptionsPanel
    extends JPanel
    implements Transparent,
    ThemeSync {
        public final boolean org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorView;
        public final boolean org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorPlots;
        private final CheckBox mirrorViewCheckBox;
        private final CheckBox mirrorPlotsCheckBox;
        public final SelectableJLabel org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$idLabel;
        public final SelectableJLabel org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$activityLabel;
        public final SelectableJLabel org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$addressLabel;
        public final SelectableJLabel org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$portLabel;
        private final TextFieldBox fields;
        private final JLabel settingsLabel;
        private final /* synthetic */ ControlCenter $outer;

        public ServerOptionsPanel(ControlCenter $outer, boolean mirrorView, boolean mirrorPlots) {
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorView = mirrorView;
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorPlots = mirrorPlots;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Transparent.$init$(this);
            this.mirrorViewCheckBox = new CheckBox($outer, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.mirrorViewOn2dClients"), (Function1<Object, BoxedUnit>)ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$anon$superArg$2$1($outer$12));
                    this.setSelected($outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorView);
                }
            };
            this.mirrorPlotsCheckBox = new CheckBox($outer, this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.mirrorPlotsOnClients"), (Function1<Object, BoxedUnit>)ControlCenter.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$anon$superArg$3$1($outer$14));
                    this.setSelected($outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$mirrorPlots);
                }
            };
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$idLabel = new SelectableJLabel($outer.org$nlogo$hubnet$server$gui$ControlCenter$$serverId);
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$activityLabel = new SelectableJLabel($outer.org$nlogo$hubnet$server$gui$ControlCenter$$activityName);
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$addressLabel = new SelectableJLabel((String)$outer.org$nlogo$hubnet$server$gui$ControlCenter$$address.map(ControlCenter::org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$$lessinit$greater$$anonfun$7).getOrElse(this::$init$$$anonfun$8));
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$portLabel = new SelectableJLabel(BoxesRunTime.boxToInteger((int)$outer.org$nlogo$hubnet$server$gui$ControlCenter$$server.port()).toString());
            this.fields = new TextFieldBox(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super(4, (Option<Font>)None$.MODULE$, (Option<Font>)Some$.MODULE$.apply((Object)new JLabel().getFont().deriveFont(1)));
                    this.addField(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.name"), (JComponent)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$idLabel);
                    this.addField(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.activity"), (JComponent)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$activityLabel);
                    this.add(Box.createVerticalStrut(12));
                    this.addField(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.serverAddress"), (JComponent)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$addressLabel);
                    this.addField(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.portNumber"), (JComponent)$outer.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$portLabel);
                }
            };
            this.settingsLabel = new JLabel(I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.settings"));
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.fields);
            this.add(Box.createVerticalStrut(30));
            this.add(this.settingsLabel);
            this.add(Box.createVerticalStrut(4));
            this.add(this.mirrorViewCheckBox);
            this.add(this.mirrorPlotsCheckBox);
            Predef$.MODULE$.locally((Object)this.add(Box.createVerticalGlue()));
        }

        private String findLocalHostAddress() {
            String string;
            block3: {
                try {
                    if (!InetAddress.getLocalHost().isLoopbackAddress()) {
                        string = InetAddress.getLocalHost().getHostAddress();
                        break block3;
                    }
                    string = (String)((IterableOnceOps)CollectionConverters$.MODULE$.EnumerationHasAsScala(NetworkInterface.getNetworkInterfaces()).asScala().toSeq().flatMap(ControlCenter::org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$findLocalHostAddress$$anonfun$1)).collectFirst((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(InetAddress x) {
                            Inet4Address addr;
                            InetAddress inetAddress = x;
                            return inetAddress instanceof Inet4Address && !(addr = (Inet4Address)inetAddress).isLoopbackAddress();
                        }

                        public final Object applyOrElse(InetAddress x, Function1 function1) {
                            Inet4Address addr;
                            InetAddress inetAddress = x;
                            if (inetAddress instanceof Inet4Address && !(addr = (Inet4Address)inetAddress).isLoopbackAddress()) {
                                return addr.getHostAddress();
                            }
                            return function1.apply((Object)x);
                        }
                    }).getOrElse(ControlCenter::org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$_$findLocalHostAddress$$anonfun$2);
                }
                catch (UnknownHostException unknownHostException) {
                    string = I18N$.MODULE$.gui().get("menu.tools.hubnetControlCenter.unknown");
                }
            }
            return string;
        }

        @Override
        public void syncTheme() {
            this.mirrorViewCheckBox.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.mirrorPlotsCheckBox.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.settingsLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$idLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$activityLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$addressLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$portLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
            this.fields.syncTheme();
        }

        public final /* synthetic */ ControlCenter org$nlogo$hubnet$server$gui$ControlCenter$ServerOptionsPanel$$$outer() {
            return this.$outer;
        }

        private final String $init$$$anonfun$8() {
            return this.findLocalHostAddress();
        }
    }
}

