/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ide;

import java.io.Serializable;
import java.util.TreeMap;
import org.nlogo.core.Dialect;
import org.nlogo.ide.AutoSuggest$;
import org.nlogo.ide.AutoSuggest$Trie$;
import org.nlogo.ide.AutoSuggest$TrieNode$;
import org.nlogo.nvm.ExtensionManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class AutoSuggest {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AutoSuggest.class.getDeclaredField("Trie$lzy1"));
    private final Set<String> primitiveNames;
    private final Function0<Set<String>> extensionPrimNames;
    private final int EDIT_WEIGHT_ADD;
    private final int EDIT_WEIGHT_REMOVE;
    private final int EDIT_WEIGHT_REPLACE;
    private final TrieNode trie;
    private Set<String> extensionPrims;
    private volatile Object Trie$lzy1;
    public final AutoSuggest$TrieNode$ TrieNode$lzy1;

    public static AutoSuggest apply(Dialect dialect, Option<ExtensionManager> option) {
        return AutoSuggest$.MODULE$.apply(dialect, option);
    }

    public AutoSuggest(Set<String> primitiveNames, Function0<Set<String>> extensionPrimNames) {
        this.primitiveNames = primitiveNames;
        this.extensionPrimNames = extensionPrimNames;
        this.TrieNode$lzy1 = new AutoSuggest$TrieNode$();
        this.EDIT_WEIGHT_ADD = 1;
        this.EDIT_WEIGHT_REMOVE = 1;
        this.EDIT_WEIGHT_REPLACE = 1;
        this.trie = new TrieNode(this, this.TrieNode().$lessinit$greater$default$1(), this.TrieNode().$lessinit$greater$default$2());
        this.extensionPrims = Predef$.MODULE$.Set().empty();
        primitiveNames.foreach(name -> this.trie().append(name.toLowerCase()));
    }

    public Set<String> primitiveNames() {
        return this.primitiveNames;
    }

    public int EDIT_WEIGHT_ADD() {
        return this.EDIT_WEIGHT_ADD;
    }

    public int EDIT_WEIGHT_REMOVE() {
        return this.EDIT_WEIGHT_REMOVE;
    }

    public int EDIT_WEIGHT_REPLACE() {
        return this.EDIT_WEIGHT_REPLACE;
    }

    public TrieNode trie() {
        return this.trie;
    }

    public Set<String> extensionPrims() {
        return this.extensionPrims;
    }

    public void extensionPrims_$eq(Set<String> x$1) {
        this.extensionPrims = x$1;
    }

    public int editDistance(String s1, String s2) {
        HashMap memo = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.stringDistance$1(memo, Predef$.MODULE$.wrapString(s1.toLowerCase()).toList(), Predef$.MODULE$.wrapString(s2.toLowerCase()).toList());
    }

    public void refresh() {
        this.extensionPrims().foreach((Function1 & Serializable)word -> this.trie().remove((String)word));
        this.extensionPrims_$eq((Set<String>)((Set)this.extensionPrimNames.apply()));
        this.extensionPrims().foreach(key -> this.trie().append((String)key));
    }

    public scala.collection.immutable.Seq<String> getSuggestions(String word) {
        ObjectRef suggestions = ObjectRef.create(this.trie().findByPrefix(word));
        if (word.length() > 1) {
            this.trie().findByAcronym(word).foreach(suggestion -> {
                suggestions$1.elem = (Seq)((Seq)suggestions$1.elem).$plus$plus(this.trie().findByPrefix((String)suggestion));
            });
        }
        return ((Seq)suggestions.elem).toSeq();
    }

    public final AutoSuggest$Trie$ Trie() {
        Object object = this.Trie$lzy1;
        if (object instanceof AutoSuggest$Trie$) {
            return (AutoSuggest$Trie$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AutoSuggest$Trie$)this.Trie$lzyINIT1();
    }

    private Object Trie$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Trie$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    AutoSuggest$Trie$ autoSuggest$Trie$ = null;
                    try {
                        autoSuggest$Trie$ = new AutoSuggest$Trie$(this);
                        serializable = autoSuggest$Trie$ == null ? LazyVals.NullValue$.MODULE$ : autoSuggest$Trie$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Trie$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return autoSuggest$Trie$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final AutoSuggest$TrieNode$ TrieNode() {
        return this.TrieNode$lzy1;
    }

    private static final int min$1(int a, int b, int c) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(a), b)), c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int stringDistance$1(HashMap memo$1, List s1, List s2) {
        int n;
        Tuple2 tuple2;
        if (memo$1.contains((Object)Tuple2$.MODULE$.apply((Object)s1, (Object)s2))) return BoxesRunTime.unboxToInt((Object)memo$1.apply((Object)Tuple2$.MODULE$.apply((Object)s1, (Object)s2)));
        Tuple2 tuple22 = tuple2 = Tuple2$.MODULE$.apply((Object)s1, (Object)s2);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        List list = (List)tuple2._1();
        List list2 = (List)tuple2._2();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            n = s1.length();
        } else {
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                n = s2.length();
            } else {
                if (!(list instanceof .colon.colon)) throw new MatchError((Object)tuple2);
                .colon.colon colon2 = (.colon.colon)list;
                List list5 = colon2.next();
                char c1 = BoxesRunTime.unboxToChar((Object)colon2.head());
                List t1 = list5;
                if (!(list2 instanceof .colon.colon)) throw new MatchError((Object)tuple2);
                .colon.colon colon3 = (.colon.colon)list2;
                List list6 = colon3.next();
                char c2 = BoxesRunTime.unboxToChar((Object)colon3.head());
                List t2 = list6;
                n = AutoSuggest.min$1(this.stringDistance$1(memo$1, t1, s2) + this.EDIT_WEIGHT_ADD(), this.stringDistance$1(memo$1, s1, t2) + this.EDIT_WEIGHT_REMOVE(), this.stringDistance$1(memo$1, t1, t2) + (c1 == c2 ? 0 : this.EDIT_WEIGHT_REPLACE()));
            }
        }
        memo$1.update((Object)tuple22, (Object)BoxesRunTime.boxToInteger((int)n));
        return BoxesRunTime.unboxToInt((Object)memo$1.apply((Object)Tuple2$.MODULE$.apply((Object)s1, (Object)s2)));
    }

    public static final void org$nlogo$ide$AutoSuggest$TrieNode$$_$foreachHelper$1(Function1 f$1, scala.collection.immutable.Seq nodes) {
        while (nodes.size() != 0) {
            nodes.foreach(node -> node.word().foreach(f$1));
            nodes = (scala.collection.immutable.Seq)nodes.flatMap((Function1 & Serializable)node -> node.children().values());
        }
    }

    public static final ListBuffer org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$1(String prefix$1, int currentIndex, TrieNode node, ListBuffer items) {
        Option option;
        while (true) {
            if (currentIndex == prefix$1.length()) {
                return (ListBuffer)items.$plus$plus((IterableOnce)node);
            }
            option = node.children().get((Object)BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(prefix$1.charAt(currentIndex)))));
            if (!(option instanceof Some)) break;
            TrieNode child = (TrieNode)((Some)option).value();
            int n = currentIndex + 1;
            TrieNode trieNode = child;
            currentIndex = n;
            node = trieNode;
        }
        if (None$.MODULE$.equals(option)) {
            return items;
        }
        throw new MatchError((Object)option);
    }

    public static final ListBuffer org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$2(String acronym$1, int currentIndex, TrieNode node, ListBuffer items, boolean previousDash, String word) {
        if (currentIndex == acronym$1.length()) {
            return (ListBuffer)items.$plus$eq((Object)word);
        }
        node.children().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 child = tuple2 = x$1;
            if (previousDash) {
                if (RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)child._1()))) == RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(acronym$1), currentIndex)))) {
                    AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$2(acronym$1, currentIndex + 1, (TrieNode)child._2(), items, BoxesRunTime.unboxToChar((Object)child._1()) == '-', word + child._1());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$2(acronym$1, currentIndex, (TrieNode)child._2(), items, BoxesRunTime.unboxToChar((Object)child._1()) == '-', word + child._1());
        });
        return items;
    }

    public static final ListBuffer org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$3(int length$1, int currentIndex, TrieNode node, ListBuffer items, String word) {
        if (currentIndex == length$1) {
            return (ListBuffer)items.$plus$eq((Object)word);
        }
        node.children().foreach((Function1 & Serializable)child -> AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$3(length$1, currentIndex + 1, (TrieNode)child._2(), items, word + child._1()));
        return items;
    }

    public static final boolean org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$4(String word$3, int currentIndex, TrieNode node) {
        Option option;
        while (true) {
            if (currentIndex == word$3.length()) {
                return node.word().isDefined();
            }
            option = node.children().get((Object)BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(word$3.charAt(currentIndex)))));
            if (!(option instanceof Some)) break;
            TrieNode child = (TrieNode)((Some)option).value();
            int n = currentIndex + 1;
            TrieNode trieNode = child;
            currentIndex = n;
            node = trieNode;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final Option org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$5(String word$4, ListBuffer buffer, int currentIndex, TrieNode node) {
        Option option;
        while (true) {
            if (currentIndex == word$4.length()) {
                return node.word().map((Function1 & Serializable)word -> (ListBuffer)buffer.$plus$eq((Object)node));
            }
            option = node.children().get((Object)BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(word$4.charAt(currentIndex)))));
            if (!(option instanceof Some)) break;
            TrieNode found = (TrieNode)((Some)option).value();
            buffer.$plus$eq((Object)node);
            int n = currentIndex + 1;
            TrieNode trieNode = found;
            currentIndex = n;
            node = trieNode;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ IterableOnce org$nlogo$ide$AutoSuggest$TrieNode$$_$iterator$$anonfun$1$$anonfun$1(TrieNode _$2) {
        return _$2.iterator();
    }

    public interface Trie
    extends Iterable<String> {
        public void append(String var1);

        public Seq<String> findByPrefix(String var1);

        public boolean contains(String var1);

        public boolean remove(String var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TrieNode
    implements IterableOnce,
    IterableOnceOps,
    IterableOps,
    IterableFactoryDefaults,
    Iterable,
    Trie {
        private final Option<Object> char;
        private Option<String> word;
        private final Map<Object, TrieNode> children;
        private final /* synthetic */ AutoSuggest $outer;

        public TrieNode(AutoSuggest $outer, Option<Object> option, Option<String> word) {
            this.char = option;
            this.word = word;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            IterableOps.$init$((IterableOps)this);
            IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
            Iterable.$init$((Iterable)this);
            this.children = CollectionConverters$.MODULE$.MapHasAsScala(new TreeMap()).asScala();
        }

        public Option<Object> char() {
            return this.char;
        }

        public Option<String> word() {
            return this.word;
        }

        public void word_$eq(Option<String> x$1) {
            this.word = x$1;
        }

        public Map<Object, TrieNode> children() {
            return this.children;
        }

        @Override
        public void append(String key) {
            this.appendHelper$1(key, this, 0);
        }

        public <U> void foreach(Function1<String, U> f) {
            AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$foreachHelper$1(f, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TrieNode[]{this}));
        }

        @Override
        public Seq<String> findByPrefix(String prefix) {
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$1(prefix, 0, this, new ListBuffer());
        }

        public Seq<String> findByAcronym(String acronym) {
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$2(acronym, 0, this, new ListBuffer(), true, "");
        }

        public Seq<String> findByLength(String prefix, int length) {
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$3(length, 0, this, new ListBuffer(), "");
        }

        @Override
        public boolean contains(String word) {
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$4(word, 0, this);
        }

        @Override
        public boolean remove(String word) {
            Option<ListBuffer<TrieNode>> option = this.pathTo(word);
            if (option instanceof Some) {
                ListBuffer path = (ListBuffer)((Some)option).value();
                int index = path.length() - 1;
                boolean bl = true;
                ((TrieNode)path.apply(index)).word_$eq((Option<String>)None$.MODULE$);
                while (index > 0 && bl) {
                    TrieNode current = (TrieNode)path.apply(index);
                    if (current.word().isDefined()) {
                        bl = false;
                        continue;
                    }
                    TrieNode parent = (TrieNode)path.apply(index - 1);
                    if (current.children().isEmpty()) {
                        parent.children().remove((Object)BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(word.charAt(index - 1)))));
                    }
                    --index;
                }
                return true;
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError(option);
        }

        public Option<ListBuffer<TrieNode>> pathTo(String word) {
            return AutoSuggest.org$nlogo$ide$AutoSuggest$TrieNode$$_$helper$5(word, new ListBuffer(), 0, this);
        }

        public Iterator<String> iterator() {
            return package$.MODULE$.Iterator().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.word()})).flatten(Predef$.MODULE$.$conforms()).$plus$plus(this::iterator$$anonfun$1);
        }

        public String toString() {
            return "Trie(char=" + this.char() + ",word=" + this.word() + ")";
        }

        public final /* synthetic */ AutoSuggest org$nlogo$ide$AutoSuggest$TrieNode$$$outer() {
            return this.$outer;
        }

        private final TrieNode $anonfun$1(char char$1) {
            return new TrieNode(this.$outer, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)char$1)), this.$outer.TrieNode().$lessinit$greater$default$2());
        }

        private final void appendHelper$1(String key$1, TrieNode node, int currentIndex) {
            while (true) {
                TrieNode result;
                if (currentIndex == key$1.length()) {
                    node.word_$eq((Option<String>)Some$.MODULE$.apply((Object)key$1));
                    return;
                }
                char c = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(key$1.charAt(currentIndex)));
                TrieNode trieNode = result = (TrieNode)node.children().getOrElseUpdate((Object)BoxesRunTime.boxToCharacter((char)c), () -> this.$anonfun$1(c));
                int n = currentIndex + 1;
                node = trieNode;
                currentIndex = n;
            }
        }

        private final IterableOnce iterator$$anonfun$1() {
            return (IterableOnce)this.children().values().flatMap(AutoSuggest::org$nlogo$ide$AutoSuggest$TrieNode$$_$iterator$$anonfun$1$$anonfun$1);
        }
    }
}

