/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.job;

import java.io.Serializable;
import java.util.List;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.job.JobThread;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerInterface;
import org.nlogo.nvm.JobManagerOwner;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class JobManager
implements JobManagerInterface {
    private final World world;
    private final JobThread thread;

    public JobManager(JobManagerOwner jobManagerOwner, World world, Object lock) {
        this.world = world;
        this.thread = new JobThread(this, jobManagerOwner, lock);
    }

    private World world() {
        return this.world;
    }

    @Override
    public boolean isInterrupted() {
        return this.thread.isInterrupted();
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    @Override
    public void die() throws InterruptedException {
        this.thread.die();
    }

    @Override
    public void timeToRunSecondaryJobs() {
        this.thread.isTimeToRunSecondaryJobs_$eq(true);
    }

    @Override
    public void maybeRunSecondaryJobs() {
        this.thread.maybeRunSecondaryJobs();
    }

    @Override
    public boolean anyPrimaryJobs() {
        return !this.thread.primaryJobs().isEmpty();
    }

    @Override
    public boolean onJobThread() {
        Thread thread = Thread.currentThread();
        JobThread jobThread = this.thread;
        return !(thread != null ? !thread.equals(jobThread) : jobThread != null);
    }

    @Override
    public void addJob(Job job, boolean waitForCompletion) {
        if (waitForCompletion) {
            this.add(job, this.thread.primaryJobs());
            this.waitFor(job, false);
            return;
        }
        this.add(job, this.thread.primaryJobs());
    }

    @Override
    public Job makeConcurrentJob(JobOwner owner, AgentSet agentSet, Workspace workspace, Procedure procedure) {
        return new ConcurrentJob(owner, agentSet, procedure, 0, null, workspace, owner.random());
    }

    @Override
    public Object callReporterProcedure(JobOwner owner, AgentSet agentSet, Workspace workspace, Procedure procedure) throws LogoException {
        return new ExclusiveJob(owner, agentSet, procedure, 0, null, workspace, owner.random()).callReporterProcedure();
    }

    @Override
    public Object addReporterJobAndWait(JobOwner owner, AgentSet agentSet, Workspace workspace, Procedure procedure) {
        ConcurrentJob job = new ConcurrentJob(owner, agentSet, procedure, 0, null, workspace, owner.random());
        this.add(job, this.thread.primaryJobs());
        this.waitFor(job, false);
        return job.result;
    }

    @Override
    public void addJobFromJobThread(Job job) {
        this.thread.primaryJobs().add(job);
    }

    @Override
    public void addJob(JobOwner owner, AgentSet agents, Workspace workspace, Procedure procedure) {
        this.add(new ConcurrentJob(owner, agents, procedure, 0, null, workspace, owner.random()), this.thread.primaryJobs());
    }

    @Override
    public void addSecondaryJob(JobOwner owner, AgentSet agents, Workspace workspace, Procedure procedure) {
        boolean bl;
        List<Job> list = this.thread.secondaryJobs();
        synchronized (list) {
            bl = CollectionConverters$.MODULE$.ListHasAsScala(this.thread.secondaryJobs()).asScala().exists((Function1 & Serializable)s -> {
                if (s == null) return false;
                JobOwner jobOwner = s.owner;
                JobOwner jobOwner2 = owner;
                if (jobOwner == null) {
                    if (jobOwner2 != null) {
                        return false;
                    }
                } else if (!jobOwner.equals(jobOwner2)) return false;
                if (s.state != 0) return false;
                return true;
            });
        }
        boolean found = bl;
        if (!found) {
            this.add(new ConcurrentJob(owner, agents, procedure, 0, null, workspace, owner.random()), this.thread.secondaryJobs());
            return;
        }
    }

    private void add(Job job, List<Job> jobs) {
        jobs.add(job);
        if (job.isTurtleForeverButtonJob()) {
            this.thread.turtleForeverButtonJobs().add((ConcurrentJob)job);
        }
        if (job.isLinkForeverButtonJob()) {
            this.thread.linkForeverButtonJobs().add((ConcurrentJob)job);
        }
        if (job.topLevelProcedure != null) {
            Object object = this.thread.newJobsCondition();
            synchronized (object) {
                this.thread.newJobsCondition().notifyAll();
            }
            return;
        }
    }

    @Override
    public void joinForeverButtons(Agent agent) {
        Agent agent2 = agent;
        if (agent2 instanceof Turtle) {
            Turtle t = (Turtle)agent2;
            List<ConcurrentJob> list = this.thread.turtleForeverButtonJobs();
            synchronized (list) {
                CollectionConverters$.MODULE$.ListHasAsScala(this.thread.turtleForeverButtonJobs()).asScala().foreach(job -> job.newAgentJoining(agent, -1, 0));
            }
            return;
        }
        if (agent2 instanceof Link) {
            Link t = (Link)agent2;
            List<ConcurrentJob> list = this.thread.linkForeverButtonJobs();
            synchronized (list) {
                CollectionConverters$.MODULE$.ListHasAsScala(this.thread.linkForeverButtonJobs()).asScala().foreach(job -> job.newAgentJoining(agent, -1, 0));
            }
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public void haltPrimary() {
        this.finishJobs(this.thread.primaryJobs(), null);
        this.waitForFinishedJobs(this.thread.primaryJobs());
    }

    @Override
    public void haltNonObserverJobs() {
        Buffer buffer;
        List<Job> list = this.thread.primaryJobs();
        synchronized (list) {
            buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.thread.primaryJobs()).asScala().filter((Function1 & Serializable)j -> {
                if (j == null) return false;
                AgentKind agentKind = j.agentset.kind();
                AgentKind$Observer$ agentKind$Observer$ = AgentKind$Observer$.MODULE$;
                if (agentKind == null) {
                    if (agentKind$Observer$ == null) return false;
                    return true;
                } else if (agentKind.equals(agentKind$Observer$)) return false;
                return true;
            });
        }
        List goners = CollectionConverters$.MODULE$.BufferHasAsJava(buffer).asJava();
        this.finishJobs(goners, null);
        this.waitForFinishedJobs(goners);
    }

    @Override
    public void finishJobs(JobOwner owner) {
        this.finishJobs(this.thread.primaryJobs(), owner);
    }

    @Override
    public void finishSecondaryJobs(JobOwner owner) {
        this.finishJobs(this.thread.secondaryJobs(), owner);
        this.thread.lastSecondaryRun_$eq(0L);
        this.timeToRunSecondaryJobs();
    }

    @Override
    public void haltSecondary() {
        this.finishJobs(this.thread.secondaryJobs(), null);
        this.thread.lastSecondaryRun_$eq(0L);
        this.timeToRunSecondaryJobs();
        this.waitForFinishedJobs(this.thread.secondaryJobs());
    }

    @Override
    public void stoppingJobs(JobOwner owner) {
        List<Job> list = this.thread.primaryJobs();
        synchronized (list) {
            CollectionConverters$.MODULE$.ListHasAsScala(this.thread.primaryJobs()).asScala().withFilter((Function1 & Serializable)job -> {
                if (job == null) return false;
                if (owner == null) return true;
                JobOwner jobOwner = job.owner;
                JobOwner jobOwner2 = owner;
                if (jobOwner != null) {
                    if (!jobOwner.equals(jobOwner2)) return false;
                    return true;
                }
                if (jobOwner2 == null) return true;
                return false;
            }).foreach(job -> {
                job.stopping = true;
            });
        }
    }

    private void waitFor(Job job, boolean kill) {
        while (job.state != 2 && this.thread.isAlive()) {
            if (kill) {
                this.thread.interrupt();
                this.world().comeUpForAir = true;
            }
            this.thread.isTimeToRunSecondaryJobs_$eq(true);
            Exceptions$.MODULE$.ignoring((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{InterruptedException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                JobManager.waitFor$$anonfun$1(job);
                return BoxedUnit.UNIT;
            });
        }
        if (job.result instanceof Exception && !(job.result instanceof LogoException)) {
            throw (Exception)job.result;
        }
    }

    public void finishJobs(List<Job> jobs, JobOwner owner) {
        List<Job> list = jobs;
        synchronized (list) {
            CollectionConverters$.MODULE$.ListHasAsScala(jobs).asScala().withFilter((Function1 & Serializable)job -> {
                if (job == null) return false;
                if (owner == null) return true;
                JobOwner jobOwner = job.owner;
                JobOwner jobOwner2 = owner;
                if (jobOwner != null) {
                    if (!jobOwner.equals(jobOwner2)) return false;
                    return true;
                }
                if (jobOwner2 == null) return true;
                return false;
            }).foreach(job -> job.finish());
        }
    }

    private void waitForFinishedJobs(List<Job> jobs) {
        while (this.thread.isAlive()) {
            Option jobToWaitFor;
            Option option;
            List<Job> list = jobs;
            synchronized (list) {
                option = CollectionConverters$.MODULE$.ListHasAsScala(jobs).asScala().find((Function1 & Serializable)_$1 -> _$1 != null);
            }
            Option option2 = jobToWaitFor = option;
            if (option2 instanceof Some) {
                Job j = (Job)((Some)option2).value();
                this.waitFor(j, true);
                continue;
            }
            return;
        }
    }

    private static final void waitFor$$anonfun$1(Job job$1) {
        Job job = job$1;
        synchronized (job) {
            job$1.wait(50L);
        }
    }
}

