/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.PeriodicUpdateDelay$;
import org.nlogo.job.JobManager;
import org.nlogo.job.JobThread$;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobManagerOwner;
import scala.Function0;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class JobThread
extends Thread {
    private final JobManager manager;
    private final JobManagerOwner owner;
    private final Object lock;
    private final List<Job> primaryJobs;
    private final List<Job> secondaryJobs;
    private volatile boolean dying;
    private final List<ConcurrentJob> turtleForeverButtonJobs;
    private final List<ConcurrentJob> linkForeverButtonJobs;
    private long lastSecondaryRun;
    private final Object newJobsCondition;
    private boolean isTimeToRunSecondaryJobs;
    private JobOwner activeButton;
    private long lastSecondaryRunDuration;

    public static int stackSize() {
        return JobThread$.MODULE$.stackSize();
    }

    public JobThread(JobManager manager, JobManagerOwner owner, Object lock) {
        this.manager = manager;
        this.owner = owner;
        this.lock = lock;
        super(null, null, "JobThread", Int$.MODULE$.int2long(JobThread$.MODULE$.stackSize() * 1024 * 1024));
        this.primaryJobs = Collections.synchronizedList(new ArrayList());
        this.secondaryJobs = Collections.synchronizedList(new ArrayList());
        this.dying = false;
        this.turtleForeverButtonJobs = Collections.synchronizedList(new ArrayList());
        this.linkForeverButtonJobs = Collections.synchronizedList(new ArrayList());
        this.lastSecondaryRun = 0L;
        this.newJobsCondition = new Object();
        this.isTimeToRunSecondaryJobs = false;
        this.activeButton = null;
        this.lastSecondaryRunDuration = 0L;
        this.setPriority(4);
        this.start();
    }

    public List<Job> primaryJobs() {
        return this.primaryJobs;
    }

    public List<Job> secondaryJobs() {
        return this.secondaryJobs;
    }

    public List<ConcurrentJob> turtleForeverButtonJobs() {
        return this.turtleForeverButtonJobs;
    }

    public List<ConcurrentJob> linkForeverButtonJobs() {
        return this.linkForeverButtonJobs;
    }

    public long lastSecondaryRun() {
        return this.lastSecondaryRun;
    }

    public void lastSecondaryRun_$eq(long x$1) {
        this.lastSecondaryRun = x$1;
    }

    public Object newJobsCondition() {
        return this.newJobsCondition;
    }

    public boolean isTimeToRunSecondaryJobs() {
        return this.isTimeToRunSecondaryJobs;
    }

    public void isTimeToRunSecondaryJobs_$eq(boolean x$1) {
        this.isTimeToRunSecondaryJobs = x$1;
    }

    public void die() throws InterruptedException {
        this.setPriority(10);
        this.dying = true;
        Object object = this.newJobsCondition();
        synchronized (object) {
            this.newJobsCondition().notifyAll();
        }
        this.join();
    }

    @Override
    public void run() {
        Exceptions$.MODULE$.handling((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{RuntimeException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.run$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void maybeRunSecondaryJobs() {
        if (this.isTimeToRunSecondaryJobs()) {
            long now = System.currentTimeMillis();
            if (now - this.lastSecondaryRun() > (long)(PeriodicUpdateDelay$.MODULE$.DelayInMilliseconds() / 2) + this.lastSecondaryRunDuration) {
                this.compact(this.secondaryJobs());
                this.runSecondaryJobs();
                this.isTimeToRunSecondaryJobs_$eq(false);
                this.lastSecondaryRun_$eq(System.currentTimeMillis());
                this.lastSecondaryRunDuration = this.lastSecondaryRun() - now;
                this.owner.periodicUpdate();
                return;
            }
            return;
        }
    }

    private void runPrimaryJobs() {
        for (int i = 0; i < this.primaryJobs().size(); ++i) {
            Job job = this.primaryJobs().get(i);
            if (job.state != 0) {
                if (job.topLevelProcedure != null && job.owner == this.activeButton) {
                    this.activeButton = null;
                }
                this.primaryJobs().set(i, null);
                if (job.isTurtleForeverButtonJob()) {
                    this.turtleForeverButtonJobs().remove(job);
                }
                if (job.isLinkForeverButtonJob()) {
                    this.linkForeverButtonJobs().remove(job);
                }
                job.state = (byte)2;
                if (job.topLevelProcedure == null) continue;
                this.owner.updateDisplay(false);
                Job job2 = job;
                synchronized (job2) {
                    job.notifyAll();
                }
                this.owner.ownerFinished(job.owner);
                continue;
            }
            boolean skip = false;
            if (job.owner.isButton() && job.topLevelProcedure != null) {
                if (this.activeButton != null) {
                    JobOwner jobOwner = job.owner;
                    JobOwner jobOwner2 = this.activeButton;
                    if (jobOwner == null ? jobOwner2 != null : !jobOwner.equals(jobOwner2)) {
                        skip = true;
                    }
                } else {
                    this.activeButton = job.owner;
                }
            }
            if (!skip) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        job.step();
                    }
                }
                catch (LogoException ex) {
                    job.result = ex;
                    this.manager.finishJobs(this.primaryJobs(), job.owner);
                }
                catch (RuntimeException ex) {
                    job.result = ex;
                    this.manager.finishJobs(this.primaryJobs(), job.owner);
                }
            }
            if (!job.buttonTurnIsOver) continue;
            this.activeButton = null;
            job.buttonTurnIsOver = false;
        }
    }

    private void runSecondaryJobs() {
        for (int i = 0; i < this.secondaryJobs().size(); ++i) {
            Job job = this.secondaryJobs().get(i);
            if (job.state != 0) {
                this.secondaryJobs().set(i, null);
                job.state = (byte)2;
                if (job.topLevelProcedure == null) continue;
                Job job2 = job;
                synchronized (job2) {
                    job.notifyAll();
                }
                this.owner.ownerFinished(job.owner);
                continue;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    job.step();
                    continue;
                }
            }
            catch (LogoException ex) {
                job.result = ex;
                this.manager.finishJobs(this.primaryJobs(), job.owner);
                continue;
            }
            catch (RuntimeException ex) {
                job.result = ex;
                this.manager.finishJobs(this.primaryJobs(), job.owner);
            }
        }
    }

    private void compact(List<Job> list) {
        List<Job> list2 = list;
        synchronized (list2) {
            Iterator<Job> iter = list.iterator();
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                iter.remove();
            }
        }
    }

    private final void run$$anonfun$1$$anonfun$1() {
        this.newJobsCondition().wait(Int$.MODULE$.int2long(PeriodicUpdateDelay$.MODULE$.DelayInMilliseconds()));
    }

    private final void run$$anonfun$1() {
        while (!this.dying) {
            this.compact(this.primaryJobs());
            this.runPrimaryJobs();
            this.maybeRunSecondaryJobs();
            Object object = this.newJobsCondition();
            synchronized (object) {
                BoxedUnit boxedUnit;
                if (this.primaryJobs().isEmpty()) {
                    Exceptions$.MODULE$.ignoring((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{InterruptedException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        this.run$$anonfun$1$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }
}

