/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lab;

import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.LabExporterType$;
import org.nlogo.api.LabProtocol;
import org.nlogo.core.WorldDimensions;
import org.nlogo.lab.Exporter;
import org.nlogo.nvm.Workspace;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxesRunTime;

public class TableExporter
extends Exporter {
    private final LabProtocol protocol;
    private final PrintWriter out;
    private final HashMap<Object, List<Tuple2<String, Object>>> settings;

    public TableExporter(String modelFileName, WorldDimensions initialDims, LabProtocol protocol, PrintWriter out) {
        this.protocol = protocol;
        this.out = out;
        super(modelFileName, initialDims, protocol, out, LabExporterType$.MODULE$.TABLE());
        this.settings = new HashMap();
    }

    public HashMap<Object, List<Tuple2<String, Object>>> settings() {
        return this.settings;
    }

    @Override
    public void experimentStarted() {
        if (this.protocol.runsCompleted() == 0) {
            this.writeExportHeader();
            this.writeExperimentHeader();
        }
        this.out.flush();
    }

    @Override
    public void runStarted(Workspace w, int runNumber, List<Tuple2<String, Object>> runSettings) {
        this.settings().update((Object)BoxesRunTime.boxToInteger((int)runNumber), runSettings);
    }

    @Override
    public void measurementsTaken(Workspace w, int runNumber, int step, List<Object> values) {
        if (!values.isEmpty()) {
            this.writeTableRow(runNumber, step, values);
            return;
        }
    }

    @Override
    public void runCompleted(Workspace w, int runNumber, int steps) {
        if (this.protocol.metrics().isEmpty()) {
            this.writeTableRow(runNumber, steps, (List<Object>)package$.MODULE$.Nil());
        }
        this.out.flush();
        this.settings().$minus$eq((Object)BoxesRunTime.boxToInteger((int)runNumber));
    }

    @Override
    public void experimentAborted() {
        this.out.close();
    }

    @Override
    public void experimentCompleted() {
        this.out.close();
    }

    public void writeExperimentHeader() {
        List list = ((List)this.protocol.valueSets().apply(0)).map((Function1 & Serializable)_$1 -> _$1.variableName());
        List headers = this.protocol.metrics().$colon$colon((Object)"[step]").$colon$colon$colon(list).$colon$colon((Object)"[run number]");
        this.out.println(headers.map((Function1 & Serializable)s -> this.csv().header((String)s)).mkString(","));
    }

    public void writeTableRow(int runNumber, int step, List<Object> values) {
        List list = ((List)this.settings().apply((Object)BoxesRunTime.boxToInteger((int)runNumber))).map((Function1 & Serializable)_$2 -> _$2._2());
        List entries = values.$colon$colon((Object)BoxesRunTime.boxToInteger((int)step)).$colon$colon$colon(list).$colon$colon((Object)BoxesRunTime.boxToInteger((int)runNumber));
        this.out.println(entries.map((Function1 & Serializable)obj -> this.csv().data(obj)).mkString(","));
    }
}

