/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lex;

import java.io.BufferedReader;
import org.nlogo.lex.LexReader;
import scala.Int$;

public class AutoGrowingBufferedReader
implements LexReader {
    private final BufferedReader reader;
    private int markSize;
    private int remainingMark;

    public AutoGrowingBufferedReader(BufferedReader reader) {
        this.reader = reader;
        this.markSize = 65536;
        this.remainingMark = 0;
    }

    @Override
    public void mark() {
        this.reader.mark(this.markSize);
        this.remainingMark = this.markSize;
    }

    @Override
    public void reset() {
        this.reader.reset();
        this.remainingMark = this.markSize;
    }

    @Override
    public void skip(long l) {
        this.reader.skip(l);
        this.remainingMark -= (int)l;
    }

    @Override
    public int read() {
        if (this.remainingMark == 0) {
            this.reader.reset();
            this.reader.mark(this.markSize * 2);
            this.reader.skip(Int$.MODULE$.int2long(this.markSize));
            this.remainingMark = this.markSize;
            this.markSize *= 2;
        }
        int i = this.reader.read();
        --this.remainingMark;
        return i;
    }
}

