/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lex;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.core.NumberParser$;
import org.nlogo.core.StringEscaper$;
import org.nlogo.core.Token;
import org.nlogo.core.Token$;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$Bad$;
import org.nlogo.core.TokenType$CloseBrace$;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$CloseParen$;
import org.nlogo.core.TokenType$Comma$;
import org.nlogo.core.TokenType$Comment$;
import org.nlogo.core.TokenType$Extension$;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBrace$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$OpenParen$;
import org.nlogo.lex.Accept$;
import org.nlogo.lex.Charset$;
import org.nlogo.lex.Error$;
import org.nlogo.lex.Finished$;
import org.nlogo.lex.LexOperations$;
import org.nlogo.lex.LexOperations$PrefixConversions$;
import org.nlogo.lex.LexStates;
import org.nlogo.lex.WrappedInput;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class TokenLexer {
    private final Map<String, TokenType> punctuation;

    public TokenLexer() {
        Object[] objectArray = new Tuple2[7];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)",");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TokenType$Comma$.MODULE$);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"{");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)TokenType$OpenBrace$.MODULE$);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"}");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)TokenType$CloseBrace$.MODULE$);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"(");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)TokenType$OpenParen$.MODULE$);
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)")");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)TokenType$CloseParen$.MODULE$);
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"[");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)TokenType$OpenBracket$.MODULE$);
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"]");
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)TokenType$CloseBracket$.MODULE$);
        this.punctuation = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Seq<Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>>> lexerOrdering() {
        return (Seq)((SeqOps)new .colon.colon(this.extensionLiteral(), (List)new .colon.colon(this.punct(), (List)new .colon.colon(this.comment(), (List)new .colon.colon(this.numericLiteral(), (List)new .colon.colon(this.string(), (List)new .colon.colon(this.ident(), (List)new .colon.colon(this.illegalCharacter(), (List)Nil$.MODULE$))))))));
    }

    public Tuple2<Token, WrappedInput> apply(WrappedInput input) {
        if (input.hasNext()) {
            Tuple2 r = (Tuple2)this.lexerOrdering().foldLeft((Object)Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), (Object)input), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Option option = (Option)tuple22._1();
                        WrappedInput wrappedInput = (WrappedInput)tuple22._2();
                        if (option instanceof Some) {
                            Token token = (Token)((Some)option).value();
                            WrappedInput remaining = wrappedInput;
                            if (tuple23 != null) {
                                Function1 prefixDetector = (Function1)tuple23._1();
                                Function1 tokenizer = (Function1)tuple23._2();
                                return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)token), (Object)remaining);
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            WrappedInput remaining = wrappedInput;
                            if (tuple23 != null) {
                                Function1 prefixDetector = (Function1)tuple23._1();
                                Function1 tokenizer = (Function1)tuple23._2();
                                return (Tuple2)remaining.assembleToken((Function1<Object, LexStates>)prefixDetector, (Function1<String, Option<Tuple3<String, TokenType, Object>>>)tokenizer).map((Function1 & Serializable)o -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply(o._1()), o._2())).getOrElse(() -> TokenLexer.$anonfun$1$$anonfun$2(remaining));
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return Tuple2$.MODULE$.apply(((Option)r._1()).get(), r._2());
        }
        return Tuple2$.MODULE$.apply((Object)Token$.MODULE$.Eof(), (Object)input);
    }

    public Tuple2<Object, WrappedInput> fastForwardWhitespace(WrappedInput input) {
        Tuple2<String, WrappedInput> tuple2 = input.longestPrefix((Function1<Object, LexStates>)(Function1 & Serializable)c -> TokenLexer.$anonfun$2(BoxesRunTime.unboxToChar((Object)c)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String spaces = (String)tuple2._1();
        WrappedInput remainder = (WrappedInput)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)spaces, (Object)remainder);
        String spaces2 = (String)tuple22._1();
        WrappedInput remainder2 = (WrappedInput)tuple22._2();
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)spaces2.length()), (Object)remainder2);
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> extensionLiteral() {
        DoubleBracePairMatcher innerMatcher = new DoubleBracePairMatcher();
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{innerMatcher, LexOperations$.MODULE$.anyOf((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('}'), LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('\n'), LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('\r')}))})), (Function1 & Serializable)literalString -> this.tokenizeExtensionLiteral(innerMatcher, (String)literalString));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> punct() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.characterMatching((Function1<Object, Object>)(Function1 & Serializable)c -> this.punct$$anonfun$1(BoxesRunTime.unboxToChar((Object)c))), (Function1 & Serializable)p -> this.punctuation.get(p).map((Function1 & Serializable)tpe -> Tuple3$.MODULE$.apply(p, tpe, null)));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> string() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('\"'), this.stringLexer(), LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('\"')})), (Function1 & Serializable)stringText -> this.tokenizeString((String)stringText));
    }

    public Function1<Object, LexStates> stringLexer() {
        return LexOperations$.MODULE$.withFeedback(Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\"')), (Function2 & Serializable)(x$1, x$2) -> TokenLexer.stringLexer$$anonfun$1((Option)x$1, BoxesRunTime.unboxToChar((Object)x$2)));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> comment() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$PrefixConversions$.MODULE$.charToLexPredicate(';'), LexOperations$.MODULE$.zeroOrMore((Function1<Object, Object>)(Function1 & Serializable)c -> TokenLexer.comment$$anonfun$1(BoxesRunTime.unboxToChar((Object)c)))})), (Function1 & Serializable)s -> Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply(s, (Object)TokenType$Comment$.MODULE$, null)));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> numericLiteral() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$.MODULE$.anyOf((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$.MODULE$.characterMatching((Function1<Object, Object>)(Function1 & Serializable)x$0 -> TokenLexer.numericLiteral$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$0))), LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$.MODULE$.anyOf((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('.'), LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('-')})), LexOperations$.MODULE$.anyOf((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$.MODULE$.characterMatching((Function1<Object, Object>)(Function1 & Serializable)x$0 -> TokenLexer.numericLiteral$$anonfun$2(BoxesRunTime.unboxToChar((Object)x$0))), LexOperations$.MODULE$.chain((Seq<Function1<Object, LexStates>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{LexOperations$PrefixConversions$.MODULE$.charToLexPredicate('.'), LexOperations$.MODULE$.characterMatching((Function1<Object, Object>)(Function1 & Serializable)x$0 -> TokenLexer.numericLiteral$$anonfun$3(BoxesRunTime.unboxToChar((Object)x$0)))}))}))}))})), LexOperations$.MODULE$.zeroOrMore((Function1<Object, Object>)(Function1 & Serializable)c -> Charset$.MODULE$.validIdentifierChar(BoxesRunTime.unboxToChar((Object)c)))})), (Function1 & Serializable)literalString -> this.tokenizeLiteral((String)literalString));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> ident() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.oneOrMore((Function1<Object, Object>)(Function1 & Serializable)c -> Charset$.MODULE$.validIdentifierChar(BoxesRunTime.unboxToChar((Object)c))), (Function1 & Serializable)identString -> this.tokenizeIdent((String)identString));
    }

    public Tuple2<Function1<Object, LexStates>, Function1<String, Option<Tuple3<String, TokenType, Object>>>> illegalCharacter() {
        return Tuple2$.MODULE$.apply(LexOperations$.MODULE$.aSingle((Function1<Object, LexStates>)(Function1 & Serializable)c -> TokenLexer.illegalCharacter$$anonfun$1(BoxesRunTime.unboxToChar((Object)c))), (Function1 & Serializable)s -> Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply(s, (Object)TokenType$Bad$.MODULE$, (Object)"This non-standard character is not allowed.")));
    }

    private Option<Tuple3<String, TokenType, Object>> tokenizeExtensionLiteral(DoubleBracePairMatcher innerMatcher, String literalString) {
        String string = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(literalString), 2);
        String string2 = "{{";
        if (string == null ? string2 != null : !string.equals(string2)) {
            return None$.MODULE$;
        }
        if (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(literalString)) == '\n' || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(literalString)) == '\r') {
            return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)"", (Object)TokenType$Bad$.MODULE$, (Object)"End of line reached unexpectedly"));
        }
        if (BoxesRunTime.unboxToInt((Object)((Tuple2)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(literalString), (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)Option$.MODULE$.empty()), (Function2 & Serializable)(x$1, x$2) -> TokenLexer.tokenizeExtensionLiteral$$anonfun$1((Tuple2)x$1, BoxesRunTime.unboxToChar((Object)x$2))))._1()) > 0) {
            return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)"", (Object)TokenType$Bad$.MODULE$, (Object)"End of file reached unexpectedly"));
        }
        return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)literalString, (Object)TokenType$Extension$.MODULE$, (Object)literalString));
    }

    private Option<Tuple3<String, TokenType, Object>> tokenizeLiteral(String literalString) {
        if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(literalString), (Function1 & Serializable)x$0 -> TokenLexer.tokenizeLiteral$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$0)))) {
            Either<String, Double> either = NumberParser$.MODULE$.parse(literalString);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)literalString, (Object)TokenType$Bad$.MODULE$, (Object)error));
            }
            if (either instanceof Right) {
                Double literal = (Double)((Right)either).value();
                return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)literalString, (Object)TokenType$Literal$.MODULE$, (Object)literal));
            }
            throw new MatchError(either);
        }
        return None$.MODULE$;
    }

    private Option<Tuple3<String, TokenType, Object>> tokenizeIdent(String identString) {
        return Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)identString, (Object)TokenType$Ident$.MODULE$, (Object)identString.toUpperCase(Locale.ENGLISH)));
    }

    private Option<Tuple3<String, TokenType, Object>> tokenizeString(String stringText) {
        Some some;
        block3: {
            boolean lastCharEscaped = BoxesRunTime.unboxToBoolean((Object)StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(stringText), 1)), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(x$1, x$2) -> TokenLexer.$anonfun$3(BoxesRunTime.unboxToBoolean((Object)x$1), BoxesRunTime.unboxToChar((Object)x$2))));
            try {
                if (stringText.length() == 1 || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(stringText)) != '\"' || lastCharEscaped) {
                    some = Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)String.valueOf(stringText), (Object)TokenType$Bad$.MODULE$, (Object)"Closing double quote is missing"));
                    break block3;
                }
                String unescapedText = StringEscaper$.MODULE$.unescapeString(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(stringText), 1)), 1));
                some = Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)String.valueOf(stringText), (Object)TokenType$Literal$.MODULE$, (Object)unescapedText));
            }
            catch (IllegalArgumentException ex) {
                some = Some$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)String.valueOf(stringText), (Object)TokenType$Bad$.MODULE$, (Object)"Illegal character after backslash"));
            }
        }
        return some;
    }

    private static final Tuple2 $anonfun$1$$anonfun$2(WrappedInput remaining$1) {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)remaining$1);
    }

    private static final /* synthetic */ LexStates $anonfun$2(char c) {
        return (LexStates)((Object)(Character.isWhitespace(c) ? Accept$.MODULE$ : Finished$.MODULE$));
    }

    private static final /* synthetic */ Tuple2 $init$$$anonfun$1(Tuple2 x$1, char x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
            if (tuple22 != null) {
                Option option = (Option)tuple22._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple22._2());
                if (None$.MODULE$.equals(option) && 0 == n && '{' == c) {
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'{')), (Object)BoxesRunTime.boxToInteger((int)0)), (Object)Accept$.MODULE$);
                }
                int n2 = n;
                if (n2 < 0) {
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)Error$.MODULE$);
                }
                int n3 = n;
                char c2 = c;
                if (c2 == '\r' || c2 == '\n') {
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)c2)), (Object)BoxesRunTime.boxToInteger((int)n3)), (Object)Finished$.MODULE$);
                }
                if (option instanceof Some) {
                    char c3 = BoxesRunTime.unboxToChar((Object)((Some)option).value());
                    if ('\"' == c3) {
                        int n4 = n;
                        if ('{' == c) {
                            return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n4)), (Object)Accept$.MODULE$);
                        }
                        int n5 = n;
                        if ('}' == c) {
                            return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)n5)), (Object)Accept$.MODULE$);
                        }
                    }
                    if ('}' == c3 && 1 == n && '}' == c) {
                        return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)), (Object)Finished$.MODULE$);
                    }
                    if ('{' == c3) {
                        int n6 = n;
                        if ('{' == c) {
                            return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(n6 + 1))), (Object)Accept$.MODULE$);
                        }
                    }
                    if ('}' == c3) {
                        int n7 = n;
                        if ('}' == c) {
                            return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(n7 - 1))), (Object)Accept$.MODULE$);
                        }
                    }
                    char c4 = c3;
                    if (0 == n && c4 != '{') {
                        return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)), (Object)Error$.MODULE$);
                    }
                }
                int n8 = n;
                char c5 = c;
                return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)c5)), (Object)BoxesRunTime.boxToInteger((int)n8)), (Object)Accept$.MODULE$);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ Tuple2 org$nlogo$lex$TokenLexer$DoubleBracePairMatcher$$_$$lessinit$greater$$anonfun$adapted$1(Object x$1, Object x$2) {
        return TokenLexer.$init$$$anonfun$1((Tuple2)x$1, BoxesRunTime.unboxToChar((Object)x$2));
    }

    private final /* synthetic */ boolean punct$$anonfun$1(char c) {
        return this.punctuation.isDefinedAt((Object)BoxesRunTime.boxToCharacter((char)c).toString());
    }

    private static final /* synthetic */ Tuple2 stringLexer$$anonfun$1(Option x$1, char x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
            if (option instanceof Some && '\\' == BoxesRunTime.unboxToChar((Object)((Some)option).value())) {
                if ('\"' == c) {
                    return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\"')), (Object)Accept$.MODULE$);
                }
                if ('\\' == c) {
                    return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Accept$.MODULE$);
                }
            }
            if ('\"' == c) {
                return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\"')), (Object)Finished$.MODULE$);
            }
            if ('\n' == c) {
                return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Error$.MODULE$);
            }
            char c2 = c;
            return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)c2)), (Object)Accept$.MODULE$);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ boolean comment$$anonfun$1(char c) {
        return c != '\r' && c != '\n';
    }

    private static final /* synthetic */ boolean numericLiteral$$anonfun$1(char x$0) {
        return Character.isDigit(x$0);
    }

    private static final /* synthetic */ boolean numericLiteral$$anonfun$2(char x$0) {
        return Character.isDigit(x$0);
    }

    private static final /* synthetic */ boolean numericLiteral$$anonfun$3(char x$0) {
        return Character.isDigit(x$0);
    }

    private static final /* synthetic */ LexStates illegalCharacter$$anonfun$1(char c) {
        return Accept$.MODULE$;
    }

    private static final /* synthetic */ Tuple2 tokenizeExtensionLiteral$$anonfun$1(Tuple2 x$1, char x$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            char currentChar;
            int nesting = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Option lastChar = (Option)tuple2._2();
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)lastChar, (Object)BoxesRunTime.boxToCharacter((char)(currentChar = BoxesRunTime.unboxToChar((Object)tuple22._2()))));
            if (tuple23 != null) {
                Option option = (Option)tuple23._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple23._2());
                if (option instanceof Some) {
                    char c2 = BoxesRunTime.unboxToChar((Object)((Some)option).value());
                    if ('{' == c2 && '{' == c) {
                        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(nesting + 1)), (Object)None$.MODULE$);
                    }
                    if ('}' == c2 && '}' == c) {
                        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(nesting - 1)), (Object)None$.MODULE$);
                    }
                }
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nesting), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)currentChar)));
        }
        throw new MatchError((Object)tuple22);
    }

    private static final /* synthetic */ boolean tokenizeLiteral$$anonfun$1(char x$0) {
        return Character.isDigit(x$0);
    }

    private static final /* synthetic */ boolean $anonfun$3(boolean x$1, char x$2) {
        Tuple2.mcZC.sp sp2 = new Tuple2.mcZC.sp(x$1, x$2);
        if (sp2 != null) {
            char c = sp2._2$mcC$sp();
            if (sp2._1$mcZ$sp() && '\\' == c) {
                return false;
            }
            if ('\\' == c) {
                return true;
            }
        }
        return false;
    }

    public class DoubleBracePairMatcher
    implements Function1<Object, LexStates> {
        private Option<Object> lastChar;
        private int nesting;
        private final Function1<Object, LexStates> detectEnd;

        public DoubleBracePairMatcher() {
            if (TokenLexer.this == null) {
                throw new NullPointerException();
            }
            this.lastChar = Option$.MODULE$.empty();
            this.nesting = 0;
            this.detectEnd = LexOperations$.MODULE$.withFeedback(Tuple2$.MODULE$.apply(this.lastChar(), (Object)BoxesRunTime.boxToInteger((int)this.nesting())), TokenLexer::org$nlogo$lex$TokenLexer$DoubleBracePairMatcher$$_$$lessinit$greater$$anonfun$adapted$1);
        }

        public Option<Object> lastChar() {
            return this.lastChar;
        }

        public void lastChar_$eq(Option<Object> x$1) {
            this.lastChar = x$1;
        }

        public int nesting() {
            return this.nesting;
        }

        public void nesting_$eq(int x$1) {
            this.nesting = x$1;
        }

        public Function1<Object, LexStates> detectEnd() {
            return this.detectEnd;
        }

        public LexStates apply(char c) {
            return (LexStates)this.detectEnd().apply((Object)BoxesRunTime.boxToCharacter((char)c));
        }

        public final /* synthetic */ TokenLexer org$nlogo$lex$TokenLexer$DoubleBracePairMatcher$$$outer() {
            return TokenLexer.this;
        }
    }
}

