/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.lite;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import javax.swing.JPanel;
import org.nlogo.agent.World;
import org.nlogo.agent.World2D;
import org.nlogo.agent.World3D;
import org.nlogo.api.AutoConvertable;
import org.nlogo.api.ControlSet;
import org.nlogo.api.Exceptions;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.LibraryManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelType$Library$;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.api.Version$;
import org.nlogo.awt.EventQueue$;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.CompilationEnvironment;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Dialect;
import org.nlogo.core.Model;
import org.nlogo.fileformat.ConversionResult;
import org.nlogo.fileformat.FileFormat$;
import org.nlogo.fileformat.NLogoAnyLoader;
import org.nlogo.lite.LiteWorkspace;
import org.nlogo.lite.ProceduresLite;
import org.nlogo.window.CompilerManager;
import org.nlogo.window.CompilerManager$;
import org.nlogo.window.DefaultEditorFactory;
import org.nlogo.window.ErrorDialog;
import org.nlogo.window.ErrorDialogManager;
import org.nlogo.window.ErrorDialogManager$;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.FileController;
import org.nlogo.window.InterfacePanelLite;
import org.nlogo.window.InvalidVersionException;
import org.nlogo.window.LinkRoot;
import org.nlogo.window.LiteAdPanel;
import org.nlogo.window.NetLogoListenerManager;
import org.nlogo.window.OutputWidget;
import org.nlogo.window.ReconfigureWorkspaceUI$;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.OpenModelFromURI$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.Statics;
import scala.util.Try$;

public abstract class LitePanel
extends JPanel
implements Exceptions.Handler,
Event.LinkParent,
LinkRoot,
ControlSet {
    private ListBuffer linkComponents;
    private final NetLogoListenerManager listenerManager;
    private final ErrorDialogManager errorDialogManager;
    private final World world;
    private final LiteWorkspace workspace;
    private final ProceduresLite procedures;
    private final DefaultEditorFactory liteEditorFactory;
    private final InterfacePanelLite iP;
    private final SimpleJobOwner defaultOwner;
    private final LiteAdPanel panel;

    public LitePanel(Frame frame, MouseListener iconListener) {
        LinkRoot.$init$(this);
        this.listenerManager = new NetLogoListenerManager();
        this.errorDialogManager = new ErrorDialogManager(this, (Function0<Map<Class<? extends Throwable>, ErrorDialog>>)((Function0 & Serializable)LitePanel::$init$$$anonfun$1));
        Exceptions$.MODULE$.setHandler(this);
        this.world = Version$.MODULE$.is3D() ? new World3D() : new World2D();
        this.workspace = new LiteWorkspace(this, this.world(), frame, this.listenerManager(), this.errorDialogManager(), this);
        this.procedures = new ProceduresLite(this.workspace(), this.workspace());
        this.liteEditorFactory = new DefaultEditorFactory(this.workspace());
        this.iP = this.createInterfacePanel(this.workspace());
        this.defaultOwner = new SimpleJobOwner("LitePanel", this.workspace().world().mainRNG(), AgentKind$Observer$.MODULE$);
        this.panel = new LiteAdPanel(iconListener);
        this.addLinkComponent(this.workspace().aggregateManager());
        this.addLinkComponent(this.workspace());
        this.addLinkComponent(this.procedures());
        this.addLinkComponent(new CompilerManager(this.workspace(), this.world(), this.procedures(), CompilerManager$.MODULE$.$lessinit$greater$default$4()));
        this.addLinkComponent(new Events.CompiledEvent.Handler(){

            public void handle(Events.CompiledEvent e) {
                if (e.error != null) {
                    e.error.printStackTrace();
                    return;
                }
            }
        });
        this.addLinkComponent(new Events.LoadModelEvent.Handler(this){
            private final /* synthetic */ LitePanel $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void handle(Events.LoadModelEvent e) {
                this.$outer.workspace().aggregateManager().load(e.model, this.$outer.workspace());
            }
        });
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.iP(), "Center");
        this.add((Component)this.panel(), "East");
        Statics.releaseFence();
    }

    public ListBuffer linkComponents() {
        return this.linkComponents;
    }

    @Override
    public void org$nlogo$window$LinkRoot$_setter_$linkComponents_$eq(ListBuffer x$0) {
        this.linkComponents = x$0;
    }

    public NetLogoListenerManager listenerManager() {
        return this.listenerManager;
    }

    public ErrorDialogManager errorDialogManager() {
        return this.errorDialogManager;
    }

    public World world() {
        return this.world;
    }

    public LiteWorkspace workspace() {
        return this.workspace;
    }

    public ProceduresLite procedures() {
        return this.procedures;
    }

    public DefaultEditorFactory liteEditorFactory() {
        return this.liteEditorFactory;
    }

    public InterfacePanelLite iP() {
        return this.iP;
    }

    public SimpleJobOwner defaultOwner() {
        return this.defaultOwner;
    }

    public LiteAdPanel panel() {
        return this.panel;
    }

    public URL getFileURL(String filename) throws MalformedURLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestFocus() {
        if (this.iP() != null) {
            this.iP().requestFocus();
            return;
        }
    }

    public InterfacePanelLite createInterfacePanel(LiteWorkspace workspace) {
        return new InterfacePanelLite(workspace.viewWidget(), workspace, workspace, workspace.plotManager(), this.liteEditorFactory(), workspace.getExtensionManager());
    }

    public void setAdVisible(boolean visible) {
        this.panel().setVisible(visible);
    }

    public void setPrefix(URL url) {
        this.workspace().fileManager().setPrefix(url);
    }

    @Override
    public void handle(Throwable throwable) {
        try {
            if (!(throwable instanceof LogoException)) {
                throwable.printStackTrace(System.err);
            }
            Thread thread = Thread.currentThread();
            EventQueue$.MODULE$.invokeLater(new Runnable(thread, throwable, this){
                private final Thread thread$1;
                private final Throwable throwable$1;
                private final /* synthetic */ LitePanel $outer;
                {
                    this.thread$1 = thread$2;
                    this.throwable$1 = throwable$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.$outer.errorDialogManager().show(null, null, this.thread$1, this.throwable$1);
                }
            });
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void command(String source) throws CompilerException {
        EventQueue$.MODULE$.cantBeEventDispatchThread();
        this.workspace().evaluateCommands(this.defaultOwner(), source);
    }

    public void commandLater(String source) throws CompilerException {
        this.workspace().evaluateCommands(this.defaultOwner(), source, false);
    }

    public Object report(String source) throws CompilerException {
        EventQueue$.MODULE$.cantBeEventDispatchThread();
        return this.workspace().evaluateReporter(this.defaultOwner(), source);
    }

    public String getProcedures() {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        return this.procedures().innerSource();
    }

    public void setProcedures(String source) {
        EventQueue$.MODULE$.mustBeEventDispatchThread();
        this.procedures().innerSource_$eq(source);
    }

    public void openFromURI(URI uri) throws InvalidVersionException {
        this.iP().reset();
        Object object = Predef$.MODULE$.refArrayOps((Object[])uri.getPath().split("/"));
        this.errorDialogManager().setModelName((String)ArrayOps$.MODULE$.last$extension(object));
        FileController controller = new FileController(this, this.workspace());
        ExtensionManager extensionManager = this.workspace().getExtensionManager();
        LibraryManager libraryManager = this.workspace().getLibraryManager();
        CompilationEnvironment compilationEnvironment = this.workspace().getCompilationEnvironment();
        Seq<AutoConvertable> seq = FileFormat$.MODULE$.defaultAutoConvertables();
        Function1 & Serializable converter = (Function1 & Serializable)dialect -> FileFormat$.MODULE$.converter(extensionManager, libraryManager, compilationEnvironment, this.workspace(), seq, (Dialect)dialect);
        NLogoAnyLoader loader = FileFormat$.MODULE$.standardAnyLoader(true, this.workspace().compiler().utilities(), FileFormat$.MODULE$.standardAnyLoader$default$3());
        Option<Model> modelOpt = OpenModelFromURI$.MODULE$.apply(uri, controller, loader, (Function2<Model, Path, ConversionResult>)((Function2)converter.apply((Object)this.workspace().world().program().dialect())), Version$.MODULE$);
        modelOpt.foreach(model -> ReconfigureWorkspaceUI$.MODULE$.apply(this, uri, ModelType$Library$.MODULE$, (Model)model, this.workspace(), ReconfigureWorkspaceUI$.MODULE$.apply$default$6(), ReconfigureWorkspaceUI$.MODULE$.apply$default$7()));
    }

    @Override
    public Future<BufferedImage> userInterface() {
        if (EventQueue.isDispatchThread()) {
            return Promise$.MODULE$.fromTry(Try$.MODULE$.apply(this::userInterface$$anonfun$1)).future();
        }
        Promise promise = Promise$.MODULE$.apply();
        EventQueue$.MODULE$.invokeLater(() -> promise.complete(Try$.MODULE$.apply(this::userInterface$$anonfun$2$$anonfun$1)));
        return promise.future();
    }

    @Override
    public Future<String> userOutput() {
        if (EventQueue.isDispatchThread()) {
            return Promise$.MODULE$.fromTry(Try$.MODULE$.apply(this::userOutput$$anonfun$1)).future();
        }
        Promise promise = Promise$.MODULE$.apply();
        EventQueue$.MODULE$.invokeLater(() -> promise.complete(Try$.MODULE$.apply(this::userOutput$$anonfun$2$$anonfun$1)));
        return promise.future();
    }

    private static final Map $init$$$anonfun$1() {
        return ErrorDialogManager$.MODULE$.$lessinit$greater$default$2();
    }

    private final BufferedImage userInterface$$anonfun$1() {
        return this.iP().interfaceImage();
    }

    private final BufferedImage userInterface$$anonfun$2$$anonfun$1() {
        return this.iP().interfaceImage();
    }

    private static final String findOutput$1$$anonfun$1() {
        return "";
    }

    private static final String findOutput$1(InterfacePanelLite ipl) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])ipl.getComponents());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Component x) {
                Component component = x;
                if (component instanceof OutputWidget) {
                    OutputWidget ow = (OutputWidget)component;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Component x, Function1 function1) {
                Component component = x;
                if (component instanceof OutputWidget) {
                    OutputWidget ow = (OutputWidget)component;
                    return ow.valueText();
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(String.class)));
        return (String)ArrayOps$.MODULE$.headOption$extension(object2).getOrElse(LitePanel::findOutput$1$$anonfun$1);
    }

    private final String userOutput$$anonfun$1() {
        return LitePanel.findOutput$1(this.iP());
    }

    private final String userOutput$$anonfun$2$$anonfun$1() {
        return LitePanel.findOutput$1(this.iP());
    }
}

