/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.log;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.time.LocalDateTime;
import org.json.simple.JSONValue;
import org.nlogo.api.Exceptions$;
import org.nlogo.core.LogoList;
import org.nlogo.log.DateTimeFormats$;
import org.nlogo.log.FileLogger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class JsonFileLogger
implements FileLogger {
    private final Path logDirectoryPath;
    private final FilenameFilter fileNameFilter;
    private final PrintWriter writer;
    private boolean first;

    public JsonFileLogger(Path logDirectoryPath) {
        this.logDirectoryPath = logDirectoryPath;
        this.fileNameFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("netlogo_log_") && name.endsWith(".json");
            }
        };
        LocalDateTime now = LocalDateTime.now();
        String logFileName = "netlogo_log_" + now.format(DateTimeFormats$.MODULE$.file()) + ".json";
        Path logFilePath = logDirectoryPath.resolve(logFileName);
        File logFile = logFilePath.toFile();
        logFile.getParentFile().mkdirs();
        this.writer = new PrintWriter(new FileWriter(logFile));
        this.writer.write("[\n");
        this.first = true;
    }

    private Path logDirectoryPath() {
        return this.logDirectoryPath;
    }

    @Override
    public FilenameFilter fileNameFilter() {
        return this.fileNameFilter;
    }

    @Override
    public void log(String event, scala.collection.immutable.Map<String, Object> eventInfo) {
        Exceptions$.MODULE$.warning((scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.log$$anonfun$1(event, eventInfo);
            return BoxedUnit.UNIT;
        });
    }

    private Object formatAnyRef(Object value) {
        Object object = value;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object a = object;
            return a;
        }
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)l.map((Function1 & Serializable)_$1 -> this.formatAnyRef(_$1))).asJava();
        }
        if (object == null) {
            return null;
        }
        Object v = object;
        return v.toString();
    }

    @Override
    public void close() {
        this.writer.write("]");
        this.writer.flush();
        this.writer.close();
    }

    private final void log$$anonfun$1(String event$1, scala.collection.immutable.Map eventInfo$1) {
        scala.collection.immutable.Map map;
        if (this.first) {
            this.first = false;
            this.writer.write("  ");
        } else {
            this.writer.write(", ");
        }
        LocalDateTime timeStamp = LocalDateTime.now();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"event");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)event$1);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"timeStamp");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)timeStamp.format(DateTimeFormats$.MODULE$.logEntry()));
        scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (!eventInfo$1.isEmpty()) {
            scala.collection.immutable.Map formattedEventInfo = (scala.collection.immutable.Map)eventInfo$1.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object object;
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object2 = value;
                    if (object2 instanceof Object) {
                        Object v = object2;
                        object = this.formatAnyRef(v);
                    } else {
                        Object v;
                        object = v = object2;
                    }
                    Object formattedValue = object;
                    return Tuple2$.MODULE$.apply((Object)key, formattedValue);
                }
                throw new MatchError((Object)tuple2);
            });
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"eventInfo");
            map = (scala.collection.immutable.Map)map2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)formattedEventInfo).asJava()));
        } else {
            map = map2;
        }
        scala.collection.immutable.Map finalMap = map;
        JSONValue.writeJSONString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)finalMap).asJava(), (Writer)this.writer);
        this.writer.write("\n");
    }
}

