/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.nlogo.api.Equality$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.FileIO$;
import org.nlogo.api.NetLogoAdapter;
import org.nlogo.api.Version$;
import org.nlogo.log.FileLogger;
import org.nlogo.log.LogEvents;
import org.nlogo.log.LogEvents$Types$;
import org.nlogo.log.LoggerState;
import org.nlogo.log.LoggerState$;
import org.nlogo.log.LoggingListener;
import org.nlogo.log.NoOpLogger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class LogManager$
implements Serializable {
    private static boolean isStarted;
    private static LoggerState state;
    private static FileLogger logger;
    private static LoggingListener loggingListener;
    public static String org$nlogo$log$LogManager$$$modelName;
    private static Function0<BoxedUnit> directoryWarning;
    public static final LogManager$ MODULE$;

    private LogManager$() {
    }

    static {
        MODULE$ = new LogManager$();
        isStarted = false;
        state = LoggerState$.MODULE$.empty();
        logger = LoggerState$.MODULE$.noOpLogger();
        loggingListener = new LoggingListener(LoggerState$.MODULE$.emptyEvents(), logger);
        org$nlogo$log$LogManager$$$modelName = "unset";
        directoryWarning = (JFunction0.mcV.sp & Serializable)() -> {};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogManager$.class);
    }

    public boolean isStarted() {
        return isStarted;
    }

    public void isStarted_$eq(boolean x$1) {
        isStarted = x$1;
    }

    public void start(Function1<NetLogoAdapter, BoxedUnit> addListener, Function1<Path, FileLogger> loggerFactory, File logDirectory, Set<String> eventsSet, String studentName, Function0<BoxedUnit> directoryWarning) {
        if (this.isStarted()) {
            throw new IllegalStateException("Logging should only be started once.");
        }
        this.isStarted_$eq(true);
        LogEvents events = new LogEvents(eventsSet);
        state = LoggerState$.MODULE$.apply(addListener, loggerFactory, logDirectory, events, studentName);
        loggingListener = new LoggingListener(events, logger);
        LogManager$.directoryWarning = directoryWarning;
        NetLogoAdapter restartListener = new NetLogoAdapter(){

            public void modelOpened(String modelName) {
                LogManager$.org$nlogo$log$LogManager$$$modelName = modelName;
                LogManager$.MODULE$.org$nlogo$log$LogManager$$$restart(LogManager$.MODULE$.org$nlogo$log$LogManager$$$restart$default$1());
            }
        };
        addListener.apply((Object)restartListener);
        addListener.apply((Object)loggingListener);
    }

    public void stop() {
        this.logStop();
        Exceptions$.MODULE$.warning((scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{Exception.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            LogManager$.stop$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        logger = new NoOpLogger();
        loggingListener.logger_$eq(logger);
    }

    public void org$nlogo$log$LogManager$$$restart(Function0<BoxedUnit> thunk) {
        this.stop();
        thunk.apply$mcV$sp();
        try {
            logger = (FileLogger)state.loggerFactory().apply((Object)state.logDirectoryPath());
            loggingListener.logger_$eq(logger);
        }
        catch (Throwable throwable) {
            directoryWarning.apply$mcV$sp();
        }
        this.logStart(org$nlogo$log$LogManager$$$modelName);
    }

    public Function0<BoxedUnit> org$nlogo$log$LogManager$$$restart$default$1() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    public void zipLogFiles(String zipFileName) {
        if (this.isStarted()) {
            FilenameFilter fileNameFilter = logger.fileNameFilter();
            this.org$nlogo$log$LogManager$$$restart((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Path zipPath = Paths.get(zipFileName, new String[0]);
                File zipFile = zipPath.isAbsolute() ? zipPath.toFile() : state.logDirectoryPath().resolve(zipPath).toFile();
                Object[] logFiles = state.logDirectory().list(fileNameFilter);
                Object object = Predef$.MODULE$.refArrayOps(logFiles);
                if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                    ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipFile));
                    Object object2 = Predef$.MODULE$.refArrayOps(logFiles);
                    ArrayOps$.MODULE$.foreach$extension(object2, logFileName -> Exceptions$.MODULE$.ignoring((scala.collection.immutable.Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class}), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                        LogManager$.zipLogFiles$$anonfun$1$$anonfun$1$$anonfun$1(zipStream, logFileName);
                        return BoxedUnit.UNIT;
                    }));
                    zipStream.flush();
                    zipStream.close();
                    return;
                }
            });
            return;
        }
    }

    public void deleteLogFiles() {
        if (this.isStarted()) {
            FilenameFilter fileNameFilter = logger.fileNameFilter();
            this.org$nlogo$log$LogManager$$$restart((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                Object[] logFiles = state.logDirectory().list(fileNameFilter);
                Object object = Predef$.MODULE$.refArrayOps(logFiles);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)logFileName -> {
                    Path logFilePath = Paths.get(logFileName, new String[0]);
                    File logFile = state.logDirectoryPath().resolve(logFilePath).toFile();
                    return logFile.delete();
                });
            });
            return;
        }
    }

    private String getIpAddress() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = "unknown";
        }
        return string;
    }

    private void log(String event, Map<String, Object> eventInfo) {
        logger.log(event, eventInfo);
    }

    private Map<String, Object> log$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private void logStart(String modelName) {
        String loginName = System.getProperty("user.name");
        String ipAddress = this.getIpAddress();
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"loginName");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)loginName);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"studentName");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)state.studentName());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"ipAddress");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)ipAddress);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"modelName");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)modelName);
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"version");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Version$.MODULE$.version());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"events");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)state.events().set().toList()).asJava());
        Map startInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.log(LogEvents$Types$.MODULE$.start(), (Map<String, Object>)startInfo);
    }

    private void logStop() {
        this.log(LogEvents$Types$.MODULE$.stop(), this.log$default$2());
    }

    public void globalChanged(String globalName, Object newValue, Object oldValue) {
        if (state.events().global() && !Equality$.MODULE$.equals(newValue, oldValue)) {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"globalName");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)globalName);
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"newValue");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, newValue);
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"oldValue");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, oldValue);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.global(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void linkCreated(long id, String breedName, long end1, long end2) {
        if (state.events().link()) {
            Object[] objectArray = new Tuple2[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"created");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)id));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"breedName");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)breedName);
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"end1");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToLong((long)end1));
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"end2");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BoxesRunTime.boxToLong((long)end2));
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.link(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void linkRemoved(long id, String breedName, long end1, long end2) {
        if (state.events().link()) {
            Object[] objectArray = new Tuple2[5];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"removed");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)id));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"breedName");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)breedName);
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"end1");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BoxesRunTime.boxToLong((long)end1));
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"end2");
            objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BoxesRunTime.boxToLong((long)end2));
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.link(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void speedSliderChanged(double newSpeed) {
        if (state.events().speedSlider()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"newSpeed");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToDouble((double)newSpeed));
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.speedSlider(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void turtleCreated(long who, String breedName) {
        if (state.events().turtle()) {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"created");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"who");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)who));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"breedName");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)breedName);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.turtle(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void turtleRemoved(long who, String breedName) {
        if (state.events().turtle()) {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"removed");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"who");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)who));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"breedName");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)breedName);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.turtle(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void userComment(String comment) {
        if (state.events().comment()) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"comment");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)comment);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.comment(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void widgetAdded(boolean isLoading, String widgetType, String name) {
        if (state.events().widgetEdit() && !isLoading) {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"added");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"widgetType");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)widgetType);
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)name);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.widgetEdit(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    public void widgetRemoved(boolean isUnloading, String widgetType, String name) {
        if (state.events().widgetEdit() && !isUnloading) {
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"removed");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"widgetType");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)widgetType);
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)name);
            Map eventInfo = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            this.log(LogEvents$Types$.MODULE$.widgetEdit(), (Map<String, Object>)eventInfo);
            return;
        }
    }

    private static final void stop$$anonfun$1() {
        logger.close();
    }

    private static final void zipLogFiles$$anonfun$1$$anonfun$1$$anonfun$1(ZipOutputStream zipStream$2, String logFileName$1) {
        zipStream$2.putNextEntry(new ZipEntry(logFileName$1));
        Path logFilePath = state.logDirectoryPath().resolve(logFileName$1).toAbsolutePath();
        byte[] logFileData = FileIO$.MODULE$.fileToString(logFilePath.toString()).getBytes();
        zipStream$2.write(logFileData, 0, logFileData.length);
        zipStream$2.closeEntry();
    }
}

