/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Binding;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;

public class ConcurrentJob
extends Job {
    private final AgentSet agentset;
    private final Procedure topLevelProcedure;
    private final int address;
    private final Context parentContext;
    private final Workspace workspace;
    private final MersenneTwisterFast random;
    private Context[] contexts;

    public ConcurrentJob(JobOwner owner, AgentSet agentset, Procedure topLevelProcedure, int address, Context parentContext, Workspace workspace, MersenneTwisterFast random) {
        this.agentset = agentset;
        this.topLevelProcedure = topLevelProcedure;
        this.address = address;
        this.parentContext = parentContext;
        this.workspace = workspace;
        this.random = random;
        super(owner, agentset, topLevelProcedure, address, parentContext, workspace, random);
        this.contexts = null;
    }

    @Override
    public boolean exclusive() {
        return false;
    }

    private void initialize() {
        this.contexts = new Context[this.agentset.count()];
        int count = 0;
        AgentIterator iter = this.agentset.shufflerator(this.random);
        while (iter.hasNext()) {
            this.newAgentJoining(iter.next(), count, this.address);
            ++count;
        }
    }

    public void newAgentJoining(Agent agent, int initialCount, int address) {
        Activation activation;
        int count = initialCount;
        if (this.parentContext == null) {
            activation = new Activation(this.topLevelProcedure, null, 0);
        } else {
            Activation parent = this.parentContext.activation;
            activation = new Activation(parent.procedure, parent.parent, parent.args, parent.returnAddress, new Binding(parent.binding));
        }
        Activation activation2 = activation;
        Context context = new Context(this, agent, address, activation2, this.workspace);
        if (count == -1) {
            if (this.contexts == null) {
                this.initialize();
            }
            count = this.contexts.length;
            Context[] newContexts = new Context[count + 1];
            System.arraycopy(this.contexts, 0, newContexts, 0, count);
            this.contexts = newContexts;
        }
        this.contexts[count] = context;
    }

    @Override
    public void step() {
        if (this.contexts == null) {
            this.initialize();
        }
        int max = this.contexts.length;
        boolean allContextsDone = true;
        Context context = null;
        try {
            for (int i = 0; i < max && this.state == 0; ++i) {
                context = this.contexts[i];
                if (context == null) continue;
                if (!context.finished) {
                    if (!context.waiting) {
                        context.stepConcurrent();
                    }
                    allContextsDone = false;
                    continue;
                }
                this.contexts[i] = null;
            }
        }
        catch (LogoException ex) {
            this.finish();
            if (!Thread.currentThread().isInterrupted()) {
                context.runtimeError(ex);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            this.finish();
            context.runtimeError(ex);
            throw ex;
        }
        if (this.state == 0 && allContextsDone) {
            this.finish();
            return;
        }
    }

    @Override
    public void finish() {
        super.finish();
        if (this.contexts != null) {
            for (Context context : this.contexts) {
                if (context == null) continue;
                context.finished = true;
            }
            return;
        }
    }
}

