/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentBit$;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.AnonymousCommand;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenHolder;
import org.nlogo.nvm.ArgumentTypeException;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.Instruction$;
import org.nlogo.nvm.InstructionJ;
import org.nlogo.nvm.RuntimePrimitiveException;
import org.nlogo.nvm.Thunk;
import org.nlogo.nvm.Workspace;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public abstract class Instruction
extends InstructionJ
implements TokenHolder {
    private Token token = null;
    private Method chosenMethod = null;
    private String source = null;
    private String fullSource = null;
    private Thunk<String> disassembly = new Thunk<String>(){

        public String compute() {
            return "";
        }
    };
    private int storedSourceStartPosition = -1;
    private int storedSourceEndPosition = -1;
    private String storedSourceSnippet = "";

    public static String agentKindDescription(AgentKind agentKind) {
        return Instruction$.MODULE$.agentKindDescription(agentKind);
    }

    public static String agentKindError(AgentKind agentKind, Seq<AgentKind> seq) {
        return Instruction$.MODULE$.agentKindError(agentKind, seq);
    }

    public Token token() {
        return this.token;
    }

    @Override
    public void token_$eq(Token x$1) {
        this.token = x$1;
    }

    public Method chosenMethod() {
        return this.chosenMethod;
    }

    public void chosenMethod_$eq(Method x$1) {
        this.chosenMethod = x$1;
    }

    public String source() {
        return this.source;
    }

    public void source_$eq(String x$1) {
        this.source = x$1;
    }

    public String fullSource() {
        return this.fullSource;
    }

    public void fullSource_$eq(String x$1) {
        this.fullSource = x$1;
    }

    public Thunk<String> disassembly() {
        return this.disassembly;
    }

    public void disassembly_$eq(Thunk<String> x$1) {
        this.disassembly = x$1;
    }

    public int storedSourceStartPosition() {
        return this.storedSourceStartPosition;
    }

    public void storedSourceStartPosition_$eq(int x$1) {
        this.storedSourceStartPosition = x$1;
    }

    public int storedSourceEndPosition() {
        return this.storedSourceEndPosition;
    }

    public void storedSourceEndPosition_$eq(int x$1) {
        this.storedSourceEndPosition = x$1;
    }

    public String storedSourceSnippet() {
        return this.storedSourceSnippet;
    }

    public void storedSourceSnippet_$eq(String x$1) {
        this.storedSourceSnippet = x$1;
    }

    public Nothing$ throwAgentClassException(Context context, AgentKind kind) {
        Seq pairs = (Seq)((SeqOps)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)AgentKind$Observer$.MODULE$, (Object)BoxesRunTime.boxToCharacter((char)'O')), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)AgentKind$Turtle$.MODULE$, (Object)BoxesRunTime.boxToCharacter((char)'T')), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)AgentKind$Patch$.MODULE$, (Object)BoxesRunTime.boxToCharacter((char)'P')), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply((Object)AgentKind$Link$.MODULE$, (Object)BoxesRunTime.boxToCharacter((char)'L')), (List)Nil$.MODULE$)))));
        Seq allowedKinds = (Seq)pairs.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AgentKind thisKind = (AgentKind)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.agentClassString), c);
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AgentKind thisKind = (AgentKind)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                return thisKind;
            }
            throw new MatchError((Object)tuple2);
        });
        throw new RuntimePrimitiveException((org.nlogo.api.Context)context, this, Instruction$.MODULE$.agentKindError(kind, (Seq<AgentKind>)allowedKinds));
    }

    public void init(Workspace workspace) {
        if (workspace != null) {
            this.workspace = workspace;
            this.world = workspace.world();
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.args);
        ArrayOps$.MODULE$.foreach$extension(object, arg -> arg.init(workspace));
        this.agentBits = AgentBit$.MODULE$.fromAgentClassString(this.agentClassString);
    }

    public void copyFieldsFrom(Instruction sourceInstr) {
        this.workspace = sourceInstr.workspace;
        this.world = sourceInstr.world;
        this.token_$eq(sourceInstr.token());
    }

    public void copyMetadataFrom(Instruction srcInstr) {
        this.token_$eq(srcInstr.token());
        this.agentClassString = srcInstr.agentClassString;
        this.source_$eq(srcInstr.source());
        this.fullSource_$eq(srcInstr.fullSource());
        this.storedSourceStartPosition_$eq(srcInstr.storedSourceStartPosition());
        this.storedSourceEndPosition_$eq(srcInstr.storedSourceEndPosition());
    }

    public Instruction extractErrorInstruction(EngineException ex) {
        return this;
    }

    public String getFilename() {
        return (String)Option$.MODULE$.apply((Object)this.token()).map((Function1 & Serializable)_$1 -> _$1.filename()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean argEvalBooleanValue(Context context, int index) {
        return this.argEvalBoolean(context, index);
    }

    public Boolean argEvalBoolean(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.BooleanType(), x);
    }

    public double argEvalDoubleValue(Context context, int index) {
        return this.argEvalDouble(context, index);
    }

    public Double argEvalDouble(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.NumberType(), x);
    }

    public int argEvalIntValue(Context context, int index) {
        return this.argEvalDouble(context, index).intValue();
    }

    public String argEvalString(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.StringType(), x);
    }

    public LogoList argEvalList(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            return l;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.ListType(), x);
    }

    public Agent argEvalAgent(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Agent) {
            Agent a = (Agent)object;
            if (a.id() == -1L) {
                throw new RuntimePrimitiveException((org.nlogo.api.Context)context, this, I18N$.MODULE$.errors().getN("org.nlogo.$common.thatAgentIsDead", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{a.classDisplayName()})));
            }
            return a;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.AgentType(), x);
    }

    public Turtle argEvalTurtle(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Turtle) {
            Turtle t = (Turtle)object;
            return t;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.TurtleType(), x);
    }

    public Patch argEvalPatch(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Patch) {
            Patch p = (Patch)object;
            return p;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.PatchType(), x);
    }

    public Link argEvalLink(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof Link) {
            Link l = (Link)object;
            return l;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.LinkType(), x);
    }

    public AgentSet argEvalAgentSet(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof AgentSet) {
            AgentSet s = (AgentSet)object;
            return s;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.AgentsetType(), x);
    }

    public AgentSet argEvalAgentSet(Context context, int index, AgentKind kind) {
        Object object = this.args[index].report(context);
        if (object instanceof AgentSet) {
            AgentSet s = (AgentSet)object;
            AgentKind agentKind = s.kind();
            AgentKind agentKind2 = kind;
            if (agentKind == null ? agentKind2 != null : !agentKind.equals(agentKind2)) {
                throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.getAgentSetMask(kind), s);
            }
            return s;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.AgentsetType(), x);
    }

    public AnonymousReporter argEvalAnonymousReporter(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof AnonymousReporter) {
            AnonymousReporter t = (AnonymousReporter)object;
            return t;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.ReporterType(), x);
    }

    public AnonymousCommand argEvalAnonymousCommand(Context context, int index) {
        Object object = this.args[index].report(context);
        if (object instanceof AnonymousCommand) {
            AnonymousCommand t = (AnonymousCommand)object;
            return t;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, index, Syntax$.MODULE$.CommandType(), x);
    }

    public Token argEvalSymbol(Context context, int argIndex) {
        Object object = this.args[argIndex].report(context);
        if (object instanceof Token) {
            Token t = (Token)object;
            return t;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, argIndex, Syntax$.MODULE$.SymbolType(), x);
    }

    public java.util.List<Token> argEvalCodeBlock(Context context, int argIndex) {
        Object object = this.args[argIndex].report(context);
        if (object instanceof java.util.List) {
            java.util.List l = (java.util.List)object;
            return l;
        }
        Object x = object;
        throw new ArgumentTypeException(context, this, argIndex, Syntax$.MODULE$.CodeBlockType(), x);
    }

    public String dump() {
        return this.dump(3);
    }

    public String dump(int indentLevel) {
        Object object;
        StringBuilder buf = new StringBuilder(this.toString());
        if (this.source() != null) {
            buf.append(" \"");
            buf.append(this.fullSource());
            buf.append('\"');
        }
        if (this.chosenMethod() != null) {
            buf.append(' ');
            buf.append(this.describeMethod(this.chosenMethod()));
        }
        if (ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.refArrayOps((Object[])this.args))) {
            buf.append('\n');
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.args);
            ArrayOps$.MODULE$.indices$extension(object2).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                buf.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indentLevel)), 2));
                buf.append(this.args[i].dump(indentLevel + 1));
                if (i < this.args.length - 1) {
                    buf.append('\n');
                    return;
                }
            });
        }
        return buf.toString();
    }

    private String describeMethod(Method m) {
        Object[] types = m.getParameterTypes();
        StringBuilder buf = new StringBuilder();
        Object object = Predef$.MODULE$.refArrayOps(types);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])((Class[])ArrayOps$.MODULE$.tail$extension(object)));
        buf.append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)tpe -> Instruction.shortClassName$1(tpe.getName()), ClassTag$.MODULE$.apply(String.class))).mkString(","));
        Object object3 = Predef$.MODULE$.refArrayOps(types);
        if (ArrayOps$.MODULE$.size$extension(object3) > 1) {
            buf.append(' ');
        }
        buf.append("=> ");
        buf.append(Instruction.shortClassName$1(m.getReturnType().getName()));
        return buf.toString();
    }

    public int[] getPositionAndLength() {
        if (this.token() == null) {
            return new int[]{-1, 0};
        }
        int begin = this.storedSourceStartPosition();
        int end = this.storedSourceEndPosition();
        return new int[]{begin, end - begin};
    }

    public String displayName() {
        if (this.token() != null) {
            return this.token().text().toUpperCase(Locale.ENGLISH);
        }
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public long validLong(double d, Context context) {
        if (d > (double)0x20000000000000L || d < (double)-9007199254740992L) {
            throw new RuntimePrimitiveException((org.nlogo.api.Context)context, this, d + " is too large to be represented exactly as an integer in NetLogo");
        }
        return (long)d;
    }

    public Double newValidDouble(double d, Context context) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw this.invalidDouble(d, context);
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public double validDouble(double d, Context context) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw this.invalidDouble(d, context);
        }
        return d;
    }

    private Nothing$ invalidDouble(double d, Context context) {
        throw new RuntimePrimitiveException((org.nlogo.api.Context)context, this, "math operation produced " + (Double.isInfinite(d) ? "a number too large for NetLogo" : "a non-number"));
    }

    private static final String shortClassName$1(String s) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\\."));
        return (String)ArrayOps$.MODULE$.last$extension(object);
    }
}

