/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Workspace;

public abstract class Job {
    public static final byte RUNNING = 0;
    public static final byte DONE = 1;
    public static final byte REMOVED = 2;
    public final JobOwner owner;
    public byte state = 0;
    public boolean stopping = false;
    public boolean buttonTurnIsOver = false;
    public Object result;
    final int address;
    public final AgentSet agentset;
    public final Context parentContext;
    public final Procedure topLevelProcedure;
    public final Workspace workspace;
    public MersenneTwisterFast random;

    abstract boolean exclusive();

    Job(JobOwner owner, AgentSet agentset, Procedure topLevelProcedure, int address, Context parentContext, Workspace workspace, MersenneTwisterFast random) {
        this.owner = owner;
        this.agentset = agentset;
        this.topLevelProcedure = topLevelProcedure;
        this.address = address;
        this.parentContext = parentContext;
        this.workspace = workspace;
        this.random = random;
    }

    public abstract void step() throws LogoException;

    public void finish() {
        this.state = 1;
        if (this.parentContext != null) {
            this.parentContext.waiting = false;
        }
    }

    public boolean isTurtleForeverButtonJob() {
        return this.topLevelProcedure != null && this.owner.isTurtleForeverButton();
    }

    public boolean isLinkForeverButtonJob() {
        return this.topLevelProcedure != null && this.owner.isLinkForeverButton();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append("(owner: {" + this.owner + "}, state:");
        switch (this.state) {
            case 0: {
                buf.append("running");
                break;
            }
            case 1: {
                buf.append("done");
                break;
            }
            case 2: {
                buf.append("removed");
                break;
            }
            default: {
                throw new IllegalStateException("unknown state: " + this.state);
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

