/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.io.Serializable;
import org.nlogo.api.Agent;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Instruction;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class StackTraceBuilder$
implements Serializable {
    public static final StackTraceBuilder$ MODULE$ = new StackTraceBuilder$();

    private StackTraceBuilder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StackTraceBuilder$.class);
    }

    public String build(org.nlogo.api.Activation act, Agent agent, Instruction instruction, Option<Throwable> exception) {
        return this.build(act, agent, instruction, exception, null);
    }

    public String build(org.nlogo.api.Activation act, Agent agent, Instruction instruction, Option<Throwable> exception, String message) {
        Option errorMessage = exception.map((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof LogoException) {
                LogoException l = (LogoException)throwable;
                return (String)Option$.MODULE$.apply((Object)l.getMessage()).getOrElse(() -> StackTraceBuilder$.$anonfun$1$$anonfun$1(message)) + "\nerror while ";
            }
            if (throwable instanceof StackOverflowError) {
                StackOverflowError soe = (StackOverflowError)throwable;
                return "error while ";
            }
            Throwable e = throwable;
            return "error (" + e.getClass().getSimpleName() + ")\n while ";
        });
        String instructionName = (String)Option$.MODULE$.apply((Object)instruction).map((Function1 & Serializable)_$1 -> _$1.displayName()).getOrElse(StackTraceBuilder$::$anonfun$3);
        return (String)errorMessage.getOrElse(StackTraceBuilder$::build$$anonfun$1) + agent + " running " + instructionName + "\n" + this.buildTrace(act);
    }

    public String buildTrace(org.nlogo.api.Activation act) {
        return this.entries(act).map((Function1 & Serializable)_$2 -> "  called by " + _$2).mkString("\n");
    }

    private List<String> entries(org.nlogo.api.Activation act) {
        List activations = package$.MODULE$.Iterator().iterate((Object)act, (Function1 & Serializable)_$3 -> (org.nlogo.api.Activation)_$3.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).takeWhile((Function1 & Serializable)_$4 -> _$4 != null).toList();
        return activations.flatMap((Function1 & Serializable)a -> {
            String string = a.procedure().displayName();
            return MODULE$.commandName((org.nlogo.api.Activation)a).toList().$colon$colon((Object)string);
        });
    }

    private Option<String> commandName(org.nlogo.api.Activation act) {
        org.nlogo.api.Activation activation = act;
        if (activation instanceof Activation) {
            Activation nvmActivation = (Activation)activation;
            return nvmActivation.parent().withFilter((Function1 & Serializable)p -> Predef$.MODULE$.wrapRefArray((Object[])p.procedure.code()).isDefinedAt(nvmActivation$1.returnAddress - 1)).map((Function1 & Serializable)p -> {
                Command c = p.procedure.code()[nvmActivation$2.returnAddress - 1];
                return Tuple2$.MODULE$.apply(p, (Object)c);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Activation p = (Activation)tuple2._1();
                    Command c = (Command)tuple2._2();
                    return c.callsOtherCode();
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Activation p = (Activation)tuple2._1();
                    Command c = (Command)tuple2._2();
                    return c.displayName();
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return None$.MODULE$;
    }

    private static final String $anonfun$1$$anonfun$1(String message$2) {
        return message$2;
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String build$$anonfun$1() {
        return "";
    }
}

