/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.core.AstNode;
import org.nlogo.core.CompilationOperand;
import org.nlogo.core.ProcedureDefinition;
import org.nlogo.core.ProcedureSyntax;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.SourceLocation;
import org.nlogo.core.SourceLocation$;
import org.nlogo.core.SourceRewriter;
import org.nlogo.core.StructureResults;
import org.nlogo.core.Token;
import org.nlogo.core.Token$;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenizerInterface;
import org.nlogo.parse.AddVisitor;
import org.nlogo.parse.AstEdit;
import org.nlogo.parse.AstEdit$;
import org.nlogo.parse.AstFormat;
import org.nlogo.parse.AstPath;
import org.nlogo.parse.AstPath$;
import org.nlogo.parse.Formatter;
import org.nlogo.parse.Formatter$;
import org.nlogo.parse.IncludeFile$;
import org.nlogo.parse.Lambdaizer;
import org.nlogo.parse.NetLogoParser;
import org.nlogo.parse.NoopFolder$;
import org.nlogo.parse.PositionalAstFolder;
import org.nlogo.parse.RemovalVisitor;
import org.nlogo.parse.ReplaceReporterVisitor;
import org.nlogo.parse.ReplaceVisitor;
import org.nlogo.parse.WhiteSpace;
import org.nlogo.parse.WhiteSpace$Context$;
import org.nlogo.parse.WhitespaceMap;
import org.nlogo.parse.WhitespaceMap$;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public class AstRewriter
implements SourceRewriter,
NetLogoParser {
    private final TokenizerInterface tokenizer;
    private final CompilationOperand op;
    private final Regex extensionsRegex;
    private final Regex globalsRegex;

    public AstRewriter(TokenizerInterface tokenizer, CompilationOperand op) {
        this.tokenizer = tokenizer;
        this.op = op;
        this.extensionsRegex = new Regex("(?i)(?m)extensions\\s+\\[[^]]*\\]", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.globalsRegex = new Regex("(?i)(?m)globals\\s+\\[[^]]*\\]", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    @Override
    public TokenizerInterface tokenizer() {
        return this.tokenizer;
    }

    public String preserveBody(StructureResults structureResults, String header, String procedures, String footer) {
        return header + procedures + footer;
    }

    @Override
    public String remove(String dropCommand) {
        return this.rewrite(new RemovalVisitor(dropCommand), (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String addCommand(Tuple2<String, String> addCommand) {
        return this.rewrite(new AddVisitor(addCommand), (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String replaceCommand(Tuple2<String, String> replaceCommand) {
        return this.rewrite(new ReplaceVisitor(replaceCommand), (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String replaceReporter(Tuple2<String, String> replaceReporter) {
        return this.rewrite(new ReplaceReporterVisitor(replaceReporter), (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String lambdaize() {
        return this.rewrite(new Lambdaizer(), (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    public String runVisitor(PositionalAstFolder<AstEdit> folder) {
        return this.rewrite(folder, (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(structureResults, header, procedures, footer) -> this.preserveBody((StructureResults)structureResults, (String)header, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String replaceToken(String original, String replacement) {
        String source = (String)this.op.sources().apply((Object)"");
        Iterator<Token> tokens = this.tokenizer().tokenizeString(source, this.tokenizer().tokenizeString$default$2());
        StringBuilder buf = new StringBuilder(source);
        IntRef offset = IntRef.create((int)0);
        tokens.withFilter((Function1 & Serializable)token -> token.text().equalsIgnoreCase(original)).foreach(token -> {
            buf.replace(token.start() + offset$1.elem, token.end() + offset$1.elem, replacement);
            offset$1.elem += replacement.length() - token.text().length();
        });
        return buf.toString();
    }

    @Override
    public String addExtension(String newExtension) {
        return this.rewrite(NoopFolder$.MODULE$, (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(res, headers, procedures, footer) -> this.declarationReplace("extensions", this.extensionsRegex, (Function1<StructureResults, Seq<String>>)(Function1 & Serializable)_$1 -> (Seq)_$1.extensions().map((Function1 & Serializable)_$2 -> _$2.text()), newExtension, (StructureResults)res, (String)headers, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String removeExtension(String extension) {
        List extSection;
        Tuple2 tuple2;
        BoxedUnit boxedUnit;
        Option option;
        String extValue = extension.toUpperCase(Locale.ENGLISH);
        String source = (String)this.op.sources().apply((Object)"");
        LazyList tokens = (LazyList)this.tokenizer().tokenizeString(source, this.tokenizer().tokenizeString$default$2()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()));
        StringBuilder buf = new StringBuilder(source);
        Tuple2 tuple22 = tokens.span((Function1 & Serializable)t -> {
            Object object = t.value();
            String string = "EXTENSIONS";
            if (object == null) {
                if (string == null) return false;
            } else if (object.equals(string)) return false;
            TokenType tokenType = t.tpe();
            TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
            if (tokenType != null) {
                if (!tokenType.equals(tokenType$Ident$)) return false;
                return true;
            }
            if (tokenType$Ident$ == null) return true;
            return false;
        });
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        LazyList beforeExtensions = (LazyList)tuple22._1();
        LazyList rest = (LazyList)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)beforeExtensions, (Object)rest);
        LazyList beforeExtensions2 = (LazyList)tuple23._1();
        LazyList rest2 = (LazyList)tuple23._2();
        int endIndex = rest2.indexWhere((Function1 & Serializable)_$3 -> {
            TokenType tokenType = _$3.tpe();
            TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
            return !(tokenType != null ? !tokenType.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null);
        });
        LazyList extensions = tokens.take(endIndex + 1);
        LazyList afterExtensions = tokens.drop(endIndex + 1);
        List list = extensions.toList();
        if (list != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)list)).isEmpty()) {
            Option option2;
            Tuple2 tuple24 = (Tuple2)option.get();
            List list2 = (List)tuple24._2();
            Token extKeyword = (Token)tuple24._1();
            if (list2 != null && !(option2 = package$.MODULE$.$plus$colon().unapply((SeqOps)list2)).isEmpty()) {
                Tuple2 tuple25 = (Tuple2)option2.get();
                Token token = (Token)tuple25._1();
                List list3 = (List)tuple25._2();
                if (token != null) {
                    Option option3;
                    Token token2 = Token$.MODULE$.unapply(token);
                    String string = token2._1();
                    TokenType tokenType = token2._2();
                    Object object = token2._3();
                    if (TokenType$OpenBracket$.MODULE$.equals(tokenType) && list3 != null && !(option3 = package$.MODULE$.$plus$colon().unapply((SeqOps)list3)).isEmpty()) {
                        Tuple2 tuple26 = (Tuple2)option3.get();
                        Token token3 = (Token)tuple26._1();
                        List list4 = (List)tuple26._2();
                        if (token3 != null) {
                            Token token4 = Token$.MODULE$.unapply(token3);
                            String string2 = token4._1();
                            TokenType tokenType2 = token4._2();
                            Object object2 = token4._3();
                            if (TokenType$Ident$.MODULE$.equals(tokenType2)) {
                                Tuple2 tuple27;
                                Token token5;
                                Option option4;
                                Object extName = object2;
                                if (list4 != null && !(option4 = package$.MODULE$.$plus$colon().unapply((SeqOps)list4)).isEmpty() && (token5 = (Token)(tuple27 = (Tuple2)option4.get())._1()) != null) {
                                    Token token6 = Token$.MODULE$.unapply(token5);
                                    String string3 = token6._1();
                                    TokenType tokenType3 = token6._2();
                                    Object object3 = token6._3();
                                    if (TokenType$CloseBracket$.MODULE$.equals(tokenType3)) {
                                        Token close = token5;
                                        Nil$ nil$ = package$.MODULE$.Nil();
                                        Object object4 = tuple27._2();
                                        if (!(nil$ != null ? !nil$.equals(object4) : object4 != null)) {
                                            Object object5 = extName;
                                            String string4 = extValue;
                                            if (!(object5 != null ? !object5.equals(string4) : string4 != null)) {
                                                if (beforeExtensions2.nonEmpty()) {
                                                    boxedUnit = buf.replace(((SourceLocatable)beforeExtensions2.last()).end(), close.end(), "");
                                                    return buf.toString();
                                                }
                                                if (afterExtensions.nonEmpty()) {
                                                    boxedUnit = buf.replace(extKeyword.start(), ((SourceLocatable)afterExtensions.head()).start(), "");
                                                    return buf.toString();
                                                }
                                                boxedUnit = buf.replace(extKeyword.start(), close.end(), "");
                                                return buf.toString();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if ((tuple2 = (extSection = list).span((Function1 & Serializable)t -> {
            Object object = t.value();
            String string = extValue;
            if (object == null) {
                if (string != null) {
                    return true;
                }
            } else if (!object.equals(string)) return true;
            TokenType tokenType = t.tpe();
            TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
            if (tokenType == null) {
                if (tokenType$Ident$ == null) return false;
                return true;
            } else if (tokenType.equals(tokenType$Ident$)) return false;
            return true;
        })) != null) {
            Option option5;
            Tuple2 tuple28;
            Token token;
            Option option6;
            List list5 = (List)tuple2._1();
            List list6 = (List)tuple2._2();
            if (list5 != null && !(option6 = package$.MODULE$.$colon$plus().unapply((SeqOps)list5)).isEmpty() && (token = (Token)(tuple28 = (Tuple2)option6.get())._2()) != null) {
                Token token7 = Token$.MODULE$.unapply(token);
                String string = token7._1();
                TokenType tokenType = token7._2();
                Object object = token7._3();
                if (TokenType$Ident$.MODULE$.equals(tokenType)) {
                    Option option7;
                    Token precedingToken = token;
                    if (list6 != null && !(option7 = package$.MODULE$.$plus$colon().unapply((SeqOps)list6)).isEmpty()) {
                        Tuple2 tuple29 = (Tuple2)option7.get();
                        Token extToken = (Token)tuple29._1();
                        boxedUnit = buf.replace(precedingToken.end(), extToken.end(), "");
                        return buf.toString();
                    }
                }
            }
            if (list6 != null && !(option5 = package$.MODULE$.$plus$colon().unapply((SeqOps)list6)).isEmpty()) {
                Option option8;
                Tuple2 tuple210 = (Tuple2)option5.get();
                List list7 = (List)tuple210._2();
                Token extToken = (Token)tuple210._1();
                if (list7 != null && !(option8 = package$.MODULE$.$plus$colon().unapply((SeqOps)list7)).isEmpty()) {
                    Tuple2 tuple211 = (Tuple2)option8.get();
                    Token followingToken = (Token)tuple211._1();
                    boxedUnit = buf.replace(extToken.start(), followingToken.start(), "");
                    return buf.toString();
                }
            }
        }
        boxedUnit = BoxedUnit.UNIT;
        return buf.toString();
    }

    @Override
    public String addGlobal(String newGlobal) {
        return this.rewrite(NoopFolder$.MODULE$, (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(res, headers, procedures, footer) -> this.declarationReplace("globals", this.globalsRegex, (Function1<StructureResults, Seq<String>>)(Function1 & Serializable)_$4 -> (Seq)_$4.program().userGlobals().map((Function1 & Serializable)_$5 -> _$5.toLowerCase()), newGlobal, (StructureResults)res, (String)headers, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    @Override
    public String addReporterProcedure(String name, Seq<String> args, String body) {
        String formattedArgs = args.isEmpty() ? "" : args.mkString(" [ ", " ", " ]");
        String procedureContent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n          |to-report " + name + formattedArgs + "\n          |" + body + "\n          |end"));
        return this.rewrite(NoopFolder$.MODULE$, (Function4<StructureResults, String, String, String, String>)(Function4 & Serializable)(res, headers, procedures, footer) -> this.procedureAdd(procedureContent, (StructureResults)res, (String)headers, (String)procedures, (String)footer), this.rewrite$default$3());
    }

    private String declarationReplace(String declKeyword, Regex declRegex, Function1<StructureResults, Seq<String>> declItems, String addedItem, StructureResults res, String headers, String procedures, String footer) {
        String newDecl = declKeyword + " " + ((IterableOnceOps)((SeqOps)((SeqOps)declItems.apply((Object)res)).$colon$plus((Object)addedItem)).distinct()).mkString("[", " ", "]");
        String modifiedHeaders = (String)declRegex.findFirstMatchIn((CharSequence)headers).map((Function1 & Serializable)m -> StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(headers), m.start()) + newDecl + StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(headers), m.end())).getOrElse(() -> AstRewriter.$anonfun$4(newDecl, headers));
        return modifiedHeaders + procedures + footer;
    }

    private String procedureAdd(String content, StructureResults res, String headers, String procedures, String footer) {
        return headers + procedures + "\n" + content + "\n" + footer;
    }

    public String rewrite(PositionalAstFolder<AstEdit> visitor, Function4<StructureResults, String, String, String, String> wholeFile, String sourceName) {
        Tuple2 tuple2 = this.basicParse(this.op);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq procs = (Seq)tuple2._1();
        StructureResults structureResults = (StructureResults)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)procs, (Object)structureResults);
        Seq procs2 = (Seq)tuple22._1();
        StructureResults structureResults2 = (StructureResults)tuple22._2();
        Tuple3<WhitespaceMap, Map<String, String>, Map<String, String>> tuple3 = this.trackWhitespace((Function1<String, String>)(Function1 & Serializable)filename -> this.getSource$5((String)filename), (Iterable<ProcedureDefinition>)procs2);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        WhitespaceMap wsMap = (WhitespaceMap)tuple3._1();
        Map fileHeaders = (Map)tuple3._2();
        Map fileFooters = (Map)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)wsMap, (Object)fileHeaders, (Object)fileFooters);
        WhitespaceMap wsMap2 = (WhitespaceMap)tuple32._1();
        Map fileHeaders2 = (Map)tuple32._2();
        Map fileFooters2 = (Map)tuple32._3();
        Seq procsToRewrite = (Seq)procs2.filter((Function1 & Serializable)_$7 -> {
            String string = _$7.filename();
            String string2 = sourceName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        AstEdit edit = (AstEdit)procsToRewrite.foldLeft((Object)AstEdit$.MODULE$.apply((Map<AstPath, Function4<Formatter, AstNode, AstPath, AstFormat, AstFormat>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), wsMap2), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                AstEdit edit = (AstEdit)tuple2._1();
                ProcedureDefinition proc = (ProcedureDefinition)tuple2._2();
                return visitor.visitProcedureDefinition(proc, edit);
            }
            throw new MatchError((Object)tuple2);
        });
        String headers = (String)fileHeaders2.getOrElse((Object)"", AstRewriter::$anonfun$8);
        String footer = (String)fileFooters2.getOrElse((Object)"", AstRewriter::$anonfun$9);
        Regex eolWhitespace = new Regex("\\s+$", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String rewrittenProcedures = this.format(edit, (Iterable<ProcedureDefinition>)procsToRewrite);
        String rewritten = (String)wholeFile.apply((Object)structureResults2, (Object)headers, (Object)rewrittenProcedures, (Object)footer);
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(rewritten)).map((Function1 & Serializable)_$8 -> eolWhitespace.replaceAllIn((CharSequence)_$8, "")).mkString("\n");
    }

    public String rewrite$default$3() {
        return "";
    }

    public Tuple3<WhitespaceMap, Map<String, String>, Map<String, String>> trackWhitespace(Function1<String, String> getSource, Iterable<ProcedureDefinition> procs) {
        WhiteSpace.Tracker ws = new WhiteSpace.Tracker(getSource, this.tokenizer());
        ObjectRef fileHeaders = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
        ObjectRef fileFooters = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
        ObjectRef procedurePositions = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
        Tuple2 whiteSpaces = (Tuple2)procs.foldLeft((Object)Tuple2$.MODULE$.apply((Object)WhitespaceMap$.MODULE$.empty(), (Object)WhiteSpace$Context$.MODULE$.empty()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                WhiteSpace.Context context;
                WhitespaceMap whitespaceLog = (WhitespaceMap)tuple2._1();
                WhiteSpace.Context ctx = (WhiteSpace.Context)tuple2._2();
                ProcedureDefinition proc = (ProcedureDefinition)tuple22._2();
                ProcedureSyntax procSyntax = this.procedurePosition$1(procedurePositions, getSource, proc.filename(), proc.procedure().name());
                if (ctx.lastPosition().map((Function1 & Serializable)_$9 -> ((SourceLocation)_$9._2()).filename()).contains((Object)proc.filename())) {
                    context = WhiteSpace$Context$.MODULE$.empty(ctx.lastPosition());
                } else {
                    int procStart = procSyntax.declarationKeyword().start();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)proc.filename());
                    fileHeaders$1.elem = (Map)((Map)fileHeaders$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString((String)getSource.apply((Object)proc.filename())), 0, procStart)));
                    context = WhiteSpace$Context$.MODULE$.empty((Option<Tuple2<AstPath, SourceLocation>>)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)AstPath$.MODULE$.apply((Seq<AstPath.Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AstPath.Component[0])), (Object)SourceLocation$.MODULE$.apply(procStart, procStart, proc.filename()))));
                }
                WhiteSpace.Context newContext = context;
                WhiteSpace.Context r = ws.visitProcedureDefinition(proc, newContext);
                AstRewriter.addTrailingWhitespace$1(fileFooters, getSource, r);
                return Tuple2$.MODULE$.apply((Object)whitespaceLog.$plus$plus(r.whitespaceLog()), (Object)r);
            }
            throw new MatchError((Object)tuple22);
        });
        if (procs.isEmpty()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"");
            fileHeaders.elem = (Map)((Map)fileHeaders.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, getSource.apply((Object)"")));
        }
        AstRewriter.addTrailingWhitespace$1(fileFooters, getSource, (WhiteSpace.Context)whiteSpaces._2());
        return Tuple3$.MODULE$.apply(whiteSpaces._1(), (Object)((Map)fileHeaders.elem), (Object)((Map)fileFooters.elem));
    }

    public String format(AstEdit edit, Iterable<ProcedureDefinition> procs) {
        Formatter formatter = new Formatter();
        AstFormat res = (AstFormat)((IterableOnceOps)procs.filter((Function1 & Serializable)p -> this.op.sources().contains((Object)p.procedure().filename()))).foldLeft((Object)Formatter$.MODULE$.context("", edit.operations(), Formatter$.MODULE$.context$default$3(), edit.wsMap()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                AstFormat acc = (AstFormat)tuple2._1();
                ProcedureDefinition proc = (ProcedureDefinition)tuple2._2();
                return formatter.visitProcedureDefinition(proc, Formatter$.MODULE$.context(acc.text(), acc.operations(), Formatter$.MODULE$.context$default$3(), edit.wsMap()));
            }
            throw new MatchError((Object)tuple2);
        });
        return res.text();
    }

    private static final String $anonfun$4(String newDecl$2, String headers$2) {
        return newDecl$2 + "\n" + headers$2;
    }

    private final Option getSource$5$$anonfun$1(String filename$1) {
        return IncludeFile$.MODULE$.apply(this.op.compilationEnvironment(), filename$1).map((Function1 & Serializable)_$6 -> (String)_$6._2());
    }

    private static final String getSource$5$$anonfun$2(String filename$2) {
        throw new Exception("Unable to find file: " + filename$2);
    }

    private final String getSource$5(String filename) {
        return (String)this.op.sources().get((Object)filename).orElse(() -> this.getSource$5$$anonfun$1(filename)).getOrElse(() -> AstRewriter.getSource$5$$anonfun$2(filename));
    }

    private static final String $anonfun$8() {
        return "";
    }

    private static final String $anonfun$9() {
        return "";
    }

    private final ProcedureSyntax procedurePosition$1(ObjectRef procedurePositions$1, Function1 getSource$1, String file, String procedureName) {
        if (((Map)procedurePositions$1.elem).isDefinedAt((Object)file)) {
            return (ProcedureSyntax)((MapOps)((Map)procedurePositions$1.elem).apply((Object)file)).apply((Object)procedureName);
        }
        Map newPositions = (Map)this.findProcedurePositions((String)getSource$1.apply((Object)file), (Option)Some$.MODULE$.apply((Object)this.op.containingProgram().dialect())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                ProcedureSyntax v = (ProcedureSyntax)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k.toUpperCase(Locale.ENGLISH));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)file);
        procedurePositions$1.elem = (Map)((Map)procedurePositions$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newPositions));
        return (ProcedureSyntax)newPositions.apply((Object)procedureName);
    }

    private static final void addTrailingWhitespace$1(ObjectRef fileFooters$1, Function1 getSource$2, WhiteSpace.Context ctx) {
        ctx.lastPosition().foreach(x$1 -> {
            SourceLocation sourceLocation;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (sourceLocation = (SourceLocation)tuple2._2()) != null) {
                SourceLocation sourceLocation2 = SourceLocation$.MODULE$.unapply(sourceLocation);
                int n = sourceLocation2._1();
                int n2 = sourceLocation2._2();
                String string = sourceLocation2._3();
                int lastIndex = n2;
                String lastFile = string;
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)lastFile);
                fileFooters$2.elem = (Map)((Map)fileFooters$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)getSource$2.apply((Object)lastFile)), lastIndex)));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }
}

