/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import org.nlogo.core.Fail$;
import org.nlogo.core.LiteralImportHandler;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$CloseParen$;
import org.nlogo.core.TokenType$Comment$;
import org.nlogo.core.TokenType$Eof$;
import org.nlogo.core.TokenType$Extension$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBrace$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$OpenParen$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class LiteralParser {
    private final LiteralImportHandler importHandler;
    private final String ERR_EXPECTED_CLOSEPAREN;
    private final String ERR_EXPECTED_LITERAL;
    private final String ERR_EXPECTED_NUMBER;
    private final String ERR_EXTRA_STUFF_AFTER_LITERAL;
    private final String ERR_EXTRA_STUFF_AFTER_NUMBER;
    private final String ERR_MISSING_CLOSEBRACKET;

    public LiteralParser(LiteralImportHandler importHandler) {
        this.importHandler = importHandler;
        this.ERR_EXPECTED_CLOSEPAREN = "Expected a closing parenthesis.";
        this.ERR_EXPECTED_LITERAL = "Expected a literal value.";
        this.ERR_EXPECTED_NUMBER = "Expected a number.";
        this.ERR_EXTRA_STUFF_AFTER_LITERAL = "Extra characters after literal.";
        this.ERR_EXTRA_STUFF_AFTER_NUMBER = "Extra characters after number.";
        this.ERR_MISSING_CLOSEBRACKET = "No closing bracket for this open bracket.";
    }

    public Object getLiteralValue(Iterator<Token> tokens) {
        Object result = this.readLiteralPrefix((Token)tokens.next(), tokens);
        Token extra = (Token)tokens.next();
        TokenType tokenType = extra.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType != null ? !tokenType.equals(tokenType$Eof$) : tokenType$Eof$ != null), (Function0<String>)((Function0 & Serializable)this::getLiteralValue$$anonfun$1), extra);
        return result;
    }

    public Object getLiteralFromFile(Iterator<Token> tokens) {
        return this.readLiteralPrefix((Token)tokens.next(), tokens);
    }

    public Double getNumberValue(Iterator<Token> tokens) {
        Token token = (Token)tokens.next();
        TokenType tokenType = token.tpe();
        TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
        if ((tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null) || !(token.value() instanceof Double)) {
            throw Fail$.MODULE$.exception(this.ERR_EXPECTED_NUMBER, token);
        }
        Token extra = (Token)tokens.next();
        TokenType tokenType2 = extra.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType2 != null ? !tokenType2.equals(tokenType$Eof$) : tokenType$Eof$ != null), (Function0<String>)((Function0 & Serializable)this::getNumberValue$$anonfun$1), extra);
        return (Double)token.value();
    }

    public Object readLiteralPrefix(Token token2, Iterator<Token> tokens2) {
        TokenType tokenType = token2.tpe();
        if (TokenType$Extension$.MODULE$.equals(tokenType)) {
            return this.importHandler.parseExtensionLiteral(token2);
        }
        if (TokenType$Literal$.MODULE$.equals(tokenType)) {
            return token2.value();
        }
        if (TokenType$OpenBracket$.MODULE$.equals(tokenType)) {
            Tuple2<LogoList, Token> tuple2 = this.parseLiteralList(token2, tokens2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            LogoList result = (LogoList)tuple2._1();
            LogoList result2 = result;
            return result2;
        }
        if (TokenType$OpenBrace$.MODULE$.equals(tokenType)) {
            return this.importHandler.parseLiteralAgentOrAgentSet(tokens2, (Function2<Token, Iterator<Token>, Object>)(Function2 & Serializable)(token, tokens) -> this.readLiteralPrefix((Token)token, (Iterator<Token>)tokens));
        }
        if (TokenType$OpenParen$.MODULE$.equals(tokenType)) {
            Object result = this.readLiteralPrefix((Token)tokens2.next(), tokens2);
            Token closeParen = (Token)tokens2.next();
            TokenType tokenType2 = closeParen.tpe();
            TokenType$CloseParen$ tokenType$CloseParen$ = TokenType$CloseParen$.MODULE$;
            Fail$.MODULE$.cAssert(!(tokenType2 != null ? !tokenType2.equals(tokenType$CloseParen$) : tokenType$CloseParen$ != null), (Function0<String>)((Function0 & Serializable)this::readLiteralPrefix$$anonfun$2), closeParen);
            return result;
        }
        if (TokenType$Comment$.MODULE$.equals(tokenType)) {
            return this.readLiteralPrefix((Token)tokens2.next(), tokens2);
        }
        throw Fail$.MODULE$.exception(this.ERR_EXPECTED_LITERAL, token2);
    }

    public Tuple2<LogoList, Token> parseLiteralList(Token openBracket, Iterator<Token> tokens) {
        LogoList list = LogoList$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[0]));
        None$ closeBracket = None$.MODULE$;
        while (!closeBracket.isDefined()) {
            Token token = (Token)tokens.next();
            TokenType tokenType = token.tpe();
            if (TokenType$CloseBracket$.MODULE$.equals(tokenType)) {
                closeBracket = Some$.MODULE$.apply((Object)token);
                continue;
            }
            if (TokenType$Eof$.MODULE$.equals(tokenType)) {
                throw Fail$.MODULE$.exception(this.ERR_MISSING_CLOSEBRACKET, openBracket);
            }
            list = list.lput(this.readLiteralPrefix(token, tokens));
        }
        return Tuple2$.MODULE$.apply((Object)list, closeBracket.get());
    }

    private final String getLiteralValue$$anonfun$1() {
        return this.ERR_EXTRA_STUFF_AFTER_LITERAL;
    }

    private final String getNumberValue$$anonfun$1() {
        return this.ERR_EXTRA_STUFF_AFTER_NUMBER;
    }

    private final String readLiteralPrefix$$anonfun$2() {
        return this.ERR_EXPECTED_CLOSEPAREN;
    }
}

