/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.core.BreedIdentifierHandler$;
import org.nlogo.core.Fail$;
import org.nlogo.core.I18N$;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.StructureDeclarations;
import org.nlogo.core.StructureDeclarations$Breed$;
import org.nlogo.core.StructureDeclarations$Procedure$;
import org.nlogo.core.StructureDeclarations$Variables$;
import org.nlogo.core.Token;
import org.nlogo.core.Token$;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.parse.StructureChecker;
import org.nlogo.parse.StructureChecker$Occurrence$;
import org.nlogo.parse.SymbolTable;
import org.nlogo.parse.SymbolTable$;
import org.nlogo.parse.SymbolType;
import org.nlogo.parse.SymbolType$;
import org.nlogo.parse.SymbolType$BreedCommand$;
import org.nlogo.parse.SymbolType$BreedReporter$;
import org.nlogo.parse.SymbolType$BreedVariable$;
import org.nlogo.parse.SymbolType$GlobalVariable$;
import org.nlogo.parse.SymbolType$LinkBreed$;
import org.nlogo.parse.SymbolType$LinkBreedSingular$;
import org.nlogo.parse.SymbolType$LinkBreedVariable$;
import org.nlogo.parse.SymbolType$LinkVariable$;
import org.nlogo.parse.SymbolType$PatchVariable$;
import org.nlogo.parse.SymbolType$ProcedureSymbol$;
import org.nlogo.parse.SymbolType$ProcedureVariable$;
import org.nlogo.parse.SymbolType$SymbolTypeOrdering$;
import org.nlogo.parse.SymbolType$TurtleBreed$;
import org.nlogo.parse.SymbolType$TurtleBreedSingular$;
import org.nlogo.parse.SymbolType$TurtleVariable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class StructureChecker$
implements Serializable {
    private static final StructureChecker$Occurrence$ Occurrence;
    public static final StructureChecker$ MODULE$;

    private StructureChecker$() {
    }

    static {
        MODULE$ = new StructureChecker$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StructureChecker$.class);
    }

    public void rejectMisplacedConstants(Seq<StructureDeclarations.Declaration> declarations) {
        declarations.foreach(declaration -> {
            StructureDeclarations.Declaration declaration2 = declaration;
            if (declaration2 instanceof StructureDeclarations.Variables) {
                Seq<StructureDeclarations.Identifier> seq;
                StructureDeclarations.Variables variables = StructureDeclarations$Variables$.MODULE$.unapply((StructureDeclarations.Variables)declaration2);
                StructureDeclarations.Identifier identifier = variables._1();
                Seq<StructureDeclarations.Identifier> names = seq = variables._2();
                names.foreach(name -> {
                    TokenType tokenType = name.token().tpe();
                    TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
                    if (!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null)) {
                        throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().get("compiler.StructureChecker.variableConstant"), name.token());
                    }
                });
                return;
            }
            if (declaration2 instanceof StructureDeclarations.Procedure) {
                StructureDeclarations.Procedure procedure = StructureDeclarations$Procedure$.MODULE$.unapply((StructureDeclarations.Procedure)declaration2);
                StructureDeclarations.Identifier identifier = procedure._1();
                boolean bl = procedure._2();
                Seq<StructureDeclarations.Identifier> seq = procedure._3();
                Seq<Token> seq2 = procedure._4();
                Seq<StructureDeclarations.Identifier> inputs = seq;
                inputs.foreach(input -> {
                    TokenType tokenType = input.token().tpe();
                    TokenType$Literal$ tokenType$Literal$ = TokenType$Literal$.MODULE$;
                    if (!(tokenType != null ? !tokenType.equals(tokenType$Literal$) : tokenType$Literal$ != null)) {
                        throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().get("compiler.StructureChecker.inputConstant"), input.token());
                    }
                });
                return;
            }
        });
    }

    public void rejectDuplicateDeclarations(Seq<StructureDeclarations.Declaration> declarations) {
        declarations.withFilter((Function1 & Serializable)x$1 -> {
            StructureDeclarations.Declaration declaration = x$1;
            if (declaration instanceof StructureDeclarations.Procedure) {
                StructureDeclarations.Procedure procedure = StructureDeclarations$Procedure$.MODULE$.unapply((StructureDeclarations.Procedure)declaration);
                StructureDeclarations.Identifier identifier = procedure._1();
                boolean bl = procedure._2();
                Seq<StructureDeclarations.Identifier> seq = procedure._3();
                Seq<Token> seq2 = procedure._4();
                Seq<StructureDeclarations.Identifier> inputs = seq;
                return true;
            }
            return false;
        }).foreach(x$1 -> {
            StructureDeclarations.Declaration declaration = x$1;
            if (declaration instanceof StructureDeclarations.Procedure) {
                StructureDeclarations.Procedure procedure = StructureDeclarations$Procedure$.MODULE$.unapply((StructureDeclarations.Procedure)declaration);
                StructureDeclarations.Identifier identifier = procedure._1();
                boolean bl = procedure._2();
                Seq<StructureDeclarations.Identifier> seq = procedure._3();
                Seq<Token> seq2 = procedure._4();
                Seq<StructureDeclarations.Identifier> inputs = seq;
                inputs.foreach(input -> {
                    MODULE$.checkNotArrow((StructureDeclarations.Identifier)input);
                    Fail$.MODULE$.cAssert(inputs.count((Function1 & Serializable)_$1 -> {
                        String string = _$1.name();
                        String string2 = input.name();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }) == 1, (Function0<String>)((Function0 & Serializable)() -> StructureChecker$.rejectDuplicateDeclarations$$anonfun$2$$anonfun$1$$anonfun$2(input)), input.token());
                });
                return;
            }
            throw new MatchError((Object)declaration);
        });
        this.allPairs(declarations).foreach(x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                StructureDeclarations.Declaration decl1 = (StructureDeclarations.Declaration)tuple2._1();
                StructureDeclarations.Declaration decl2 = (StructureDeclarations.Declaration)tuple2._2();
                this.checkPair$1(decl1, decl2).foreach((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String kind = (String)tuple2._1();
                        Token token = (Token)tuple2._2();
                        throw Fail$.MODULE$.exception(MODULE$.redeclarationOf(kind), token);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void rejectDuplicateNames(Seq<StructureDeclarations.Declaration> declarations, SymbolTable usedNames) {
        declarations.foreach(x$1 -> {
            StructureDeclarations.Declaration declaration = x$1;
            if (declaration instanceof StructureDeclarations.Breed) {
                StructureDeclarations.Breed breed = StructureDeclarations$Breed$.MODULE$.unapply((StructureDeclarations.Breed)declaration);
                StructureDeclarations.Identifier identifier = breed._1();
                StructureDeclarations.Identifier identifier2 = breed._2();
                boolean bl = breed._3();
                boolean bl2 = breed._4();
                StructureDeclarations.Identifier plural = identifier;
                StructureDeclarations.Identifier singular = identifier2;
                String string = plural.name();
                String string2 = singular.name();
                Fail$.MODULE$.cAssert(string == null ? string2 != null : !string.equals(string2), (Function0<String>)((Function0 & Serializable)StructureChecker$::rejectDuplicateNames$$anonfun$1$$anonfun$1), singular.token());
                return;
            }
        });
        Seq<StructureChecker.Occurrence> occurrences = this.occurrencesFromDeclarations(declarations);
        occurrences.iterator().withFilter((Function1 & Serializable)x$1 -> {
            StructureChecker.Occurrence occurrence = x$1;
            if (occurrence != null) {
                StructureChecker.Occurrence occurrence2 = StructureChecker$Occurrence$.MODULE$.unapply(occurrence);
                StructureDeclarations.Declaration declaration = occurrence2._1();
                StructureDeclarations.Identifier identifier = occurrence2._2();
                SymbolType symbolType = occurrence2._3();
                boolean bl = occurrence2._4();
                if (declaration instanceof StructureDeclarations.Breed) {
                    StructureDeclarations.Breed breed = StructureDeclarations$Breed$.MODULE$.unapply((StructureDeclarations.Breed)declaration);
                    StructureDeclarations.Identifier identifier2 = breed._1();
                    StructureDeclarations.Identifier identifier3 = breed._2();
                    boolean bl2 = breed._3();
                    boolean bl3 = breed._4();
                    StructureChecker.Occurrence usage = occurrence;
                    return true;
                }
            }
            return false;
        }).foreach(x$1 -> {
            StructureChecker.Occurrence occurrence = x$1;
            if (occurrence != null) {
                StructureChecker.Occurrence occurrence2 = StructureChecker$Occurrence$.MODULE$.unapply(occurrence);
                StructureDeclarations.Declaration declaration = occurrence2._1();
                StructureDeclarations.Identifier identifier = occurrence2._2();
                SymbolType symbolType = occurrence2._3();
                boolean bl = occurrence2._4();
                if (declaration instanceof StructureDeclarations.Breed) {
                    StructureDeclarations.Breed breed = StructureDeclarations$Breed$.MODULE$.unapply((StructureDeclarations.Breed)declaration);
                    StructureDeclarations.Identifier identifier2 = breed._1();
                    StructureDeclarations.Identifier identifier3 = breed._2();
                    boolean bl2 = breed._3();
                    boolean bl3 = breed._4();
                    StructureChecker.Occurrence usage = occurrence;
                    MODULE$.checkForBreedPrimsDuplicatingBuiltIn(usage, usedNames);
                    return;
                }
            }
            throw new MatchError((Object)occurrence);
        });
        SymbolTable usedNamesAndBreedNames = usedNames.$plus$plus(this.breedPrimitives(declarations));
        occurrences.iterator().foreach(usage -> {
            this.checkNotArrow(usage.identifier());
            usedNamesAndBreedNames.foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String identifier = (String)tuple2._1();
                    SymbolType typeName = (SymbolType)tuple2._2();
                    this.checkForInconsistentIDs$1(identifier, typeName, (StructureChecker.Occurrence)usage);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        });
        occurrences.iterator().withFilter((Function1 & Serializable)firstUsage -> firstUsage.isGlobal()).foreach(firstUsage -> occurrences.withFilter((Function1 & Serializable)secondUsage -> secondUsage != firstUsage).foreach(secondUsage -> this.checkForInconsistentIDs$1(firstUsage.identifier().name(), firstUsage.typeOfDeclaration(), (StructureChecker.Occurrence)secondUsage)));
    }

    public void rejectMissingReport(Seq<StructureDeclarations.Declaration> declarations) {
        declarations.foreach(_$2 -> {
            StructureDeclarations.Declaration declaration = _$2;
            if (declaration instanceof StructureDeclarations.Procedure) {
                StructureDeclarations.Procedure procedure = StructureDeclarations$Procedure$.MODULE$.unapply((StructureDeclarations.Procedure)declaration);
                StructureDeclarations.Identifier identifier = procedure._1();
                boolean bl = procedure._2();
                Seq<StructureDeclarations.Identifier> seq = procedure._3();
                Seq<Token> seq2 = procedure._4();
                if (bl) {
                    Seq<Token> tokens = seq2;
                    if (!tokens.exists((Function1 & Serializable)_$3 -> {
                        Token token = _$3;
                        if (token != null) {
                            Token token2 = Token$.MODULE$.unapply(token);
                            String string = token2._1();
                            TokenType tokenType = token2._2();
                            Object object = token2._3();
                            if (TokenType$Ident$.MODULE$.equals(tokenType) && ("REPORT".equals(object) || "RUN".equals(object) || "RUNRESULT".equals(object) || "ERROR".equals(object))) {
                                return true;
                            }
                        }
                        return false;
                    })) {
                        throw Fail$.MODULE$.exception("Reporter procedures must report a value", (SourceLocatable)tokens.apply(1));
                    }
                    return;
                }
            }
        });
    }

    public SymbolTable breedPrimitives(Seq<StructureDeclarations.Declaration> declarations) {
        return (SymbolTable)((Object)declarations.foldLeft((Object)SymbolTable$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, x$2);
            if (tuple2 != null) {
                SymbolTable symbolTable = (SymbolTable)((Object)((Object)tuple2._1()));
                StructureDeclarations.Declaration declaration = (StructureDeclarations.Declaration)tuple2._2();
                SymbolTable table = symbolTable;
                if (declaration instanceof StructureDeclarations.Breed) {
                    StructureDeclarations.Breed breed = (StructureDeclarations.Breed)declaration;
                    return table.addSymbols((Iterable<String>)BreedIdentifierHandler$.MODULE$.breedCommands(breed), SymbolType$BreedCommand$.MODULE$).addSymbols((Iterable<String>)BreedIdentifierHandler$.MODULE$.breedReporters(breed), SymbolType$BreedReporter$.MODULE$);
                }
                SymbolTable table2 = symbolTable;
                return table2;
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private void checkForBreedPrimsDuplicatingBuiltIn(StructureChecker.Occurrence usage, SymbolTable usedNames) {
        StructureDeclarations.Declaration declaration = usage.declaration();
        if (declaration instanceof StructureDeclarations.Breed) {
            StructureDeclarations.Breed breed = StructureDeclarations$Breed$.MODULE$.unapply((StructureDeclarations.Breed)declaration);
            StructureDeclarations.Identifier identifier = breed._1();
            StructureDeclarations.Identifier identifier2 = breed._2();
            boolean bl = breed._3();
            boolean bl2 = breed._4();
            StructureDeclarations.Breed breed2 = (StructureDeclarations.Breed)declaration;
            Seq matchedPrimAndType = (Seq)((IterableOps)((IterableOps)BreedIdentifierHandler$.MODULE$.breedCommands(breed2).filter((Function1 & Serializable)c -> usedNames.contains(c.toUpperCase(Locale.ENGLISH)))).map((Function1 & Serializable)i -> Tuple2$.MODULE$.apply(i, (Object)SymbolType$BreedCommand$.MODULE$))).$plus$plus((IterableOnce)((IterableOps)BreedIdentifierHandler$.MODULE$.breedReporters(breed2).filter((Function1 & Serializable)r -> usedNames.contains(r.toUpperCase(Locale.ENGLISH)))).map((Function1 & Serializable)i -> Tuple2$.MODULE$.apply(i, (Object)SymbolType$BreedReporter$.MODULE$)));
            matchedPrimAndType.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String p = (String)tuple2._1();
                    SymbolType st = (SymbolType)tuple2._2();
                    throw Fail$.MODULE$.exception(MODULE$.breedOverridesBuiltIn(breed2, usedNames.apply(p.toUpperCase(Locale.ENGLISH)), p), usage.identifier().token());
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    private Seq<StructureChecker.Occurrence> occurrencesFromDeclarations(Seq<StructureDeclarations.Declaration> declarations) {
        Seq os = (Seq)declarations.foldLeft((Object)((SeqOps)Nil$.MODULE$), (Function2 & Serializable)(x$1, x$2) -> {
            StructureDeclarations.Declaration declaration;
            Seq seq;
            block9: {
                Seq seq2;
                Seq occs;
                block10: {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    seq = (Seq)tuple2._1();
                    declaration = (StructureDeclarations.Declaration)tuple2._2();
                    occs = seq;
                    if (!(declaration instanceof StructureDeclarations.Variables)) break block9;
                    StructureDeclarations.Variables variables = (StructureDeclarations.Variables)declaration;
                    StructureDeclarations.Variables variables2 = StructureDeclarations$Variables$.MODULE$.unapply(variables);
                    StructureDeclarations.Identifier identifier = variables2._1();
                    Seq<StructureDeclarations.Identifier> seq3 = variables2._2();
                    StructureDeclarations.Identifier kind = identifier;
                    Seq<StructureDeclarations.Identifier> names = seq3;
                    StructureDeclarations.Variables decl = variables;
                    String string = kind.name().toUpperCase(Locale.ENGLISH);
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1174749392: {
                            if (!"TURTLES-OWN".equals(string)) break;
                            seq2 = (Seq)names.map((Function1 & Serializable)_$4 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$4, SymbolType$TurtleVariable$.MODULE$, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                            break block10;
                        }
                        case -1079569425: {
                            if (!"PATCHES-OWN".equals(string)) break;
                            seq2 = (Seq)names.map((Function1 & Serializable)_$5 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$5, SymbolType$PatchVariable$.MODULE$, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                            break block10;
                        }
                        case 839056656: {
                            if (!"GLOBALS".equals(string)) break;
                            seq2 = (Seq)names.map((Function1 & Serializable)_$7 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$7, SymbolType$GlobalVariable$.MODULE$, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                            break block10;
                        }
                        case 1179618098: {
                            if (!"LINKS-OWN".equals(string)) break;
                            seq2 = (Seq)names.map((Function1 & Serializable)_$6 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$6, SymbolType$LinkVariable$.MODULE$, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                            break block10;
                        }
                    }
                    String breedName = string;
                    String name = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(breedName), "-OWN");
                    seq2 = (Seq)occs.find((Function1 & Serializable)_$8 -> {
                        String string = _$8.identifier().name();
                        String string2 = name;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }).map((Function1 & Serializable)occ -> {
                        SymbolType symbolType = occ.typeOfDeclaration();
                        if (SymbolType$LinkBreed$.MODULE$.equals(symbolType)) {
                            return (Seq)names.map((Function1 & Serializable)_$9 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$9, SymbolType$LinkBreedVariable$.MODULE$.apply(name), StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                        }
                        if (SymbolType$TurtleBreed$.MODULE$.equals(symbolType)) {
                            return (Seq)names.map((Function1 & Serializable)_$10 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$10, SymbolType$BreedVariable$.MODULE$.apply(name), StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()));
                        }
                        return (Seq)((SeqOps)Nil$.MODULE$);
                    }).getOrElse(StructureChecker$::$anonfun$12);
                }
                Seq vars = seq2;
                return (Seq)occs.$plus$plus((IterableOnce)vars);
            }
            Seq occs = seq;
            if (declaration instanceof StructureDeclarations.Procedure) {
                StructureDeclarations.Procedure procedure = (StructureDeclarations.Procedure)declaration;
                StructureDeclarations.Procedure procedure2 = StructureDeclarations$Procedure$.MODULE$.unapply(procedure);
                StructureDeclarations.Identifier identifier = procedure2._1();
                boolean bl = procedure2._2();
                Seq<StructureDeclarations.Identifier> seq4 = procedure2._3();
                Seq<Token> seq5 = procedure2._4();
                StructureDeclarations.Identifier name = identifier;
                Seq<StructureDeclarations.Identifier> inputs = seq4;
                StructureDeclarations.Procedure decl = procedure;
                StructureChecker.Occurrence occurrence = StructureChecker$Occurrence$.MODULE$.apply(decl, name, SymbolType$ProcedureSymbol$.MODULE$, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4());
                return (Seq)((IterableOps)((SeqOps)inputs.map((Function1 & Serializable)_$11 -> StructureChecker$Occurrence$.MODULE$.apply(decl, (StructureDeclarations.Identifier)_$11, SymbolType$ProcedureVariable$.MODULE$, false))).$plus$colon((Object)occurrence)).$plus$plus((IterableOnce)occs);
            }
            Seq occs2 = seq;
            if (!(declaration instanceof StructureDeclarations.Breed)) {
                return seq;
            }
            StructureDeclarations.Breed breed = (StructureDeclarations.Breed)declaration;
            StructureDeclarations.Breed breed2 = StructureDeclarations$Breed$.MODULE$.unapply(breed);
            StructureDeclarations.Identifier identifier = breed2._1();
            StructureDeclarations.Identifier identifier2 = breed2._2();
            boolean bl = breed2._3();
            boolean bl2 = breed2._4();
            StructureDeclarations.Identifier plural = identifier;
            StructureDeclarations.Identifier singular = identifier2;
            StructureDeclarations.Breed decl = breed;
            Tuple2 tuple2 = decl.isLinkBreed() ? Tuple2$.MODULE$.apply((Object)SymbolType$LinkBreed$.MODULE$, (Object)SymbolType$LinkBreedSingular$.MODULE$) : Tuple2$.MODULE$.apply((Object)SymbolType$TurtleBreed$.MODULE$, (Object)SymbolType$TurtleBreedSingular$.MODULE$);
            SymbolType symType = (SymbolType)tuple2._1();
            SymbolType singularSymType = (SymbolType)tuple2._2();
            return (Seq)occs2.$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)StructureChecker$Occurrence$.MODULE$.apply(decl, plural, symType, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()), (List)new .colon.colon((Object)StructureChecker$Occurrence$.MODULE$.apply(decl, singular, singularSymType, StructureChecker$Occurrence$.MODULE$.$lessinit$greater$default$4()), (List)Nil$.MODULE$))));
        });
        return (Seq)os.sortBy((Function1 & Serializable)_$12 -> _$12.typeOfDeclaration(), (Ordering)SymbolType$SymbolTypeOrdering$.MODULE$);
    }

    private boolean usageDoesNotClashWithOccurrence(String usageIdentifier, SymbolType usageType, StructureChecker.Occurrence occ) {
        SymbolType symbolType;
        boolean identifierNamesAreDifferent;
        boolean bl = identifierNamesAreDifferent = !usageIdentifier.equalsIgnoreCase(occ.identifier().name());
        return identifierNamesAreDifferent || ((symbolType = usageType) instanceof SymbolType.Variable ? this.compatibleVariableDeclaration(usageIdentifier, usageType, occ) : false);
    }

    private boolean compatibleVariableDeclaration(String usageIdentifier, SymbolType usageType, StructureChecker.Occurrence occ) {
        Tuple2 tuple2;
        block14: {
            block16: {
                SymbolType symbolType;
                SymbolType symbolType2;
                block15: {
                    block11: {
                        block13: {
                            SymbolType symbolType3;
                            SymbolType symbolType4;
                            block12: {
                                tuple2 = Tuple2$.MODULE$.apply((Object)usageType, (Object)occ.typeOfDeclaration());
                                if (tuple2 == null) break block11;
                                symbolType4 = (SymbolType)tuple2._1();
                                symbolType3 = (SymbolType)tuple2._2();
                                if (!SymbolType$TurtleVariable$.MODULE$.equals(symbolType4) || !(symbolType3 instanceof SymbolType.BreedVariable)) break block12;
                                SymbolType.BreedVariable breedVariable = SymbolType$BreedVariable$.MODULE$.unapply((SymbolType.BreedVariable)symbolType3);
                                String string = breedVariable._1();
                                break block13;
                            }
                            if (!(symbolType4 instanceof SymbolType.BreedVariable)) break block11;
                            SymbolType.BreedVariable breedVariable = SymbolType$BreedVariable$.MODULE$.unapply((SymbolType.BreedVariable)symbolType4);
                            String string = breedVariable._1();
                            if (!SymbolType$TurtleVariable$.MODULE$.equals(symbolType3)) break block11;
                        }
                        return true;
                    }
                    if (tuple2 == null) break block14;
                    symbolType2 = (SymbolType)tuple2._1();
                    symbolType = (SymbolType)tuple2._2();
                    if (!SymbolType$LinkVariable$.MODULE$.equals(symbolType2) || !(symbolType instanceof SymbolType.LinkBreedVariable)) break block15;
                    SymbolType.LinkBreedVariable linkBreedVariable = SymbolType$LinkBreedVariable$.MODULE$.unapply((SymbolType.LinkBreedVariable)symbolType);
                    String string = linkBreedVariable._1();
                    break block16;
                }
                if (!(symbolType2 instanceof SymbolType.LinkBreedVariable)) break block14;
                SymbolType.LinkBreedVariable linkBreedVariable = SymbolType$LinkBreedVariable$.MODULE$.unapply((SymbolType.LinkBreedVariable)symbolType2);
                String string = linkBreedVariable._1();
                if (!SymbolType$LinkVariable$.MODULE$.equals(symbolType)) break block14;
            }
            return true;
        }
        if (tuple2 != null) {
            SymbolType symbolType = (SymbolType)tuple2._1();
            SymbolType symbolType5 = (SymbolType)tuple2._2();
            if (symbolType instanceof SymbolType.LinkBreedVariable) {
                SymbolType.LinkBreedVariable linkBreedVariable = SymbolType$LinkBreedVariable$.MODULE$.unapply((SymbolType.LinkBreedVariable)symbolType);
                String string = linkBreedVariable._1();
                if (symbolType5 instanceof SymbolType.LinkBreedVariable) {
                    SymbolType.LinkBreedVariable linkBreedVariable2 = SymbolType$LinkBreedVariable$.MODULE$.unapply((SymbolType.LinkBreedVariable)symbolType5);
                    String string2 = linkBreedVariable2._1();
                    return true;
                }
            }
            if (symbolType instanceof SymbolType.BreedVariable) {
                SymbolType.BreedVariable breedVariable = SymbolType$BreedVariable$.MODULE$.unapply((SymbolType.BreedVariable)symbolType);
                String string = breedVariable._1();
                if (symbolType5 instanceof SymbolType.BreedVariable) {
                    SymbolType.BreedVariable breedVariable2 = SymbolType$BreedVariable$.MODULE$.unapply((SymbolType.BreedVariable)symbolType5);
                    String string3 = breedVariable2._1();
                    return true;
                }
            }
        }
        return false;
    }

    private <T> Iterator<Tuple2<T, T>> allPairs(Seq<T> xs) {
        return xs.iterator().flatMap((Function1 & Serializable)x1 -> (IterableOnce)xs.withFilter((Function1 & Serializable)x2 -> x1 != x2).map((Function1 & Serializable)x2 -> Tuple2$.MODULE$.apply(x1, x2)));
    }

    private String breedOverridesBuiltIn(StructureDeclarations.Breed breed, SymbolType duplicatedType, String duplicatedName) {
        String typeName = SymbolType$.MODULE$.typeName(duplicatedType);
        return I18N$.MODULE$.errors().getN("compiler.StructureChecker.breedOverrides", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"[" + breed.plural().name() + " " + breed.singular().name() + "]", duplicatedName, typeName}));
    }

    private void checkNotArrow(StructureDeclarations.Identifier ident) {
        String string = ident.name();
        String string2 = "->";
        Fail$.MODULE$.cAssert(string == null ? string2 != null : !string.equals(string2), (Function0<String>)((Function0 & Serializable)StructureChecker$::checkNotArrow$$anonfun$1), ident.token());
    }

    private String redeclarationOf(String kind) {
        return I18N$.MODULE$.errors().getN("compiler.StructureChecker.redeclaration", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{kind}));
    }

    private String duplicateOf(SymbolType symbolType, String origName) {
        String typeName = SymbolType$.MODULE$.typeName(symbolType);
        return I18N$.MODULE$.errors().getN("compiler.StructureChecker.duplicateType", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{typeName, origName}));
    }

    private String duplicateVariableIdentifier(StructureDeclarations.Identifier ident) {
        return I18N$.MODULE$.errors().getN("compiler.StructureChecker.duplicateVariable", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ident.name()}));
    }

    private final Option checkPair$1(StructureDeclarations.Declaration decl1, StructureDeclarations.Declaration decl2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)decl1, (Object)decl2);
        if (tuple2 != null) {
            StructureDeclarations.Declaration declaration = (StructureDeclarations.Declaration)tuple2._1();
            StructureDeclarations.Declaration declaration2 = (StructureDeclarations.Declaration)tuple2._2();
            if (declaration instanceof StructureDeclarations.Variables) {
                StructureDeclarations.Variables v1 = (StructureDeclarations.Variables)declaration;
                if (declaration2 instanceof StructureDeclarations.Variables) {
                    StructureDeclarations.Variables v2 = (StructureDeclarations.Variables)declaration2;
                    StructureDeclarations.Identifier identifier = v1.kind();
                    StructureDeclarations.Identifier identifier2 = v2.kind();
                    if (!(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null)) {
                        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)v1.kind().name(), (Object)v2.kind().token()));
                    }
                }
            }
            if (declaration instanceof StructureDeclarations.Extensions && declaration2 instanceof StructureDeclarations.Extensions) {
                StructureDeclarations.Extensions e = (StructureDeclarations.Extensions)declaration2;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"EXTENSIONS", (Object)e.token()));
            }
            if (declaration instanceof StructureDeclarations.Includes && declaration2 instanceof StructureDeclarations.Includes) {
                StructureDeclarations.Includes i = (StructureDeclarations.Includes)declaration2;
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"INCLUDES", (Object)i.token()));
            }
        }
        return None$.MODULE$;
    }

    private static final String rejectDuplicateDeclarations$$anonfun$2$$anonfun$1$$anonfun$2(StructureDeclarations.Identifier input$2) {
        return MODULE$.duplicateVariableIdentifier(input$2);
    }

    private static final String checkForInconsistentIDs$1$$anonfun$1(SymbolType usageType$1, StructureChecker.Occurrence occ$1) {
        return MODULE$.duplicateOf(usageType$1, occ$1.identifier().name());
    }

    private final void checkForInconsistentIDs$1(String usageIdentifier, SymbolType usageType, StructureChecker.Occurrence occ) {
        Fail$.MODULE$.cAssert(this.usageDoesNotClashWithOccurrence(usageIdentifier, usageType, occ), (Function0<String>)((Function0 & Serializable)() -> StructureChecker$.checkForInconsistentIDs$1$$anonfun$1(usageType, occ)), occ.identifier().token());
    }

    private static final String rejectDuplicateNames$$anonfun$1$$anonfun$1() {
        return I18N$.MODULE$.errors().get("compiler.StructureChecker.pluralSingular");
    }

    private static final Seq $anonfun$12() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final String checkNotArrow$$anonfun$1() {
        return I18N$.MODULE$.errors().get("compiler.StructureChecker.invalidArrow");
    }
}

