/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.parse.SymbolTable$;
import org.nlogo.parse.SymbolType;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.WithFilter;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public class SymbolTable
extends WithFilter<Tuple2<String, SymbolType>, Iterable> {
    private final Map<String, SymbolType> syms;
    private final int uniqueVarID;

    public static SymbolTable empty() {
        return SymbolTable$.MODULE$.empty();
    }

    public static int $lessinit$greater$default$2() {
        return SymbolTable$.MODULE$.$lessinit$greater$default$2();
    }

    public SymbolTable(Map<String, SymbolType> syms, int uniqueVarID) {
        this.syms = syms;
        this.uniqueVarID = uniqueVarID;
    }

    private Map<String, SymbolType> syms() {
        return this.syms;
    }

    private int uniqueVarID() {
        return this.uniqueVarID;
    }

    public <B> Iterable<B> flatMap(Function1<Tuple2<String, SymbolType>, IterableOnce<B>> f) {
        return (Iterable)this.syms().flatMap(f);
    }

    public <B> Iterable<B> map(Function1<Tuple2<String, SymbolType>, B> f) {
        return (Iterable)this.syms().map(f);
    }

    public WithFilter<Tuple2<String, SymbolType>, Iterable> withFilter(Function1<Tuple2<String, SymbolType>, Object> p) {
        return new SymbolTable((Map<String, SymbolType>)((Map)this.syms().filter(p)), this.uniqueVarID());
    }

    public <U> void foreach(Function1<Tuple2<String, SymbolType>, U> f) {
        this.syms().foreach(f);
    }

    public SymbolTable addSymbols(Iterable<String> symNames, SymbolType tpe) {
        return new SymbolTable((Map<String, SymbolType>)((Map)this.syms().$plus$plus((IterableOnce)((IterableOnceOps)symNames.map((Function1 & Serializable)_$1 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)_$1.toUpperCase(Locale.ENGLISH));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)tpe);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), this.uniqueVarID());
    }

    public SymbolTable addSymbol(String symName, SymbolType tpe) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)symName.toUpperCase(Locale.ENGLISH));
        return new SymbolTable((Map<String, SymbolType>)((Map)this.syms().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)tpe))), this.uniqueVarID());
    }

    public SymbolTable $plus$plus(SymbolTable other) {
        return new SymbolTable((Map<String, SymbolType>)((Map)this.syms().$plus$plus(other.syms())), this.uniqueVarID() + other.uniqueVarID());
    }

    public SymbolTable $minus(String name) {
        return new SymbolTable((Map<String, SymbolType>)((Map)this.syms().$minus((Object)name.toUpperCase(Locale.ENGLISH))), this.uniqueVarID());
    }

    public SymbolType apply(String name) {
        return (SymbolType)this.syms().apply((Object)name.toUpperCase(Locale.ENGLISH));
    }

    public boolean contains(String name) {
        return this.syms().isDefinedAt((Object)name.toUpperCase(Locale.ENGLISH));
    }

    public Option<SymbolType> get(String name) {
        return this.syms().get((Object)name.toUpperCase(Locale.ENGLISH));
    }

    public Tuple2<String, SymbolTable> withFreshSymbol(SymbolType symType, String hint) {
        Option foundSymbolAndID = Option$.MODULE$.empty();
        int currentVarID = this.uniqueVarID();
        while (foundSymbolAndID.isEmpty()) {
            String potentialName = (hint + "_" + BoxesRunTime.boxToInteger((int)currentVarID).toString()).toUpperCase(Locale.ENGLISH);
            if (this.contains(potentialName)) {
                ++currentVarID;
                continue;
            }
            foundSymbolAndID = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)potentialName, (Object)BoxesRunTime.boxToInteger((int)currentVarID)));
        }
        Tuple2 tuple2 = (Tuple2)foundSymbolAndID.get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String symbolName = (String)tuple2._1();
        int symbolID = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)symbolName, (Object)BoxesRunTime.boxToInteger((int)symbolID));
        String symbolName2 = (String)tuple22._1();
        int symbolID2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)symbolName2);
        return Tuple2$.MODULE$.apply((Object)symbolName2, (Object)new SymbolTable((Map<String, SymbolType>)((Map)this.syms().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)symType))), symbolID2 + 1));
    }

    public String withFreshSymbol$default$2() {
        return "";
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof SymbolTable) {
            SymbolTable st = (SymbolTable)((Object)object);
            Map<String, SymbolType> map = st.syms();
            Map<String, SymbolType> map2 = this.syms();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }
        return super.equals(that);
    }

    public String toString() {
        return this.syms().mkString(", ");
    }
}

