/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.CSV;
import org.nlogo.api.Color$;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPointInterface;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class CorePlotExporter {
    private final PlotInterface plot;
    private final CSV csv;

    public CorePlotExporter(PlotInterface plot, CSV csv) {
        this.plot = plot;
        this.csv = csv;
    }

    private PlotInterface plot() {
        return this.plot;
    }

    private CSV csv() {
        return this.csv;
    }

    public void export(PrintWriter writer) {
        this.exportIntro(writer);
        this.exportPens(writer);
        this.exportPoints(writer);
    }

    private void exportIntro(PrintWriter writer) {
        writer.println(this.csv().data(this.plot().name()));
        writer.println(this.csv().headerRow(new String[]{"x min", "x max", "y min", "y max", "autoplot?", "current pen", "legend open?", "number of pens"}));
        writer.println(this.csv().dataRow(Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Comparable[]{BoxesRunTime.boxToDouble((double)this.plot().state().xMin()), BoxesRunTime.boxToDouble((double)this.plot().state().xMax()), BoxesRunTime.boxToDouble((double)this.plot().state().yMin()), BoxesRunTime.boxToDouble((double)this.plot().state().yMax()), BoxesRunTime.boxToBoolean((this.plot().state().autoPlotX() && this.plot().state().autoPlotY() ? 1 : 0) != 0), (Comparable)this.plot().currentPen().map((Function1 & Serializable)_$1 -> _$1.name()).getOrElse(CorePlotExporter::exportIntro$$anonfun$2), BoxesRunTime.boxToBoolean((boolean)this.plot().legendIsOpen()), BoxesRunTime.boxToInteger((int)this.plot().pens().size())}), ClassTag$.MODULE$.apply(Comparable.class))));
        writer.println();
    }

    private void exportPens(PrintWriter writer) {
        writer.println(this.csv().headerRow(new String[]{"pen name", "pen down?", "mode", "interval", "color", "x"}));
        this.plot().pens().foreach(pen -> writer.println(this.csv().dataRow(Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Comparable[]{pen.name(), BoxesRunTime.boxToBoolean((boolean)pen.state().isDown()), BoxesRunTime.boxToInteger((int)pen.state().mode()), BoxesRunTime.boxToDouble((double)pen.state().interval()), Color$.MODULE$.argbToColor(pen.state().color()), BoxesRunTime.boxToDouble((double)pen.state().x())}), ClassTag$.MODULE$.apply(Comparable.class)))));
        writer.println();
    }

    private void exportPoints(PrintWriter writer) {
        IntRef numPens = IntRef.create((int)0);
        this.plot().pens().foreach(pen -> {
            if (numPens$1.elem > 0) {
                writer.print(",,,,");
            }
            writer.print(this.csv().data(pen.name()));
            ++numPens$1.elem;
        });
        writer.println();
        Buffer pointHeaders = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPens.elem).foreach((Function1 & Serializable)i -> CorePlotExporter.exportPoints$$anonfun$2(pointHeaders, BoxesRunTime.unboxToInt((Object)i)));
        writer.println(this.csv().headerRow((String[])pointHeaders.toArray(ClassTag$.MODULE$.apply(String.class))));
        Buffer penDataListsList = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[0]));
        IntRef maxPenDataListSize = IntRef.create((int)0);
        this.plot().pens().foreach((Function1 & Serializable)pen -> {
            Seq penDataList = (Seq)Option$.MODULE$.apply(pen.points()).getOrElse(CorePlotExporter::$anonfun$1);
            maxPenDataListSize$1.elem = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxPenDataListSize$1.elem), penDataList.size());
            return (Buffer)penDataListsList.$plus$eq((Object)penDataList);
        });
        PlotPointInterface[][] outColumnsArray = new PlotPointInterface[maxPenDataListSize.elem][numPens.elem];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPens.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Seq penDataList = (Seq)penDataListsList.apply(i);
            int penDataListSize = penDataList.size();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), penDataListSize).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                outColumnsArray$2[j][i$1] = (PlotPointInterface)penDataList.apply(j);
            });
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maxPenDataListSize.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPens$2.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
                if (outColumnsArray[row][col] != null) {
                    writer.print(this.csv().data(BoxesRunTime.boxToDouble((double)outColumnsArray[row][col].x())));
                    writer.print(",");
                    writer.print(this.csv().data(BoxesRunTime.boxToDouble((double)outColumnsArray[row][col].y())));
                    writer.print(",");
                    writer.print(this.csv().data(Color$.MODULE$.argbToColor(outColumnsArray[row][col].color())));
                    writer.print(",");
                    writer.print(this.csv().data(BoxesRunTime.boxToBoolean((boolean)outColumnsArray[row][col].isDown())));
                    if (col + 1 < numPens$3.elem) {
                        writer.print(",");
                        return;
                    }
                    return;
                }
                if (col + 1 < numPens$3.elem) {
                    writer.print(",,,,");
                    return;
                }
                writer.print(",,,");
            });
            writer.println();
        });
    }

    private static final String exportIntro$$anonfun$2() {
        return "";
    }

    private static final /* synthetic */ Buffer exportPoints$$anonfun$2(Buffer pointHeaders$1, int i) {
        return (Buffer)pointHeaders$1.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y", "color", "pen down?"}));
    }

    private static final Seq $anonfun$1() {
        return (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }
}

