/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.Serializable;
import org.nlogo.api.PlotAction;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.PlotState;
import org.nlogo.api.PlotState$;
import org.nlogo.api.StringUtils$;
import org.nlogo.core.Color$;
import org.nlogo.core.ColorConstants$;
import org.nlogo.plot.Histogram;
import org.nlogo.plot.PenListener;
import org.nlogo.plot.PlotHelper$;
import org.nlogo.plot.PlotListener;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPen$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public class Plot
implements PlotInterface,
Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private PlotState state;
    private Option<DirtyListener> dirtyListener;
    private Option<PlotListener> plotListener;
    private List<PlotPen> _pens;
    private boolean pensDirty;
    private Option<PlotPen> _currentPen;
    private Set<PenListener> penListeners;
    private boolean legendIsOpen;
    private double _defaultXMin;
    private double _defaultXMax;
    private double _defaultYMin;
    private double _defaultYMax;
    private boolean _defaultAutoPlotX;
    private boolean _defaultAutoPlotY;
    private String setupCode;
    private String updateCode;
    private Option<Exception> runtimeError;
    private int backgroundColor;
    private Option<Histogram> histogram;

    public Plot(String name) {
        this.name = name;
        this.state = PlotState$.MODULE$.apply(PlotState$.MODULE$.$lessinit$greater$default$1(), PlotState$.MODULE$.$lessinit$greater$default$2(), PlotState$.MODULE$.$lessinit$greater$default$3(), PlotState$.MODULE$.$lessinit$greater$default$4(), PlotState$.MODULE$.$lessinit$greater$default$5(), PlotState$.MODULE$.$lessinit$greater$default$6());
        this.dirtyListener = None$.MODULE$;
        this.plotListener = None$.MODULE$;
        this._pens = (List)Nil$.MODULE$;
        this.pensDirty = false;
        this._currentPen = None$.MODULE$;
        this.penListeners = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PenListener[0]));
        this.legendIsOpen = false;
        this._defaultXMin = 0.0;
        this._defaultXMax = 10.0;
        this._defaultYMin = 0.0;
        this._defaultYMax = 10.0;
        this._defaultAutoPlotX = true;
        this._defaultAutoPlotY = true;
        this.setupCode = "";
        this.updateCode = "";
        this.runtimeError = None$.MODULE$;
        this.backgroundColor = Color$.MODULE$.getARGBbyPremodulatedColorNumber(ColorConstants$.MODULE$.White());
        this.clear();
        this.histogram = None$.MODULE$;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public PlotState state() {
        return this.state;
    }

    @Override
    public void state_$eq(PlotState x$1) {
        this.state = x$1;
    }

    public Option<DirtyListener> dirtyListener() {
        return this.dirtyListener;
    }

    public void dirtyListener_$eq(Option<DirtyListener> x$1) {
        this.dirtyListener = x$1;
    }

    public Option<PlotListener> plotListener() {
        return this.plotListener;
    }

    public void plotListener_$eq(Option<PlotListener> x$1) {
        this.plotListener = x$1;
    }

    public List<PlotPen> _pens() {
        return this._pens;
    }

    public void _pens_$eq(List<PlotPen> x$1) {
        this._pens = x$1;
    }

    public boolean pensDirty() {
        return this.pensDirty;
    }

    public void pensDirty_$eq(boolean x$1) {
        this.pensDirty = x$1;
    }

    @Override
    public boolean legendIsOpen() {
        return this.legendIsOpen;
    }

    @Override
    public void legendIsOpen_$eq(boolean x$1) {
        this.legendIsOpen = x$1;
    }

    public String setupCode() {
        return this.setupCode;
    }

    public void setupCode_$eq(String x$1) {
        this.setupCode = x$1;
    }

    public String updateCode() {
        return this.updateCode;
    }

    public void updateCode_$eq(String x$1) {
        this.updateCode = x$1;
    }

    public Option<Exception> runtimeError() {
        return this.runtimeError;
    }

    public void runtimeError_$eq(Option<Exception> x$1) {
        this.runtimeError = x$1;
    }

    public int backgroundColor() {
        return this.backgroundColor;
    }

    public void backgroundColor_$eq(int x$1) {
        this.backgroundColor = x$1;
    }

    public String toString() {
        return "Plot(" + this.name() + ")";
    }

    public void setPlotListener(PlotListener plotListener) {
        if (plotListener == null) {
            throw package$.MODULE$.error("null plotListener");
        }
        this.plotListener_$eq((Option<PlotListener>)Some$.MODULE$.apply((Object)plotListener));
    }

    public void removePlotListener() {
        this.plotListener_$eq((Option<PlotListener>)None$.MODULE$);
    }

    public void addPenListener(PenListener listener) {
        this.penListeners = (Set)this.penListeners.$plus((Object)listener);
    }

    public void name(String newName) {
        this.name_$eq(newName);
    }

    public void makeDirty() {
        this.dirtyListener().foreach(_$1 -> _$1.makeDirty());
    }

    public List<PlotPen> pens() {
        return this._pens();
    }

    public void pens_$eq(List<PlotPen> pens) {
        this._pens_$eq(pens);
        this.currentPen_$eq((Option<PlotPen>)this._pens().headOption());
    }

    public void addPen(PlotPen p) {
        this.pens_$eq((List<PlotPen>)((List)this._pens().$colon$plus((Object)p)));
        this.pensDirty_$eq(true);
        this.penListeners.foreach(_$2 -> _$2.penAdded());
    }

    public Option<PlotPen> currentPen() {
        return this._currentPen.orElse(this::currentPen$$anonfun$1);
    }

    public void currentPen_$eq(PlotPen p) {
        this.currentPen_$eq((Option<PlotPen>)(p == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)p)));
    }

    public void currentPen_$eq(Option<PlotPen> p) {
        this._currentPen = p;
        this.plotListener().foreach(_$3 -> _$3.currentPen(((PlotPen)p.get()).name()));
    }

    @Override
    public String currentPenByName() {
        return (String)this.currentPen().map((Function1 & Serializable)_$4 -> _$4.name()).getOrElse(Plot::currentPenByName$$anonfun$2);
    }

    @Override
    public void currentPenByName_$eq(String penName) {
        this.currentPen_$eq(this.getPen(penName));
    }

    public Option<PlotPen> getPen(String penName) {
        return this._pens().find((Function1 & Serializable)_$5 -> {
            String string = _$5.name().toLowerCase();
            String string2 = penName.toLowerCase();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public double defaultXMin() {
        return this._defaultXMin;
    }

    public void defaultXMin_$eq(double defaultXMin) {
        this._defaultXMin = defaultXMin;
        this.plotListener().foreach(_$6 -> _$6.defaultXMin(defaultXMin));
    }

    public double defaultXMax() {
        return this._defaultXMax;
    }

    public void defaultXMax_$eq(double defaultXMax) {
        this._defaultXMax = defaultXMax;
        this.plotListener().foreach(_$7 -> _$7.defaultXMax(defaultXMax));
    }

    public double defaultYMin() {
        return this._defaultYMin;
    }

    public void defaultYMin_$eq(double defaultYMin) {
        this._defaultYMin = defaultYMin;
        this.plotListener().foreach(_$8 -> _$8.defaultYMin(defaultYMin));
    }

    public double defaultYMax() {
        return this._defaultYMax;
    }

    public void defaultYMax_$eq(double defaultYMax) {
        this._defaultYMax = defaultYMax;
        this.plotListener().foreach(_$9 -> _$9.defaultYMax(defaultYMax));
    }

    public boolean defaultAutoPlotX() {
        return this._defaultAutoPlotX;
    }

    public void defaultAutoPlotX_$eq(boolean defaultAutoPlotX) {
        this._defaultAutoPlotX = defaultAutoPlotX;
        this.plotListener().foreach(_$10 -> _$10.defaultAutoPlotX(defaultAutoPlotX));
    }

    public boolean defaultAutoPlotY() {
        return this._defaultAutoPlotY;
    }

    public void defaultAutoPlotY_$eq(boolean defaultAutoPlotY) {
        this._defaultAutoPlotY = defaultAutoPlotY;
        this.plotListener().foreach(_$11 -> _$11.defaultAutoPlotY(defaultAutoPlotY));
    }

    public boolean autoPlotX() {
        return this.state().autoPlotX();
    }

    public boolean autoPlotY() {
        return this.state().autoPlotY();
    }

    public double xMin() {
        return this.state().xMin();
    }

    public double xMax() {
        return this.state().xMax();
    }

    public double yMin() {
        return this.state().yMin();
    }

    public double yMax() {
        return this.state().yMax();
    }

    public String saveString() {
        return "\"" + StringUtils$.MODULE$.escapeString(this.setupCode().trim()) + "\" \"" + StringUtils$.MODULE$.escapeString(this.updateCode().trim()) + "\"";
    }

    @Override
    public void plot(double y) {
        this.currentPen().foreach(p -> {
            this.plot((PlotPen)p, y);
            this.makeDirty();
        });
    }

    @Override
    public void plot(double x, double y) {
        this.currentPen().foreach(p -> {
            this.plot((PlotPen)p, x, y);
            this.makeDirty();
        });
    }

    public void plot(PlotPen pen, double y) {
        pen.plot(y);
        if (pen.state().isDown()) {
            this.perhapsGrowRanges(pen, pen.state().x(), y);
            return;
        }
    }

    public void plot(PlotPen pen, double x, double y) {
        pen.plot(x, y);
        if (pen.state().isDown()) {
            this.perhapsGrowRanges(pen, x, y);
            return;
        }
    }

    public void clear() {
        this.pens_$eq((List<PlotPen>)this._pens().filterNot((Function1 & Serializable)_$12 -> _$12.temporary()));
        this.currentPen_$eq((Option<PlotPen>)this._pens().headOption());
        this._pens().foreach(_$13 -> _$13.hardReset());
        this.state_$eq(PlotState$.MODULE$.apply(this.defaultAutoPlotX(), this.defaultAutoPlotY(), this.defaultXMin(), this.defaultXMax(), this.defaultYMin(), this.defaultYMax()));
        this.runtimeError_$eq((Option<Exception>)None$.MODULE$);
        this.backgroundColor_$eq(Color$.MODULE$.getARGBbyPremodulatedColorNumber(ColorConstants$.MODULE$.White()));
        this.makeDirty();
        this.plotListener().foreach(_$14 -> _$14.clear());
        this.pensDirty_$eq(true);
    }

    public PlotPen createPlotPen(String name, boolean temporary) {
        return this.createPlotPen(name, temporary, "", "");
    }

    public PlotPen createPlotPen(String name, boolean temporary, String setupCode, String updateCode) {
        return new PlotPen(this, name, temporary, setupCode, updateCode, PlotPen$.MODULE$.$lessinit$greater$default$6(), PlotPen$.MODULE$.$lessinit$greater$default$7(), PlotPen$.MODULE$.$lessinit$greater$default$8(), PlotPen$.MODULE$.$lessinit$greater$default$9(), PlotPen$.MODULE$.$lessinit$greater$default$10(), PlotPen$.MODULE$.$lessinit$greater$default$11(), PlotPen$.MODULE$.$lessinit$greater$default$12(), PlotPen$.MODULE$.$lessinit$greater$default$13(), PlotPen$.MODULE$.$lessinit$greater$default$14(), PlotPen$.MODULE$.$lessinit$greater$default$15(), PlotPen$.MODULE$.$lessinit$greater$default$16());
    }

    @Override
    public Seq<PlotAction> histogramActions(PlotPenInterface pen, Seq<Object> values) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void perhapsGrowRanges(PlotPen pen, double x, double y) {
        if (this.autoPlotX()) {
            if (pen.mode() == PlotPen$.MODULE$.BAR_MODE()) {
                this.growRangeX(x + pen.interval());
            }
            this.growRangeX(x);
        }
        if (this.autoPlotY()) {
            this.growRangeY(y);
            return;
        }
    }

    private void growRangeX(double x) {
        if (x > this.xMax()) {
            PlotState plotState = this.state();
            double d = PlotHelper$.MODULE$.expandRange(this.xMin(), this.xMax(), x);
            boolean bl = plotState.copy$default$1();
            boolean bl2 = plotState.copy$default$2();
            double d2 = plotState.copy$default$3();
            double d3 = plotState.copy$default$5();
            double d4 = plotState.copy$default$6();
            this.state_$eq(plotState.copy(bl, bl2, d2, d, d3, d4));
        }
        if (x < this.xMin()) {
            PlotState plotState = this.state();
            double d = PlotHelper$.MODULE$.expandRange(this.xMin(), this.xMax(), x);
            boolean bl = plotState.copy$default$1();
            boolean bl3 = plotState.copy$default$2();
            double d5 = plotState.copy$default$4();
            double d6 = plotState.copy$default$5();
            double d7 = plotState.copy$default$6();
            this.state_$eq(plotState.copy(bl, bl3, d, d5, d6, d7));
            return;
        }
    }

    private void growRangeY(double y) {
        if (y > this.yMax()) {
            PlotState plotState = this.state();
            double d = PlotHelper$.MODULE$.expandRange(this.yMin(), this.yMax(), y);
            boolean bl = plotState.copy$default$1();
            boolean bl2 = plotState.copy$default$2();
            double d2 = plotState.copy$default$3();
            double d3 = plotState.copy$default$4();
            double d4 = plotState.copy$default$5();
            this.state_$eq(plotState.copy(bl, bl2, d2, d3, d4, d));
        }
        if (y < this.yMin()) {
            PlotState plotState = this.state();
            double d = PlotHelper$.MODULE$.expandRange(this.yMin(), this.yMax(), y);
            boolean bl = plotState.copy$default$1();
            boolean bl3 = plotState.copy$default$2();
            double d5 = plotState.copy$default$3();
            double d6 = plotState.copy$default$4();
            double d7 = plotState.copy$default$6();
            this.state_$eq(plotState.copy(bl, bl3, d5, d6, d, d7));
            return;
        }
    }

    public void setHistogramNumBars(PlotPen pen, int numBars) {
        pen.interval_$eq((this.xMax() - this.xMin()) / (double)numBars);
        this.plotListener().foreach(_$15 -> _$15.setHistogramNumBars(numBars));
    }

    public Option<Histogram> histogram() {
        return this.histogram;
    }

    public void histogram_$eq(Option<Histogram> x$1) {
        this.histogram = x$1;
    }

    public void beginHistogram(PlotPen pen) {
        this.histogram_$eq((Option<Histogram>)Some$.MODULE$.apply((Object)new Histogram(this.xMin(), this.xMax(), pen.interval())));
    }

    public void beginHistogram(PlotPen pen, int[] bars) {
        this.histogram_$eq((Option<Histogram>)Some$.MODULE$.apply((Object)new Histogram(this.xMin(), pen.interval(), bars)));
    }

    public void nextHistogramValue(double value) {
        ((Histogram)this.histogram().get()).nextValue(value);
    }

    public void endHistogram(PlotPen pen) {
        pen.softReset();
        if (this.autoPlotY()) {
            this.growRangeY(Int$.MODULE$.int2double(((Histogram)this.histogram().get()).ceiling()));
        }
        Object object = Predef$.MODULE$.intArrayOps(((Histogram)this.histogram().get()).bars());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int bar = tuple2._1$mcI$sp();
                int barNumber = tuple2._2$mcI$sp();
                if (bar > 0) {
                    pen.plot(this.xMin() + (double)barNumber * pen.interval(), Int$.MODULE$.int2double(bar));
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.histogram_$eq((Option<Histogram>)None$.MODULE$);
    }

    private final Option currentPen$$anonfun$1() {
        return this._pens().headOption();
    }

    private static final String currentPenByName$$anonfun$2() {
        return null;
    }

    public static interface DirtyListener {
        public void makeDirty();
    }
}

