/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.io.Serializable;
import org.nlogo.api.CommandLogoThunk;
import org.nlogo.api.HaltSignal;
import org.nlogo.api.LogoThunkFactory;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.PlotAction;
import org.nlogo.core.CompilerException;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotListener;
import org.nlogo.plot.PlotManager$CodeType$;
import org.nlogo.plot.PlotManager$Results$;
import org.nlogo.plot.PlotManager$Setup$;
import org.nlogo.plot.PlotManager$Update$;
import org.nlogo.plot.PlotManagerInterface;
import org.nlogo.plot.PlotPen;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.WeakHashMap;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public class PlotManager
implements PlotManagerInterface {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PlotManager.class.getDeclaredField("Setup$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PlotManager.class.getDeclaredField("Update$lzy1"));
    private final LogoThunkFactory factory;
    private final MersenneTwisterFast random;
    private final Buffer<Plot> _plots;
    private PlotListener listener;
    private Option<Plot> currentPlot;
    public final PlotManager$Results$ Results$lzy1;
    private final WeakHashMap<Plot, Results> plotThunks;
    private final WeakHashMap<PlotPen, Results> penThunks;
    public final PlotManager$CodeType$ CodeType$lzy1;
    private volatile Object Update$lzy1;
    private volatile Object Setup$lzy1;

    public PlotManager(LogoThunkFactory factory, MersenneTwisterFast random) {
        this.factory = factory;
        this.random = random;
        this.Results$lzy1 = new PlotManager$Results$(this);
        this.CodeType$lzy1 = new PlotManager$CodeType$();
        this._plots = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Plot[0]));
        this.listener = null;
        this.currentPlot = None$.MODULE$;
        this.plotThunks = new WeakHashMap();
        this.penThunks = new WeakHashMap();
    }

    public List<Plot> plots() {
        return this._plots.toList();
    }

    public PlotListener listener() {
        return this.listener;
    }

    public void listener_$eq(PlotListener x$1) {
        this.listener = x$1;
    }

    public Option<Plot> currentPlot() {
        return this.currentPlot;
    }

    public void currentPlot_$eq(Option<Plot> x$1) {
        this.currentPlot = x$1;
    }

    @Override
    public void addPlot(Plot plot) {
        this._plots.$plus$eq((Object)plot);
        this.compilePlot(plot);
        this.currentPlot_$eq((Option<Plot>)Some$.MODULE$.apply((Object)plot));
    }

    @Override
    public Plot newPlot(String name) {
        Plot plot = new Plot(name);
        this.compilePlot(plot);
        this._plots.$plus$eq((Object)plot);
        this.currentPlot_$eq((Option<Plot>)Some$.MODULE$.apply((Object)plot));
        return plot;
    }

    @Override
    public Seq<String> getPlotNames() {
        return ((IterableOnceOps)this._plots.map((Function1 & Serializable)_$1 -> _$1.name())).toSeq();
    }

    @Override
    public String nextName() {
        return (String)package$.MODULE$.LazyList().from(1).map((Function1 & Serializable)_$2 -> PlotManager.nextName$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$2))).find((Function1 & Serializable)_$3 -> {
            Option<Plot> option = this.maybeGetPlot((String)_$3);
            None$ none$ = None$.MODULE$;
            return !(option != null ? !option.equals((Object)none$) : none$ != null);
        }).get();
    }

    @Override
    public boolean hasPlot(String name) {
        return this._plots.exists((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<Plot> maybeGetPlot(String name) {
        return this._plots.find((Function1 & Serializable)_$5 -> _$5.name().equalsIgnoreCase(name));
    }

    @Override
    public void publish(PlotAction action) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void setCurrentPlot(String name) {
        this.currentPlot_$eq(this.maybeGetPlot(name));
    }

    @Override
    public void forgetPlot(Plot goner) {
        Option<Plot> option = this.currentPlot();
        Some some = Some$.MODULE$.apply((Object)goner);
        if (!(option != null ? !option.equals((Object)some) : some != null)) {
            this.currentPlot_$eq((Option<Plot>)None$.MODULE$);
        }
        this._plots.$minus$eq((Object)goner);
    }

    public void forgetAll() {
        this._plots.clear();
        this.plotThunks.clear();
        this.penThunks.clear();
        this.currentPlot_$eq((Option<Plot>)None$.MODULE$);
    }

    public void clearAll() {
        this._plots.foreach(_$6 -> _$6.clear());
        if (this.listener() != null) {
            this.listener().clearAll();
            return;
        }
    }

    public final PlotManager$Results$ Results() {
        return this.Results$lzy1;
    }

    public List<CompilerException> compileAllPlots() {
        return this.plots().flatMap((Function1 & Serializable)plot -> this.compilePlot((Plot)plot));
    }

    @Override
    public List<CompilerException> compilePlot(Plot plot) {
        Results plotResults = this.Results().apply((Either<CompilerException, CommandLogoThunk>)this.compile$1(plot.setupCode(), PlotManager.procName$1(plot, true, PlotManager.procName$default$2$1())), (Either<CompilerException, CommandLogoThunk>)this.compile$1(plot.updateCode(), PlotManager.procName$1(plot, false, PlotManager.procName$default$2$1())));
        this.plotThunks.update((Object)plot, (Object)plotResults);
        List plotPensResults = (List)plot.pens().withFilter((Function1 & Serializable)pen -> !pen.temporary()).map((Function1 & Serializable)pen -> Tuple2$.MODULE$.apply(pen, (Object)this.Results().apply((Either<CompilerException, CommandLogoThunk>)this.compile$1(pen.setupCode(), PlotManager.procName$1(plot, true, (Option)Some$.MODULE$.apply(pen))), (Either<CompilerException, CommandLogoThunk>)this.compile$1(pen.updateCode(), PlotManager.procName$1(plot, false, (Option)Some$.MODULE$.apply(pen))))));
        this.penThunks.$plus$plus$eq((IterableOnce)plotPensResults);
        List results = plotPensResults.map((Function1 & Serializable)_$8 -> (Results)_$8._2()).toList().$colon$colon((Object)plotResults);
        List errors = results.flatMap((Function1 & Serializable)r -> (IterableOnce)new .colon.colon(r.setup(), (List)new .colon.colon(r.update(), (List)Nil$.MODULE$))).flatMap((Function1 & Serializable)_$9 -> _$9.left().toOption());
        return errors;
    }

    public void setupPlots() {
        this.runCode(this.Setup());
    }

    public void updatePlots() {
        this.runCode(this.Update());
    }

    private void runCode(CodeType codeType) {
        Option<Plot> oldCurrentPlot = this.currentPlot();
        this._plots.foreach(plot -> {
            this.currentPlot_$eq((Option<Plot>)Some$.MODULE$.apply(plot));
            boolean stopped = BoxesRunTime.unboxToBoolean((Object)this.plotThunks.get(plot).map((Function1 & Serializable)_$10 -> {
                Try<Object> try_ = codeType.call((Results)_$10);
                if (try_ instanceof Success) {
                    boolean stop = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
                    return stop;
                }
                if (try_ instanceof Failure) {
                    Throwable throwable = ((Failure)try_).exception();
                    if (throwable instanceof HaltSignal) {
                        Throwable e = (Throwable)((Object)((HaltSignal)((Object)throwable)));
                        throw e;
                    }
                    if (throwable instanceof Exception) {
                        Exception e = (Exception)throwable;
                        plot.runtimeError_$eq((Option<Exception>)Some$.MODULE$.apply((Object)e));
                        return false;
                    }
                    if (throwable != null) {
                        Throwable t = throwable;
                        throw t;
                    }
                }
                throw new MatchError(try_);
            }).getOrElse(PlotManager::$anonfun$7));
            if (!stopped) {
                Option<PlotPen> oldCurrentPen = plot.currentPen();
                plot.pens().withFilter((Function1 & Serializable)pp -> !pp.temporary()).foreach(pp -> this.penThunks.get(pp).foreach(results -> {
                    plot.currentPen_$eq((PlotPen)pp);
                    Try<Object> try_ = codeType.call((Results)results);
                    if (try_ instanceof Success) {
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable throwable = ((Failure)try_).exception();
                        if (throwable instanceof HaltSignal) {
                            Throwable e = (Throwable)((Object)((HaltSignal)((Object)throwable)));
                            throw e;
                        }
                        if (throwable instanceof Exception) {
                            Exception e = (Exception)throwable;
                            pp.runtimeError_$eq((Option<Exception>)Some$.MODULE$.apply((Object)e));
                            return;
                        }
                        if (throwable != null) {
                            Throwable t = throwable;
                            throw t;
                        }
                    }
                    throw new MatchError(try_);
                }));
                plot.currentPen_$eq(oldCurrentPen);
                return;
            }
        });
        this.currentPlot_$eq(oldCurrentPlot);
    }

    public final PlotManager$CodeType$ CodeType() {
        return this.CodeType$lzy1;
    }

    public final PlotManager$Update$ Update() {
        Object object = this.Update$lzy1;
        if (object instanceof PlotManager$Update$) {
            return (PlotManager$Update$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PlotManager$Update$)this.Update$lzyINIT1();
    }

    private Object Update$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Update$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    PlotManager$Update$ plotManager$Update$ = null;
                    try {
                        plotManager$Update$ = new PlotManager$Update$(this);
                        serializable = plotManager$Update$ == null ? LazyVals.NullValue$.MODULE$ : plotManager$Update$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Update$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return plotManager$Update$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final PlotManager$Setup$ Setup() {
        Object object = this.Setup$lzy1;
        if (object instanceof PlotManager$Setup$) {
            return (PlotManager$Setup$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PlotManager$Setup$)this.Setup$lzyINIT1();
    }

    private Object Setup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Setup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    PlotManager$Setup$ plotManager$Setup$ = null;
                    try {
                        plotManager$Setup$ = new PlotManager$Setup$(this);
                        serializable = plotManager$Setup$ == null ? LazyVals.NullValue$.MODULE$ : plotManager$Setup$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Setup$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return plotManager$Setup$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean hasErrors(Plot plot) {
        return this.getPlotSetupError(plot).isDefined() || this.getPlotUpdateError(plot).isDefined() || plot.runtimeError().isDefined() || plot.pens().filterNot((Function1 & Serializable)_$12 -> _$12.temporary()).exists((Function1 & Serializable)pen -> this.hasErrors((PlotPen)pen));
    }

    @Override
    public Option<CompilerException> getPlotSetupError(Plot plot) {
        return this.plotThunks.get((Object)plot).flatMap((Function1 & Serializable)_$13 -> _$13.setup().left().toOption());
    }

    @Override
    public Option<CompilerException> getPlotUpdateError(Plot plot) {
        return this.plotThunks.get((Object)plot).flatMap((Function1 & Serializable)_$14 -> _$14.update().left().toOption());
    }

    public boolean hasErrors(PlotPen pen) {
        return pen.runtimeError().isDefined() || this.getPenSetupError(pen).isDefined() || this.getPenUpdateError(pen).isDefined();
    }

    @Override
    public Option<CompilerException> getPenSetupError(PlotPen pen) {
        return this.penThunks.get((Object)pen).flatMap((Function1 & Serializable)_$15 -> _$15.setup().left().toOption());
    }

    @Override
    public Option<CompilerException> getPenUpdateError(PlotPen pen) {
        return this.penThunks.get((Object)pen).flatMap((Function1 & Serializable)_$16 -> _$16.update().left().toOption());
    }

    private static final /* synthetic */ String nextName$$anonfun$1(int _$2) {
        return "plot " + _$2;
    }

    private final Either compile$1(String code, String procName) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.factory.makeCommandThunk(code, procName, this.random));
        }
        catch (CompilerException ce) {
            left = package$.MODULE$.Left().apply((Object)ce);
        }
        return left;
    }

    private static final String procName$1$$anonfun$2() {
        return "";
    }

    private static final String procName$1(Plot plot$1, boolean setup, Option pen) {
        return "plot '" + plot$1.name() + "' " + pen.map((Function1 & Serializable)_$7 -> "pen '" + _$7.name() + "' ").getOrElse(PlotManager::procName$1$$anonfun$2) + (setup ? "setup code" : "update code");
    }

    private static final Option procName$default$2$1() {
        return None$.MODULE$;
    }

    private static final boolean $anonfun$7() {
        return false;
    }

    public static final /* synthetic */ Try org$nlogo$plot$PlotManager$CodeType$$_$call$$anonfun$1(CompilerException _$11) {
        return Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ Try org$nlogo$plot$PlotManager$CodeType$$_$call$$anonfun$2(CommandLogoThunk thunk) {
        return thunk.call();
    }

    public abstract class CodeType
    implements Product,
    Serializable {
        private final String name;
        private final /* synthetic */ PlotManager $outer;

        public CodeType(PlotManager $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CodeType)) return false;
            if (((CodeType)object).org$nlogo$plot$PlotManager$CodeType$$$outer() != this.$outer) return false;
            CodeType codeType = (CodeType)object;
            String string = this.name();
            String string2 = codeType.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!codeType.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CodeType;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CodeType";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public abstract Either<CompilerException, CommandLogoThunk> selector(Results var1);

        public Try<Object> call(Results r) {
            return (Try)this.selector(r).fold(PlotManager::org$nlogo$plot$PlotManager$CodeType$$_$call$$anonfun$1, PlotManager::org$nlogo$plot$PlotManager$CodeType$$_$call$$anonfun$2);
        }

        public String _1() {
            return this.name();
        }

        public final /* synthetic */ PlotManager org$nlogo$plot$PlotManager$CodeType$$$outer() {
            return this.$outer;
        }
    }

    public class Results
    implements Product,
    Serializable {
        private final Either<CompilerException, CommandLogoThunk> setup;
        private final Either<CompilerException, CommandLogoThunk> update;
        private final /* synthetic */ PlotManager $outer;

        public Results(PlotManager $outer, Either<CompilerException, CommandLogoThunk> setup, Either<CompilerException, CommandLogoThunk> update) {
            this.setup = setup;
            this.update = update;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Results)) return false;
            if (((Results)object).org$nlogo$plot$PlotManager$Results$$$outer() != this.$outer) return false;
            Results results = (Results)object;
            Either<CompilerException, CommandLogoThunk> either = this.setup();
            Either<CompilerException, CommandLogoThunk> either2 = results.setup();
            if (either == null) {
                if (either2 != null) {
                    return false;
                }
            } else if (!either.equals(either2)) return false;
            Either<CompilerException, CommandLogoThunk> either3 = this.update();
            Either<CompilerException, CommandLogoThunk> either4 = results.update();
            if (either3 == null) {
                if (either4 != null) {
                    return false;
                }
            } else if (!either3.equals(either4)) return false;
            if (!results.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Results;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Results";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "setup";
            }
            if (1 == n2) {
                return "update";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Either<CompilerException, CommandLogoThunk> setup() {
            return this.setup;
        }

        public Either<CompilerException, CommandLogoThunk> update() {
            return this.update;
        }

        public Results copy(Either<CompilerException, CommandLogoThunk> setup, Either<CompilerException, CommandLogoThunk> update) {
            return new Results(this.$outer, setup, update);
        }

        public Either<CompilerException, CommandLogoThunk> copy$default$1() {
            return this.setup();
        }

        public Either<CompilerException, CommandLogoThunk> copy$default$2() {
            return this.update();
        }

        public Either<CompilerException, CommandLogoThunk> _1() {
            return this.setup();
        }

        public Either<CompilerException, CommandLogoThunk> _2() {
            return this.update();
        }

        public final /* synthetic */ PlotManager org$nlogo$plot$PlotManager$Results$$$outer() {
            return this.$outer;
        }
    }
}

