/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.nlogo.api.AddableComponent;
import org.nlogo.api.ComponentSerialization;
import org.nlogo.api.ConfigurableModelLoader;
import org.nlogo.api.FormatterPair;
import org.nlogo.api.ModelFormat;
import org.nlogo.core.Model;
import org.nlogo.core.OptionalSection;
import org.nlogo.sdm.gui.AggregateDrawing;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.util.Try;
import scala.util.Try$;

public abstract class AbstractNLogoGuiSDMFormat<A extends ModelFormat<String[], A>>
implements AddableComponent,
ComponentSerialization<String[], A> {
    private final ClassTag<A> ct;
    private final String guiComponentName;

    public AbstractNLogoGuiSDMFormat(ClassTag<A> ct) {
        this.ct = ct;
        this.guiComponentName = "org.nlogo.modelsection.systemdynamics.gui";
    }

    @Override
    public String componentName() {
        return "org.nlogo.modelsection.systemdynamics";
    }

    public String guiComponentName() {
        return this.guiComponentName;
    }

    @Override
    public Function1<Model, Model> addDefault() {
        return (Function1 & Serializable)x -> (Model)Predef$.MODULE$.identity(x);
    }

    @Override
    public String[] serialize(Model m) {
        return (String[])m.optionalSectionValue(this.guiComponentName(), ClassTag$.MODULE$.apply(OptionalSection.class)).map((Function1 & Serializable)drawing -> this.drawingStrings((AggregateDrawing)drawing)).getOrElse(AbstractNLogoGuiSDMFormat::serialize$$anonfun$2);
    }

    @Override
    public Option<String> validationErrors(Model m) {
        return None$.MODULE$;
    }

    @Override
    public Function1<Model, Try<Model>> deserialize(String[] s) {
        return (Function1 & Serializable)m -> Try$.MODULE$.apply(() -> this.deserialize$$anonfun$1$$anonfun$1(s, m));
    }

    private String[] drawingStrings(AggregateDrawing drawing) {
        drawing.synchronizeModel();
        if (drawing.getModel().elements().isEmpty()) {
            return new String[0];
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        StorableOutput output = new StorableOutput((OutputStream)s);
        output.writeDouble(drawing.getModel().getDt());
        output.writeStorable((Storable)drawing);
        output.close();
        s.flush();
        return (String[])StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(s.toString())).map((Function1 & Serializable)_$1 -> _$1.replaceAll("\\s*$", "")).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private Option<AggregateDrawing> stringsToDrawing(String[] s) {
        String text = Predef$.MODULE$.wrapRefArray((Object[])s).mkString("\n");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(text.trim()))) {
            String text2 = this.mungeClassNames(text);
            BufferedReader br = new BufferedReader(new StringReader(text2));
            double dt = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(br.readLine()));
            String str = br.readLine();
            text2 = text2.substring(text2.indexOf(str));
            ByteArrayInputStream s2 = new ByteArrayInputStream(text2.getBytes());
            StorableInput input = new StorableInput((InputStream)s2);
            AggregateDrawing drawing = (AggregateDrawing)input.readStorable();
            drawing.synchronizeModel();
            drawing.getModel().setDt(dt);
            return Some$.MODULE$.apply((Object)drawing);
        }
        return None$.MODULE$;
    }

    private String mungeClassNames(String input) {
        return input.replaceAll(" *org.nlogo.sdm.Stock ", "org.nlogo.sdm.gui.WrappedStock ").replaceAll(" *org.nlogo.sdm.Rate ", "org.nlogo.sdm.gui.WrappedRate ").replaceAll(" *org.nlogo.sdm.Reservoir ", "org.nlogo.sdm.gui.WrappedReservoir").replaceAll(" *org.nlogo.sdm.Converter ", "org.nlogo.sdm.gui.WrappedConverter").replaceAll("org.nlogo.aggregate.gui", "org.nlogo.sdm.gui");
    }

    @Override
    public ConfigurableModelLoader addToLoader(ConfigurableModelLoader loader) {
        return loader.addSerializer(this, ClassTag$.MODULE$.apply(String.class).wrap(), this.ct, ClassTag$.MODULE$.apply(FormatterPair.class));
    }

    private static final String[] serialize$$anonfun$2() {
        return new String[0];
    }

    private static final Model deserialize$$anonfun$1$$anonfun$1$$anonfun$2(Model m$3) {
        return m$3;
    }

    private final Model deserialize$$anonfun$1$$anonfun$1(String[] s$2, Model m$1) {
        return (Model)this.stringsToDrawing(s$2).map((Function1 & Serializable)sdm -> m$1.withOptionalSection(this.guiComponentName(), Some$.MODULE$.apply(sdm), sdm).withOptionalSection(this.componentName(), Some$.MODULE$.apply((Object)sdm.getModel()), sdm.getModel())).getOrElse(() -> AbstractNLogoGuiSDMFormat.deserialize$$anonfun$1$$anonfun$1$$anonfun$2(m$1));
    }
}

