/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Options;
import org.nlogo.editor.Colorizer;
import org.nlogo.sdm.Converter;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.gui.ConverterEditPanel;
import org.nlogo.sdm.gui.ModelElementFigure;
import org.nlogo.sdm.gui.Utils;
import org.nlogo.sdm.gui.WrappedConverter;
import org.nlogo.sdm.gui.Wrapper;
import org.nlogo.theme.InterfaceColors;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.List;

public class ConverterFigure
extends DiamondFigure
implements ModelElementFigure,
Storable,
Editable {
    private Converter converter;
    private transient CompilerServices compiler;
    private transient Colorizer colorizer;
    private transient ExtensionManager extensionManager;
    private boolean dirty = false;

    public ConverterFigure() {
        this.setAttribute(FigureAttributeConstant.FILL_COLOR, InterfaceColors.converterBackground());
        this.converter = new Converter();
        this.converter.setSelected("Select");
    }

    public void setConstructorDeps(CompilerServices compiler, Colorizer colorizer, ExtensionManager extensionManager) {
        this.compiler = compiler;
        this.colorizer = colorizer;
        this.extensionManager = extensionManager;
    }

    @Override
    public ModelElement getModelElement() {
        return this.converter;
    }

    @Override
    public boolean anyErrors() {
        return false;
    }

    @Override
    public void error(Object o, Exception e) {
    }

    @Override
    public Option<Exception> error(Object o) {
        return Option.apply(null);
    }

    @Override
    public int sourceOffset() {
        return 0;
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.draw(g);
        if (this.converter != null) {
            String name;
            Color oldColor = g.getColor();
            if (!this.converter.isComplete()) {
                g.setColor(Color.RED);
            }
            if ((name = this.converter.getName()).length() == 0) {
                name = "?";
            }
            Utils.drawStringInBox(g, name, this.displayBox().x + 14, this.displayBox().y + 1 + this.displayBox().height / 2);
            g.setColor(oldColor);
        }
    }

    protected Rectangle invalidateRectangle(Rectangle r) {
        Rectangle box = super.invalidateRectangle(r);
        box.grow(this.converter.getName().length() * 10, this.converter.getName().length() * 10);
        return box;
    }

    public HandleEnumeration handles() {
        ArrayList<NullHandle> handles = new ArrayList<NullHandle>();
        handles.add(new NullHandle((Figure)this, RelativeLocator.southEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northWest()));
        return new HandleEnumerator(handles);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(Wrapper.wrap(this.converter));
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.converter = ((WrappedConverter)dr.readStorable()).converter;
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public EditPanel editPanel() {
        return new ConverterEditPanel(this, this.compiler, this.colorizer, this.extensionManager);
    }

    @Override
    public String classDisplayName() {
        return "Variable";
    }

    @Override
    public boolean editFinished() {
        return true;
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    public void nameWrapper(String name) {
        this.dirty = this.dirty || !this.converter.getName().equals(name);
        this.converter.setName(name);
    }

    public String nameWrapper() {
        return this.converter.getName();
    }

    public void expressionWrapper(String expression) {
        this.dirty = this.dirty || !this.converter.getExpression().equals(expression);
        this.converter.setExpression(expression);
    }

    public String expressionWrapper() {
        return this.converter.getExpression();
    }

    public void inputs(List<String> ls) {
        this.converter.setInputs(ls);
    }

    public void inputs(Options<String> newInputs) {
        String oldChoice = newInputs.chosenName();
        String newChoice = this.converter.getSelected();
        this.converter.setSelected(oldChoice);
        if (!"Select".equals(oldChoice) && !oldChoice.equals(newChoice)) {
            String oldExpression = this.converter.getExpression();
            String newExpression = oldExpression.trim() + " " + oldChoice + " ";
            this.converter.setExpression(newExpression);
        }
    }

    public Options<String> inputs() {
        Options<String> inputs = new Options<String>();
        Iterator ins = this.converter.getInputs().iterator();
        inputs.addOption("Select", "null");
        while (ins.hasNext()) {
            inputs.addOption((String)ins.next(), "unused");
        }
        String name = this.converter.getSelected();
        if (name == "") {
            name = (String)inputs.names().head();
            inputs.selectByName(name);
            this.converter.setSelected(name);
        } else {
            inputs.selectByName(name);
        }
        return inputs;
    }
}

