/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.core.Shape$;
import org.nlogo.shape.Element;
import scala.Int$;

public class Circle
extends Element
implements Shape.Circle {
    private static final long serialVersionUID = 0L;
    private int x = 0;
    private int y = 0;
    private int xDiameter = 0;
    private int yDiameter = 0;

    public Circle(Color color) {
        super(color);
    }

    @Override
    public int x() {
        return this.x;
    }

    public void x_$eq(int x$1) {
        this.x = x$1;
    }

    @Override
    public int y() {
        return this.y;
    }

    public void y_$eq(int x$1) {
        this.y = x$1;
    }

    @Override
    public int diameter() {
        return (int)this.bounds().getWidth();
    }

    public Circle(Point center, Point circum, Color color) {
        this(color);
        double radius = this.distance(center, circum);
        this.x_$eq(center.x - (int)Math.round(radius));
        this.y_$eq(center.y - (int)Math.round(radius));
        this.yDiameter = this.xDiameter = (int)Math.round(2.0 * radius);
    }

    public Circle(int x, int y, int xDiameter, Color color) {
        this(color);
        this.x_$eq(x);
        this.y_$eq(y);
        this.xDiameter = xDiameter;
        this.yDiameter = xDiameter;
    }

    public Circle(Color color, boolean filled, boolean marked, int x, int y, int diameter) {
        this(x, y, diameter, color);
        this.filled_$eq(filled);
        this.marked_$eq(marked);
    }

    public Point origin() {
        return new Point(this.x() + Math.round((float)this.xDiameter / (float)2), this.y() + Math.round((float)this.yDiameter / (float)2));
    }

    @Override
    public Rectangle bounds() {
        return new Rectangle(this.x(), this.y(), this.xDiameter, this.yDiameter);
    }

    @Override
    public void modify(Point center, Point circum) {
        double radius = this.distance(center, circum);
        this.x_$eq(center.x - (int)Math.round(radius));
        this.y_$eq(center.y - (int)Math.round(radius));
        this.yDiameter = this.xDiameter = (int)Math.round(2.0 * radius);
    }

    @Override
    public void setModifiedPoint(Point modified) {
    }

    @Override
    public void reshapeElement(Point oldPoint, Point newPoint) {
        double change = this.distance(this.origin(), newPoint);
        this.x_$eq(this.origin().x - (int)change);
        this.y_$eq(this.origin().y - (int)change);
        this.xDiameter = (int)change * 2;
        this.yDiameter = (int)change * 2;
    }

    @Override
    public void moveElement(int xOffset, int yOffset) {
        this.x_$eq(this.x() + xOffset);
        this.y_$eq(this.y() + yOffset);
    }

    @Override
    public Point[] getHandles() {
        Point top = new Point(this.x() + this.xDiameter / 2, this.y());
        Point left = new Point(this.x(), this.y() + this.yDiameter / 2);
        Point right = new Point(this.x() + this.xDiameter, this.y() + this.yDiameter / 2);
        Point bottom = new Point(this.x() + this.xDiameter / 2, this.y() + this.yDiameter);
        return new Point[]{top, left, right, bottom};
    }

    @Override
    public boolean contains(Point p) {
        Ellipse2D.Double check = new Ellipse2D.Double(Int$.MODULE$.int2double(this.x()), Int$.MODULE$.int2double(this.y()), Int$.MODULE$.int2double(this.xDiameter), Int$.MODULE$.int2double(this.yDiameter));
        return check.contains(Int$.MODULE$.int2double(p.x), Int$.MODULE$.int2double(p.y));
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.displayColor(turtleColor));
        if (this.filled()) {
            g.fillCircle(Int$.MODULE$.int2double(this.x()), Int$.MODULE$.int2double(this.y()), Int$.MODULE$.int2double(this.xDiameter), Int$.MODULE$.int2double(this.yDiameter), scale, angle);
            return;
        }
        g.drawCircle(Int$.MODULE$.int2double(this.x()), Int$.MODULE$.int2double(this.y()), Int$.MODULE$.int2double(this.xDiameter), Int$.MODULE$.int2double(this.yDiameter), scale, angle);
    }

    @Override
    public void rotateLeft() {
        int oldX = this.x();
        this.x_$eq(this.y());
        this.y_$eq(Shape$.MODULE$.Width() - oldX - this.yDiameter);
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    @Override
    public void rotateRight() {
        int oldX = this.x();
        this.x_$eq(Shape$.MODULE$.Width() - this.y() - this.xDiameter);
        this.y_$eq(oldX);
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    @Override
    public void flipHorizontal() {
        this.x_$eq(Shape$.MODULE$.Width() - this.x() - this.xDiameter);
    }

    @Override
    public void flipVertical() {
        this.y_$eq(Shape$.MODULE$.Width() - this.y() - this.yDiameter);
    }

    @Override
    public String toReadableString() {
        return "Type: Circle, color: " + this.awtColor() + ",\n bounds: " + this.bounds();
    }

    public String toString() {
        return "Circle " + this.awtColor().getRGB() + " " + this.filled() + " " + this.marked() + " " + this.x() + " " + this.y() + " " + this.xDiameter;
    }
}

