/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape$;
import org.nlogo.shape.Element;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public abstract class Curve
extends Element {
    private static final long serialVersionUID = 0L;
    private int[] xcoords = new int[0];
    private int[] ycoords = new int[0];
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;

    public Curve(Color color) {
        super(color);
    }

    public int[] xcoords() {
        return this.xcoords;
    }

    public void xcoords_$eq(int[] x$1) {
        this.xcoords = x$1;
    }

    public int[] ycoords() {
        return this.ycoords;
    }

    public void ycoords_$eq(int[] x$1) {
        this.ycoords = x$1;
    }

    public Curve(Point start, Point next, Color color) {
        this(color);
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)BoxesRunTime.boxToInteger((int)start.x), ClassTag$.MODULE$.apply(Integer.TYPE));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object2, (Object)BoxesRunTime.boxToInteger((int)start.y), ClassTag$.MODULE$.apply(Integer.TYPE));
        Object object3 = Predef$.MODULE$.intArrayOps(this.xcoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object3, (Object)BoxesRunTime.boxToInteger((int)next.x), ClassTag$.MODULE$.apply(Integer.TYPE));
        Object object4 = Predef$.MODULE$.intArrayOps(this.ycoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object4, (Object)BoxesRunTime.boxToInteger((int)next.y), ClassTag$.MODULE$.apply(Integer.TYPE));
        this.xmin = start.x;
        this.xmax = start.x;
        this.ymin = start.y;
        this.ymax = start.y;
        this.updateBounds(next);
    }

    @Override
    public Rectangle bounds() {
        return this.createRect(new Point(this.xmin, this.ymin), new Point(this.xmax, this.ymax));
    }

    @Override
    public void modify(Point start, Point next) {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)BoxesRunTime.boxToInteger((int)next.x), ClassTag$.MODULE$.apply(Integer.TYPE));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        ArrayOps$.MODULE$.$colon$plus$extension(object2, (Object)BoxesRunTime.boxToInteger((int)next.y), ClassTag$.MODULE$.apply(Integer.TYPE));
        this.updateBounds(next);
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        int[] xArray = new int[ArrayOps$.MODULE$.size$extension(object)];
        Object object2 = Predef$.MODULE$.intArrayOps(this.xcoords());
        int[] yArray = new int[ArrayOps$.MODULE$.size$extension(object2)];
        Object object3 = Predef$.MODULE$.intArrayOps(this.xcoords());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object3)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            xArray$1[i] = this.xcoords()[i];
            yArray$1[i] = this.ycoords()[i];
        });
        g.setColor(this.awtColor());
        Object object4 = Predef$.MODULE$.intArrayOps(this.xcoords());
        g.drawPolyline(xArray, yArray, ArrayOps$.MODULE$.size$extension(object4));
    }

    @Override
    public void rotateLeft() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int temp = this.xcoords()[i];
            this.xcoords()[i] = this.ycoords()[i];
            this.ycoords()[i] = Shape$.MODULE$.Width() - temp;
        });
    }

    @Override
    public void rotateRight() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int temp = this.xcoords()[i];
            this.xcoords()[i] = Shape$.MODULE$.Width() - this.ycoords()[i];
            this.ycoords()[i] = temp;
        });
    }

    @Override
    public void flipHorizontal() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.xcoords()[i] = Shape$.MODULE$.Width() - this.xcoords()[i];
        });
    }

    @Override
    public void flipVertical() {
        Object object = Predef$.MODULE$.intArrayOps(this.ycoords());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.ycoords()[i] = Shape$.MODULE$.Width() - this.ycoords()[i];
        });
    }

    private void updateBounds(Point newPoint) {
        this.xmin = StrictMath.min(this.xmin, newPoint.x);
        this.xmax = StrictMath.max(this.xmax, newPoint.x);
        this.ymin = StrictMath.min(this.ymin, newPoint.y);
        this.ymax = StrictMath.max(this.ymax, newPoint.y);
    }

    @Override
    public String toReadableString() {
        return "Type: Curve, color: " + this.awtColor() + ",\n bounds: " + this.bounds();
    }
}

