/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.shape.Curve;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class Polygon
extends Curve
implements Shape.Polygon {
    private static final long serialVersionUID = 0L;
    private int modifiedPointIndex = -1;
    private boolean notCompleted = false;

    public Polygon(Color color) {
        super(color);
    }

    @Override
    public Seq<Tuple2<Object, Object>> points() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapIntArray(this.ycoords())));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
    }

    public Polygon(List<Object> xcoords, List<Object> ycoords, Color c) {
        this(c);
        this.xcoords_$eq((int[])xcoords.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        this.ycoords_$eq((int[])ycoords.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
    }

    public Polygon(Point start, Color color) {
        this(color);
        this.notCompleted_$eq(true);
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        this.xcoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)BoxesRunTime.boxToInteger((int)start.x), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        this.ycoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object2, (Object)BoxesRunTime.boxToInteger((int)start.y), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object3 = Predef$.MODULE$.intArrayOps(this.xcoords());
        this.xcoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object3, (Object)BoxesRunTime.boxToInteger((int)start.x), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object4 = Predef$.MODULE$.intArrayOps(this.ycoords());
        this.ycoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object4, (Object)BoxesRunTime.boxToInteger((int)start.y), ClassTag$.MODULE$.apply(Integer.TYPE)));
        this.modifiedPointIndex += 2;
    }

    public Polygon(Color color, boolean filled, boolean marked, List<Point> points) {
        this(color);
        this.filled_$eq(filled);
        this.marked_$eq(marked);
        points.foreach(newPoint -> this.addNewPoint((Point)newPoint));
    }

    @Override
    public Object clone() {
        Polygon newPoly = (Polygon)super.clone();
        newPoly.xcoords_$eq((int[])Array$.MODULE$.apply((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)newPoly.xcoords()), ClassTag$.MODULE$.apply(Integer.TYPE)));
        newPoly.ycoords_$eq((int[])Array$.MODULE$.apply((Seq)ArraySeq$.MODULE$.unsafeWrapArray((Object)newPoly.ycoords()), ClassTag$.MODULE$.apply(Integer.TYPE)));
        return newPoly;
    }

    @Override
    public Rectangle bounds() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        return new java.awt.Polygon(this.xcoords(), this.ycoords(), ArrayOps$.MODULE$.size$extension(object)).getBounds();
    }

    public void addNewPoint(Point newPoint) {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        this.xcoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)BoxesRunTime.boxToInteger((int)newPoint.x), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        this.ycoords_$eq((int[])ArrayOps$.MODULE$.$colon$plus$extension(object2, (Object)BoxesRunTime.boxToInteger((int)newPoint.y), ClassTag$.MODULE$.apply(Integer.TYPE)));
        ++this.modifiedPointIndex;
    }

    public void modifyPoint(Point newPoint) {
        this.xcoords()[this.modifiedPointIndex] = newPoint.x;
        this.ycoords()[this.modifiedPointIndex] = newPoint.y;
    }

    @Override
    public void modify(Point start, Point end) {
        this.xcoords()[this.modifiedPointIndex] = end.x;
        this.ycoords()[this.modifiedPointIndex] = end.y;
    }

    @Override
    public void reshapeElement(Point oldPoint, Point newPoint) {
        if (this.modifiedPointIndex != -1) {
            this.xcoords()[this.modifiedPointIndex] = newPoint.x;
            this.ycoords()[this.modifiedPointIndex] = newPoint.y;
            return;
        }
    }

    @Override
    public void setModifiedPoint(Point modified) {
        this.modifiedPointIndex = this.points().indexOf((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)modified.x), (Object)BoxesRunTime.boxToInteger((int)modified.y)));
    }

    @Override
    public void moveElement(int xOffset, int yOffset) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.xcoords().length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.xcoords()[i] = Predef$.MODULE$.int2Integer(this.xcoords()[i]) + xOffset;
            this.ycoords()[i] = Predef$.MODULE$.int2Integer(this.ycoords()[i]) + yOffset;
        });
    }

    @Override
    public Point[] getHandles() {
        return (Point[])((IterableOnceOps)this.points().map((Function1 & Serializable)t -> new Point(t._1$mcI$sp(), t._2$mcI$sp()))).toArray(ClassTag$.MODULE$.apply(Point.class));
    }

    @Override
    public boolean contains(Point p) {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        java.awt.Polygon check = new java.awt.Polygon((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcII.sp & Serializable)_$1 -> Predef$.MODULE$.int2Integer(_$1), ClassTag$.MODULE$.apply(Integer.TYPE)), (int[])ArrayOps$.MODULE$.map$extension(object2, (Function1)(JFunction1.mcII.sp & Serializable)_$2 -> Predef$.MODULE$.int2Integer(_$2), ClassTag$.MODULE$.apply(Integer.TYPE)), this.xcoords().length);
        return check.contains(p);
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        if (this.notCompleted()) {
            super.draw(g, null, scale, angle);
            return;
        }
        g.setColor(this.displayColor(turtleColor));
        if (this.filled()) {
            Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
            g.fillPolygon(this.xcoords(), this.ycoords(), ArrayOps$.MODULE$.size$extension(object));
            return;
        }
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        g.drawPolygon(this.xcoords(), this.ycoords(), ArrayOps$.MODULE$.size$extension(object));
    }

    public void finishUp() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        this.xcoords_$eq((int[])ArrayOps$.MODULE$.dropRight$extension(object, 3));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        this.ycoords_$eq((int[])ArrayOps$.MODULE$.dropRight$extension(object2, 3));
        this.notCompleted_$eq(false);
    }

    public void selfClose() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        this.xcoords_$eq((int[])ArrayOps$.MODULE$.dropRight$extension(object, 1));
        Object object2 = Predef$.MODULE$.intArrayOps(this.ycoords());
        this.ycoords_$eq((int[])ArrayOps$.MODULE$.dropRight$extension(object2, 1));
        this.notCompleted_$eq(false);
    }

    @Override
    public String toReadableString() {
        return "Polygon - color: " + this.awtColor() + ",\n          bounds: " + this.bounds();
    }

    @Override
    public boolean shouldSave() {
        Object object = Predef$.MODULE$.intArrayOps(this.xcoords());
        return ArrayOps$.MODULE$.size$extension(object) >= 2;
    }

    public String toString() {
        String pointsString = ((IterableOnceOps)this.points().map((Function1 & Serializable)p -> p._1$mcI$sp() + " " + p._2$mcI$sp())).mkString(" ");
        return "Polygon " + this.awtColor().getRGB() + " " + this.filled() + " " + this.marked() + " " + pointsString;
    }

    public boolean notCompleted() {
        return this.notCompleted;
    }

    public void notCompleted_$eq(boolean x$1) {
        this.notCompleted = x$1;
    }
}

