/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.core.Shape$;
import org.nlogo.shape.Element;
import scala.Int$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;

public class Rectangle
extends Element
implements Shape.Rectangle {
    private static final long serialVersionUID = 0L;
    private Point upperLeft = null;
    private Point upperRight = null;
    private Point lowerRight = null;
    private Point lowerLeft = null;
    private int xmin = 0;
    private int xmax = 0;
    private int ymin = 0;
    private int ymax = 0;
    private String modifiedPoint = null;

    public Rectangle(Color color) {
        super(color);
    }

    public Rectangle(Point start, Point end, Color color) {
        this(color);
        this.upperLeft_$eq(new Point(start));
        this.upperRight_$eq(new Point(end.x, start.y));
        this.lowerLeft_$eq(new Point(start.x, end.y));
        this.lowerRight_$eq(new Point(end));
    }

    public Rectangle(Color color, boolean filled, boolean marked, Point start, Point end) {
        this(start, end, color);
        this.filled_$eq(filled);
        this.marked_$eq(marked);
    }

    public Point upperLeft() {
        return this.upperLeft;
    }

    public void upperLeft_$eq(Point x$1) {
        this.upperLeft = x$1;
    }

    public Point upperRight() {
        return this.upperRight;
    }

    public void upperRight_$eq(Point x$1) {
        this.upperRight = x$1;
    }

    public Point lowerRight() {
        return this.lowerRight;
    }

    public void lowerRight_$eq(Point x$1) {
        this.lowerRight = x$1;
    }

    public Point lowerLeft() {
        return this.lowerLeft;
    }

    public void lowerLeft_$eq(Point x$1) {
        this.lowerLeft = x$1;
    }

    public int xmin() {
        return this.xmin;
    }

    public void xmin_$eq(int x$1) {
        this.xmin = x$1;
    }

    public int xmax() {
        return this.xmax;
    }

    public void xmax_$eq(int x$1) {
        this.xmax = x$1;
    }

    public int ymin() {
        return this.ymin;
    }

    public void ymin_$eq(int x$1) {
        this.ymin = x$1;
    }

    public int ymax() {
        return this.ymax;
    }

    public void ymax_$eq(int x$1) {
        this.ymax = x$1;
    }

    @Override
    public int getX() {
        return this.upperLeft().x;
    }

    @Override
    public int getY() {
        return this.upperLeft().y;
    }

    @Override
    public int getWidth() {
        return this.lowerRight().x - this.upperLeft().x;
    }

    @Override
    public int getHeight() {
        return this.lowerRight().y - this.upperLeft().y;
    }

    @Override
    public Tuple2<Object, Object> upperLeftCorner() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.upperLeft().getX())), (Object)BoxesRunTime.boxToInteger((int)((int)this.upperLeft().getY())));
    }

    @Override
    public Tuple2<Object, Object> lowerRightCorner() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)this.lowerRight().getX())), (Object)BoxesRunTime.boxToInteger((int)((int)this.lowerRight().getY())));
    }

    public Point[] getCorners() {
        return new Point[]{this.upperLeft(), this.lowerRight()};
    }

    @Override
    public Object clone() {
        Rectangle newRect = (Rectangle)super.clone();
        newRect.upperLeft_$eq((Point)newRect.upperLeft().clone());
        newRect.upperRight_$eq((Point)newRect.upperRight().clone());
        newRect.lowerLeft_$eq((Point)newRect.lowerLeft().clone());
        newRect.lowerRight_$eq((Point)newRect.lowerRight().clone());
        return newRect;
    }

    @Override
    public java.awt.Rectangle bounds() {
        this.setMaxsAndMins();
        return new java.awt.Rectangle(this.xmin(), this.ymin(), this.xmax() - this.xmin(), this.ymax() - this.ymin());
    }

    @Override
    public Point[] getHandles() {
        return new Point[]{this.upperLeft(), this.upperRight(), this.lowerRight(), this.lowerLeft()};
    }

    @Override
    public boolean contains(Point p) {
        return this.bounds().contains(p);
    }

    @Override
    public void modify(Point start, Point last) {
        int width = StrictMath.abs(start.x - last.x);
        int height = StrictMath.abs(start.y - last.y);
        this.upperLeft().x = StrictMath.min(start.x, last.x);
        this.upperLeft().y = StrictMath.min(start.y, last.y);
        this.upperRight().x = this.upperLeft().x + width;
        this.upperRight().y = this.upperLeft().y;
        this.lowerRight().x = this.upperLeft().x + width;
        this.lowerRight().y = this.upperLeft().y + height;
        this.lowerLeft().x = this.upperLeft().x;
        this.lowerLeft().y = this.upperLeft().y + height;
    }

    @Override
    public void setModifiedPoint(Point modified) {
        Point point = modified;
        Point point2 = this.upperLeft();
        if (!(point != null ? !((Object)point).equals(point2) : point2 != null)) {
            this.modifiedPoint = "upperLeft";
            return;
        }
        Point point3 = modified;
        Point point4 = this.upperRight();
        if (!(point3 != null ? !((Object)point3).equals(point4) : point4 != null)) {
            this.modifiedPoint = "upperRight";
            return;
        }
        Point point5 = modified;
        Point point6 = this.lowerRight();
        if (!(point5 != null ? !((Object)point5).equals(point6) : point6 != null)) {
            this.modifiedPoint = "lowerRight";
            return;
        }
        Point point7 = modified;
        Point point8 = this.lowerLeft();
        if (!(point7 != null ? !((Object)point7).equals(point8) : point8 != null)) {
            this.modifiedPoint = "lowerLeft";
            return;
        }
    }

    @Override
    public void reshapeElement(Point oldPoint, Point newPoint) {
        String string = this.modifiedPoint;
        String string2 = "upperLeft";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.upperLeft_$eq(newPoint);
            this.lowerLeft().x = newPoint.x;
            this.upperRight().y = newPoint.y;
        }
        String string3 = this.modifiedPoint;
        String string4 = "upperRight";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.upperRight_$eq(newPoint);
            this.lowerRight().x = newPoint.x;
            this.upperLeft().y = newPoint.y;
        }
        String string5 = this.modifiedPoint;
        String string6 = "lowerRight";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            this.lowerRight_$eq(newPoint);
            this.upperRight().x = newPoint.x;
            this.lowerLeft().y = newPoint.y;
        }
        String string7 = this.modifiedPoint;
        String string8 = "lowerLeft";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            this.lowerLeft_$eq(newPoint);
            this.upperLeft().x = newPoint.x;
            this.lowerRight().y = newPoint.y;
        }
        this.xmin_$eq(this.upperLeft().x);
        this.xmax_$eq(this.upperRight().x);
        this.ymin_$eq(this.upperLeft().y);
        this.ymax_$eq(this.lowerLeft().y);
    }

    @Override
    public void moveElement(int xOffset, int yOffset) {
        Point point = this.upperLeft();
        point.x += xOffset;
        Point point2 = this.upperLeft();
        point2.y += yOffset;
        Point point3 = this.upperRight();
        point3.x += xOffset;
        Point point4 = this.upperRight();
        point4.y += yOffset;
        Point point5 = this.lowerLeft();
        point5.x += xOffset;
        Point point6 = this.lowerLeft();
        point6.y += yOffset;
        Point point7 = this.lowerRight();
        point7.x += xOffset;
        Point point8 = this.lowerRight();
        point8.y += yOffset;
    }

    public void setMaxsAndMins() {
        int[] xcoords = new int[]{this.upperLeft().x, this.upperRight().x, this.lowerRight().x, this.lowerLeft().x};
        int[] ycoords = new int[]{this.upperLeft().y, this.upperRight().y, this.lowerRight().y, this.lowerLeft().y};
        this.xmin_$eq(this.min(xcoords));
        this.xmax_$eq(this.max(xcoords));
        this.ymin_$eq(this.min(ycoords));
        this.ymax_$eq(this.max(ycoords));
    }

    @Override
    public void draw(GraphicsInterface g, Color turtleColor, double scale, double angle) {
        g.setColor(this.displayColor(turtleColor));
        if (this.filled()) {
            g.fillRect(Int$.MODULE$.int2double(this.upperLeft().x), Int$.MODULE$.int2double(this.upperLeft().y), Int$.MODULE$.int2double(this.upperRight().x - this.upperLeft().x), Int$.MODULE$.int2double(this.lowerLeft().y - this.upperLeft().y), scale, angle);
            return;
        }
        g.drawRect(Int$.MODULE$.int2double(this.upperLeft().x), Int$.MODULE$.int2double(this.upperLeft().y), Int$.MODULE$.int2double(this.upperRight().x - this.upperLeft().x), Int$.MODULE$.int2double(this.lowerLeft().y - this.upperLeft().y), scale, angle);
    }

    @Override
    public void rotateLeft() {
        Point temp = this.lowerLeft();
        this.lowerLeft_$eq(this.upperLeft());
        this.upperLeft_$eq(this.upperRight());
        this.upperRight_$eq(this.lowerRight());
        this.lowerRight_$eq(temp);
        int temp2 = 0;
        temp2 = this.upperLeft().x;
        this.upperLeft().x = this.upperLeft().y;
        this.upperLeft().y = Shape$.MODULE$.Width() - temp2;
        temp2 = this.upperRight().x;
        this.upperRight().x = this.upperRight().y;
        this.upperRight().y = Shape$.MODULE$.Width() - temp2;
        temp2 = this.lowerLeft().x;
        this.lowerLeft().x = this.lowerLeft().y;
        this.lowerLeft().y = Shape$.MODULE$.Width() - temp2;
        temp2 = this.lowerRight().x;
        this.lowerRight().x = this.lowerRight().y;
        this.lowerRight().y = Shape$.MODULE$.Width() - temp2;
    }

    @Override
    public void rotateRight() {
        Point temp = this.upperLeft();
        this.upperLeft_$eq(this.lowerLeft());
        this.lowerLeft_$eq(this.lowerRight());
        this.lowerRight_$eq(this.upperRight());
        this.upperRight_$eq(temp);
        int temp2 = 0;
        temp2 = this.upperLeft().x;
        this.upperLeft().x = Shape$.MODULE$.Width() - this.upperLeft().y;
        this.upperLeft().y = temp2;
        temp2 = this.lowerLeft().x;
        this.lowerLeft().x = Shape$.MODULE$.Width() - this.lowerLeft().y;
        this.lowerLeft().y = temp2;
        temp2 = this.upperRight().x;
        this.upperRight().x = Shape$.MODULE$.Width() - this.upperRight().y;
        this.upperRight().y = temp2;
        temp2 = this.lowerRight().x;
        this.lowerRight().x = Shape$.MODULE$.Width() - this.lowerRight().y;
        this.lowerRight().y = temp2;
    }

    @Override
    public void flipHorizontal() {
        Point temp = this.upperLeft();
        this.upperLeft_$eq(this.upperRight());
        this.upperRight_$eq(temp);
        temp = this.lowerLeft();
        this.lowerLeft_$eq(this.lowerRight());
        this.lowerRight_$eq(temp);
        this.upperLeft().x = Shape$.MODULE$.Width() - this.upperLeft().x;
        this.upperRight().x = Shape$.MODULE$.Width() - this.upperRight().x;
        this.lowerLeft().x = Shape$.MODULE$.Width() - this.lowerLeft().x;
        this.lowerRight().x = Shape$.MODULE$.Width() - this.lowerRight().x;
    }

    @Override
    public void flipVertical() {
        Point temp = this.upperLeft();
        this.upperLeft_$eq(this.lowerLeft());
        this.lowerLeft_$eq(temp);
        temp = this.lowerRight();
        this.lowerRight_$eq(this.upperRight());
        this.upperRight_$eq(temp);
        this.upperLeft().y = Shape$.MODULE$.Width() - this.upperLeft().y;
        this.upperRight().y = Shape$.MODULE$.Width() - this.upperRight().y;
        this.lowerLeft().y = Shape$.MODULE$.Width() - this.lowerLeft().y;
        this.lowerRight().y = Shape$.MODULE$.Width() - this.lowerRight().y;
    }

    @Override
    public String toReadableString() {
        return "Type: Rectangle, color: " + this.awtColor() + ",\n bounds: " + this.bounds();
    }

    public String toString() {
        return "Rectangle " + this.awtColor().getRGB() + " " + this.filled() + " " + this.marked() + " " + this.upperLeft().x + " " + this.upperLeft().y + " " + this.lowerRight().x + " " + this.lowerRight().y;
    }
}

