/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import org.nlogo.core.Shape;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ShapeConverter$
implements Serializable {
    public static final ShapeConverter$ MODULE$ = new ShapeConverter$();

    private ShapeConverter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShapeConverter$.class);
    }

    public Shape baseShapeToShape(Shape bs) {
        Shape shape;
        Shape shape2 = bs;
        if (shape2 instanceof Shape.VectorShape) {
            Shape.VectorShape vs = (Shape.VectorShape)shape2;
            shape = this.baseVectorShapeToVectorShape(vs);
        } else if (shape2 instanceof Shape.LinkShape) {
            Shape.LinkShape ls = (Shape.LinkShape)shape2;
            shape = this.baseLinkShapeToLinkShape(ls);
        } else {
            throw new MatchError((Object)shape2);
        }
        return shape;
    }

    public LinkShape baseLinkShapeToLinkShape(Shape.LinkShape l) {
        LinkShape ls = new LinkShape();
        ls.name_$eq(l.name());
        ls.curviness_$eq(l.curviness());
        ls.directionIndicator_$eq(this.baseVectorShapeToVectorShape(l.indicator()));
        ((IterableOnceOps)l.linkLines().zipWithIndex()).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Shape.LinkLine ll = (Shape.LinkLine)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                ls.add(i, new LinkLine(ll.xcor(), ll.isVisible(), (float[])ll.dashChoices().toArray(ClassTag$.MODULE$.apply(Float.TYPE))));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return ls;
    }

    public VectorShape baseVectorShapeToVectorShape(Shape.VectorShape v) {
        VectorShape vs = new VectorShape();
        vs.name_$eq(v.name());
        vs.setRotatable(v.rotatable());
        vs.setEditableColorIndex(v.editableColorIndex());
        v.elements().map(e -> vs.add(MODULE$.coreElementToElement((Shape.Element)e)));
        return vs;
    }

    public Color color(Shape.RgbColor c) {
        return new Color(c.red(), c.green(), c.blue(), c.alpha());
    }

    public Point point(Tuple2<Object, Object> t) {
        return new Point(t._1$mcI$sp(), t._2$mcI$sp());
    }

    public Element coreElementToElement(Shape.Element e) {
        Shape.Element element = e;
        if (element instanceof Shape.Line) {
            Shape.Line bl = (Shape.Line)element;
            Line line = new Line(this.point(bl.startPoint()), this.point(bl.endPoint()), this.color(bl.color()));
            line.marked_$eq(bl.marked());
            return line;
        }
        if (element instanceof Shape.Polygon) {
            Shape.Polygon bp = (Shape.Polygon)element;
            Polygon poly = new Polygon((List<Object>)bp.xCoords().toList(), (List<Object>)bp.yCoords().toList(), this.color(bp.color()));
            poly.filled_$eq(bp.filled());
            poly.marked_$eq(bp.marked());
            return poly;
        }
        if (element instanceof Shape.Circle) {
            Shape.Circle bc = (Shape.Circle)element;
            Circle circle = new Circle(bc.x(), bc.y(), bc.diameter(), this.color(bc.color()));
            circle.filled_$eq(bc.filled());
            circle.marked_$eq(bc.marked());
            return circle;
        }
        if (element instanceof Shape.Rectangle) {
            Shape.Rectangle br = (Shape.Rectangle)element;
            Rectangle rect = new Rectangle(this.point(br.upperLeftCorner()), this.point(br.lowerRightCorner()), this.color(br.color()));
            rect.filled_$eq(br.filled());
            rect.marked_$eq(br.marked());
            return rect;
        }
        throw new IllegalStateException();
    }

    public LinkLine coreLinkLineToLinkLine(Shape.LinkLine l) {
        LinkLine ll = new LinkLine(l.xcor(), l.isVisible());
        ll.dashes_$eq((float[])l.dashChoices().toArray(ClassTag$.MODULE$.apply(Float.TYPE)));
        return ll;
    }
}

