/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.List;
import org.nlogo.api.Color$;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.core.Shape;
import org.nlogo.core.Shape$;
import org.nlogo.shape.DrawableShape;
import org.nlogo.shape.Element;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape$;
import org.nlogo.shape.VectorShape$Recolorable$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class VectorShape
implements Shape.VectorShape,
Cloneable,
Serializable,
DrawableShape {
    private static final long serialVersionUID = 0L;
    private String name = "";
    private int editableColorIndex = 0;
    private boolean rotatable = true;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Enumeration.Value _fgRecolorable = VectorShape$Recolorable$.MODULE$.UNKNOWN();
    private ArrayBuffer<Element> elementList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Element[0]));

    public static int CLOSE_ENOUGH() {
        return VectorShape$.MODULE$.CLOSE_ENOUGH();
    }

    public static int NUM_GRID_LINES() {
        return VectorShape$.MODULE$.NUM_GRID_LINES();
    }

    public static int TURTLE_WIDTH() {
        return VectorShape$.MODULE$.TURTLE_WIDTH();
    }

    public static VectorShape getDefaultShape() {
        return VectorShape$.MODULE$.getDefaultShape();
    }

    public static String getString(String[] stringArray, int n) {
        return VectorShape$.MODULE$.getString(stringArray, n);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    @Override
    public int editableColorIndex() {
        return this.editableColorIndex;
    }

    public void editableColorIndex_$eq(int x$1) {
        this.editableColorIndex = x$1;
    }

    @Override
    public boolean rotatable() {
        return this.rotatable;
    }

    public void rotatable_$eq(boolean x$1) {
        this.rotatable = x$1;
    }

    public PropertyChangeSupport propertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public ArrayBuffer<Element> elementList() {
        return this.elementList;
    }

    public void elementList_$eq(ArrayBuffer<Element> x$1) {
        this.elementList = x$1;
    }

    @Override
    public Seq<Shape.Element> elements() {
        return this.elementList().toSeq();
    }

    public void setEditableColorIndex(int editableColorIndex) {
        this.editableColorIndex_$eq(editableColorIndex);
    }

    @Override
    public int getEditableColorIndex() {
        return this.editableColorIndex();
    }

    /*
     * WARNING - void declaration
     */
    public VectorShape clone() {
        void v0;
        try {
            void var1_1;
            VectorShape newShape = (VectorShape)super.clone();
            newShape.elementList_$eq((ArrayBuffer<Element>)((ArrayBuffer)this.elementList().map((Function1 & Serializable)_$1 -> (Element)_$1.clone())));
            v0 = var1_1;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
        return v0;
    }

    public void setOutline() {
        this.elementList().foreach(_$2 -> _$2.filled_$eq(false));
    }

    public List<Element> getElementsJ() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.elementList()).asJava();
    }

    public Seq<Element> getElements() {
        return this.elementList().toSeq();
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable_$eq(rotatable);
    }

    @Override
    public boolean isRotatable() {
        return this.rotatable();
    }

    public boolean fgRecolorable() {
        if (this._fgRecolorable == VectorShape$Recolorable$.MODULE$.UNKNOWN()) {
            Color editableColor = new Color(Color$.MODULE$.getARGBByIndex(this.editableColorIndex()));
            this.updateRecolorability(editableColor);
        }
        Enumeration.Value value = this._fgRecolorable;
        Enumeration.Value value2 = VectorShape$Recolorable$.MODULE$.TRUE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void markRecolorableElements(Color editableColor, int editableColorIndex) {
        this.editableColorIndex_$eq(editableColorIndex);
        this.updateRecolorability(editableColor);
        this.elementList().foreach(el -> {
            Color color = el.awtColor();
            Color color2 = editableColor;
            el.marked_$eq(!(color != null ? !((Object)color).equals(color2) : color2 != null));
        });
    }

    private void updateRecolorability(Color editableColor) {
        if (this.elementList().exists((Function1 & Serializable)_$3 -> {
            Color color = _$3.awtColor();
            Color color2 = editableColor;
            return !(color != null ? !((Object)color).equals(color2) : color2 != null);
        })) {
            this._fgRecolorable = VectorShape$Recolorable$.MODULE$.TRUE();
            return;
        }
        this._fgRecolorable = VectorShape$Recolorable$.MODULE$.FALSE();
    }

    public boolean isTooSimpleToCache() {
        int n = this.elementList().size();
        if (0 == n) {
            return true;
        }
        if (1 == n) {
            return !(this.element(0) instanceof Polygon);
        }
        return false;
    }

    public Element element(int i) {
        return (Element)this.elementList().apply(i);
    }

    public void modifyingElements(Function0<ArrayBuffer<Element>> newEls) {
        ArrayBuffer modifiedElements;
        ArrayBuffer arrayBuffer = modifiedElements = (ArrayBuffer)newEls.apply();
        ArrayBuffer<Element> arrayBuffer2 = this.elementList();
        if (arrayBuffer == null ? arrayBuffer2 != null : !arrayBuffer.equals(arrayBuffer2)) {
            this.elementList_$eq((ArrayBuffer<Element>)modifiedElements);
            this.notifyObservers();
            return;
        }
    }

    public void changed() {
        this.notifyObservers();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void notifyObservers() {
        this.propertyChangeSupport().firePropertyChange("shapeChanged", null, null);
    }

    public ArrayBuffer<Element> remove(Element element) {
        return (ArrayBuffer)this.elementList().$minus$eq((Object)element);
    }

    public void removeLast() {
        this.modifyingElements((Function0<ArrayBuffer<Element>>)((Function0 & Serializable)this::removeLast$$anonfun$1));
    }

    public void removeAll() {
        this.modifyingElements((Function0<ArrayBuffer<Element>>)((Function0 & Serializable)VectorShape::removeAll$$anonfun$1));
    }

    public void add(Element element) {
        this.modifyingElements((Function0<ArrayBuffer<Element>>)((Function0 & Serializable)() -> this.add$$anonfun$1(element)));
    }

    public void addAtPosition(int index, Element element) {
        this.modifyingElements((Function0<ArrayBuffer<Element>>)((Function0 & Serializable)() -> this.addAtPosition$$anonfun$1(index, element)));
    }

    public void rotateLeft() {
        this.elementList().foreach(_$4 -> _$4.rotateLeft());
    }

    public void rotateRight() {
        this.elementList().foreach(_$5 -> _$5.rotateRight());
    }

    public void flipHorizontal() {
        this.elementList().foreach(_$6 -> _$6.flipHorizontal());
    }

    public void flipVertical() {
        this.elementList().foreach(_$7 -> _$7.flipVertical());
    }

    public void paint(GraphicsInterface g, Color turtleColor, double x, double y, double size, double cellSize, int angle, double lineThickness) {
        g.push();
        double scale = size * cellSize;
        try {
            if (this.isRotatable() && angle != 0) {
                g.rotate((double)angle / 180.0 * Math.PI, x, y, scale);
            }
            g.translate(x, y);
            g.scale(scale, scale, Int$.MODULE$.int2double(Shape$.MODULE$.Width()));
            g.setStrokeFromLineThickness(lineThickness, scale, cellSize, Int$.MODULE$.int2double(Shape$.MODULE$.Width()));
            this.elementList().foreach(_$8 -> _$8.draw(g, turtleColor, scale, this.isRotatable() ? Int$.MODULE$.int2double(angle) : 0.0));
        }
        finally {
            g.pop();
        }
    }

    @Override
    public void paint(GraphicsInterface g, Color turtleColor, int x, int y, double cellSize, int angle) {
        this.paint(g, turtleColor, Int$.MODULE$.int2double(x), Int$.MODULE$.int2double(y), 1.0, cellSize, angle, 0.0);
    }

    public String toReadableString() {
        return "Shape " + this.name() + ":\n" + this.elementList().map((Function1 & Serializable)_$9 -> _$9.toString());
    }

    public String toString() {
        return ((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToBoolean((boolean)this.rotatable()), BoxesRunTime.boxToInteger((int)this.editableColorIndex())})).$plus$plus((IterableOnce)((StrictOptimizedIterableOps)this.elementList().filter((Function1 & Serializable)_$10 -> _$10.shouldSave())).map((Function1 & Serializable)_$11 -> _$11.toString()))).mkString("\n");
    }

    public void addElement(Element element) {
        if (element != null) {
            this.add(element);
            return;
        }
    }

    private final ArrayBuffer removeLast$$anonfun$1() {
        return (ArrayBuffer)this.elementList().dropRight(1);
    }

    private static final ArrayBuffer removeAll$$anonfun$1() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Element[0]));
    }

    private final ArrayBuffer add$$anonfun$1(Element element$1) {
        ArrayBuffer newList;
        block0: {
            newList = (ArrayBuffer)this.elementList().$colon$plus((Object)element$1);
            Element element = element$1;
            if (!(element instanceof Rectangle)) break block0;
            Rectangle rectangle = (Rectangle)element;
            rectangle.setMaxsAndMins();
        }
        return newList;
    }

    private final ArrayBuffer addAtPosition$$anonfun$1(int index$1, Element element$2) {
        Tuple2 tuple2 = this.elementList().splitAt(index$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer prefix = (ArrayBuffer)tuple2._1();
        ArrayBuffer postfix = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)prefix, (Object)postfix);
        ArrayBuffer prefix2 = (ArrayBuffer)tuple22._1();
        ArrayBuffer postfix2 = (ArrayBuffer)tuple22._2();
        return (ArrayBuffer)((IterableOps)prefix2.$colon$plus((Object)element$2)).$plus$plus((IterableOnce)postfix2);
    }
}

