/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.Paths;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.Exceptions$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.AgentKind;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.Model;
import org.nlogo.core.Shape;
import org.nlogo.core.ShapeList$;
import org.nlogo.core.ShapeListTracker;
import org.nlogo.shape.editor.DrawableList;
import org.nlogo.shape.editor.ImportDialog;
import org.nlogo.shape.editor.ManagerDialog$;
import org.nlogo.swing.Button;
import org.nlogo.swing.DialogButton;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.Implicits$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public abstract class ManagerDialog<A extends Shape>
extends JDialog
implements ListSelectionListener,
ThemeSync {
    private final Frame parentFrame;
    private final AbstractModelLoader modelLoader;
    private final ClassTag<A> ct;
    private final I18N.Prefix i18nPrefix;
    private final DrawableList<A> shapesList;
    private Option<ImportDialog> importDialog;
    public final DialogButton org$nlogo$shape$editor$ManagerDialog$$newButton;
    public final DialogButton org$nlogo$shape$editor$ManagerDialog$$modelImportButton;
    public final DialogButton org$nlogo$shape$editor$ManagerDialog$$editButton;
    public final DialogButton org$nlogo$shape$editor$ManagerDialog$$duplicateButton;
    public final DialogButton org$nlogo$shape$editor$ManagerDialog$$deleteButton;
    private final ScrollPane scrollPane;
    private final TextField searchField;
    private final JLabel searchIcon;

    public ManagerDialog(Frame parentFrame, AbstractModelLoader modelLoader, ShapeListTracker shapeListTracker, ClassTag<A> ct) {
        this.parentFrame = parentFrame;
        this.modelLoader = modelLoader;
        this.ct = ct;
        super(parentFrame);
        this.i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.shapesEditor");
        this.shapesList = new DrawableList<A>(shapeListTracker, 10, 34, this, ct);
        this.importDialog = None$.MODULE$;
        this.org$nlogo$shape$editor$ManagerDialog$$newButton = new DialogButton(false, I18N$.MODULE$.gui().apply("new", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.newShape());
        this.org$nlogo$shape$editor$ManagerDialog$$modelImportButton = new DialogButton(false, I18N$.MODULE$.gui().apply("importFromModel", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.importFromModel());
        this.org$nlogo$shape$editor$ManagerDialog$$editButton = new DialogButton(false, I18N$.MODULE$.gui().apply("edit", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.editShape());
        this.org$nlogo$shape$editor$ManagerDialog$$duplicateButton = new DialogButton(false, I18N$.MODULE$.gui().apply("duplicate", this.i18nPrefix()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.duplicateShape());
        this.org$nlogo$shape$editor$ManagerDialog$$deleteButton = new DialogButton(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(false, I18N$.MODULE$.gui().apply("delete", $outer.i18nPrefix()), (Function0<BoxedUnit>)$outer.org$nlogo$shape$editor$ManagerDialog$$_$$anon$superArg$1$1());
                this.setEnabled(false);
            }
        };
        this.scrollPane = new ScrollPane(this.shapesList(), ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
        this.searchField = new TextField(this){
            private final /* synthetic */ ManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(TextField$.MODULE$.$lessinit$greater$default$1(), TextField$.MODULE$.$lessinit$greater$default$2(), TextField$.MODULE$.$lessinit$greater$default$3());
                this.getDocument().addDocumentListener(new DocumentListener(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void changedUpdate(DocumentEvent e) {
                    }

                    public void insertUpdate(DocumentEvent e) {
                        this.$outer.org$nlogo$shape$editor$ManagerDialog$_$$anon$$$outer().shapesList().update(this.$outer.org$nlogo$shape$editor$ManagerDialog$_$$anon$$$outer().searchOption());
                    }

                    public void removeUpdate(DocumentEvent e) {
                        this.$outer.org$nlogo$shape$editor$ManagerDialog$_$$anon$$$outer().shapesList().update(this.$outer.org$nlogo$shape$editor$ManagerDialog$_$$anon$$$outer().searchOption());
                    }
                });
            }

            public final /* synthetic */ ManagerDialog org$nlogo$shape$editor$ManagerDialog$_$$anon$$$outer() {
                return this.$outer;
            }
        };
        this.searchIcon = new JLabel(Utils$.MODULE$.iconScaledWithColor("/images/find.png", 15, 15, InterfaceColors$.MODULE$.toolbarImage()));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 3;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(12, 0, 12, 0);
        this.add((Component)((Object)new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new FlowLayout(0, 12, 0));
                Transparent.$init$(this);
                this.add($outer.org$nlogo$shape$editor$ManagerDialog$$newButton);
                this.add($outer.org$nlogo$shape$editor$ManagerDialog$$modelImportButton);
                $outer.additionalButton().foreach((Function1 & Serializable)x$0 -> this.add((Component)x$0));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$5(java.awt.Component )}, serializedLambda);
            }
        }), c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.scrollPane, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)this.searchIcon, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.searchField, c);
        c.gridx = 2;
        c.anchor = 13;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 12, 0);
        this.add((Component)((Object)new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new FlowLayout(0, 12, 0));
                Transparent.$init$(this);
                this.add($outer.org$nlogo$shape$editor$ManagerDialog$$editButton);
                this.add($outer.org$nlogo$shape$editor$ManagerDialog$$duplicateButton);
                this.add($outer.org$nlogo$shape$editor$ManagerDialog$$deleteButton);
            }
        }), c);
        this.shapesList().addMouseListener(new MouseInputAdapter(this){
            private final /* synthetic */ ManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    this.$outer.editShape();
                    return;
                }
            }
        });
        Utils$.MODULE$.addEscKeyAction(this, Implicits$.MODULE$.thunk2action((JFunction0.mcV.sp & Serializable)() -> this.dispose()));
        Rectangle maxBounds = this.getGraphicsConfiguration().getBounds();
        this.setLocation(maxBounds.x + maxBounds.width / 3, maxBounds.y + maxBounds.height / 3);
        this.pack();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public I18N.Prefix i18nPrefix() {
        return this.i18nPrefix;
    }

    public DrawableList<A> shapesList() {
        return this.shapesList;
    }

    public Option<ImportDialog> importDialog() {
        return this.importDialog;
    }

    public void importDialog_$eq(Option<ImportDialog> x$1) {
        this.importDialog = x$1;
    }

    public abstract void newShape();

    public abstract void editShape();

    public abstract void duplicateShape();

    public abstract Option<A> displayableShapeFromCoreShape(Shape var1);

    public abstract Seq<Shape> modelShapes(Model var1);

    public abstract AgentKind shapeKind();

    public Option<Button> additionalButton() {
        return None$.MODULE$;
    }

    public void init(String title) {
        this.shapesList().update(this.searchOption());
        this.shapesList().selectShapeName("default");
        this.setTitle(title);
        this.setVisible(true);
    }

    public void reset() {
        this.shapesList().update(this.searchOption());
        this.shapesList().selectShapeName("default");
    }

    private void importFromModel() {
        block6: {
            Object object;
            try {
                String path = FileDialog$.MODULE$.showFiles(this.parentFrame, I18N$.MODULE$.gui().apply("import.note", this.i18nPrefix()), 0);
                URI modelUri = Paths.get(path, new String[0]).toUri();
                Try try_ = this.modelLoader.readModel(modelUri).map((Function1 & Serializable)m -> this.modelShapes((Model)m)).map((Function1 & Serializable)shapes -> this.drawableListFromModelShapes((Seq<Shape>)shapes));
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    object = new OptionPane(this, I18N$.MODULE$.gui().apply("import", this.i18nPrefix()), I18N$.MODULE$.gui().apply("import.invalidError", this.i18nPrefix()), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                    break block6;
                }
                if (try_ instanceof Success) {
                    DrawableList drawableList = (DrawableList)((Success)try_).value();
                    if (drawableList.shapeList().isEmpty()) {
                        this.importDialog().foreach(_$2 -> _$2.sendImportWarning(I18N$.MODULE$.gui().apply("import.error", this.i18nPrefix())));
                        object = BoxedUnit.UNIT;
                    } else {
                        this.importDialog_$eq((Option<ImportDialog>)Some$.MODULE$.apply((Object)new ImportDialog(this, this, drawableList)));
                        object = BoxedUnit.UNIT;
                    }
                    break block6;
                }
                throw new MatchError((Object)try_);
            }
            catch (UserCancelException e) {
                Exceptions$.MODULE$.ignore(e);
                object = BoxedUnit.UNIT;
            }
        }
        this.shapesList().requestFocus();
    }

    public DrawableList<A> drawableListFromModelShapes(Seq<Shape> shapes) {
        Seq<Shape> sortedShapes = ShapeList$.MODULE$.sortShapes((Seq<Shape>)((Seq)shapes.flatMap((Function1 & Serializable)shape -> this.displayableShapeFromCoreShape((Shape)shape))));
        ShapeListTracker shapeListTracker = new ShapeListTracker(this.shapeKind(), ShapeList$.MODULE$.shapesToMap((Iterable<Shape>)sortedShapes));
        return new DrawableList<A>(shapeListTracker, 10, 34, this, this.ct);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] selected = this.shapesList().getSelectedIndices();
        if (selected.length != 1) {
            this.org$nlogo$shape$editor$ManagerDialog$$editButton.setEnabled(false);
            this.org$nlogo$shape$editor$ManagerDialog$$duplicateButton.setEnabled(false);
        } else {
            this.org$nlogo$shape$editor$ManagerDialog$$editButton.setEnabled(true);
            this.org$nlogo$shape$editor$ManagerDialog$$duplicateButton.setEnabled(true);
            this.shapesList().ensureIndexIsVisible(selected[0]);
        }
        if (selected.length == 0 || selected.length == 1 && ShapeList$.MODULE$.isDefaultShapeName(this.shapesList().elementAt(selected[0]).name())) {
            this.org$nlogo$shape$editor$ManagerDialog$$deleteButton.setEnabled(false);
            return;
        }
        this.org$nlogo$shape$editor$ManagerDialog$$deleteButton.setEnabled(true);
    }

    public Option<String> searchOption() {
        if (this.searchField.getText().trim().isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)this.searchField.getText().trim());
    }

    @Override
    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.scrollPane.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.shapesList().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$shape$editor$ManagerDialog$$newButton.syncTheme();
        this.org$nlogo$shape$editor$ManagerDialog$$modelImportButton.syncTheme();
        this.org$nlogo$shape$editor$ManagerDialog$$editButton.syncTheme();
        this.org$nlogo$shape$editor$ManagerDialog$$duplicateButton.syncTheme();
        this.org$nlogo$shape$editor$ManagerDialog$$deleteButton.syncTheme();
        this.searchField.syncTheme();
        this.additionalButton().foreach(_$3 -> _$3.syncTheme());
        this.searchIcon.setIcon(Utils$.MODULE$.iconScaledWithColor("/images/find.png", 15, 15, InterfaceColors$.MODULE$.toolbarImage()));
    }

    public final Function0 org$nlogo$shape$editor$ManagerDialog$$_$$anon$superArg$1$1() {
        return (JFunction0.mcV.sp & Serializable)() -> {
            this.shapesList().deleteShapes();
            this.org$nlogo$shape$editor$ManagerDialog$$editButton.setEnabled(true);
            this.setEnabled(true);
            Option<A> shape = this.shapesList().getOneSelected();
            if (shape.map((Function1 & Serializable)_$1 -> _$1.name()).exists((Function1 & Serializable)name -> ShapeList$.MODULE$.isDefaultShapeName((String)name))) {
                this.setEnabled(false);
                return;
            }
        };
    }
}

