/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JDialog;
import org.nlogo.core.I18N$;
import org.nlogo.swing.BrowserLauncher;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class BrowserLauncher$
implements Serializable {
    private static final String osName;
    private static final String unableToOpenBrowserError;
    public static final BrowserLauncher$ MODULE$;

    private BrowserLauncher$() {
    }

    static {
        MODULE$ = new BrowserLauncher$();
        osName = System.getProperty("os.name");
        unableToOpenBrowserError = "We were unable to open a browser on your system.\nThis error can be reported to bugs@ccl.northwestern.edu";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BrowserLauncher$.class);
    }

    public String unableToOpenBrowserError() {
        return unableToOpenBrowserError;
    }

    public void openURI(Component comp, URI uri) {
        URI normalUri = uri.normalize();
        try {
            boolean opened = BoxesRunTime.unboxToBoolean((Object)this.desktop().map((Function1 & Serializable)d -> {
                d.browse(normalUri);
                return true;
            }).getOrElse(BrowserLauncher$::$anonfun$2));
            if (!opened) {
                ((Function1)this.osSpecificBrowserRunner().getOrElse(BrowserLauncher$::openURI$$anonfun$1)).apply((Object)normalUri.toString());
            }
        }
        catch (UnsupportedOperationException ex) {
            new OptionPane(comp, I18N$.MODULE$.gui().get("common.messages.error"), this.unableToOpenBrowserError(), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
        catch (BrowserLauncher.BrowserNotFoundException ex) {
            new OptionPane(comp, I18N$.MODULE$.gui().get("common.messages.error"), ex.getLocalizedMessage(), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
        catch (IOException ex) {
            String string = normalUri.toString();
            String string2 = uri.toString();
            Object object = (string == null ? string2 != null : !string.equals(string2)) ? "with original URI: " + uri.toString() : "";
            new OptionPane(comp, I18N$.MODULE$.gui().get("common.messages.error"), "Unable to open a browser to: " + normalUri.toString() + "\n                       " + (String)object + "\n                       Please report to bugs@ccl.northwestern.edu", OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        }
    }

    public void openURI(URI uri) {
        this.openURI(new JDialog(), uri);
    }

    public void openURIString(String s) {
        JDialog dialog = new JDialog();
        URI uri = this.makeURI(dialog, s);
        this.openURI(dialog, uri);
    }

    public void tryOpenURI(Component comp, URI uri, Path fallback, String anchor) {
        if (CollectionConverters$.MODULE$.EnumerationHasAsScala(NetworkInterface.getNetworkInterfaces()).asScala().exists((Function1 & Serializable)_$1 -> _$1.isUp())) {
            this.openURI(comp, uri);
            return;
        }
        this.openPath(comp, fallback, anchor);
    }

    public String tryOpenURI$default$4() {
        return "";
    }

    public void openPath(Component comp, Path path, String anchor) {
        URI u;
        block3: {
            block2: {
                u = path.toUri();
                if (anchor == null) break block2;
                String string = anchor;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            this.openURI(comp, u);
            return;
        }
        this.openURI(comp, new URI(u.getScheme(), u.getHost(), u.getPath(), anchor));
    }

    public void openPath(Path path, String anchor) {
        this.openPath(new JDialog(), path, anchor);
    }

    public URI makeURI(Component comp, String s) {
        URI uRI;
        try {
            uRI = new URI(s);
        }
        catch (URISyntaxException ue) {
            new OptionPane(comp, I18N$.MODULE$.gui().get("common.messages.error"), "Unable to open a browser to: " + s + "\nPlease report to bugs@ccl.northwestern.edu", OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
            uRI = null;
        }
        return uRI;
    }

    public Path docPath(String docName) {
        String docRoot = System.getProperty("netlogo.docs.dir", "docs");
        return Paths.get(docRoot + "/" + docName, new String[0]);
    }

    private Option<Desktop> desktop() {
        if (Desktop.isDesktopSupported()) {
            return Some$.MODULE$.apply((Object)Desktop.getDesktop());
        }
        return None$.MODULE$;
    }

    private Option<Function1<String, BoxedUnit>> osSpecificBrowserRunner() throws BrowserLauncher.BrowserNotFoundException {
        if (osName.startsWith("Windows")) {
            return Some$.MODULE$.apply(urlString -> MODULE$.runCommand(new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + urlString + "\""}));
        }
        if (osName.startsWith("Mac")) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(urlString -> {
            try {
                int exitCode = MODULE$.runCommand(new String[]{"firefox", "-remote", "'openURL(" + urlString + ")'"}).waitFor();
                if (exitCode != 0) {
                    MODULE$.runCommand(new String[]{"firefox", urlString});
                }
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
            catch (IOException ex) {
                throw MODULE$.firefoxNotFound(ex);
            }
        });
    }

    private Process runCommand(String[] cmd) {
        return Runtime.getRuntime().exec(cmd);
    }

    private Nothing$ browserNotFound() {
        throw new BrowserLauncher.BrowserNotFoundException(this.unableToOpenBrowserError());
    }

    private Nothing$ firefoxNotFound(Exception ex) {
        throw new BrowserLauncher.BrowserNotFoundException("NetLogo could not find and execute a web browser named 'firefox'.Please install Firefox and ensure that the 'firefox' command is in your executable PATH.  Firefox is available here:\n http://www.mozilla.com/firefox/\n\nThe full error message was:\n " + ex.getLocalizedMessage());
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final Function1 openURI$$anonfun$1() {
        throw MODULE$.browserNotFound();
    }
}

