/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.swing.CollapsibleArrow;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public class CollapsiblePane
extends JPanel
implements ThemeSync {
    private final JComponent element;
    private final JDialog parent;
    private final JLabel titleLabel;
    private final CollapsibleArrow arrow;
    private final JPanel titlePanel;

    public CollapsiblePane(String title, JComponent element, JDialog parent) {
        this.element = element;
        this.parent = parent;
        super(new BorderLayout());
        this.titleLabel = new JLabel(title);
        this.arrow = new CollapsibleArrow(element.isVisible());
        this.titleLabel.setIcon(this.arrow);
        this.titlePanel = new JPanel(new FlowLayout(3));
        this.titlePanel.add(this.titleLabel);
        MouseAdapter mouseListener = new MouseAdapter(this){
            private final /* synthetic */ CollapsiblePane $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                this.$outer.setOpen(!this.$outer.isOpen());
            }
        };
        this.titlePanel.addMouseListener(mouseListener);
        this.titleLabel.addMouseListener(mouseListener);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)element, "Center");
    }

    public void setOpen(boolean open) {
        if (this.element.isVisible() != open) {
            this.element.setVisible(open);
            this.arrow.setOpen(open);
            this.parent.pack();
            this.repaint();
            return;
        }
    }

    public boolean isOpen() {
        return this.element.isVisible();
    }

    @Override
    public void syncTheme() {
        this.titlePanel.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.titleLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        JComponent jComponent = this.element;
        if (jComponent instanceof ThemeSync) {
            JComponent ts = (JComponent)((Object)((ThemeSync)((Object)jComponent)));
            ((ThemeSync)((Object)ts)).syncTheme();
            return;
        }
    }
}

