/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.PlainDocument;

public class FixedLengthDocument
extends PlainDocument {
    private final int maxLength;

    public FixedLengthDocument(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) {
        if (this.getLength() + str.length() <= this.maxLength) {
            super.insertString(offset, str.toUpperCase(Locale.ENGLISH), a);
            return;
        }
    }

    @Override
    public void replace(int offset, int length, String str, AttributeSet a) {
        if (this.getLength() - length + str.length() <= this.maxLength) {
            super.replace(offset, length, str.toUpperCase(Locale.ENGLISH), a);
            return;
        }
    }
}

