/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicMenuUI;
import org.nlogo.swing.Menu$;
import org.nlogo.swing.Menu$MenuOrdering$;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.MenuModel;
import org.nlogo.swing.PopupCheckBoxMenuItem;
import org.nlogo.swing.RichAction$;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public class Menu
extends JMenu
implements UserAction.Menu,
ThemeSync {
    private MenuModel<Action, String> menuModel;
    private final BasicMenuUI menuUI;
    private Map<String, Range> groups;
    private Map<String, Tuple2<Menu, String>> subcategories;

    public static Menu$MenuOrdering$ menuOrdering() {
        return Menu$.MODULE$.menuOrdering();
    }

    public Menu(String text, MenuModel<Action, String> menuModel) {
        this.menuModel = menuModel;
        super(text);
        this.menuUI = new ThemeSync(this){
            private final /* synthetic */ Menu $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.arrowIcon = new Icon(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public int getIconWidth() {
                        return 5;
                    }

                    public int getIconHeight() {
                        return 9;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
                        if (this.$outer.org$nlogo$swing$Menu$_$$anon$$$outer().isSelected()) {
                            g2d.setColor(InterfaceColors$.MODULE$.toolbarTextSelected());
                        } else {
                            g2d.setColor(InterfaceColors$.MODULE$.toolbarText());
                        }
                        g2d.drawLine(x, y + 1, x + this.getIconWidth() - 1, y + this.getIconHeight() / 2 + 1);
                        g2d.drawLine(x + this.getIconWidth() - 1, y + this.getIconHeight() / 2 + 1, x, y + this.getIconHeight());
                    }
                };
            }

            public void syncTheme() {
                this.$outer.setForeground(InterfaceColors$.MODULE$.toolbarText());
                this.selectionBackground = InterfaceColors$.MODULE$.menuBackgroundHover();
                this.selectionForeground = InterfaceColors$.MODULE$.menuTextHover();
                this.acceleratorForeground = InterfaceColors$.MODULE$.toolbarText();
                this.acceleratorSelectionForeground = InterfaceColors$.MODULE$.menuTextHover();
                this.disabledForeground = InterfaceColors$.MODULE$.menuTextDisabled();
            }

            public final /* synthetic */ Menu org$nlogo$swing$Menu$_$$anon$$$outer() {
                return this.$outer;
            }
        };
        this.setUI(this.menuUI);
        this.syncTheme();
        this.addMenuListener(new MenuListener(this){
            private final /* synthetic */ Menu $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.getMenuComponents());
                ArrayOps$.MODULE$.foreach$extension(object, Menu::org$nlogo$swing$Menu$$anon$3$$_$menuSelected$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$nlogo$swing$Menu$$anon$3$$_$menuSelected$$anonfun$1(java.awt.Component )}, serializedLambda);
            }
        });
        this.groups = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.subcategories = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public MenuModel<Action, String> menuModel() {
        return this.menuModel;
    }

    public void menuModel_$eq(MenuModel<Action, String> x$1) {
        this.menuModel = x$1;
    }

    public Menu(String text) {
        this(text, Menu$.MODULE$.model());
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = super.getPopupMenu();
        menu.setBackground(InterfaceColors$.MODULE$.menuBackground());
        menu.setBorder(new LineBorder(InterfaceColors$.MODULE$.menuBorder()));
        return menu;
    }

    public JMenuItem addMenuItem(String name, Function0<BoxedUnit> fn) {
        return this.addMenuItem(RichAction$.MODULE$.apply(name, _$2 -> fn.apply$mcV$sp()));
    }

    public JMenuItem addMenuItem(String name, char c, boolean shifted, Function0<BoxedUnit> fn) {
        return this.addMenuItem(c, shifted, (Action)RichAction$.MODULE$.apply(name, _$3 -> fn.apply$mcV$sp()));
    }

    public JMenuItem addMenuItem(String text) {
        return this.addMenuItem(text, '\u0000', false, null, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut) {
        return this.addMenuItem(text, shortcut, false, null, true);
    }

    public JMenuItem addMenuItem(Action action) {
        return this.addMenuItem((String)action.getValue("Name"), action);
    }

    public JMenuItem addMenuItem(String text, Action action) {
        return this.addMenuItem(text, '\u0000', false, action, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut, Action action) {
        return this.addMenuItem(text, shortcut, false, action, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut, Action action, boolean addMenuMask) {
        return this.addMenuItem(text, shortcut, false, action, addMenuMask);
    }

    public JMenuItem addMenuItem(char shortcut, Action action) {
        return this.addMenuItem((String)action.getValue("Name"), shortcut, action, true);
    }

    public JMenuItem addMenuItem(char shortcut, boolean shift, Action action) {
        return this.addMenuItem((String)action.getValue("Name"), shortcut, shift, action, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut, boolean shift) {
        return this.addMenuItem(text, shortcut, shift, null, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut, boolean shift, Action action) {
        return this.addMenuItem(text, shortcut, shift, action, true);
    }

    public JMenuItem addMenuItem(String text, char shortcut, boolean shift, Action action, boolean addMenuMask) {
        int mask;
        MenuItem menuItem;
        if (action == null) {
            menuItem = new MenuItem(text, false);
        } else {
            MenuItem item = new MenuItem(action, false);
            item.setText(text);
            menuItem = item;
        }
        MenuItem item = menuItem;
        int n = mask = shift ? 64 : 0;
        if (shortcut != '\u0000') {
            int menuMask = addMenuMask ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() : 0;
            item.setAccelerator(KeyStroke.getKeyStroke(Char$.MODULE$.char2int(shortcut), mask | menuMask));
        }
        this.add(item);
        return item;
    }

    public Map<String, Range> groups() {
        return this.groups;
    }

    public void groups_$eq(Map<String, Range> x$1) {
        this.groups = x$1;
    }

    public Map<String, Tuple2<Menu, String>> subcategories() {
        return this.subcategories;
    }

    public void subcategories_$eq(Map<String, Tuple2<Menu, String>> x$1) {
        this.subcategories = x$1;
    }

    public void rebuildFromModel(MenuModel<Action, String> mm) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getMenuComponents());
        ArrayOps$.MODULE$.foreach$extension(object, _$4 -> this.remove((Component)_$4));
        mm.children().foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                JMenuItem jMenuItem;
                MenuModel.Node node;
                Option priorGroup = (Option)tuple2._1();
                MenuModel.Node node2 = (MenuModel.Node)tuple2._2();
                if (priorGroup.nonEmpty() && !priorGroup.exists((Function1 & Serializable)_$5 -> {
                    String string = _$5;
                    String string2 = node2.groupName();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    this.addSeparator();
                }
                if ((node = node2) instanceof MenuModel.Branch && ((MenuModel.Branch)node).org$nlogo$swing$MenuModel$Branch$$$outer() == mm) {
                    MenuModel.Branch branch = mm.Branch().unapply((MenuModel.Branch)node);
                    MenuModel<Action, String> menuModel = branch._1();
                    String string = (String)branch._2();
                    String string2 = branch._3();
                    MenuModel<Action, String> model = menuModel;
                    String key = string;
                    String group = string2;
                    Menu subMenu = new Menu((String)this.subcategoryNameAndGroup(key)._1(), model);
                    subMenu.rebuildFromModel(subMenu.menuModel());
                    jMenuItem = subMenu;
                } else if (node instanceof MenuModel.Leaf && ((MenuModel.Leaf)node).org$nlogo$swing$MenuModel$Leaf$$$outer() == mm) {
                    MenuModel.Leaf leaf = mm.Leaf().unapply((MenuModel.Leaf)node);
                    Action action = (Action)leaf._1();
                    String string = leaf._2();
                    Action action2 = action;
                    String group = string;
                    jMenuItem = this.createMenuItem(action2);
                } else {
                    throw new MatchError((Object)node);
                }
                JMenuItem itemToAdd = jMenuItem;
                this.add(itemToAdd);
                return Some$.MODULE$.apply((Object)node2.groupName());
            }
            throw new MatchError((Object)tuple2);
        });
        this.syncTheme();
    }

    private JMenuItem createMenuItem(Action action) {
        JMenuItem jMenuItem;
        Action action2 = action;
        if (action2 instanceof UserAction.CheckBoxAction) {
            Action cba = (Action)((Object)((UserAction.CheckBoxAction)((Object)action2)));
            jMenuItem = new PopupCheckBoxMenuItem(action);
        } else {
            jMenuItem = new MenuItem(action, false);
        }
        return jMenuItem;
    }

    @Override
    public void revokeAction(UserAction.MenuAction action) {
        this.menuModel().removeElement((Action)((Object)action));
        this.rebuildFromModel(this.menuModel());
    }

    @Override
    public void offerAction(UserAction.MenuAction action) {
        Tuple2 tuple2;
        Option<Tuple2<String, String>> option = this.subcategoryItem((Action)((Object)action));
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String subcategoryKey = (String)tuple2._1();
            String subcategoryGroup = (String)tuple2._2();
            MenuModel<Action, String> branch = this.menuModel().createBranch(subcategoryKey, subcategoryGroup);
            branch.insertLeaf((Action)((Object)action), action.group());
        } else if (None$.MODULE$.equals(option)) {
            this.menuModel().insertLeaf((Action)((Object)action), action.group());
        } else {
            throw new MatchError(option);
        }
        this.rebuildFromModel(this.menuModel());
    }

    public Option<Tuple2<String, String>> subcategoryItem(Action action) {
        Object object = action.getValue(UserAction$.MODULE$.ActionSubcategoryKey());
        if (object instanceof String) {
            String key = (String)object;
            Tuple2<String, String> tuple2 = this.subcategoryNameAndGroup(key);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String group = (String)tuple2._2();
            String group2 = group;
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)key, (Object)group2));
        }
        return None$.MODULE$;
    }

    public Tuple2<String, String> subcategoryNameAndGroup(String key) {
        return Tuple2$.MODULE$.apply((Object)key, (Object)UserAction$.MODULE$.DefaultGroup());
    }

    @Override
    public void syncTheme() {
        ((ThemeSync)((Object)this.menuUI)).syncTheme();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.getMenuComponents());
        ArrayOps$.MODULE$.foreach$extension(object, _$6 -> {
            Component component = _$6;
            if (component instanceof ThemeSync) {
                Component ts = (Component)((Object)((ThemeSync)((Object)component)));
                ((ThemeSync)((Object)ts)).syncTheme();
                return;
            }
        });
    }

    public static final /* synthetic */ void org$nlogo$swing$Menu$$anon$3$$_$menuSelected$$anonfun$1(Component _$1) {
        Component component = _$1;
        if (component instanceof MenuItem) {
            MenuItem menu = (MenuItem)component;
            menu.updateEnabled();
            return;
        }
    }
}

