/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JLayeredPane;
import org.nlogo.core.I18N$;
import org.nlogo.swing.SplitPaneDivider;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class SplitPane
extends JLayeredPane {
    private final Component mainComponent;
    private final Component topComponent;
    private final Option<Action> commandCenterToggleAction;
    private final SplitPaneDivider divider;
    private int orientation;
    private int dividerLocation;
    private int lastOpenDividerLocation;
    private final int dividerSize;

    public SplitPane(Component mainComponent, Component topComponent, Option<Action> commandCenterToggleAction) {
        this.mainComponent = mainComponent;
        this.topComponent = topComponent;
        this.commandCenterToggleAction = commandCenterToggleAction;
        this.divider = new SplitPaneDivider(this);
        this.add(mainComponent, JLayeredPane.DEFAULT_LAYER);
        this.add(topComponent, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.divider, JLayeredPane.PALETTE_LAYER);
        this.orientation = 1;
        this.dividerLocation = 0;
        this.lastOpenDividerLocation = 0;
        this.dividerSize = 18;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.revalidate();
        this.dividerChanged();
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int location) {
        this.dividerLocation = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(location), 0)), this.maxClosedDividerLocation());
        this.revalidate();
        this.dividerChanged();
    }

    public void dragDividerLocation(int location) {
        this.lastOpenDividerLocation = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(location), this.minOpenDividerLocation())), this.maxOpenDividerLocation());
        this.dividerLocation = location < this.minOpenDividerLocation() / 2 ? 0 : (location > this.maxOpenDividerLocation() + (this.maxClosedDividerLocation() - this.maxOpenDividerLocation()) / 2 ? this.maxClosedDividerLocation() : this.lastOpenDividerLocation);
        this.revalidate();
        this.dividerChanged();
    }

    private void dividerChanged() {
        this.commandCenterToggleAction.foreach(_$1 -> _$1.putValue("Name", this.dividerLocation < this.maxClosedDividerLocation() ? I18N$.MODULE$.gui().get("menu.tools.hideCommandCenter") : I18N$.MODULE$.gui().get("menu.tools.showCommandCenter")));
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void resetToPreferredSizes() {
        this.setDividerLocation(this.maxOpenDividerLocation());
        this.lastOpenDividerLocation = this.dividerLocation;
    }

    public void resetToLastOpenSizes() {
        this.setDividerLocation(this.lastOpenDividerLocation);
    }

    public int minOpenDividerLocation() {
        return 25;
    }

    public int maxOpenDividerLocation() {
        int n = this.orientation;
        if (1 == n) {
            return this.getHeight() - this.topComponent.getPreferredSize().height - this.dividerSize;
        }
        if (0 == n) {
            return this.getWidth() - this.topComponent.getPreferredSize().width - this.dividerSize;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    public int maxClosedDividerLocation() {
        int n = this.orientation;
        if (1 == n) {
            return this.getHeight() - this.dividerSize;
        }
        if (0 == n) {
            return this.getWidth() - this.dividerSize;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    @Override
    public void doLayout() {
        int n;
        int n2 = this.orientation;
        if (1 == n2) {
            this.mainComponent.setBounds(0, 0, this.getWidth(), this.dividerLocation);
        } else if (0 == n2) {
            this.mainComponent.setBounds(0, 0, this.dividerLocation, this.getHeight());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
        }
        if (this.dividerLocation > this.maxClosedDividerLocation()) {
            this.dividerLocation = this.maxClosedDividerLocation();
        }
        if (1 == (n = this.orientation)) {
            this.topComponent.setBounds(0, this.dividerLocation + this.dividerSize, this.getWidth(), this.getHeight() - this.dividerLocation - this.dividerSize);
            this.divider.setBounds(0, this.dividerLocation, this.getWidth(), this.dividerSize);
        } else if (0 == n) {
            this.topComponent.setBounds(this.dividerLocation + this.dividerSize, 0, this.getWidth() - this.dividerLocation - this.dividerSize, this.getHeight());
            this.divider.setBounds(this.dividerLocation, 0, this.dividerSize, this.getHeight());
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        this.dividerChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.dividerLocation > 0 && this.dividerLocation < this.maxClosedDividerLocation()) {
            int n = this.orientation;
            if (1 == n) {
                this.dividerLocation = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(1), this.dividerLocation + (height - this.getHeight()));
            } else {
                if (0 != n) throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                this.dividerLocation = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(1), this.dividerLocation + (width - this.getWidth()));
            }
        } else if (this.dividerLocation < 0) {
            this.dividerLocation = 0;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.mainComponent.getPreferredSize().width, this.mainComponent.getPreferredSize().height + this.topComponent.getPreferredSize().height + this.dividerSize);
    }
}

