/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.swing.TextActions$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;

public final class TextActions {
    public static void applyToComponent(JTextComponent jTextComponent) {
        TextActions$.MODULE$.applyToComponent(jTextComponent);
    }

    public static class CorrectBackwardAction
    extends TextAction {
        private final JTextComponent comp;

        public CorrectBackwardAction(JTextComponent comp) {
            this.comp = comp;
            super("caret backward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comp.getSelectionStart() == this.comp.getSelectionEnd()) {
                this.comp.setCaretPosition(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.comp.getCaretPosition() - 1), 0));
                return;
            }
            this.comp.setCaretPosition(this.comp.getSelectionStart());
        }
    }

    public static class CorrectDeleteNextWordAction
    extends TextAction {
        private final JTextComponent comp;

        public CorrectDeleteNextWordAction(JTextComponent comp) {
            this.comp = comp;
            super("delete next word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CorrectNextWordAction(this.comp, true).actionPerformed(e);
            this.comp.replaceSelection(null);
        }
    }

    public static class CorrectDeletePrevWordAction
    extends TextAction {
        private final JTextComponent comp;

        public CorrectDeletePrevWordAction(JTextComponent comp) {
            this.comp = comp;
            super("delete previous word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CorrectPreviousWordAction(this.comp, true).actionPerformed(e);
            this.comp.replaceSelection(null);
        }
    }

    public static class CorrectForwardAction
    extends TextAction {
        private final JTextComponent comp;

        public CorrectForwardAction(JTextComponent comp) {
            this.comp = comp;
            super("caret backward");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comp.getSelectionStart() == this.comp.getSelectionEnd()) {
                this.comp.setCaretPosition(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.comp.getCaretPosition() + 1), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.comp.getText()))));
                return;
            }
            this.comp.setCaretPosition(this.comp.getSelectionEnd());
        }
    }

    public static class CorrectNextWordAction
    extends TextAction {
        private final JTextComponent comp;
        private final boolean select;

        public CorrectNextWordAction(JTextComponent comp, boolean select) {
            this.comp = comp;
            this.select = select;
            super("next word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comp.getCaretPosition() < StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.comp.getText()))) {
                if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.comp.getText()), this.comp.getCaretPosition())))) {
                    while (this.comp.getCaretPosition() < StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.comp.getText())) && RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.comp.getText()), this.comp.getCaretPosition())))) {
                        if (this.select) {
                            this.comp.moveCaretPosition(this.comp.getCaretPosition() + 1);
                            continue;
                        }
                        this.comp.setCaretPosition(this.comp.getCaretPosition() + 1);
                    }
                    return;
                }
                if (this.select) {
                    this.comp.moveCaretPosition(this.comp.getCaretPosition() + 1);
                    return;
                }
                this.comp.setCaretPosition(this.comp.getCaretPosition() + 1);
                return;
            }
        }
    }

    public static class CorrectPreviousWordAction
    extends TextAction {
        private final JTextComponent comp;
        private final boolean select;

        public CorrectPreviousWordAction(JTextComponent comp, boolean select) {
            this.comp = comp;
            this.select = select;
            super("previous word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.comp.getCaretPosition() > 0) {
                if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.comp.getText()), this.comp.getCaretPosition() - 1)))) {
                    while (this.comp.getCaretPosition() > 0 && RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.comp.getText()), this.comp.getCaretPosition() - 1)))) {
                        if (this.select) {
                            this.comp.moveCaretPosition(this.comp.getCaretPosition() - 1);
                            continue;
                        }
                        this.comp.setCaretPosition(this.comp.getCaretPosition() - 1);
                    }
                    return;
                }
                if (this.select) {
                    this.comp.moveCaretPosition(this.comp.getCaretPosition() - 1);
                    return;
                }
                this.comp.setCaretPosition(this.comp.getCaretPosition() - 1);
                return;
            }
        }
    }

    public static class CorrectSelectWordAction
    extends TextAction {
        private final JTextComponent comp;

        public CorrectSelectWordAction(JTextComponent comp) {
            this.comp = comp;
            super("select word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CorrectPreviousWordAction(this.comp, false).actionPerformed(e);
            new CorrectNextWordAction(this.comp, true).actionPerformed(e);
        }
    }
}

