/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import org.nlogo.core.I18N$;
import org.nlogo.swing.CenteredImageIcon;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.ScalableIcon;
import scala.Function1;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Utils$
implements Serializable {
    private static double uiScale;
    public static final Utils$ MODULE$;

    private Utils$() {
    }

    static {
        MODULE$ = new Utils$();
        uiScale = 1.0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Utils$.class);
    }

    public double getUIScale() {
        return uiScale;
    }

    public void setUIScale(double value) {
        uiScale = value;
    }

    public ImageIcon icon(String path) {
        return new ImageIcon(this.getClass().getResource(path));
    }

    public ImageIcon icon(String path, int w, int h) {
        return new CenteredImageIcon(this.icon(path), w, h);
    }

    public ScalableIcon iconScaled(String path, int width, int height) {
        return new ScalableIcon(new ImageIcon(this.icon(path).getImage().getScaledInstance((int)((double)width * uiScale), (int)((double)height * uiScale), 4)), width, height);
    }

    public ScalableIcon iconScaledWithColor(String path, int width, int height, Color color) {
        ScalableIcon image = this.iconScaled(path, width, height);
        BufferedImage buffered = new BufferedImage(width * 2, height * 2, 2);
        image.paintIcon(null, buffered.getGraphics(), 0, 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffered.getHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)y -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffered.getWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x -> {
            int c1 = buffered.getRGB(x, y);
            int c2 = color.getRGB();
            int r = (c1 & 0xFF) * (c2 & 0xFF) / 255;
            int g = (c1 >> 8 & 0xFF) * (c2 >> 8 & 0xFF) / 255;
            int b = (c1 >> 16 & 0xFF) * (c2 >> 16 & 0xFF) / 255;
            int a = (c1 >> 24 & 0xFF) * (c2 >> 24 & 0xFF) / 255;
            buffered.setRGB(x, y, r | g << 8 | b << 16 | a << 24);
        }));
        return new ScalableIcon(new ImageIcon(buffered), width, height);
    }

    public Font font(String path) {
        return Font.createFont(0, this.getClass().getResourceAsStream(path));
    }

    public void alert(String message, String continueText) {
        new OptionPane(null, I18N$.MODULE$.gui().get("common.messages.notice"), message, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)continueText, (List)Nil$.MODULE$))), OptionPane$Icons$.MODULE$.Info());
    }

    public void alert(String title, String message, String details, String continueText) {
        new OptionPane(null, title, message + "\n\n" + details, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)continueText, (List)Nil$.MODULE$))), OptionPane$Icons$.MODULE$.Info());
    }

    public void addEscKeyAction(JDialog dialog, Action action) {
        this.addEscKeyAction(dialog.getRootPane(), action);
    }

    public void addEscKeyAction(JWindow window, Action action) {
        this.addEscKeyAction(window.getRootPane(), action);
    }

    public void addEscKeyAction(JComponent component, Action action) {
        this.addEscKeyAction(component, component.getInputMap(2), action);
    }

    public void addEscKeyAction(JComponent component, InputMap inputMap, Action action) {
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "ESC_ACTION");
        component.getActionMap().put("ESC_ACTION", action);
    }

    public Graphics2D initGraphics2D(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2d;
    }
}

