/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.api.StringUtils$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Pen;
import org.nlogo.core.Pen$;
import org.nlogo.core.Plot$;
import org.nlogo.plot.PenListener;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotLoader$;
import org.nlogo.plot.PlotManagerInterface;
import org.nlogo.plot.PlotPen;
import org.nlogo.swing.MouseUtils;
import org.nlogo.swing.RoundedBorderPanel;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.AbstractPlotWidget$;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.PlotCanvas;
import org.nlogo.window.PlotLegend;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Widget;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class AbstractPlotWidget
extends Widget
implements Editable,
Plot.DirtyListener,
Events.AfterLoadEvent.Handler,
Events.WidgetRemovedEvent.Handler,
Events.CompiledEvent.Handler {
    private final Plot plot;
    private final PlotManagerInterface plotManager;
    private final String originalName;
    private boolean fullyConstructed;
    private final PlotCanvas canvas;
    private final CanvasPanel canvasPanel;
    public final PlotLegend org$nlogo$window$AbstractPlotWidget$$legend;
    private final JLabel nameLabel;
    private final XAxisLabels xAxis;
    private final YAxisLabels yAxis;
    private String _xAxisLabel;
    private String _yAxisLabel;

    public static Dimension MIN_SIZE() {
        return AbstractPlotWidget$.MODULE$.MIN_SIZE();
    }

    public static Dimension PREF_SIZE() {
        return AbstractPlotWidget$.MODULE$.PREF_SIZE();
    }

    public AbstractPlotWidget(Plot plot, PlotManagerInterface plotManager) {
        this.plot = plot;
        this.plotManager = plotManager;
        this.originalName = plot.name();
        this.fullyConstructed = false;
        plot.dirtyListener_$eq((Option<Plot.DirtyListener>)Some$.MODULE$.apply((Object)this));
        this.canvas = new PlotCanvas(plot);
        this.canvasPanel = new CanvasPanel(this.canvas());
        this.org$nlogo$window$AbstractPlotWidget$$legend = new PlotLegend(this);
        this.nameLabel = new JLabel(this.originalName);
        this.xAxis = new XAxisLabels(this);
        this.yAxis = new YAxisLabels(this);
        plot.addPenListener(new PenListener(this){
            private final /* synthetic */ AbstractPlotWidget $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void penAdded() {
                this.$outer.org$nlogo$window$AbstractPlotWidget$$legend.refresh();
            }
        });
        this.displayName(this.originalName);
        plot.clear();
        this.setLayout(new GridBagLayout());
        this.initGUI();
        this._xAxisLabel = "";
        this._yAxisLabel = "";
        this.fullyConstructed = true;
    }

    public Plot plot() {
        return this.plot;
    }

    public PlotManagerInterface plotManager() {
        return this.plotManager;
    }

    public PlotCanvas canvas() {
        return this.canvas;
    }

    @Override
    public void initGUI() {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = this._oldSize() ? new Insets(this.zoom(3.0), this.zoom(6.0), this.zoom(6.0), this.zoom(6.0)) : new Insets(this.zoom(8.0), this.zoom(10.0), this.zoom(8.0), this.zoom(10.0));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.anchor = 10;
        this.add((Component)this.nameLabel, c);
        this.nameLabel.setText(this.plot().name());
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(this._boldState()));
        c.insets = new Insets(0, this.zoom(3.0), this.zoom(3.0), this.zoom(8.0));
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 3;
        this.add((Component)this.yAxis, c);
        this.yAxis.setBoldState(this._boldState());
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, this.zoom(3.0), this.zoom(8.0));
        this.add((Component)this.canvasPanel, c);
        c.insets = new Insets(0, this.zoom(3.0), 0, this.zoom(3.0));
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.xAxis, c);
        this.xAxis.setBoldState(this._boldState());
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.insets = new Insets(this.zoom(2.0), this.zoom(10.0), this.zoom(8.0), this.zoom(10.0));
        this.add((Component)this.org$nlogo$window$AbstractPlotWidget$$legend, c);
        this.org$nlogo$window$AbstractPlotWidget$$legend.setBoldState(this._boldState());
        this.refreshGUI();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setBackgroundColor(InterfaceColors$.MODULE$.plotBackground());
        this.recolor();
        super.paintComponent(g);
        this.nameLabel.setToolTipText(this.nameLabel.getPreferredSize().width > this.nameLabel.getSize().width ? this.plotName() : null);
    }

    public void refreshGUI() {
        this.xAxis.setMin(AbstractPlotWidget.getLabel$1(this.plot().xMin()));
        this.xAxis.setMax(AbstractPlotWidget.getLabel$1(this.plot().xMax()));
        this.yAxis.setMin(AbstractPlotWidget.getLabel$1(this.plot().yMin()));
        this.yAxis.setMax(AbstractPlotWidget.getLabel$1(this.plot().yMax()));
        if (this.plot().pensDirty()) {
            this.org$nlogo$window$AbstractPlotWidget$$legend.refresh();
            this.plot().pensDirty_$eq(false);
            return;
        }
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.plot");
    }

    @Override
    public void makeDirty() {
        if (this.fullyConstructed) {
            this.canvas().makeDirty();
            return;
        }
    }

    @Override
    public Option<String> helpLink() {
        return Some$.MODULE$.apply((Object)"programming.html#plotting");
    }

    public int legendHeight() {
        return this.org$nlogo$window$AbstractPlotWidget$$legend.getHeight();
    }

    public boolean showLegend() {
        return this.org$nlogo$window$AbstractPlotWidget$$legend.open();
    }

    public void setShowLegend(boolean open) {
        this.org$nlogo$window$AbstractPlotWidget$$legend.open_$eq(open);
    }

    public Option<Exception> runtimeError() {
        return this.plot().runtimeError();
    }

    public void setRuntimeError(Option<Exception> e) {
        this.plot().runtimeError_$eq(e);
    }

    public List<PlotPen> editPlotPens() {
        return this.plot().pens();
    }

    public void setEditPlotPens(List<PlotPen> pens) {
        if (this.plot().pens() != pens) {
            this.plot().pens_$eq(pens);
            return;
        }
    }

    public void togglePenList() {
        this.org$nlogo$window$AbstractPlotWidget$$legend.toggle();
    }

    public void clear() {
        this.plot().clear();
        this.org$nlogo$window$AbstractPlotWidget$$legend.refresh();
    }

    public String plotName() {
        return this.plot().name();
    }

    public void setPlotName(String name) {
        this.plot().name(name);
        if (name.isEmpty()) {
            this.displayName(this.originalName);
        } else {
            this.displayName(this.plot().name());
        }
        this.nameLabel.setText(this.displayName());
    }

    public String xLabel() {
        return this.xAxis.getLabel();
    }

    public void setXLabel(String label) {
        this._xAxisLabel = label;
        this.xAxis.setLabel(this._xAxisLabel);
    }

    public String yLabel() {
        return this.yAxis.getLabel();
    }

    public void setYLabel(String label) {
        this._yAxisLabel = label;
        this.yAxis.setLabel(this._yAxisLabel);
    }

    public String setupCode() {
        return this.plot().setupCode();
    }

    public void setSetupCode(String setupCode) {
        this.plot().setupCode_$eq(setupCode);
    }

    public String updateCode() {
        return this.plot().updateCode();
    }

    public void setUpdateCode(String updateCode) {
        this.plot().updateCode_$eq(updateCode);
    }

    public double defaultXMin() {
        return this.plot().defaultXMin();
    }

    public void setDefaultXMin(double defaultXMin) {
        this.plot().defaultXMin_$eq(defaultXMin);
    }

    public double defaultYMin() {
        return this.plot().defaultYMin();
    }

    public void setDefaultYMin(double defaultYMin) {
        this.plot().defaultYMin_$eq(defaultYMin);
    }

    public double defaultXMax() {
        return this.plot().defaultXMax();
    }

    public void setDefaultXMax(double defaultXMax) {
        this.plot().defaultXMax_$eq(defaultXMax);
    }

    public double defaultYMax() {
        return this.plot().defaultYMax();
    }

    public void setDefaultYMax(double defaultYMax) {
        this.plot().defaultYMax_$eq(defaultYMax);
    }

    public boolean defaultAutoPlotX() {
        return this.plot().defaultAutoPlotX();
    }

    public void setDefaultAutoPlotX(boolean defaultAutoPlotX) {
        this.plot().defaultAutoPlotX_$eq(defaultAutoPlotX);
    }

    public boolean defaultAutoPlotY() {
        return this.plot().defaultAutoPlotY();
    }

    public void setDefaultAutoPlotY(boolean defaultAutoPlotY) {
        this.plot().defaultAutoPlotY_$eq(defaultAutoPlotY);
    }

    @Override
    public Dimension getMinimumSize() {
        return AbstractPlotWidget$.MODULE$.MIN_SIZE();
    }

    @Override
    public Dimension getPreferredSize() {
        return AbstractPlotWidget$.MODULE$.PREF_SIZE();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.org$nlogo$window$AbstractPlotWidget$$legend.revalidate();
    }

    @Override
    public void syncTheme() {
        this.canvasPanel.syncTheme();
    }

    public void savePens(StringBuilder s) {
        this.plot().pens().withFilter((Function1 & Serializable)pen -> !pen.temporary()).foreach((Function1 & Serializable)pen -> s.append("\"" + StringUtils$.MODULE$.escapeString(pen.name()) + "\" " + pen.defaultInterval() + " " + pen.defaultMode() + " " + pen.defaultColor() + " " + pen.inLegend() + " " + pen.saveString() + "\n"));
    }

    @Override
    public void load(org.nlogo.core.Widget model) {
        org.nlogo.core.Widget widget = model;
        if (widget instanceof org.nlogo.core.Plot) {
            org.nlogo.core.Plot corePlot = (org.nlogo.core.Plot)widget;
            this.oldSize(corePlot.oldSize());
            this.setSize(corePlot.width(), corePlot.height());
            this.setXLabel(this.RichStringOption(corePlot.xAxis()).optionToPotentiallyEmptyString());
            this.setYLabel(this.RichStringOption(corePlot.yAxis()).optionToPotentiallyEmptyString());
            this.org$nlogo$window$AbstractPlotWidget$$legend.open_$eq(corePlot.legendOn());
            PlotLoader$.MODULE$.loadPlot(corePlot, this.plot());
            this.setPlotName(this.plot().name());
            this.clear();
            return;
        }
    }

    @Override
    public org.nlogo.core.Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        Option<String> displayName = this.RichWidgetString(this.plotName()).potentiallyEmptyStringToOption();
        Option<String> savedXLabel = this.RichWidgetString(this.xLabel()).potentiallyEmptyStringToOption();
        Option<String> savedYLabel = this.RichWidgetString(this.yLabel()).potentiallyEmptyStringToOption();
        List pens = (List)this.plot().pens().withFilter((Function1 & Serializable)pen -> !pen.temporary()).map((Function1 & Serializable)pen -> Pen$.MODULE$.apply(pen.name(), pen.defaultInterval(), pen.defaultMode(), pen.defaultColor(), pen.inLegend(), pen.setupCode(), pen.updateCode()));
        return Plot$.MODULE$.apply(displayName, b.x, b.y, b.width, b.height, this._oldSize(), savedXLabel, savedYLabel, this.plot().defaultXMin(), this.plot().defaultXMax(), this.plot().defaultYMin(), this.plot().defaultYMax(), this.plot().defaultAutoPlotX(), this.plot().defaultAutoPlotY(), this.org$nlogo$window$AbstractPlotWidget$$legend.open(), this.plot().setupCode(), this.plot().updateCode(), (List<Pen>)pens.toList());
    }

    public BufferedImage exportGraphics() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paint(image.getGraphics());
        return image;
    }

    public void recolor() {
        this.nameLabel.setForeground(this.anyErrors() ? InterfaceColors$.MODULE$.widgetTextError() : InterfaceColors$.MODULE$.widgetText());
        if (this.error("setupCode").isDefined()) {
            new Events.WidgetErrorEvent(this, this.error("setupCode")).raise(this);
            return;
        }
        if (this.error("updateCode").isDefined()) {
            new Events.WidgetErrorEvent(this, this.error("updateCode")).raise(this);
            return;
        }
        new Events.WidgetErrorEvent(this, (Option<Exception>)None$.MODULE$).raise(this);
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.plotManager().compilePlot(this.plot());
        this.recolor();
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        Widget widget = e.widget;
        AbstractPlotWidget abstractPlotWidget = this;
        if (!(widget != null ? !widget.equals(abstractPlotWidget) : abstractPlotWidget != null)) {
            this.plotManager().forgetPlot(this.plot());
            return;
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        if (e.sourceOwner instanceof ProceduresInterface) {
            this.plotManager().compilePlot(this.plot());
            this.recolor();
            return;
        }
    }

    @Override
    public boolean anyErrors() {
        return this.plotManager().hasErrors(this.plot());
    }

    public Nothing$ removeAllErrors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<Exception> error(Object key) {
        Object object = key;
        String string = I18N$.MODULE$.gui().get("edit.plot.setupCode");
        if (!(object != null ? !object.equals(string) : string != null)) {
            return this.plotManager().getPlotSetupError(this.plot());
        }
        Object object2 = key;
        String string2 = I18N$.MODULE$.gui().get("edit.plot.updateCode");
        if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
            return this.plotManager().getPlotUpdateError(this.plot());
        }
        return None$.MODULE$;
    }

    @Override
    public void error(Object key, Exception e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<String> errorString() {
        boolean hasDuplicatedName;
        boolean bl = hasDuplicatedName = ((SeqOps)((IterableOps)this.widgetContainer().map((Function1 & Serializable)_$1 -> _$1.allWidgets()).getOrElse(AbstractPlotWidget::$anonfun$4)).collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ AbstractPlotWidget $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(org.nlogo.core.Widget x) {
                org.nlogo.core.Widget widget = x;
                if (widget instanceof org.nlogo.core.Plot) {
                    org.nlogo.core.Plot p = (org.nlogo.core.Plot)widget;
                    Object object = p.display().map(AbstractPlotWidget::org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$1).getOrElse(AbstractPlotWidget::org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$2);
                    String string = this.$outer.plotName().toUpperCase(Locale.ENGLISH);
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(org.nlogo.core.Widget x, Function1 function1) {
                org.nlogo.core.Widget widget = x;
                if (widget instanceof org.nlogo.core.Plot) {
                    org.nlogo.core.Plot p = (org.nlogo.core.Plot)widget;
                    Object object = p.display().map(AbstractPlotWidget::org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$1).getOrElse(AbstractPlotWidget::org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$2);
                    String string = this.$outer.plotName().toUpperCase(Locale.ENGLISH);
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        return p;
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$1(java.lang.String ), org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$2(), org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.String ), org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$2()}, serializedLambda);
            }
        })).length() > 1;
        if (hasDuplicatedName) {
            return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().getN("edit.plot.name.duplicate", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.plotName().toUpperCase(Locale.ENGLISH)})));
        }
        return None$.MODULE$;
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.plotManager().compilePlot(this.plot());
        this.nameLabel.setText(this.plot().name());
        this.xAxis.setLabel(this._xAxisLabel);
        this.yAxis.setLabel(this._yAxisLabel);
        this.recolor();
        this.clear();
        return true;
    }

    private static final String getLabel$1(double d) {
        if (BoxesRunTime.boxToDouble((double)d).toString().endsWith(".0")) {
            return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(BoxesRunTime.boxToDouble((double)d).toString()), 2);
        }
        return BoxesRunTime.boxToDouble((double)d).toString();
    }

    private static final Seq $anonfun$4() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    public static final /* synthetic */ String org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$1(String _$2) {
        return _$2.toUpperCase(Locale.ENGLISH);
    }

    public static final String org$nlogo$window$AbstractPlotWidget$$anon$2$$_$isDefinedAt$$anonfun$2() {
        return "";
    }

    public static final /* synthetic */ String org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$1(String _$2) {
        return _$2.toUpperCase(Locale.ENGLISH);
    }

    public static final String org$nlogo$window$AbstractPlotWidget$$anon$2$$_$applyOrElse$$anonfun$2() {
        return "";
    }

    public class CanvasPanel
    extends JPanel
    implements Transparent,
    MouseUtils,
    RoundedBorderPanel,
    ThemeSync {
        private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
        private boolean org$nlogo$swing$MouseUtils$$hover;
        private boolean org$nlogo$swing$MouseUtils$$pressed;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$borderColor;
        private int org$nlogo$swing$RoundedBorderPanel$$diameter;
        private boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        private boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;

        public CanvasPanel(PlotCanvas canvas) {
            if (AbstractPlotWidget.this == null) {
                throw new NullPointerException();
            }
            Transparent.$init$(this);
            MouseUtils.$init$(this);
            RoundedBorderPanel.$init$(this);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(AbstractPlotWidget.this.zoom(3.0), AbstractPlotWidget.this.zoom(3.0), AbstractPlotWidget.this.zoom(3.0), AbstractPlotWidget.this.zoom(3.0));
            this.add((Component)canvas, c);
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
            return this.org$nlogo$swing$MouseUtils$$useHandCursor;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$hover() {
            return this.org$nlogo$swing$MouseUtils$$hover;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$pressed() {
            return this.org$nlogo$swing$MouseUtils$$pressed;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$hover = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$pressed = x$1;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$borderColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$borderColor;
        }

        @Override
        public int org$nlogo$swing$RoundedBorderPanel$$diameter() {
            return this.org$nlogo$swing$RoundedBorderPanel$$diameter;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$borderColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$borderColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$diameter_$eq(int x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$diameter = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$hoverEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$pressedEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled = x$1;
        }

        @Override
        public /* synthetic */ void org$nlogo$swing$RoundedBorderPanel$$super$paintComponent(Graphics x$0) {
            super.paintComponent(x$0);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setDiameter(Int$.MODULE$.int2double(AbstractPlotWidget.this.zoom(6.0)));
            RoundedBorderPanel.paintComponent$(this, g);
        }

        @Override
        public void syncTheme() {
            this.setBackgroundColor(Color.WHITE);
            this.setBorderColor(InterfaceColors$.MODULE$.plotBorder());
        }

        public final /* synthetic */ AbstractPlotWidget org$nlogo$window$AbstractPlotWidget$CanvasPanel$$$outer() {
            return AbstractPlotWidget.this;
        }
    }

    public static class VerticalLabel
    extends JPanel {
        private String text = "";

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getFont().getSize(), super.getPreferredSize().height);
        }

        @Override
        public void paintComponent(Graphics g) {
            Object object;
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            g2d.setColor(InterfaceColors$.MODULE$.widgetText());
            g2d.setFont(this.getFont());
            FontMetrics metrics = g2d.getFontMetrics();
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-this.getHeight(), metrics.getAscent() - metrics.getDescent());
            if (metrics.stringWidth(this.text) > this.getHeight()) {
                String shortened = this.text;
                while (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(shortened)) && metrics.stringWidth(shortened + "...") > this.getHeight()) {
                    shortened = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(shortened), 1);
                }
                object = shortened + "...";
            } else {
                object = this.text;
            }
            String finalText = object;
            g2d.drawString(finalText, this.getHeight() / 2 - metrics.stringWidth(finalText) / 2, 0);
        }
    }

    public static class XAxisLabels
    extends JPanel {
        private final JLabel min = new JLabel();
        private final JLabel label = new JLabel("", 0);
        private final JLabel max = new JLabel();
        private final GridBagLayout gridbag = new GridBagLayout();
        private final GridBagConstraints c;

        public XAxisLabels(AbstractPlotWidget plot) {
            this.setLayout(this.gridbag());
            this.c = new GridBagConstraints();
            this.c().insets = new Insets(0, 0, 0, plot.zoom(3.0));
            this.c().gridheight = 1;
            this.c().weighty = 0.0;
            this.c().fill = 0;
            this.c().gridwidth = 1;
            this.c().weightx = 0.0;
            this.c().anchor = 17;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.min, this.c());
            this.add(this.min);
            this.c().weightx = 100.0;
            this.c().anchor = 10;
            this.c().fill = 2;
            this.gridbag().setConstraints(this.label, this.c());
            this.add(this.label);
            this.c().gridwidth = 0;
            this.c().weightx = 0.0;
            this.c().anchor = 13;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.max, this.c());
            this.add(this.max);
        }

        public GridBagLayout gridbag() {
            return this.gridbag;
        }

        public GridBagConstraints c() {
            return this.c;
        }

        public void setBoldState(int state) {
            this.min.setFont(this.min.getFont().deriveFont(state));
            this.label.setFont(this.label.getFont().deriveFont(state));
            this.max.setFont(this.max.getFont().deriveFont(state));
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setBackground(InterfaceColors$.MODULE$.plotBackground());
            this.min.setForeground(InterfaceColors$.MODULE$.widgetText());
            this.label.setForeground(InterfaceColors$.MODULE$.widgetText());
            this.max.setForeground(InterfaceColors$.MODULE$.widgetText());
            this.label.setToolTipText(this.label.getPreferredSize().width > this.label.getSize().width ? this.getLabel() : null);
            super.paintComponent(g);
        }

        public void setLabel(String text) {
            this.label.setText(text);
        }

        public void setMax(String text) {
            this.max.setText(text);
        }

        public void setMin(String text) {
            this.min.setText(text);
        }

        public String getLabel() {
            return this.label.getText();
        }
    }

    public static class YAxisLabels
    extends JPanel {
        private final VerticalLabel label = new VerticalLabel();
        private final JLabel max = new JLabel();
        private final JLabel min = new JLabel();
        private final GridBagLayout gridbag = new GridBagLayout();
        private final GridBagConstraints c;

        public YAxisLabels(AbstractPlotWidget plot) {
            this.setLayout(this.gridbag());
            this.c = new GridBagConstraints();
            this.c().insets = new Insets(plot.zoom(3.0), 0, 0, 0);
            this.c().gridwidth = 0;
            this.c().gridheight = 1;
            this.c().weightx = 1.0;
            this.c().weighty = 0.0;
            this.c().anchor = 13;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.max, this.c());
            this.add(this.max);
            this.c().weighty = 100.0;
            this.c().fill = 3;
            this.gridbag().setConstraints(this.label, this.c());
            this.add(this.label);
            this.c().gridheight = 0;
            this.c().weighty = 0.0;
            this.c().fill = 0;
            this.gridbag().setConstraints(this.min, this.c());
            this.add(this.min);
        }

        public GridBagLayout gridbag() {
            return this.gridbag;
        }

        public GridBagConstraints c() {
            return this.c;
        }

        public void setBoldState(int state) {
            this.min.setFont(this.min.getFont().deriveFont(state));
            this.label.setFont(this.label.getFont().deriveFont(state));
            this.max.setFont(this.max.getFont().deriveFont(state));
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setBackground(InterfaceColors$.MODULE$.plotBackground());
            this.min.setForeground(InterfaceColors$.MODULE$.widgetText());
            this.max.setForeground(InterfaceColors$.MODULE$.widgetText());
            if (this.label.getPreferredSize().width > this.label.getWidth()) {
                this.label.setToolTipText(this.label.getText());
            } else {
                this.label.setToolTipText(null);
            }
            super.paintComponent(g);
        }

        public void setMin(String text) {
            this.min.setText(text);
        }

        public void setMax(String text) {
            this.max.setText(text);
        }

        public String getLabel() {
            return this.label.getText();
        }

        public void setLabel(String text) {
            this.label.setText(text);
            this.label.revalidate();
            this.label.repaint();
        }
    }
}

