/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.agent.CompilationManagement;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.ValueConstraint;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Program;
import org.nlogo.core.Program$;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.PresentationCompilerInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.window.CompilerManager$;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileInterface;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.JobWidget;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.Widget;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class CompilerManager
implements Event.LinkChild,
Events.CompileMoreSourceEvent.Handler,
Events.InterfaceGlobalEvent.Handler,
Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.WidgetAddedEvent.Handler,
Events.WidgetRemovedEvent.Handler,
Events.CompileAllEvent.Handler {
    private final AbstractWorkspace workspace;
    private final World world;
    private final ProceduresInterface proceduresInterface;
    private final Function2<Event, Object, BoxedUnit> eventRaiser;
    private final HashSet<JobOwner> widgets;
    private final HashSet<InterfaceGlobalWidget> globalWidgets;
    private boolean isLoading;

    public static World $lessinit$greater$default$2() {
        return CompilerManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static Function2<Event, Object, BoxedUnit> $lessinit$greater$default$4() {
        return CompilerManager$.MODULE$.$lessinit$greater$default$4();
    }

    public CompilerManager(AbstractWorkspace workspace, World world, ProceduresInterface proceduresInterface, Function2<Event, Object, BoxedUnit> eventRaiser) {
        this.workspace = workspace;
        this.world = world;
        this.proceduresInterface = proceduresInterface;
        this.eventRaiser = eventRaiser;
        this.widgets = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JobOwner[0]));
        this.globalWidgets = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InterfaceGlobalWidget[0]));
        this.isLoading = false;
    }

    public AbstractWorkspace workspace() {
        return this.workspace;
    }

    public World world() {
        return this.world;
    }

    public ProceduresInterface proceduresInterface() {
        return this.proceduresInterface;
    }

    public HashSet<JobOwner> widgets() {
        return this.widgets;
    }

    public HashSet<InterfaceGlobalWidget> globalWidgets() {
        return this.globalWidgets;
    }

    private void raiseEvent(Event e) {
        this.eventRaiser.apply((Object)e, (Object)this);
    }

    @Override
    public Object getLinkParent() {
        return this.workspace();
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.isLoading = true;
        this.widgets().clear();
        this.globalWidgets().clear();
        this.world().clearLinks();
        ((CompilationManagement)((Object)this.world())).program(Program$.MODULE$.fromDialect(this.workspace().dialect()));
        ((CompilationManagement)((Object)this.world())).rememberOldProgram();
        ((CompilationManagement)((Object)this.world())).program(Program$.MODULE$.fromDialect(this.workspace().dialect()));
        this.world().setUpShapes(true);
    }

    @Override
    public void handle(Events.LoadEndEvent e) {
        this.isLoading = false;
        Program program = Program$.MODULE$.fromDialect(this.workspace().dialect());
        ((CompilationManagement)((Object)this.world())).program(program.copy(this.getGlobalVariableNames(), program.copy$default$2(), program.copy$default$3(), program.copy$default$4(), program.copy$default$5(), program.copy$default$6(), program.copy$default$7(), program.copy$default$8()));
        ((CompilationManagement)((Object)this.world())).realloc();
        this.compileAll();
        this.world().clearAll();
    }

    @Override
    public void handle(Events.CompileMoreSourceEvent e) {
        JobOwner owner = e.owner;
        if (this.isLoading) {
            this.widgets().$plus$eq((Object)owner);
            return;
        }
        if (!owner.isCommandCenter()) {
            this.compileWidgets();
            return;
        }
        try {
            Some displayName = Some$.MODULE$.apply((Object)owner.classDisplayName());
            PresentationCompilerInterface presentationCompilerInterface = this.workspace().compiler();
            CompilerResults results = presentationCompilerInterface.compileMoreCode(owner.source(), (Option<String>)displayName, ((CompilationManagement)((Object)this.world())).program(), this.workspace().procedures(), this.workspace().getExtensionManager(), this.workspace().getLibraryManager(), this.workspace().getCompilationEnvironment(), presentationCompilerInterface.compileMoreCode$default$8());
            results.head().init(this.workspace());
            results.head().owner_$eq(owner);
            this.raiseEvent(new Events.CompiledEvent(owner, ((CompilationManagement)((Object)this.world())).program(), results.head(), null));
        }
        catch (CompilerException error) {
            this.raiseEvent(new Events.CompiledEvent(owner, ((CompilationManagement)((Object)this.world())).program(), null, error));
        }
    }

    @Override
    public void handle(Events.InterfaceGlobalEvent e) {
        InterfaceGlobalWidget widget = e.widget;
        this.globalWidgets().$plus$eq((Object)e.widget);
        if (e.nameChanged) {
            this.compileAll();
            return;
        }
        if (this.world().observerOwnsIndexOf(widget.name().toUpperCase(Locale.ENGLISH)) != -1) {
            block10: {
                if (e.updating) {
                    widget.valueObject(this.world().getObserverVariableByName(widget.name()));
                }
                try {
                    Object widgetValue = widget.valueObject();
                    if (widgetValue == this.world().getObserverVariableByName(widget.name())) break block10;
                    World world = this.world();
                    synchronized (world) {
                        this.world().setObserverVariableByName(widget.name(), widgetValue);
                    }
                }
                catch (ValueConstraint.Violation ex) {
                    Exceptions$.MODULE$.ignore(ex);
                }
                catch (AgentException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (LogoException ex) {
                    Exceptions$.MODULE$.ignore(ex);
                }
            }
            return;
        }
    }

    @Override
    public void handle(Events.CompileAllEvent e) {
        this.compileAll();
    }

    @Override
    public void handle(Events.WidgetAddedEvent e) {
        BoxedUnit boxedUnit;
        Object object = e.widget;
        if (object instanceof JobOwner) {
            JobOwner jobOwner = (JobOwner)object;
            boxedUnit = this.widgets().$plus$eq((Object)jobOwner);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object2 = e.widget;
        if (object2 instanceof InterfaceGlobalWidget) {
            InterfaceGlobalWidget interfaceGlobal = (InterfaceGlobalWidget)object2;
            this.globalWidgets().$plus$eq((Object)interfaceGlobal);
            return;
        }
    }

    @Override
    public void handle(Events.WidgetRemovedEvent e) {
        BoxedUnit boxedUnit;
        Widget widget = e.widget;
        if (widget instanceof JobOwner) {
            Widget jobOwner = (Widget)((Object)((JobOwner)((Object)widget)));
            boxedUnit = this.widgets().$minus$eq((Object)jobOwner);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Widget widget2 = e.widget;
        if (widget2 instanceof InterfaceGlobalWidget) {
            Widget interfaceGlobal = (Widget)((Object)((InterfaceGlobalWidget)((Object)widget2)));
            this.globalWidgets().$minus$eq((Object)interfaceGlobal);
            return;
        }
    }

    private void compileAll() {
        this.raiseEvent(new Events.RemoveAllJobsEvent());
        this.world().displayOn(true);
        if (!this.isLoading) {
            boolean proceed = this.compileProcedures();
            if (proceed) {
                ((CompilationManagement)((Object)this.world())).realloc();
                ((CompilationManagement)((Object)this.world())).rememberOldProgram();
                this.setGlobalVariables();
                this.compileWidgets();
                return;
            }
            this.setGlobalVariables();
            this.updateInterfaceGlobalConstraints();
            this.resetWidgetProcedures();
            return;
        }
    }

    private boolean compileProcedures() {
        boolean bl;
        Program program = Program$.MODULE$.fromDialect(this.workspace().dialect());
        Program program2 = program.copy(this.getGlobalVariableNames(), program.copy$default$2(), program.copy$default$3(), program.copy$default$4(), program.copy$default$5(), program.copy$default$6(), program.copy$default$7(), program.copy$default$8());
        ((CompilationManagement)((Object)this.world())).program(program2);
        try {
            Seq owners = this.workspace().aggregateManager() != null ? (Seq)((SeqOps)new .colon.colon((Object)this.workspace().aggregateManager(), (List)Nil$.MODULE$)) : (Seq)((SeqOps)Nil$.MODULE$);
            CompilerResults results = this.workspace().compiler().compileProgram(this.proceduresInterface().innerSource(), (Seq<SourceOwner>)owners, program2, this.workspace().getExtensionManager(), this.workspace().getLibraryManager(), this.workspace().getCompilationEnvironment(), false);
            this.workspace().setProcedures(results.proceduresMap());
            this.workspace().procedures().values().foreach(procedure -> {
                SourceOwner sourceOwner;
                String string = procedure.filename();
                if ("".equals(string)) {
                    sourceOwner = this.proceduresInterface();
                } else if ("aggregate".equals(string)) {
                    sourceOwner = this.workspace().aggregateManager();
                } else {
                    String fileName = string;
                    sourceOwner = new ExternalFileInterface(fileName);
                }
                ProceduresInterface owner = sourceOwner;
                procedure.owner_$eq(owner);
            });
            this.workspace().init();
            ((CompilationManagement)((Object)this.world())).program(results.program());
            this.raiseEvent(new Events.CompiledEvent(this.proceduresInterface(), results.program(), null, null));
            bl = true;
        }
        catch (CompilerException error) {
            SourceOwner sourceOwner;
            String string = error.filename();
            if ("".equals(string)) {
                sourceOwner = this.proceduresInterface();
            } else if ("aggregate".equals(string)) {
                sourceOwner = this.workspace().aggregateManager();
            } else {
                String fileName = string;
                sourceOwner = new ExternalFileInterface(fileName);
            }
            ProceduresInterface errorSource = sourceOwner;
            this.raiseEvent(new Events.CompiledEvent(errorSource, null, null, error));
            bl = false;
        }
        return bl;
    }

    private void setGlobalVariables() {
        this.globalWidgets().foreach(widget -> {
            try {
                int index = this.world().observerOwnsIndexOf(widget.name().toUpperCase(Locale.ENGLISH));
                if (index != -1) {
                    this.world().observer().setVariable(index, widget.valueObject());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AgentException || throwable2 instanceof LogoException) {
                    Exception ex = (Exception)throwable2;
                    throw new IllegalStateException(ex);
                }
                throw throwable;
            }
        });
    }

    private void updateInterfaceGlobalConstraints() {
        this.globalWidgets().foreach(_$1 -> _$1.updateConstraints());
    }

    private Option<Events.CompiledEvent> compileSource(JobOwner owner) {
        Some some;
        try {
            Some displayName = Some$.MODULE$.apply((Object)(owner.classDisplayName() + " '" + owner.displayName() + "'"));
            PresentationCompilerInterface presentationCompilerInterface = this.workspace().compiler();
            CompilerResults results = presentationCompilerInterface.compileMoreCode(owner.source(), (Option<String>)displayName, ((CompilationManagement)((Object)this.world())).program(), this.workspace().procedures(), this.workspace().getExtensionManager(), this.workspace().getLibraryManager(), this.workspace().getCompilationEnvironment(), presentationCompilerInterface.compileMoreCode$default$8());
            if (!results.proceduresMap().isEmpty()) {
                ListMap<String, Procedure> listMap = results.proceduresMap();
                ListMap<String, Procedure> listMap2 = this.workspace().procedures();
                if (listMap == null ? listMap2 != null : !listMap.equals(listMap2)) {
                    results.head().init(this.workspace());
                    results.head().owner_$eq(owner);
                    this.raiseEvent(new Events.CompiledEvent(owner, ((CompilationManagement)((Object)this.world())).program(), results.head(), null));
                }
            }
            some = None$.MODULE$;
        }
        catch (CompilerException error) {
            some = Some$.MODULE$.apply((Object)new Events.CompiledEvent(owner, ((CompilationManagement)((Object)this.world())).program(), null, error));
        }
        return some;
    }

    private void compileWidgets() {
        if (this.widgets().isEmpty()) {
            this.raiseEvent(new Events.CompiledEvent(null, ((CompilationManagement)((Object)this.world())).program(), null, null));
        } else {
            Seq errorEvents = (Seq)this.widgets().foldLeft((Object)((SeqOps)Nil$.MODULE$), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Seq seq = (Seq)tuple2._1();
                    JobOwner jobOwner = (JobOwner)tuple2._2();
                    Seq errors = seq;
                    JobOwner widget = jobOwner;
                    if (!widget.isCommandCenter()) {
                        return (Seq)this.compileSource(widget).map((Function1 & Serializable)e -> (Seq)errors.$colon$plus(e)).getOrElse(() -> CompilerManager.$anonfun$1$$anonfun$2(errors));
                    }
                    Seq errors2 = seq;
                    JobOwner widget2 = jobOwner;
                    return errors2;
                }
                throw new MatchError((Object)tuple2);
            });
            errorEvents.foreach(e -> this.raiseEvent((Event)e));
        }
        this.updateInterfaceGlobalConstraints();
    }

    private void resetWidgetProcedures() {
        this.widgets().foreach(x$1 -> {
            JobOwner jobOwner = x$1;
            if (jobOwner instanceof JobWidget) {
                JobWidget jw = (JobWidget)jobOwner;
                jw.procedure_$eq(null);
                return;
            }
        });
    }

    private Seq<String> getGlobalVariableNames() {
        return ((IterableOnceOps)this.globalWidgets().map((Function1 & Serializable)_$2 -> _$2.name())).toSeq();
    }

    private static final Seq $anonfun$1$$anonfun$2(Seq errors$2) {
        return errors$2;
    }
}

