/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.api.FileIO$;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.ModelType;
import org.nlogo.api.Version$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.core.Model;
import org.nlogo.fileformat.FailedConversionResult;
import org.nlogo.swing.BrowserLauncher$;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.window.AutoConversionErrorDialog;
import org.nlogo.workspace.ModelTracker;
import org.nlogo.workspace.OpenModel;
import org.nlogo.workspace.SaveModel;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public class FileController
implements OpenModel.Controller,
SaveModel.Controller {
    private final Component owner;
    private final ModelTracker modelTracker;

    public FileController(Component owner, ModelTracker modelTracker) {
        this.owner = owner;
        this.modelTracker = modelTracker;
    }

    @Override
    public void errorOpeningURI(URI uri, Exception exception) {
        Predef$.MODULE$.println((Object)exception);
        exception.printStackTrace();
        new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().getN("file.open.error.unableToOpen", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Paths.get(uri).toString(), exception.getMessage()})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
    }

    @Override
    public Option<Model> errorAutoconvertingModel(FailedConversionResult res) {
        return this.showAutoconversionError(res, "model");
    }

    public Option<Model> showAutoconversionError(FailedConversionResult res, String base) {
        res.errors().foreach(_$1 -> _$1.errors().foreach(e -> {
            Predef$.MODULE$.println(e);
            e.printStackTrace();
        }));
        AutoConversionErrorDialog dialog = new AutoConversionErrorDialog(this.owner, base);
        dialog.doShow(res);
        return dialog.modelToOpen();
    }

    @Override
    public void invalidModel(URI uri) throws IllegalStateException {
        this.notifyUserNotValidFile(uri);
    }

    @Override
    public void invalidModelVersion(URI uri, String version) {
        this.notifyUserNotValidFile(uri);
    }

    @Override
    public boolean shouldOpenModelOfDifferingArity(int arity, String version) {
        boolean bl;
        try {
            if (arity == 3) {
                this.checkWithUserBeforeOpening3DModelin2D(version);
            } else {
                this.checkWithUserBeforeOpening2DModelin3D();
            }
            bl = true;
        }
        catch (UserCancelException ex) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean shouldOpenModelOfUnknownVersion(String version) {
        boolean bl;
        try {
            this.checkWithUserBeforeOpeningModelFromFutureVersion(version);
            bl = true;
        }
        catch (UserCancelException ex) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean shouldOpenModelOfLegacyVersion(String version) {
        return this.showVersionWarningAndGetResponse(version);
    }

    public void checkWithUserBeforeOpeningModelFromFutureVersion(String version) throws UserCancelException {
        if (new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().getN("file.open.warn.version.newer", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version(), version})), OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex() != 0) {
            throw new UserCancelException();
        }
    }

    public void checkWithUserBeforeOpening3DModelin2D(String version) throws UserCancelException {
        if (new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().getN("file.open.warn.intwod.openthreed", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version(), version})), OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex() != 0) {
            throw new UserCancelException();
        }
    }

    public void checkWithUserBeforeOpening2DModelin3D() throws UserCancelException {
        if (new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().getN("file.open.warn.inthreed.opentwod", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Version$.MODULE$.version()})), OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex() != 0) {
            throw new UserCancelException();
        }
    }

    public void notifyUserNotValidFile(URI uri) throws UserCancelException {
        String warningText = (String)Try$.MODULE$.apply(() -> FileController.$anonfun$1(uri)).toOption().map((Function1 & Serializable)path -> I18N$.MODULE$.gui().getN("file.open.error.invalidmodel.withPath", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{path.toString()}))).getOrElse(FileController::$anonfun$3);
        new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.error"), warningText, OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
        throw new UserCancelException();
    }

    public boolean showVersionWarningAndGetResponse(String version) {
        int response = new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().getN("file.open.warn.version.older", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{version, Version$.MODULE$.version()})), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.continue"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("file.open.warn.version.transitionGuide"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex();
        int n = response;
        if (0 == n) {
            return true;
        }
        if (1 == n) {
            BrowserLauncher$.MODULE$.openURI(this.owner, new URI(I18N$.MODULE$.gui().get("file.open.transitionGuide.url")));
            return this.showVersionWarningAndGetResponse(version);
        }
        return false;
    }

    @Override
    public Option<URI> chooseFilePath(ModelType modelType) {
        String userPath = FileDialog$.MODULE$.showFiles(this.owner, I18N$.MODULE$.gui().get("menu.file.saveAs"), 1, this.guessFileName(), (List<String>)((List)new .colon.colon((Object)ModelReader$.MODULE$.modelSuffix(), (List)Nil$.MODULE$)));
        String extensionPath = FileIO$.MODULE$.ensureExtension(userPath, ModelReader$.MODULE$.modelSuffix());
        Path path = Paths.get(extensionPath, new String[0]);
        if (!path.toFile().exists()) {
            return Some$.MODULE$.apply((Object)path.toUri());
        }
        return FileDialog$.MODULE$.confirmFileOverwrite(this.owner, extensionPath).map((Function1 & Serializable)_$2 -> path.toUri());
    }

    private String guessFileName() {
        return FileIO$.MODULE$.ensureExtension(this.modelTracker.modelNameForDisplay(), ModelReader$.MODULE$.modelSuffix());
    }

    @Override
    public boolean shouldSaveModelOfDifferingVersion(String version) {
        return Version$.MODULE$.compatibleVersion(version) || new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().getN("file.save.warn.savingInNewerVersion", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{version, Version$.MODULE$.version()})), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.save"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.cancel"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Error()).getSelectedIndex() == 0;
    }

    @Override
    public void warnInvalidFileFormat(String format) {
        new OptionPane(this.owner, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().getN("file.save.warn.invalidFormat", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{format})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Warning());
    }

    private static final Path $anonfun$1(URI uri$1) {
        return Paths.get(uri$1);
    }

    private static final String $anonfun$3() {
        return I18N$.MODULE$.gui().get("file.open.error.invalidmodel");
    }
}

