/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import javax.swing.JLabel;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.Button;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.Implicits$;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.PropertyAccessor;
import org.nlogo.window.PropertyEditor;
import org.nlogo.window.PropertyEditor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public class FilePathEditor
extends PropertyEditor<String> {
    private final Component parent;
    private final Option<Path> currentDirectory;
    private final String suggestedFileName;
    private final Path homePath;
    private final JLabel label;
    private final TextField editor;
    public final Button org$nlogo$window$FilePathEditor$$browseButton;
    public final Button org$nlogo$window$FilePathEditor$$disableButton;

    public FilePathEditor(PropertyAccessor<String> accessor, Component parent, Option<Path> currentDirectory, Option<String> suggestedFile) {
        this.parent = parent;
        this.currentDirectory = currentDirectory;
        super(accessor, PropertyEditor$.MODULE$.$lessinit$greater$default$2());
        this.suggestedFileName = (String)suggestedFile.map((Function1 & Serializable)_$1 -> _$1.trim()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).getOrElse(() -> FilePathEditor.$init$$$anonfun$3(accessor));
        this.homePath = new File(System.getProperty("user.home")).toPath().toAbsolutePath();
        this.label = new JLabel(accessor.name());
        this.editor = new TextField(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(12, TextField$.MODULE$.$lessinit$greater$default$2(), TextField$.MODULE$.$lessinit$greater$default$3());
                this.getDocument().addDocumentListener(Implicits$.MODULE$.thunk2documentListener(() -> FilePathEditor.org$nlogo$window$FilePathEditor$$anon$1$$_$$lessinit$greater$$anonfun$4($outer)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$nlogo$window$FilePathEditor$$anon$1$$_$$lessinit$greater$$anonfun$4(org.nlogo.window.FilePathEditor )}, serializedLambda);
            }
        };
        this.org$nlogo$window$FilePathEditor$$browseButton = new Button("Browse...", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                this.set(FileDialog$.MODULE$.showFiles(parent, accessor.name() + " export", 1, this.asPath(this.getCurrentText()).getFileName().toString(), FileDialog$.MODULE$.showFiles$default$5()).trim());
            }
            catch (UserCancelException userCancelException) {}
        });
        this.org$nlogo$window$FilePathEditor$$disableButton = new Button("Disable", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.set(""));
        Transparent toolbar = new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                Transparent.$init$(this);
                this.setLayout(new BorderLayout(6, 0));
                this.setFloatable(false);
                this.add((Component)$outer.org$nlogo$window$FilePathEditor$$browseButton, "West");
                this.add((Component)$outer.org$nlogo$window$FilePathEditor$$disableButton, "Center");
            }
        };
        this.setLayout(new BorderLayout(6, 0));
        this.add((Component)this.label, "West");
        this.add((Component)this.editor, "Center");
        this.add((Component)((Object)toolbar), "East");
    }

    private PropertyAccessor<String> accessor$accessor() {
        return super.accessor();
    }

    private Path asPath(String currentText) {
        Path path;
        Path currentPath = new File(currentText).toPath();
        Path path2 = path = currentPath.isAbsolute() ? currentPath : ((Path)this.currentDirectory.getOrElse(this::$anonfun$1)).resolve(currentPath);
        if (path.toFile().isDirectory()) {
            return path.resolve(this.suggestedFileName);
        }
        return path;
    }

    private String getCurrentText() {
        Option option = Option$.MODULE$.apply((Object)this.editor.getText());
        if (option instanceof Some) {
            String text = (String)((Some)option).value();
            return text.trim();
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<String> get() {
        String currentText;
        String string = currentText = this.getCurrentText();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Option$.MODULE$.apply((Object)currentText);
        }
        return Option$.MODULE$.apply((Object)this.asPath(currentText).toString());
    }

    @Override
    public void set(String value) {
        this.editor.setText(value);
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    @Override
    public void syncTheme() {
        this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.editor.syncTheme();
        this.org$nlogo$window$FilePathEditor$$browseButton.syncTheme();
        this.org$nlogo$window$FilePathEditor$$disableButton.syncTheme();
    }

    private static final String $init$$$anonfun$3(PropertyAccessor accessor$1) {
        return accessor$1.name() + "-export.csv";
    }

    public static final /* synthetic */ void org$nlogo$window$FilePathEditor$$anon$1$$_$$lessinit$greater$$anonfun$4(FilePathEditor $outer$1) {
        $outer$1.accessor$accessor().changed().apply$mcV$sp();
    }

    private final Path $anonfun$1() {
        return this.homePath;
    }
}

