/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.nlogo.api.Approximate;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPainter;
import org.nlogo.theme.InterfaceColors;

class PlotCanvas
extends JPanel {
    final Plot plot;
    private final PlotPainter painter;
    public boolean dirty = true;
    private boolean mouseHere = false;
    private Point mouseLoc = null;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            PlotCanvas.this.mouseHere = true;
            PlotCanvas.this.mouseLoc = e.getPoint();
            PlotCanvas.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PlotCanvas.this.mouseHere = false;
            PlotCanvas.this.repaint();
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            PlotCanvas.this.mouseLoc = e.getPoint();
            PlotCanvas.this.mouseHere = PlotCanvas.this.mouseLoc.x >= 0 && PlotCanvas.this.mouseLoc.y >= 0 && PlotCanvas.this.mouseLoc.x < PlotCanvas.this.getBounds().width && PlotCanvas.this.mouseLoc.y < PlotCanvas.this.getBounds().height;
            PlotCanvas.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PlotCanvas.this.mouseHere = true;
            PlotCanvas.this.mouseLoc = e.getPoint();
            PlotCanvas.this.repaint();
        }
    };

    void repaintIfNeeded() {
        if (this.dirty) {
            this.painter.setupOffscreenImage(this.getWidth(), this.getHeight());
            this.painter.refresh();
            this.dirty = false;
            this.repaint();
        }
    }

    public void makeDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    PlotCanvas(Plot plot) {
        this.plot = plot;
        this.painter = new PlotPainter(plot);
        this.setOpaque(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.painter.setupOffscreenImage(this.getWidth(), this.getHeight());
        this.painter.drawImage(g);
        if (this.mouseHere) {
            this.drawMouseCoords(g);
        }
    }

    private void drawMouseCoords(Graphics g) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int fontHeight = fontMetrics.getAscent();
        int xPrecision = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenXCor(1.0) - this.fromScreenXCor(0.0)) / StrictMath.log(10.0)));
        String xcor = Double.toString(Approximate.approximate(this.fromScreenXCor(this.mouseLoc.x), StrictMath.min(xPrecision, 34)));
        if (xPrecision <= 0) {
            xcor = xcor.substring(0, xcor.length() - 2);
        }
        int xcorWidth = fontMetrics.stringWidth(xcor);
        int yPrecision = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenYCor(0.0) - this.fromScreenYCor(1.0)) / StrictMath.log(10.0)));
        String ycor = Double.toString(Approximate.approximate(this.fromScreenYCor(this.mouseLoc.y), StrictMath.min(yPrecision, 34)));
        if (yPrecision <= 0) {
            ycor = ycor.substring(0, ycor.length() - 2);
        }
        int ycorWidth = fontMetrics.stringWidth(ycor);
        int xx = this.mouseLoc.x - xcorWidth / 2;
        xx = StrictMath.max(xx, ycorWidth);
        xx = StrictMath.min(xx, this.getBounds().width - xcorWidth);
        int xy = this.getBounds().height - fontHeight + 1;
        g.setColor(InterfaceColors.plotMouseBackground());
        g.fillRect(xx - 1, xy, xcorWidth + 1, fontHeight + 1);
        g.setColor(InterfaceColors.plotMouseText());
        g.drawString(xcor, xx, xy + fontHeight - 1);
        int yy = this.mouseLoc.y - fontHeight / 2;
        yy = StrictMath.max(yy, 0);
        yy = StrictMath.min(yy, this.getBounds().height - 2 * fontHeight);
        int yx = 0;
        g.setColor(InterfaceColors.plotMouseBackground());
        g.fillRect(yx, yy, ycorWidth + 1, fontHeight + 1);
        g.setColor(InterfaceColors.plotMouseText());
        g.drawString(ycor, yx, yy + fontHeight - 1);
    }

    private double fromScreenXCor(double screenX) {
        double width = this.getWidth() - 1;
        double range = this.plot.xMax() - this.plot.xMin();
        return this.plot.xMin() + screenX * range / width;
    }

    private double fromScreenYCor(double screenY) {
        double height = this.getHeight() - 1;
        double range = this.plot.yMax() - this.plot.yMin();
        return this.plot.yMax() - screenY * range / height;
    }
}

