/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.io.Serializable;
import org.nlogo.agent.ConstantSliderConstraint;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.Approximate$;
import org.nlogo.window.MultiErrorHandler;
import org.nlogo.window.SliderData$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

public class SliderData {
    private final MultiErrorHandler errorHandler;
    private double minimum;
    private double maximum;
    private double increment;
    private double _value;
    private SliderConstraint constraint;

    public static double $lessinit$greater$default$2() {
        return SliderData$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$3() {
        return SliderData$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$4() {
        return SliderData$.MODULE$.$lessinit$greater$default$4();
    }

    public SliderData(MultiErrorHandler errorHandler, double minimum, double maximum, double increment) {
        this.errorHandler = errorHandler;
        this.minimum = minimum;
        this.maximum = maximum;
        this.increment = increment;
        this._value = 50.0;
        this.constraint = new ConstantSliderConstraint(this.minimum(), this.maximum(), this.increment());
        this.setSliderConstraint(this.constraint());
    }

    public double minimum() {
        return this.minimum;
    }

    public void minimum_$eq(double x$1) {
        this.minimum = x$1;
    }

    public double maximum() {
        return this.maximum;
    }

    public void maximum_$eq(double x$1) {
        this.maximum = x$1;
    }

    public double increment() {
        return this.increment;
    }

    public void increment_$eq(double x$1) {
        this.increment = x$1;
    }

    public double value() {
        return this._value;
    }

    public void value_$eq(double value) {
        this.valueSetter(value);
    }

    public boolean valueSetter(double v) {
        if (v != this._value) {
            this._value = v;
            return true;
        }
        return false;
    }

    public SliderConstraint constraint() {
        return this.constraint;
    }

    public void constraint_$eq(SliderConstraint x$1) {
        this.constraint = x$1;
    }

    public boolean setSliderConstraint(SliderConstraint con) {
        this.constraint_$eq(con);
        return BoxesRunTime.unboxToBoolean((Object)con.minimum().flatMap((Function1 & Serializable)min -> this.setSliderConstraint$$anonfun$1(con, BoxesRunTime.unboxToDouble((Object)min))).getOrElse(() -> this.setSliderConstraint$$anonfun$2(con)));
    }

    public double effectiveMaximum() {
        if (this.minimum() >= this.maximum()) {
            return this.minimum();
        }
        if (this.increment() == 0.0) {
            return this.minimum();
        }
        double result = this.minimum() + this.increment() * StrictMath.floor((this.maximum() - this.minimum()) / this.increment());
        if (Approximate$.MODULE$.approximate(result + this.increment(), this.precision()) <= this.maximum()) {
            result += this.increment();
        }
        return Approximate$.MODULE$.approximate(result, this.precision());
    }

    public int precision() {
        return package$.MODULE$.max(SliderData.precisionHelper$1(this.minimum()), SliderData.precisionHelper$1(this.increment()));
    }

    public double coerceValue(double value) {
        double d;
        int p = this.precision();
        if (value > this.effectiveMaximum()) {
            d = this.effectiveMaximum();
        } else if (value <= this.minimum()) {
            d = this.minimum();
        } else {
            double value2 = Approximate$.MODULE$.approximate(value, p);
            double numDivisions = StrictMath.floor((value2 - this.minimum()) / this.increment());
            double roundedDown = this.minimum() + numDivisions * this.increment();
            double roundedUp = this.minimum() + (numDivisions + 1.0) * this.increment();
            d = Approximate$.MODULE$.approximate(roundedUp, p) <= Approximate$.MODULE$.approximate(this.effectiveMaximum(), p) ? (StrictMath.abs(value2 - roundedDown) < StrictMath.abs(roundedUp - value2) ? roundedDown : roundedUp) : this.effectiveMaximum();
        }
        double newVal = d;
        return Approximate$.MODULE$.approximate(newVal, p);
    }

    public String toString() {
        return "Slider(min=" + this.minimum() + ", max=" + this.maximum() + ", inc=" + this.increment() + ")";
    }

    private final boolean resetValues$1(double newmin, double newmax, double newinc) {
        if (newmin != this.minimum() || newmax != this.maximum() || newinc != this.increment()) {
            this.minimum_$eq(newmin);
            this.maximum_$eq(newmax);
            this.increment_$eq(newinc);
            this.value_$eq(this.coerceValue(this.value()));
            return true;
        }
        return false;
    }

    private final void setError$1(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SliderConstraint.ConstraintRuntimeException) {
            SliderConstraint.ConstraintRuntimeException ex = (SliderConstraint.ConstraintRuntimeException)throwable;
            this.errorHandler.error(ex.spec().fieldName(), ex);
            return;
        }
        Throwable otherEx = throwable;
    }

    private static final void ignore$1(double d) {
    }

    private final /* synthetic */ Try setSliderConstraint$$anonfun$1$$anonfun$1(SliderConstraint con$2, double min$1, double max) {
        return con$2.increment().map((Function1)(JFunction1.mcZD.sp & Serializable)inc -> this.resetValues$1(min$1, max, inc));
    }

    private final /* synthetic */ Try setSliderConstraint$$anonfun$1(SliderConstraint con$1, double min) {
        return con$1.maximum().flatMap((Function1 & Serializable)max -> this.setSliderConstraint$$anonfun$1$$anonfun$1(con$1, min, BoxesRunTime.unboxToDouble((Object)max)));
    }

    private final boolean setSliderConstraint$$anonfun$2(SliderConstraint con$3) {
        con$3.minimum().fold(e -> this.setError$1((Throwable)e), (Function1)(JFunction1.mcVD.sp & Serializable)d -> SliderData.ignore$1(d));
        con$3.maximum().fold(e -> this.setError$1((Throwable)e), (Function1)(JFunction1.mcVD.sp & Serializable)d -> SliderData.ignore$1(d));
        con$3.increment().fold(e -> this.setError$1((Throwable)e), (Function1)(JFunction1.mcVD.sp & Serializable)d -> SliderData.ignore$1(d));
        return false;
    }

    private static final /* synthetic */ boolean $anonfun$1(char _$1) {
        return _$1 == '0';
    }

    private static final int precisionHelper$1(double n) {
        String s = BoxesRunTime.boxToDouble((double)n).toString();
        int place = s.indexOf(69);
        Tuple2 tuple2 = place == -1 ? Tuple2$.MODULE$.apply((Object)s, (Object)BoxesRunTime.boxToInteger((int)0)) : Tuple2$.MODULE$.apply((Object)s.substring(0, place), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s.substring(place + 1)))));
        String sWithoutE = (String)tuple2._1();
        int eValue = BoxesRunTime.unboxToInt((Object)tuple2._2());
        String sAfterDot = sWithoutE.substring(sWithoutE.indexOf(46) + 1);
        int digitsAfterDot = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(sAfterDot))), (Function1 & Serializable)_$1 -> SliderData.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1))).length();
        return package$.MODULE$.max(0, digitsAfterDot - eValue);
    }
}

