/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.core.NetLogoPreferences$;
import org.nlogo.log.LogManager$;
import org.nlogo.swing.Button;
import org.nlogo.swing.RoundedBorderPanel;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.SpeedSliderPanel$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public class SpeedSliderPanel
extends JPanel
implements MouseListener,
ChangeListener,
Events.LoadBeginEvent.Handler,
ThemeSync {
    private final GUIWorkspace workspace;
    private final Component ticksLabel;
    private final I18N.Prefix prefix;
    private final SpeedSlider speedSlider;
    private final Button slower;
    private final Button faster;
    private final JLabel modelSpeed;
    public boolean org$nlogo$window$SpeedSliderPanel$$jumpOnClick;

    public static Component $lessinit$greater$default$2() {
        return SpeedSliderPanel$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * WARNING - void declaration
     */
    public SpeedSliderPanel(GUIWorkspace workspace, Component ticksLabel) {
        BoxedUnit boxedUnit;
        void var3_3;
        this.workspace = workspace;
        this.ticksLabel = ticksLabel;
        this.prefix = I18N$Prefix$.MODULE$.apply("tabs.run.speedslider");
        SpeedSlider slider = new SpeedSlider((int)workspace.speedSliderPosition());
        slider.setFocusable(false);
        slider.addChangeListener(this);
        slider.addMouseListener(this);
        slider.setOpaque(false);
        this.speedSlider = var3_3;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.slower = new RoundedBorderPanel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super("", (Function0<BoxedUnit>)$outer.org$nlogo$window$SpeedSliderPanel$$_$$anon$superArg$1$1());
            }

            public Dimension getPreferredSize() {
                return new Dimension(19, 19);
            }

            public void paintComponent(Graphics g) {
                RoundedBorderPanel.paintComponent$(this, g);
                Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
                g2d.setColor(InterfaceColors$.MODULE$.toolbarText());
                g2d.fillRect(6, 9, 7, 1);
            }
        };
        this.faster = new RoundedBorderPanel(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super("", (Function0<BoxedUnit>)$outer.org$nlogo$window$SpeedSliderPanel$$_$$anon$superArg$2$1());
            }

            public Dimension getPreferredSize() {
                return new Dimension(19, 19);
            }

            public void paintComponent(Graphics g) {
                RoundedBorderPanel.paintComponent$(this, g);
                Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
                g2d.setColor(InterfaceColors$.MODULE$.toolbarText());
                g2d.fillRect(6, 9, 7, 1);
                g2d.fillRect(9, 6, 1, 7);
            }
        };
        this.modelSpeed = new JLabel(I18N$.MODULE$.gui().apply("modelSpeed", this.prefix()), 0);
        this.org$nlogo$window$SpeedSliderPanel$$jumpOnClick = NetLogoPreferences$.MODULE$.getBoolean("jumpOnClick", true);
        this.slower().setFont(this.slower().getFont().deriveFont(10.0f));
        this.faster().setFont(this.faster().getFont().deriveFont(10.0f));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.slower(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)this.modelSpeed(), c);
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)this.faster(), c);
        c.gridx = 1;
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)this.speedSlider(), c);
        if (ticksLabel != null) {
            c.gridy = 2;
            c.fill = 0;
            this.add(ticksLabel, c);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }

    public I18N.Prefix prefix() {
        return this.prefix;
    }

    public SpeedSlider speedSlider() {
        return this.speedSlider;
    }

    public Button slower() {
        return this.slower;
    }

    public Button faster() {
        return this.faster;
    }

    public JLabel modelSpeed() {
        return this.modelSpeed;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, this.modelSpeed().getPreferredSize().height + RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.speedSlider().getPreferredSize().height), this.faster().getPreferredSize().height) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.ticksLabel).map((Function1 & Serializable)_$1 -> _$1.getPreferredSize().height).getOrElse(SpeedSliderPanel::getMinimumSize$$anonfun$2)));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getMinimumSize().height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.speedSlider().setEnabled(enabled);
        if (enabled) {
            this.stateChanged(null);
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = this.speedSlider().getValue();
        int adjustedValue = value < -10 ? value + 10 : (value > 10 ? value - 10 : 0);
        this.workspace.speedSliderPosition((double)adjustedValue / (double)2);
        LogManager$.MODULE$.speedSliderChanged(Int$.MODULE$.int2double(adjustedValue));
        this.workspace.updateManager().nudgeSleeper();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int n = this.speedSlider().getValue();
        int value = n;
        if (value <= 10 && value > 0 || value >= -10 && value < 0) {
            this.speedSlider().setValue(0);
            return;
        }
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.speedSlider().reset();
    }

    public void setValue(int speed) {
        if (this.speedSlider().getValue() != speed) {
            this.speedSlider().setValue(speed);
            return;
        }
    }

    public int getValue() {
        return this.speedSlider().getValue();
    }

    public int getMaximum() {
        return this.speedSlider().getMaximum();
    }

    @Override
    public boolean isEnabled() {
        return this.speedSlider().isEnabled();
    }

    public void setJumpOnClick(boolean value) {
        this.org$nlogo$window$SpeedSliderPanel$$jumpOnClick = value;
    }

    @Override
    public void syncTheme() {
        this.slower().syncTheme();
        this.faster().syncTheme();
        this.modelSpeed().setForeground(InterfaceColors$.MODULE$.toolbarText());
    }

    public final Function0 org$nlogo$window$SpeedSliderPanel$$_$$anon$superArg$1$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.speedSlider().setValue(this.speedSlider().getValue() - 11);
    }

    public final Function0 org$nlogo$window$SpeedSliderPanel$$_$$anon$superArg$2$1() {
        return (JFunction0.mcV.sp & Serializable)() -> this.speedSlider().setValue(this.speedSlider().getValue() + 11);
    }

    private static final int getMinimumSize$$anonfun$2() {
        return 0;
    }

    public class SpeedSlider
    extends JSlider
    implements MouseWheelListener {
        private final SpeedSliderUI sliderUI;
        public int org$nlogo$window$SpeedSliderPanel$SpeedSlider$$lastThumbLocation;

        public SpeedSlider(int defaultSpeed) {
            if (SpeedSliderPanel.this == null) {
                throw new NullPointerException();
            }
            super(-110, 112, defaultSpeed);
            this.sliderUI = new SpeedSliderUI();
            this.org$nlogo$window$SpeedSliderPanel$SpeedSlider$$lastThumbLocation = 0;
            this.setExtent(1);
            this.setToolTipText(I18N$.MODULE$.gui().apply("tooltip", SpeedSliderPanel.this.prefix()));
            this.setUI(this.sliderUI);
            this.addMouseWheelListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(180, super.getPreferredSize().height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(60, super.getPreferredSize().height);
        }

        public void reset() {
            this.setValue(0);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.setValue(this.getValue() - e.getWheelRotation());
        }

        @Override
        public void setValue(int value) {
            this.org$nlogo$window$SpeedSliderPanel$SpeedSlider$$lastThumbLocation = this.sliderUI.getThumbLocation();
            super.setValue(value);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            g2d.setColor(Color.GRAY);
            g2d.drawLine(this.getWidth() / 2 - 1, this.getHeight() / 4, this.getWidth() / 2 - 1, this.getHeight() * 3 / 4);
            super.paintComponent(g);
        }

        public final /* synthetic */ SpeedSliderPanel org$nlogo$window$SpeedSliderPanel$SpeedSlider$$$outer() {
            return SpeedSliderPanel.this;
        }

        public class SpeedSliderUI
        extends BasicSliderUI {
            public SpeedSliderUI() {
                if (SpeedSlider.this == null) {
                    throw new NullPointerException();
                }
                super(SpeedSlider.this);
            }

            public int getThumbLocation() {
                return this.thumbRect.x;
            }

            @Override
            public Dimension getThumbSize() {
                return new Dimension(12, 12);
            }

            @Override
            public void paintTrack(Graphics g) {
                Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
                int startY = this.trackRect.y + this.trackRect.height / 2 - 1;
                if (SpeedSlider.this.isEnabled()) {
                    g2d.setColor(InterfaceColors$.MODULE$.speedSliderBarBackgroundFilled());
                } else {
                    g2d.setColor(InterfaceColors$.MODULE$.speedSliderBarBackground());
                }
                g2d.fillRoundRect(this.trackRect.x, startY, this.thumbRect.x, 2, 2, 2);
                g2d.setColor(InterfaceColors$.MODULE$.speedSliderBarBackground());
                g2d.fillRoundRect(this.thumbRect.x, startY, this.trackRect.width - this.thumbRect.x, 2, 2, 2);
            }

            @Override
            public void paintThumb(Graphics g) {
                if (!SpeedSlider.this.isEnabled()) {
                    this.setThumbLocation(SpeedSlider.this.org$nlogo$window$SpeedSliderPanel$SpeedSlider$$lastThumbLocation, 0);
                }
                Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
                int width = this.getThumbSize().width;
                int startY = (int)this.thumbRect.getCenterY() - width / 2;
                if (SpeedSlider.this.isEnabled()) {
                    g2d.setColor(InterfaceColors$.MODULE$.speedSliderThumb());
                } else {
                    g2d.setColor(InterfaceColors$.MODULE$.speedSliderThumbDisabled());
                }
                g2d.fillOval(this.thumbRect.x + this.thumbRect.width / 2 - width / 2, startY, width, width);
            }

            @Override
            public void scrollDueToClickInTrack(int dir) {
            }

            @Override
            public BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
                return new BasicSliderUI.TrackListener(slider, this){
                    private final JSlider slider$1;
                    private final /* synthetic */ SpeedSliderUI $outer;
                    {
                        this.slider$1 = slider$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer);
                    }

                    public void mousePressed(MouseEvent e) {
                        if (e.getButton() == 1) {
                            this.slider$1.requestFocus();
                            if (this.$outer.org$nlogo$window$SpeedSliderPanel$SpeedSlider$SpeedSliderUI$$$outer().org$nlogo$window$SpeedSliderPanel$SpeedSlider$$$outer().org$nlogo$window$SpeedSliderPanel$$jumpOnClick) {
                                this.slider$1.setValue(this.$outer.valueForXPosition(e.getX()));
                                return;
                            }
                            if (this.$outer.valueForXPosition(e.getX()) > this.slider$1.getValue()) {
                                this.slider$1.setValue(this.slider$1.getValue() + 11);
                                return;
                            }
                            this.slider$1.setValue(this.slider$1.getValue() - 11);
                            return;
                        }
                    }

                    public void mouseDragged(MouseEvent e) {
                        if ((e.getModifiersEx() & 0x400) == 1024 && (this.$outer.org$nlogo$window$SpeedSliderPanel$SpeedSlider$SpeedSliderUI$$$outer().org$nlogo$window$SpeedSliderPanel$SpeedSlider$$$outer().org$nlogo$window$SpeedSliderPanel$$jumpOnClick || this.$outer.protected$isDragging())) {
                            this.slider$1.setValue(this.$outer.valueForXPosition(e.getPoint().x));
                            return;
                        }
                    }
                };
            }

            public boolean protected$isDragging() {
                return this.isDragging();
            }

            public final /* synthetic */ SpeedSlider org$nlogo$window$SpeedSliderPanel$SpeedSlider$SpeedSliderUI$$$outer() {
                return SpeedSlider.this;
            }
        }
    }
}

